/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: AccWall.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 23:59:52 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include "AccWall.hxx"

#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLESTATETYPE_HPP_
#include <com/sun/star/accessibility/AccessibleStateType.hpp>
#endif

// for SolarMutex
#ifndef _SV_SVAPP_HXX 
#include <vcl/svapp.hxx>
#endif

#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#ifndef _DEFINES_HXX
#include "defines.hxx"
#endif

namespace accessibility
{

Wall::Wall( AccessibleBase * pParent ) :
        AccessibleChartElement( AccessibleUniqueId( CHOBJID_DIAGRAM_WALL ),
                                pParent,
                                false /* has no children */ )
{
    ChartModel * pModel = GetChartModel();
    OSL_ASSERT( pModel );

    // /-- solar
    ::vos::OGuard aSolarGuard( Application::GetSolarMutex() );
    SetItemSet( pModel->GetDiagramWallAttr() );
    // \-- solar

    AddState( ::com::sun::star::accessibility::AccessibleStateType::OPAQUE );
}

Wall::~Wall()
{}

::rtl::OUString SAL_CALL Wall::getImplementationName() 
    throw (::com::sun::star::uno::RuntimeException)
{
    return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "AccWall" ));
}

}  // namespace accessibility
