/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: guiutil.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 01:12:09 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

#include "guiutil.hxx"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "objid.hxx"
#include "schresid.hxx"
#include "strings.hrc"
#include "glob.hrc"

//*************************************************************************
//*************************************************************************

USHORT GuiUtilities::GetObjectNameResId(UINT16 nObjId, ChartModel& rDoc)
{
	USHORT nResId;
	switch (nObjId)
	{
		case CHOBJID_DIAGRAM_AREA:
			nResId = STR_DIAGRAM_AREA;
			break;

		case CHOBJID_TITLE_MAIN:
			nResId = STR_TITLE_MAIN;
			break;;

		case CHOBJID_TITLE_SUB:
			nResId = STR_TITLE_SUB;
			break;

		case CHOBJID_DIAGRAM:
			nResId = STR_DIAGRAM;
			break;

		case CHOBJID_DIAGRAM_WALL:
			nResId = STR_DIAGRAM_WALL;
			break;

		case CHOBJID_DIAGRAM_FLOOR:
			nResId = STR_DIAGRAM_FLOOR;
			break;

		case CHOBJID_DIAGRAM_TITLE_X_AXIS:
			nResId = STR_DIAGRAM_TITLE_X_AXIS;
			break;

		case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
			nResId = STR_DIAGRAM_TITLE_Y_AXIS;
			break;

		case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
			nResId = STR_DIAGRAM_TITLE_Z_AXIS;
			break;

		case CHOBJID_DIAGRAM_A_AXIS:
		case CHOBJID_DIAGRAM_X_AXIS:
			nResId = STR_DIAGRAM_X_AXIS;
			break;

		case CHOBJID_DIAGRAM_B_AXIS:
		case CHOBJID_DIAGRAM_Y_AXIS:
			nResId = STR_DIAGRAM_Y_AXIS;
			break;

		case CHOBJID_DIAGRAM_C_AXIS:
		case CHOBJID_DIAGRAM_Z_AXIS:
			nResId = STR_DIAGRAM_Z_AXIS;
			break;

		case CHOBJID_DIAGRAM_X_GRID_MAIN:
		case CHOBJID_DIAGRAM_X_GRID_MAIN_GROUP:
			nResId = STR_DIAGRAM_X_GRID_MAIN;
			break;

		case CHOBJID_DIAGRAM_Y_GRID_MAIN:
        case CHOBJID_DIAGRAM_Y_GRID_MAIN_GROUP:
			nResId = STR_DIAGRAM_Y_GRID_MAIN;
			break;

		case CHOBJID_DIAGRAM_Z_GRID_MAIN:
        case CHOBJID_DIAGRAM_Z_GRID_MAIN_GROUP:
			nResId = STR_DIAGRAM_Z_GRID_MAIN;
			break;

		case CHOBJID_DIAGRAM_X_GRID_HELP:
        case CHOBJID_DIAGRAM_X_GRID_HELP_GROUP:
			nResId = STR_DIAGRAM_X_GRID_HELP;
			break;

		case CHOBJID_DIAGRAM_Y_GRID_HELP:
        case CHOBJID_DIAGRAM_Y_GRID_HELP_GROUP:
			nResId = STR_DIAGRAM_Y_GRID_HELP;
			break;

		case CHOBJID_DIAGRAM_Z_GRID_HELP:
        case CHOBJID_DIAGRAM_Z_GRID_HELP_GROUP:
			nResId = STR_DIAGRAM_Z_GRID_HELP;
			break;

		case CHOBJID_DIAGRAM_ROWGROUP:
		case CHOBJID_DIAGRAM_ROWS:
		case CHOBJID_DIAGRAM_ROWSLINE:
		case CHOBJID_DIAGRAM_SPECIAL_GROUP:
		case CHOBJID_DIAGRAM_STACKEDGROUP:
			nResId = STR_DIAGRAM_ROW;
			break;

		case CHOBJID_DIAGRAM_DATA:
			nResId    = STR_STATUS_DATAPOINT_MARKED;
			break;

		case CHOBJID_DIAGRAM_DESCRGROUP:
			nResId = STR_DIAGRAM_DESCRGROUP;
			break;

		case CHOBJID_DIAGRAM_DESCR_ROW:
			nResId = STR_DIAGRAM_DESCR_ROW;
			break;

		case CHOBJID_DIAGRAM_DESCR_COL:
			nResId = STR_DIAGRAM_DESCR_COL;
			break;

		case CHOBJID_LEGEND:
			nResId = STR_LEGEND;
			break;

		case CHOBJID_LEGEND_SYMBOL_ROW:
			nResId = STR_LEGEND_SYMBOL_ROW;
			break;

		case CHOBJID_LEGEND_SYMBOL_COL:
			nResId = STR_LEGEND_SYMBOL_COL;
			break;

		default:
			nResId = 0;
			break;
	}
	return nResId;
}
