/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: animationbasenode.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/07/26 07:30:13 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef INCLUDED_SLIDESHOW_ANIMATIONBASENODE_HXX
#define INCLUDED_SLIDESHOW_ANIMATIONBASENODE_HXX

#include "basecontainernode.hxx"
#include "activitiesfactory.hxx"
#include "shapeattributelayer.hxx"
#include "shapeattributelayerholder.hxx"
#include "attributableshape.hxx"
#include "shapesubset.hxx"
#include "com/sun/star/animations/XAnimate.hpp"

namespace presentation {
namespace internal {

/** Common base class for all leaf animation nodes.
    
    This class basically holds the target shape
*/
class AnimationBaseNode : public BaseNode
{
public:
    AnimationBaseNode(
        ::com::sun::star::uno::Reference<
        ::com::sun::star::animations::XAnimationNode> const& xNode, 
        ::boost::shared_ptr<BaseContainerNode> const& pParent,
        NodeContext const& rContext );
    
#if defined(VERBOSE) && defined(DBG_UTIL)
    virtual void showState() const;
#endif
    
protected:
    virtual void dispose();
    
    ::com::sun::star::uno::Reference<
        ::com::sun::star::animations::XAnimate> const& getXAnimateNode() const
        { return mxAnimateNode; }
    
    /// Create parameter struct for ActivitiesFactory
    ActivitiesFactory::CommonParameters fillCommonParameters() const;
    
    AttributableShapeSharedPtr getShape() const;
    
private:
    virtual bool hasPendingAnimation() const;
    
private: // state transition callbacks
    virtual bool init_st();
    virtual bool resolve_st();
    virtual void activate_st();
    virtual void deactivate_st( NodeState eDestState );
    virtual AnimationActivitySharedPtr createActivity() const = 0;
    
private:
    /** Returns true, if this is a subset animation, and
        the subset is autogenerated (e.g. from an
        iteration)
    */
    bool isDependentSubsettedShape() const
        { return mpShapeSubset && !mbIsIndependentSubset; }
    
    ShapeAttributeLayerHolder const & getAttributeLayerHolder() const
        { return maAttributeLayerHolder; }
    
private:
    ::com::sun::star::uno::Reference<
        ::com::sun::star::animations::XAnimate>     mxAnimateNode;
    ShapeAttributeLayerHolder                       maAttributeLayerHolder;
    AnimationActivitySharedPtr                      mpActivity;
    
    /// When valid, this node has a plain target shape
    AttributableShapeSharedPtr                      mpShape;
    /// When valid, this is a subsetted target shape 
    ShapeSubsetSharedPtr                            mpShapeSubset;
    bool                                            mbIsIndependentSubset;
};

} // namespace internal
} // namespace presentation

#endif /* INCLUDED_SLIDESHOW_ANIMATIONBASENODE_HXX */

