/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: SwUndoTempAutoCorr.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 03:40:26 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// #102505# (whole file)

#ifndef _SWUNDOTEMPAUTOCORR_HXX
#define _SWUNDOTEMPAUTOCORR_HXX

#include <tempauto.hxx>
#include <undobj.hxx>

/**
   Undo for inserting an entry into a list of temporal
   autocorrections.

 */
class SwUndoTempAutoCorr : public SwUndo
{
    /** 
        Word corrected by the correction.
    */
    String aWrong;

    /** 
        Corrected Word inserted by the correction.
    */
    String aCorrect;
    
    /**
       List receiving the correction.
     */
    SwTempAuto & aList;

    /**
       Inserts the correction defined by @a aWrong and @a aCorrect into
       @a aList and set @a bInsertSucceeded accordingly.
    */
    void _InsertCorrection();

public:
    /**
       Constructor
       
       @param _aList list to insert correction into
       @param _aWrong the word to be corrected
       @param _aCorrect the correct word
    */
    SwUndoTempAutoCorr(USHORT nL, SwTempAuto & _aList,
                       const String & _aWrong, const String & _aCorrect);

    /**
       Destructor
    */
    virtual ~SwUndoTempAutoCorr();

    /**
       Undos the insertion of @a aCorr, i.e. removes @a aCorr from
       @a aList.
    */
    virtual void Undo(SwUndoIter & aIter);

    /**
       Redos the insertion of @a aCorr into @a aList.
    */
    virtual void Redo(SwUndoIter & aIter);
};

#endif // _SWUNDOTEMPAUTOCORR_HXX
