/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_client.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 18:45:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// INCLUDE ---------------------------------------------------------------

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

// auto strip #include <bf_sfx2/objsh.hxx>
// auto strip #include <bf_sfx2/viewfrm.hxx>
// auto strip #include <sot/sotref.hxx>
// auto strip #include <so3/ipobj.hxx>
// auto strip #include <so3/persist.hxx>
// auto strip #include <so3/embobj.hxx>
// auto strip #include <bf_svx/svditer.hxx>
// auto strip #include <bf_svx/svdobj.hxx>
// auto strip #include <bf_svx/svdmodel.hxx>
// auto strip #include <bf_svx/svdpage.hxx>
// auto strip #include <bf_svx/svdoole2.hxx>
// auto strip #include <bf_svx/svdview.hxx>
// auto strip #include <bf_svx/svdograf.hxx>

#include "client.hxx"
#include "tabvwsh.hxx"
// auto strip #include "docsh.hxx"
namespace binfilter {

//------------------------------------------------------------------------

/*N*/ ScClient::ScClient( ScTabViewShell* pViewShell, Window* pDraw, SdrModel* pSdrModel ) :
/*N*/ 	SfxInPlaceClient( pViewShell, pDraw ),
/*N*/ 	pModel( pSdrModel ),
/*N*/ 	pGrafEdit( 0 )
/*N*/ {
/*N*/ }

/*N*/ __EXPORT ScClient::~ScClient()
/*N*/ {
/*N*/ }

//STRIP001 SdrOle2Obj* ScClient::GetDrawObj()
//STRIP001 {
//STRIP001 	SvEmbeddedObject* pMyObj = GetEmbedObj();
//STRIP001 	SvInfoObject* pInfoObj = GetViewShell()->GetViewFrame()->GetObjectShell()->Find( pMyObj );
//STRIP001 	SdrOle2Obj* pOle2Obj = NULL;
//STRIP001 //	String aName = pMyObj->GetName()->GetName();
//STRIP001 
//STRIP001 	String aName;
//STRIP001 
//STRIP001 	if ( pInfoObj )
//STRIP001 		aName = pInfoObj->GetObjName();
//STRIP001 	else
//STRIP001 		DBG_ERROR( "IP-Object not found :-/" );
//STRIP001 
//STRIP001 	USHORT nPages = pModel->GetPageCount();
//STRIP001 	for (USHORT nPNr=0; nPNr<nPages && !pOle2Obj; nPNr++)
//STRIP001 	{
//STRIP001 		SdrPage* pPage = pModel->GetPage(nPNr);
//STRIP001 		SdrObjListIter aIter( *pPage, IM_DEEPNOGROUPS );
//STRIP001 		SdrObject* pObject = aIter.Next();
//STRIP001 		while (pObject && !pOle2Obj)
//STRIP001 		{
//STRIP001 			if ( pObject->GetObjIdentifier() == OBJ_OLE2 )
//STRIP001 			{
//STRIP001 				// name from InfoObject is PersistName
//STRIP001 				if ( ((SdrOle2Obj*)pObject)->GetPersistName() == aName )
//STRIP001 					pOle2Obj = (SdrOle2Obj*)pObject;
//STRIP001 			}
//STRIP001 			pObject = aIter.Next();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return pOle2Obj;
//STRIP001 }

//STRIP001 void __EXPORT ScClient::RequestObjAreaPixel( const Rectangle& rObjRect )
//STRIP001 {
//STRIP001 	SfxViewShell* pSfxViewSh = GetViewShell();
//STRIP001 	ScTabViewShell* pViewSh = PTR_CAST( ScTabViewShell, pSfxViewSh );
//STRIP001 	if (!pViewSh)
//STRIP001 	{
//STRIP001 		DBG_ERROR("RequestObjAreaPixel: das ist nicht meine ViewShell");
//STRIP001 		SfxInPlaceClient::RequestObjAreaPixel( rObjRect );
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	//	Position anpassen
//STRIP001 
//STRIP001 	Rectangle aRect = rObjRect;
//STRIP001 	Window* pWin = pViewSh->GetActiveWin();
//STRIP001 	Rectangle aLogicRect( pWin->PixelToLogic( aRect.TopLeft() ),
//STRIP001 							pWin->PixelToLogic( aRect.GetSize() ) );
//STRIP001 
//STRIP001 	BOOL bChange = FALSE;
//STRIP001 	USHORT nTab = pViewSh->GetViewData()->GetTabNo();
//STRIP001 	SdrPage* pPage = pModel->GetPage(nTab);
//STRIP001 	if (pPage)
//STRIP001 	{
//STRIP001 		Size aSize = pPage->GetSize();
//STRIP001 		if (aLogicRect.Right() >= aSize.Width())					// rechts
//STRIP001 		{
//STRIP001 			long nDiff = aLogicRect.Right() - aSize.Width() + 1;
//STRIP001 			aLogicRect.Left() -= nDiff;
//STRIP001 			aLogicRect.Right() -= nDiff;
//STRIP001 			bChange = TRUE;
//STRIP001 		}
//STRIP001 		if (aLogicRect.Bottom() >= aSize.Height())					// unten
//STRIP001 		{
//STRIP001 			long nDiff = aLogicRect.Bottom() - aSize.Height() + 1;
//STRIP001 			aLogicRect.Top() -= nDiff;
//STRIP001 			aLogicRect.Bottom() -= nDiff;
//STRIP001 			bChange = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		DBG_ERROR("RequestObjAreaPixel: Page ist weg");
//STRIP001 
//STRIP001 	if (aLogicRect.Left() < 0)										// links
//STRIP001 	{
//STRIP001 		aLogicRect.Right() -= aLogicRect.Left();
//STRIP001 		aLogicRect.Left() = 0;
//STRIP001 		bChange = TRUE;
//STRIP001 	}
//STRIP001 	if (aLogicRect.Top() < 0)										// oben
//STRIP001 	{
//STRIP001 		aLogicRect.Bottom() -= aLogicRect.Top();
//STRIP001 		aLogicRect.Top() = 0;
//STRIP001 		bChange = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 		//	wieder in Pixel umrechnen
//STRIP001 
//STRIP001 	if (bChange)
//STRIP001 		aRect = Rectangle( pWin->LogicToPixel( aLogicRect.TopLeft() ),
//STRIP001 							pWin->LogicToPixel( aLogicRect.GetSize() ) );
//STRIP001 
//STRIP001 	//	Basisklasse
//STRIP001 
//STRIP001 	SfxInPlaceClient::RequestObjAreaPixel( aRect );
//STRIP001 
//STRIP001 	//	Position und Groesse ins Dokument uebernehmen
//STRIP001 
//STRIP001 	SdrOle2Obj* pDrawObj = GetDrawObj();
//STRIP001 	if (pDrawObj)
//STRIP001 	{
//STRIP001 		//	das ist schon das skalierte Rechteck (wie im Draw-Model)
//STRIP001 
//STRIP001 		Rectangle aOld = pDrawObj->GetLogicRect();
//STRIP001 		if ( aLogicRect != aOld )
//STRIP001 		{
//STRIP001 			//	#56590# Rundungsfehler vermeiden - nur, wenn mindestens 1 Pixel Unterschied
//STRIP001 			//	(getrennt fuer Position und Groesse)
//STRIP001 
//STRIP001 			Size aOnePixel = pWin->PixelToLogic( Size(1,1) );
//STRIP001 			Size aLogicSize = aLogicRect.GetSize();
//STRIP001 			Rectangle aNew = aOld;
//STRIP001 			Size aNewSize = aNew.GetSize();
//STRIP001 
//STRIP001 			if ( Abs( aLogicRect.Left() - aOld.Left() ) >= aOnePixel.Width() )
//STRIP001 				aNew.SetPos( Point( aLogicRect.Left(), aNew.Top() ) );
//STRIP001 			if ( Abs( aLogicRect.Top() - aOld.Top() ) >= aOnePixel.Height() )
//STRIP001 				aNew.SetPos( Point( aNew.Left(), aLogicRect.Top() ) );
//STRIP001 
//STRIP001 			if ( Abs( aLogicSize.Width() - aNewSize.Width() ) >= aOnePixel.Width() )
//STRIP001 				aNewSize.Width() = aLogicSize.Width();
//STRIP001 			if ( Abs( aLogicSize.Height() - aNewSize.Height() ) >= aOnePixel.Height() )
//STRIP001 				aNewSize.Height() = aLogicSize.Height();
//STRIP001 			aNew.SetSize( aNewSize );
//STRIP001 
//STRIP001 			if ( aNew != aOld )						// veraendert nur, wenn mindestens 1 Pixel
//STRIP001 			{
//STRIP001 				pDrawObj->SetLogicRect( aNew );
//STRIP001 
//STRIP001 				//	set document modified (SdrModel::SetChanged is not used)
//STRIP001 				SfxViewShell* pSfxViewSh = GetViewShell();
//STRIP001 				ScTabViewShell* pViewSh = PTR_CAST( ScTabViewShell, pSfxViewSh );
//STRIP001 				if (pViewSh)
//STRIP001 					pViewSh->GetViewData()->GetDocShell()->SetDrawModified();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//
//STRIP001 	//	evtl. scrollen, um Objekt sichtbar zu halten
//STRIP001 	//
//STRIP001 
//STRIP001 	if (pDrawObj)
//STRIP001 		pViewSh->ScrollToObject( pDrawObj );
//STRIP001 }

//STRIP001 void __EXPORT ScClient::ViewChanged( USHORT nAspect )
//STRIP001 {
//STRIP001 	SfxInPlaceClient::ViewChanged( nAspect );
//STRIP001 
//STRIP001 	SvEmbeddedObject* pObj = GetEmbedObj();
//STRIP001 	Rectangle aObjVisArea = OutputDevice::LogicToLogic( pObj->GetVisArea(),
//STRIP001 												pObj->GetMapUnit(), MAP_100TH_MM );
//STRIP001 	Size aVisSize = aObjVisArea.GetSize();
//STRIP001 
//STRIP001 	//	Groesse ins Dokument uebernehmen
//STRIP001 
//STRIP001 	SdrOle2Obj* pDrawObj = GetDrawObj();
//STRIP001 	if (pDrawObj)
//STRIP001 	{
//STRIP001 		Rectangle aLogicRect = pDrawObj->GetLogicRect();
//STRIP001 
//STRIP001 //		SvClientData* pClientData = GetEnv();
//STRIP001 		SvClientData* pClientData = GetClientData();
//STRIP001 		if (pClientData)
//STRIP001 		{
//STRIP001 			Fraction aFractX = pClientData->GetScaleWidth();
//STRIP001 			Fraction aFractY = pClientData->GetScaleHeight();
//STRIP001 			aFractX *= aVisSize.Width();
//STRIP001 			aFractY *= aVisSize.Height();
//STRIP001 			aVisSize = Size( (long) aFractX, (long) aFractY );		// skaliert fuer Draw-Model
//STRIP001 
//STRIP001 				//	pClientData->SetObjArea vor pDrawObj->SetLogicRect, damit keine
//STRIP001 				//	falschen Skalierungen ausgerechnet werden:
//STRIP001 
//STRIP001 			Rectangle aObjArea = aLogicRect;
//STRIP001 			aObjArea.SetSize( aObjVisArea.GetSize() );			// Dokument-Groesse vom Server
//STRIP001 			pClientData->SetObjArea( aObjArea );
//STRIP001 		}
//STRIP001 
//STRIP001 		//	Set size in draw model (scale is recalculated) - only if there was a visible
//STRIP001 		//	change (in pixels)
//STRIP001 
//STRIP001 		SfxViewShell* pSfxViewSh = GetViewShell();
//STRIP001 		ScTabViewShell* pViewSh = PTR_CAST( ScTabViewShell, pSfxViewSh );
//STRIP001 		if ( pViewSh )
//STRIP001 		{
//STRIP001 			Window* pWin = pViewSh->GetActiveWin();
//STRIP001 			if ( pWin->LogicToPixel( aVisSize ) != pWin->LogicToPixel( aLogicRect.GetSize() ) )
//STRIP001 			{
//STRIP001 				aLogicRect.SetSize( aVisSize );
//STRIP001 				pDrawObj->SetLogicRect( aLogicRect );
//STRIP001 
//STRIP001 				//	set document modified (SdrModel::SetChanged is not used)
//STRIP001 				pViewSh->GetViewData()->GetDocShell()->SetDrawModified();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 void __EXPORT ScClient::MakeViewData()
//STRIP001 {
//STRIP001 	SfxInPlaceClient::MakeViewData();
//STRIP001 
//STRIP001 	SvClientData* pClientData = GetClientData();
//STRIP001 	SdrOle2Obj* pDrawObj = GetDrawObj();
//STRIP001 	if (pClientData && pDrawObj)
//STRIP001 	{
//STRIP001 		//	Groesse und Scale wie in tabvwshb
//STRIP001 
//STRIP001 		Rectangle aRect = pDrawObj->GetLogicRect();
//STRIP001 		Size aDrawSize = aRect.GetSize();
//STRIP001 		Size aOleSize = GetEmbedObj()->GetVisArea().GetSize();
//STRIP001 
//STRIP001 			// sichtbarer Ausschnitt wird nur inplace veraendert!
//STRIP001 		aRect.SetSize( aOleSize );
//STRIP001 		pClientData->SetObjArea( aRect );
//STRIP001 
//STRIP001 		Fraction aScaleWidth (aDrawSize.Width(),  aOleSize.Width() );
//STRIP001 		Fraction aScaleHeight(aDrawSize.Height(), aOleSize.Height() );
//STRIP001 		aScaleWidth.ReduceInaccurate(10);		// kompatibel zum SdrOle2Obj
//STRIP001 		aScaleHeight.ReduceInaccurate(10);
//STRIP001 		pClientData->SetSizeScale(aScaleWidth,aScaleHeight);
//STRIP001 	}
//STRIP001 }

//STRIP001 void __EXPORT ScClient::MakeVisible()
//STRIP001 {
//STRIP001 	SdrOle2Obj* pDrawObj = GetDrawObj();
//STRIP001 	if (pDrawObj)
//STRIP001 	{
//STRIP001 		SfxViewShell* pSfxViewSh = GetViewShell();
//STRIP001 		ScTabViewShell* pViewSh = PTR_CAST( ScTabViewShell, pSfxViewSh );
//STRIP001 		if (pViewSh)
//STRIP001 			pViewSh->ScrollToObject( pDrawObj );
//STRIP001 	}
//STRIP001 }

//STRIP001 #if 0
//STRIP001 
//STRIP001 //	Mit Optimierung gibt es Abstuerze beim Deaktivieren von Grafik-Image-Objekten
//STRIP001 
//STRIP001 #ifdef WNT
//STRIP001 #pragma optimize ( "", off )
//STRIP001 #endif

//STRIP001 void lcl_ReplaceObject( SdrOle2Obj* pGrafOle, SdrGrafObj* pGrafObj,
//STRIP001 						SfxViewShell* pSfxViewSh )
//STRIP001 {
//STRIP001 	//	das Ole-Objekt wieder durch das Grafikobjekt ersetzen
//STRIP001 
//STRIP001 	ScTabViewShell* pViewSh = PTR_CAST( ScTabViewShell, pSfxViewSh );
//STRIP001 	if (pViewSh)
//STRIP001 	{
//STRIP001 		SdrView* pSdrView = pViewSh->GetSdrView();
//STRIP001 		SdrPageView* pPV = pSdrView->GetPageViewPvNum(0);
//STRIP001 
//STRIP001 		if ( pGrafOle )
//STRIP001 		{
//STRIP001 			SvInPlaceObjectRef aIPObj = pGrafOle->GetObjRef();
//STRIP001 			Rectangle		   aRect  = pGrafOle->GetLogicRect();
//STRIP001 
//STRIP001 			// #41302# ReplaceObject ohne zu markieren, weil's aus dem
//STRIP001 			// MarkListHasChanged heraus gerufen wird
//STRIP001 			pSdrView->ReplaceObject( pGrafOle, *pPV, pGrafObj, FALSE );
//STRIP001 			pSdrView->EndUndo();
//STRIP001 			pGrafObj->SetLogicRect(aRect);
//STRIP001 			pGrafObj->SetGraphic(SimDLL::GetGraphic(aIPObj));
//STRIP001 		}
//STRIP001 		else							// zwischendurch geloescht ?
//STRIP001 		{
//STRIP001 			DBG_ERROR("Grafik-Ole-Objekt ist weg");
//STRIP001 
//STRIP001 			pSdrView->EndUndo();		//	damit das Undo nicht offen bleibt
//STRIP001 										//!	anderen Text fuer Undo setzen ???
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 #ifdef WNT
//STRIP001 #pragma optimize ( "", on )
//STRIP001 #endif

//STRIP001 #endif

//STRIP001 void __EXPORT ScClient::UIActivate( BOOL bActivate )
//STRIP001 {
//STRIP001 	SvInPlaceClientRef aIPClient( this );	// nicht aus versehen zwischendrin loeschen
//STRIP001 
//STRIP001 	SfxInPlaceClient::UIActivate(bActivate);
//STRIP001 
//STRIP001 #if 0
//STRIP001 	//!	remove this along with the pGrafEdit member!
//STRIP001 
//STRIP001 	if ( !bActivate && pGrafEdit )			// wurde eine Grafik bearbeitet?
//STRIP001 	{
//STRIP001 		SdrOle2Obj* pGrafOle = GetDrawObj();
//STRIP001 		SdrGrafObj* pGrafObj = pGrafEdit;
//STRIP001 		pGrafEdit = NULL;					// vor lcl_ReplaceObject
//STRIP001 
//STRIP001 		lcl_ReplaceObject( pGrafOle, pGrafObj, GetViewShell() );
//STRIP001 	}
//STRIP001 #endif
//STRIP001 
//STRIP001 	if ( !bActivate )		//	Chart-Daten-Hervorhebung aufheben
//STRIP001 	{
//STRIP001 		SfxViewShell* pSfxViewSh = GetViewShell();
//STRIP001 		ScTabViewShell* pViewSh = PTR_CAST( ScTabViewShell, pSfxViewSh );
//STRIP001 		if (pViewSh)
//STRIP001 		{
//STRIP001 			pViewSh->ClearHighlightRanges();
//STRIP001 
//STRIP001 			//	Move an der ViewShell soll eigentlich vom Sfx gerufen werden, wenn sich
//STRIP001 			//	das Frame-Window wegen unterschiedlicher Toolboxen o.ae. verschiebt
//STRIP001 			//	(um nicht aus Versehen z.B. Zeichenobjekte zu verschieben, #56515#).
//STRIP001 			//	Dieser Mechanismus funktioniert aber momentan nicht, darum hier der Aufruf
//STRIP001 			//	per Hand (im Move wird verglichen, ob die Position wirklich geaendert ist).
//STRIP001 			pViewSh->ForceMove();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }


}
