/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: autofmt.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 19:33:47 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SC_AUTOFMT_HXX
#define SC_AUTOFMT_HXX

#ifndef _VIRDEV_HXX //autogen
#include <vcl/virdev.hxx>
#endif
#ifndef SV_FIXED_HXX
#include <vcl/fixed.hxx>
#endif
#ifndef SV_LSTBOX_HXX
#include <vcl/lstbox.hxx>
#endif
#ifndef SV_BUTTON_HXX
#include <vcl/button.hxx>
#endif
#ifndef SV_MOREBTN_HXX
#include <vcl/morebtn.hxx>
#endif
#ifndef _DIALOG_HXX //autogen
#include <vcl/dialog.hxx>
#endif
#ifndef _SVTOOLS_SCRIPTEDTEXT_HXX
#include <svtools/scriptedtext.hxx>
#endif
class SvNumberFormatter;
namespace binfilter {


//------------------------------------------------------------------------

class ScAutoFormat;
class ScAutoFormatData;
class SvxBoxItem;
class SvxBorderLine;
class AutoFmtPreview; // s.u.

//------------------------------------------------------------------------

enum AutoFmtLine { TOP_LINE, BOTTOM_LINE, LEFT_LINE, RIGHT_LINE };

//========================================================================

class ScAutoFormatDlg : public ModalDialog
{
public:
			ScAutoFormatDlg( Window*					pParent,
							 ScAutoFormat*				pAutoFormat,
                             const ScAutoFormatData*    pSelFormatData,
                             ScDocument*                pDoc );
			~ScAutoFormatDlg();

	USHORT GetIndex() const { return nIndex; }
	String GetCurrFormatName();

private:
    FixedLine       aFlFormat;
	ListBox			aLbFormat;
	AutoFmtPreview*	pWndPreview;
	OKButton		aBtnOk;
	CancelButton	aBtnCancel;
	HelpButton		aBtnHelp;
	PushButton		aBtnAdd;
	PushButton		aBtnRemove;
	MoreButton		aBtnMore;
    FixedLine       aFlFormatting;
	CheckBox		aBtnNumFormat;
	CheckBox		aBtnBorder;
	CheckBox		aBtnFont;
	CheckBox		aBtnPattern;
	CheckBox		aBtnAlignment;
	CheckBox		aBtnAdjust;
	PushButton		aBtnRename;
	String			aStrTitle;
	String			aStrLabel;
	String			aStrClose;
	String			aStrDelTitle;
	String			aStrDelMsg;
	String			aStrRename;

	//------------------------
	ScAutoFormat*			pFormat;
	const ScAutoFormatData*	pSelFmtData;
	USHORT					nIndex;
	BOOL					bCoreDataChanged;
	BOOL					bFmtInserted;

	void Init			();
	void UpdateChecks	();
	//------------------------
	DECL_LINK( CheckHdl, Button * );
	DECL_LINK( AddHdl, void * );
	DECL_LINK( RemoveHdl, void * );
	DECL_LINK( SelFmtHdl, void * );
	DECL_LINK( CloseHdl, PushButton * );
	DECL_LINK( DblClkHdl, void * );
	DECL_LINK( RenameHdl, void *);

};

//========================================================================

class AutoFmtPreview : public Window
{
public:
            AutoFmtPreview( Window* pParent, const ResId& rRes, ScDocument* pDoc );
			~AutoFmtPreview();

	void NotifyChange( ScAutoFormatData* pNewData );

protected:
	virtual void Paint( const Rectangle& rRect );

private:
    ScAutoFormatData*       pCurData;
    VirtualDevice           aVD;
    SvtScriptedTextHelper   aScriptedText;
    ::com::sun::star::uno::Reference< ::com::sun::star::i18n::XBreakIterator > xBreakIter;
    BOOL                    bFitWidth;
    static USHORT           aFmtMap[25];        // Zuordnung: Zelle->Format
    Rectangle               aCellArray[25];     // Position und Groesse der Zellen
    SvxBoxItem*             aLinePtrArray[49];  // LinienAttribute
    Size                    aPrvSize;
    const USHORT            nLabelColWidth;
    const USHORT            nDataColWidth1;
    const USHORT            nDataColWidth2;
    const USHORT            nRowHeight;
    const String            aStrJan;
    const String            aStrFeb;
    const String            aStrMar;
    const String            aStrNorth;
    const String            aStrMid;
    const String            aStrSouth;
    const String            aStrSum;
    SvNumberFormatter*      pNumFmt;
	//-------------------------------------------
	void	Init			();
	void	DoPaint			( const Rectangle& rRect );
	void	CalcCellArray	( BOOL bFitWidth );
	void	CalcLineMap		();
	void	PaintCells		();
	void	DrawBackground	( USHORT nIndex );
	void	DrawFrame		( USHORT nIndex );
	void	DrawString		( USHORT nIndex );
    void    MakeFonts       ( USHORT nIndex,
                              Font& rFont,
                              Font& rCJKFont,
                              Font& rCTLFont );
	String	MakeNumberString( String cellString, BOOL bAddDec );
	void	DrawFrameLine	( const SvxBorderLine&	rLineD,
							  Point					from,
							  Point					to,
							  BOOL					bHorizontal,
							  const SvxBorderLine&	rLineLT,
							  const SvxBorderLine&	rLineL,
							  const SvxBorderLine&	rLineLB,
							  const SvxBorderLine&	rLineRT,
							  const SvxBorderLine&	rLineR,
							  const SvxBorderLine&	rLineRB );
	void 	CheckPriority	( USHORT			nCurLine,
							  AutoFmtLine		eLine,
							  SvxBorderLine&	rLine );
	void	GetLines		( USHORT nIndex, AutoFmtLine eLine,
							  SvxBorderLine&	rLineD,
							  SvxBorderLine&	rLineLT,
							  SvxBorderLine&	rLineL,
							  SvxBorderLine&	rLineLB,
							  SvxBorderLine&	rLineRT,
							  SvxBorderLine&	rLineR,
							  SvxBorderLine&	rLineRB );
};

} //namespace binfilter
#endif // SC_AUTOFMT_HXX


