/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_orgmgr.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:52:42 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
// auto strip #ifndef _SVSTOR_HXX //autogen
// auto strip #include <so3/svstor.hxx>
// auto strip #endif
// auto strip #include <tools/urlobj.hxx>
#pragma hdrstop

// auto strip #ifndef _UNOTOOLS_PROCESSFACTORY_HXX
// auto strip #include <comphelper/processfactory.hxx>
// auto strip #endif
// auto strip #ifndef _UNOTOOLS_INTLWRAPPER_HXX
// auto strip #include <unotools/intlwrapper.hxx>
// auto strip #endif

// auto strip #include "app.hxx"
// auto strip #include "objsh.hxx"
// auto strip #include "docfile.hxx"
// auto strip #include "docfac.hxx"
// auto strip #include "doctempl.hxx"
// auto strip #include "docvor.hxx"
// auto strip #include "orgmgr.hxx"
// auto strip #include "sfxtypes.hxx"
// auto strip #include "sfxresid.hxx"
#include "view.hrc"
// auto strip #include "docfilt.hxx"
// auto strip #include "fltfnc.hxx"

// auto strip #ifndef _LEGACYBINFILTERMGR_HXX
// auto strip #include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
// auto strip #endif
#include "so3/staticbaseurl.hxx"
namespace binfilter {

//=========================================================================

/*  [Beschreibung]

	Implementierungsklasse; einzelner Eintrag in der Dateiansicht

*/

//STRIP001 struct _FileListEntry
//STRIP001 {
//STRIP001 	String aFileName;			// Dateiname mit komplettem Pfad
//STRIP001 	String aBaseName;			// Dateiname
//STRIP001 	const CollatorWrapper* pCollator;
//STRIP001 	SfxObjectShellLock aDocShell; // ObjectShell als Ref-Klasse
//STRIP001 	SvStorageRef aStor;			// Referenz auf Storage, wenn wir diesen geoeffnet haben
//STRIP001 	BOOL bFile;					// als Datei auf Platte
//STRIP001 								// (!= unbenannt1, nicht als Dok. geladen;
//STRIP001 								// diese werden nicht gespeichert!)
//STRIP001 	BOOL bOwner;				// selbst erzeugt
//STRIP001 	BOOL bNoName;
//STRIP001 
//STRIP001 	_FileListEntry( const String& rFileName,
//STRIP001 					const CollatorWrapper* pColl, const String* pTitle = NULL );
//STRIP001 	~_FileListEntry();
//STRIP001 
//STRIP001 	int operator==( const _FileListEntry &rCmp) const;
//STRIP001 	int operator< ( const _FileListEntry &rCmp) const;
//STRIP001 	BOOL DeleteObjectShell();
//STRIP001 };

//-------------------------------------------------------------------------

//STRIP001 inline int _FileListEntry::operator==(const _FileListEntry &rCmp) const
//STRIP001 {
//STRIP001 	DBG_ASSERT( pCollator, "invalid CollatorWrapper" );
//STRIP001 	return COMPARE_EQUAL == pCollator->compareString(aBaseName, rCmp.aBaseName);
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 inline int _FileListEntry::operator< (const _FileListEntry &rCmp) const
//STRIP001 {
//STRIP001 	DBG_ASSERT( pCollator, "invalid CollatorWrapper" );
//STRIP001 	return COMPARE_LESS == pCollator->compareString(aBaseName, rCmp.aBaseName);
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 _FileListEntry::_FileListEntry( const String& rFileName,
//STRIP001 								const CollatorWrapper* pColl, const String* pTitle ) :
//STRIP001 
//STRIP001 	aFileName	( rFileName ),
//STRIP001 	pCollator	( pColl ),
//STRIP001 	bFile		( FALSE ),
//STRIP001 	bOwner		( FALSE ),
//STRIP001 	bNoName		( TRUE )
//STRIP001 
//STRIP001 {
//STRIP001 	if ( pTitle )
//STRIP001 		aBaseName = *pTitle;
//STRIP001 	else
//STRIP001 	{
//STRIP001 		INetURLObject aObj( rFileName, INET_PROT_FILE );
//STRIP001 		aBaseName = aObj.getName( INetURLObject::LAST_SEGMENT, true,
//STRIP001 								  INetURLObject::DECODE_WITH_CHARSET );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 _FileListEntry::~_FileListEntry()
//STRIP001 {
//STRIP001 	DeleteObjectShell();
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 SV_IMPL_OP_PTRARR_SORT(_SfxObjectList, _FileListEntry*)
//STRIP001 
//STRIP001 //=========================================================================
//STRIP001 
//STRIP001 BOOL _FileListEntry::DeleteObjectShell()
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Freigabe der DokumentShell
//STRIP001 
//STRIP001 	[Returnwert]			TRUE: alles Ok
//STRIP001 							FALSE: es ist ein Fehler aufgetreten (das
//STRIP001 							Dokument konnte nicht gesichert werden)
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	BOOL bRet = TRUE;
//STRIP001 	//Falls wir die Shell angelegt haben und sie veraendert wurde
//STRIP001 	if(bOwner && aDocShell.Is() && aDocShell->IsModified())
//STRIP001 	{
//STRIP001 		//Mussten wir konvertieren?
//STRIP001 		if(aStor.Is())
//STRIP001 		{
//STRIP001 			if(!aDocShell->Save() )
//STRIP001 				bRet = FALSE;
//STRIP001 			else
//STRIP001 			{
//STRIP001 				aStor->Commit();
//STRIP001 //				aDocShell->SfxObjectShell::DoSaveCompleted();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// Falls konvertiert im eigenen Format speichern
//STRIP001 			INetURLObject aObj( aFileName );
//STRIP001 			String aTitle = aObj.getName( INetURLObject::LAST_SEGMENT, true,
//STRIP001 										  INetURLObject::DECODE_WITH_CHARSET );
//STRIP001 			bRet = aDocShell->PreDoSaveAs_Impl(
//STRIP001                         aTitle, aDocShell->GetFactory().GetFilter(0)->GetFilterName(), 0 );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if( bOwner)
//STRIP001 	{
//STRIP001 		aDocShell.Clear();
//STRIP001 		aStor.Clear();
//STRIP001 	}
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxObjectList::SfxObjectList()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxObjectList::~SfxObjectList()
//STRIP001 {
//STRIP001 	DeleteAndDestroy(0, Count());
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 const String &SfxObjectList::GetBaseName(USHORT i) const
//STRIP001 {
//STRIP001 	return (*this)[i]->aBaseName;
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 const String& SfxObjectList::GetFileName( USHORT i ) const
//STRIP001 {
//STRIP001 	return (*this)[i]->aFileName;
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxOrganizeMgr::SfxOrganizeMgr( SfxOrganizeListBox_Impl *pLeft,
//STRIP001 								SfxOrganizeListBox_Impl *pRight,
//STRIP001 								SfxDocumentTemplates *pTempl) :
//STRIP001 	pLeftBox(pLeft),
//STRIP001 	pRightBox(pRight),
//STRIP001 	pTemplates(pTempl? pTempl: new SfxDocumentTemplates),
//STRIP001 	pImpl(new SfxOrganizeMgr_Impl),
//STRIP001 	bModified(0),
//STRIP001 	bDeleteTemplates(pTempl == 0)
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Konstruktor
//STRIP001 
//STRIP001 	Das aktuelle Dokument wird in die Liste der Dokumente
//STRIP001 	aufgenommen.
//STRIP001 
//STRIP001 */
//STRIP001 {
//STRIP001 	pImpl->pDocList = new SfxObjectList;
//STRIP001 	pImpl->pIntlWrapper = new IntlWrapper( ::legacy_binfilters::getLegacyProcessServiceFactory(), Application::GetSettings().GetLocale() );
//STRIP001 	const CollatorWrapper* pCollator = pImpl->pIntlWrapper->getCaseCollator();
//STRIP001 	for ( SfxObjectShell* pTmp = SfxObjectShell::GetFirst(); pTmp; pTmp = SfxObjectShell::GetNext(*pTmp) )
//STRIP001 	{
//STRIP001 		if ( pTmp->GetCreateMode() != SFX_CREATE_MODE_STANDARD ||
//STRIP001 			 !( pTmp->GetFlags() & SFXOBJECTSHELL_HASOPENDOC ) || !pTmp->GetStyleSheetPool() )
//STRIP001 			continue;
//STRIP001 		_FileListEntry* pNewEntry = NULL;
//STRIP001 		BOOL bHasLongName = pTmp->GetMedium()->GetLongName().Len() != 0;
//STRIP001 		String aTitle = pTmp->GetTitle( SFX_TITLE_TITLE );
//STRIP001         pNewEntry = new _FileListEntry( pTmp->GetMedium()->GetName(), pCollator, &aTitle );
//STRIP001 		pNewEntry->aDocShell = pTmp;
//STRIP001 		pImpl->pDocList->C40_PTR_INSERT( _FileListEntry, pNewEntry );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxOrganizeMgr::~SfxOrganizeMgr()
//STRIP001 {
//STRIP001 	if ( bDeleteTemplates )
//STRIP001 		delete pTemplates;
//STRIP001 	delete pImpl->pDocList;
//STRIP001 	delete pImpl->pIntlWrapper;
//STRIP001 	delete pImpl;
//STRIP001 	pLeftBox = pRightBox = NULL;
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxObjectShellRef SfxOrganizeMgr::CreateObjectShell( USHORT nIdx )
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Zugriff auf die DokumentShell an der Position nIdx
//STRIP001 
//STRIP001 	[Returnwert]			Referenz auf die DokumentShell
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	_FileListEntry* pEntry = (*pImpl->pDocList)[nIdx];
//STRIP001 	// andernfalls Doc-Shell anlegen
//STRIP001 	if ( !pEntry->aDocShell.Is() )
//STRIP001 	{
//STRIP001 //(mba)/task        SfxWaitCursor aWaitCursor;
//STRIP001 		INetURLObject aFileObj( pEntry->aFileName );
//STRIP001 		BOOL bDum = FALSE;
//STRIP001 		SfxApplication* pSfxApp = SFX_APP();
//STRIP001         String aFilePath = aFileObj.GetMainURL( INetURLObject::NO_DECODE );
//STRIP001 		pEntry->aDocShell = pSfxApp->DocAlreadyLoaded( aFilePath, FALSE, bDum );
//STRIP001 		if ( !pEntry->aDocShell.Is() )
//STRIP001 		{
//STRIP001 			pEntry->bOwner = TRUE;
//STRIP001 			SfxMedium* pMed = new SfxMedium(
//STRIP001 				aFilePath, ( STREAM_READ | STREAM_SHARE_DENYWRITE ), FALSE, 0 );
//STRIP001 			const SfxFilter* pFilter = NULL;
//STRIP001 			if( pSfxApp->GetFilterMatcher().GuessFilter( *pMed, &pFilter, SFX_FILTER_TEMPLATE, 0 ) ||
//STRIP001 				pFilter && !pFilter->IsOwnFormat() ||
//STRIP001 				pFilter && !pFilter->UsesStorage() )
//STRIP001 			{
//STRIP001 				pSfxApp->LoadTemplate( pEntry->aDocShell, aFilePath );
//STRIP001 				pEntry->aStor = 0;
//STRIP001 				delete pMed;
//STRIP001 				if ( pEntry->aDocShell.Is() )
//STRIP001 					return (SfxObjectShellRef)(SfxObjectShell*)(pEntry->aDocShell);
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				delete pMed;
//STRIP001 				if ( pFilter )
//STRIP001 				{
//STRIP001 					pEntry->aDocShell = (SfxObjectShell *)
//STRIP001 						((SfxFactoryFilterContainer*)pFilter->GetFilterContainer())
//STRIP001 						->GetFactory().CreateObject(SFX_CREATE_MODE_ORGANIZER);
//STRIP001 				}
//STRIP001 
//STRIP001 #if SUPD<583 //(mba)
//STRIP001 				if ( !pEntry->aDocShell.Is() )
//STRIP001 					// Config-Files
//STRIP001 					pEntry->aDocShell = new SfxGenericObjectShell( SFX_CREATE_MODE_ORGANIZER );
//STRIP001 #else
//STRIP001 				if ( !pEntry->aDocShell.Is() )
//STRIP001                     return NULL;
//STRIP001 #endif
//STRIP001 				pEntry->aStor = new SvStorage( aFilePath,
//STRIP001 												STREAM_READWRITE |
//STRIP001 												STREAM_NOCREATE  |
//STRIP001 												STREAM_SHARE_DENYALL,
//STRIP001 												STORAGE_TRANSACTED );
//STRIP001 				// kein Storage-File oder andere Fehler beim Oeffnen
//STRIP001 				if( SVSTREAM_OK == pEntry->aStor->GetError() )
//STRIP001 				{
//STRIP001 					if ( pEntry->aDocShell.Is() )
//STRIP001 					{
//STRIP001 						String aOldBaseURL = so3::StaticBaseUrl::GetBaseURL();
//STRIP001 						pEntry->aDocShell->DoInitNew(0);
//STRIP001 						so3::StaticBaseUrl::SetBaseURL( pEntry->aDocShell->GetMedium()->GetName() );
//STRIP001 						pEntry->aDocShell->LoadFrom(pEntry->aStor);
//STRIP001 						pEntry->aDocShell->DoHandsOff();
//STRIP001 						pEntry->aDocShell->DoSaveCompleted(pEntry->aStor);
//STRIP001 						so3::StaticBaseUrl::SetBaseURL( aOldBaseURL );
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return ( SfxObjectShellRef )(SfxObjectShell*)(pEntry->aDocShell);
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SfxOrganizeMgr::DeleteObjectShell(USHORT nIdx)
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Freigabe der DokumentShell an der Position nIdx
//STRIP001 
//STRIP001 	[Returnwert]			TRUE: alles Ok
//STRIP001 							FALSE: es ist ein Fehler aufgetreten (das
//STRIP001 							Dokument konnte nicht gesichert werden)
//STRIP001 
//STRIP001 */
//STRIP001 {
//STRIP001 	return (*pImpl->pDocList)[nIdx]->DeleteObjectShell();
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxObjectShellRef SfxOrganizeMgr::CreateObjectShell(USHORT nRegion,
//STRIP001 														USHORT nIdx)
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Zugriff auf die DokumentShell an der Position nIdx im Bereich
//STRIP001 	nRegion (Dokumentvorlage)
//STRIP001 
//STRIP001 	[Returnwert]			Referenz auf die DokumentShell
//STRIP001 
//STRIP001 */
//STRIP001 {
//STRIP001 //(mba)/task    SfxWaitCursor aWaitCursor;
//STRIP001 	return pTemplates->CreateObjectShell(nRegion, nIdx);
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SfxOrganizeMgr::DeleteObjectShell(USHORT nRegion, USHORT nIdx)
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Freigabe der DokumentShell an der Position nIdx im Bereich
//STRIP001 	nRegion (Dokumentvorlage)
//STRIP001 
//STRIP001 	[Returnwert]			TRUE: alles Ok
//STRIP001 							FALSE: es ist ein Fehler aufgetreten (das
//STRIP001 							Dokument konnte nicht gesichert werden)
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	return pTemplates->DeleteObjectShell(nRegion, nIdx);
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL	SfxOrganizeMgr::Copy(USHORT nTargetRegion,
//STRIP001 							USHORT nTargetIdx,
//STRIP001 							USHORT nSourceRegion,
//STRIP001 							USHORT nSourceIdx)
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Kopieren einer Dokumentvorlage
//STRIP001 
//STRIP001 	[Parameter]
//STRIP001 
//STRIP001 	USHORT nTargetRegion			Index des Zielbereiches
//STRIP001 	USHORT nTargetIdx				Index Zielposition
//STRIP001 	USHORT nSourceRegion			Index des Quellbereiches
//STRIP001 	USHORT nSourceIdx				Index der zu kopierenden / z uverschiebenden
//STRIP001 									Dokumentvorlage
//STRIP001 
//STRIP001 	[R"uckgabewert]					Erfolg (TRUE) oder Mi"serfolg (FALSE)
//STRIP001 
//STRIP001 
//STRIP001 	[Querverweise]
//STRIP001 
//STRIP001 	<SfxDocumentTemplates::Copy(USHORT nTargetRegion,
//STRIP001 								USHORT nTargetIdx,
//STRIP001 								USHORT nSourceRegion,
//STRIP001 								USHORT nSourceIdx)>
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	if(nSourceIdx == USHRT_MAX)	// keine Verzeichnisse kopieren
//STRIP001 		return FALSE ;
//STRIP001 	const BOOL bOk = pTemplates->Copy(nTargetRegion, nTargetIdx,
//STRIP001 										nSourceRegion, nSourceIdx);
//STRIP001 	if(bOk)
//STRIP001 		bModified = 1;
//STRIP001 	return bOk;
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL	SfxOrganizeMgr::Move(USHORT nTargetRegion,
//STRIP001 							USHORT nTargetIdx,
//STRIP001 							USHORT nSourceRegion,
//STRIP001 							USHORT nSourceIdx)
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Verschieben einer Dokumentvorlage
//STRIP001 
//STRIP001 	[Parameter]
//STRIP001 
//STRIP001 	USHORT nTargetRegion			Index des Zielbereiches
//STRIP001 	USHORT nTargetIdx				Index Zielposition
//STRIP001 	USHORT nSourceRegion			Index des Quellbereiches
//STRIP001 	USHORT nSourceIdx				Index der zu kopierenden / z uverschiebenden
//STRIP001 									Dokumentvorlage
//STRIP001 
//STRIP001 	[R"uckgabewert]					Erfolg (TRUE) oder Mi"serfolg (FALSE)
//STRIP001 
//STRIP001 
//STRIP001 	[Querverweise]
//STRIP001 
//STRIP001 	<SfxDocumentTemplates::Move(USHORT nTargetRegion,
//STRIP001 								USHORT nTargetIdx,
//STRIP001 								USHORT nSourceRegion,
//STRIP001 								USHORT nSourceIdx)>
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	if(nSourceIdx == USHRT_MAX)	// keine Verzeichnisse verschieben
//STRIP001 		return FALSE ;
//STRIP001 	const BOOL bOk = pTemplates->Move(nTargetRegion, nTargetIdx,
//STRIP001 										nSourceRegion, nSourceIdx);
//STRIP001 	if(bOk)
//STRIP001 		bModified = 1;
//STRIP001 	return bOk;
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL	SfxOrganizeMgr::Delete(SfxOrganizeListBox_Impl *pCaller,
//STRIP001 								USHORT nRegion, USHORT nIdx)
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	"oschen einer Dokumentvorlage
//STRIP001 
//STRIP001 	[Parameter]
//STRIP001 
//STRIP001 	SfxOrganizeListBox *pCaller		rufende ListBox; da dieses
//STRIP001 									Event durch das Men"u oder
//STRIP001 									durch das Keyboard angetriggert wird,
//STRIP001 									mu"s das Model der ListBox anschlie"send
//STRIP001 									aktualisiert werden.
//STRIP001 	USHORT nRegion					Index des Bereiches
//STRIP001 	USHORT nIdx						Index der Dokumentvorlage
//STRIP001 
//STRIP001 	[R"uckgabewert]					Erfolg (TRUE) oder Mi"serfolg (FALSE)
//STRIP001 
//STRIP001 
//STRIP001 	[Querverweise]
//STRIP001 
//STRIP001 	<SfxDocumentTemplates::Delete(USHORT nRegion, USHORT nIdx)>
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	const BOOL bOk = pTemplates->Delete(nRegion, nIdx);
//STRIP001 	if(bOk)
//STRIP001 	{
//STRIP001 		bModified = 1;
//STRIP001 			// zu loeschender Eintrag
//STRIP001 		SvLBoxEntry *pEntryToDelete = USHRT_MAX == nIdx?	// Verzeichnis
//STRIP001 			pCaller->SvLBox::GetEntry(nRegion):
//STRIP001 			pCaller->SvLBox::GetEntry(pCaller->SvLBox::GetEntry(nRegion), nIdx);
//STRIP001 
//STRIP001 		pCaller->GetModel()->Remove(pEntryToDelete);
//STRIP001 	}
//STRIP001 	return bOk;
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL	SfxOrganizeMgr::InsertDir
//STRIP001 (
//STRIP001 	SfxOrganizeListBox_Impl*	pCaller,/*	rufende ListBox; da dieses Event
//STRIP001 											durch das Men"u oder durch das
//STRIP001 											Keyboard angetriggert wird,
//STRIP001 											mu\s das Model der ListBox
//STRIP001 											anschlie\send aktualisiert werden */
//STRIP001 	const String&				rText,	//	logischer Name des Bereiches
//STRIP001 	USHORT						nRegion //	Index des Bereiches
//STRIP001 )
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	Einf"ugen eines Bereiches
//STRIP001 
//STRIP001 
//STRIP001 	[R"uckgabewert]
//STRIP001 
//STRIP001 	Erfolg (TRUE) oder Mi\serfolg (FALSE)
//STRIP001 
//STRIP001 
//STRIP001 	[Querverweise]
//STRIP001 
//STRIP001 	<SfxDocumentTemplates::InsertDir(const String &, USHORT nRegion)>
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	const BOOL bOk = pTemplates->InsertDir(rText, nRegion);
//STRIP001 	if(bOk)
//STRIP001 	{
//STRIP001 		bModified = 1;
//STRIP001 		SvLBoxEntry *pEntry = pCaller->InsertEntry(rText,
//STRIP001 												   pCaller->GetOpenedBmp(0),
//STRIP001 												   pCaller->GetClosedBmp(0),
//STRIP001 												   0, TRUE, nRegion);
//STRIP001 		pCaller->Update();
//STRIP001 		pCaller->EditEntry(pEntry);
//STRIP001 	}
//STRIP001 	return bOk;
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SfxOrganizeMgr::SetName(const String &rName,
//STRIP001 							 USHORT nRegion, USHORT nIdx)
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	"Andern eines (logischen) Namens
//STRIP001 
//STRIP001 	[Parameter]
//STRIP001 
//STRIP001 	const String &rName				der neue Name
//STRIP001 	USHORT nRegion					Index des Bereiches
//STRIP001 	USHORT nIdx						Index der Dokumentvorlage
//STRIP001 
//STRIP001 	[R"uckgabewert]					Erfolg (TRUE) oder Mi"serfolg (FALSE)
//STRIP001 
//STRIP001 
//STRIP001 	[Querverweise]
//STRIP001 
//STRIP001 	<SfxDocumentTemplates::SetName(const String &, USHORT nRegion, USHORT nIdx)>
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	const BOOL bOk = pTemplates->SetName(rName, nRegion, nIdx);
//STRIP001 	if(bOk)
//STRIP001 		bModified = 1;
//STRIP001 	return bOk;
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SfxOrganizeMgr::CopyTo(USHORT nRegion, USHORT nIdx, const String &rName) const
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Export einer Vorlage
//STRIP001 
//STRIP001 	[Parameter]
//STRIP001 
//STRIP001 	USHORT nRegion					Index des Bereiches
//STRIP001 	USHORT nIdx						Index der Dokumentvorlage
//STRIP001 	const String &rName				Dateiname
//STRIP001 
//STRIP001 	[R"uckgabewert]					Erfolg (TRUE) oder Mi"serfolg (FALSE)
//STRIP001 
//STRIP001 
//STRIP001 	[Querverweise]
//STRIP001 
//STRIP001 	<SfxDocumentTemplates::CopyTo( USHORT nRegion, USHORT nIdx, const String &)>
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	return pTemplates->CopyTo(nRegion, nIdx, rName);
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SfxOrganizeMgr::CopyFrom(SfxOrganizeListBox_Impl *pCaller,
//STRIP001 							  USHORT nRegion, USHORT nIdx, String &rName)
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Import einer Vorlage
//STRIP001 
//STRIP001 	[Parameter]
//STRIP001 
//STRIP001 	SfxOrganizeListBox *pCaller		rufende ListBox; da dieses
//STRIP001 									Event durch das Men"u angetriggert wird,
//STRIP001 									mu"s das Model der ListBox anschlie"send
//STRIP001 									aktualisiert werden.
//STRIP001 	USHORT nRegion					Index des Bereiches
//STRIP001 	USHORT nIdx						Index der Dokumentvorlage
//STRIP001 	String &rName					Dateiname
//STRIP001 
//STRIP001 	[R"uckgabewert]					Erfolg (TRUE) oder Mi"serfolg (FALSE)
//STRIP001 
//STRIP001 
//STRIP001 	[Querverweise]
//STRIP001 
//STRIP001 	<SfxDocumentTemplates::CopyFrom( USHORT nRegion, USHORT nIdx, const String &)>
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	SvLBoxEntry *pParent = pCaller->FirstSelected();
//STRIP001 	if( nIdx!=USHRT_MAX )
//STRIP001 		pParent = pCaller->GetParent(pParent);
//STRIP001 	if( pTemplates->CopyFrom( nRegion, nIdx, rName ) )
//STRIP001 	{
//STRIP001 		// pCaller aktualisieren
//STRIP001 		if( nIdx == USHRT_MAX )
//STRIP001 			nIdx = 0;
//STRIP001 		else nIdx++;
//STRIP001 
//STRIP001 		SvLBoxEntry *pEntry = pCaller->InsertEntry( rName,
//STRIP001 													pCaller->GetOpenedBmp(1),
//STRIP001 													pCaller->GetClosedBmp(1),
//STRIP001 													pParent, TRUE, nIdx);
//STRIP001 		pCaller->Update();
//STRIP001 		pCaller->EditEntry( pEntry );
//STRIP001 		bModified = TRUE;
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SfxOrganizeMgr::InsertFile( SfxOrganizeListBox_Impl* pCaller, const String& rFileName )
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Eine Datei in der Dateiansicht hinzuf"ugen
//STRIP001 
//STRIP001 	[Parameter]
//STRIP001 
//STRIP001 	SfxOrganizeListBox *pCaller		rufende ListBox; da dieses
//STRIP001 									Event durch das Men"u angetriggert wird,
//STRIP001 									mu"s das Model der ListBox anschlie"send
//STRIP001 									aktualisiert werden.
//STRIP001 	const String &rFileName			Name der hinzuf"ugenden Datei
//STRIP001 
//STRIP001 	[R"uckgabewert]					Erfolg (TRUE) oder Mi"serfolg (FALSE)
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	const CollatorWrapper* pCollator = pImpl->pIntlWrapper->getCaseCollator();
//STRIP001 	_FileListEntry* pEntry = new _FileListEntry( rFileName, pCollator );
//STRIP001 	if ( pImpl->pDocList->C40_PTR_INSERT( _FileListEntry, pEntry ) )
//STRIP001 	{
//STRIP001 		USHORT nPos = 0;
//STRIP001 		pImpl->pDocList->Seek_Entry( pEntry, &nPos );
//STRIP001 		pCaller->InsertEntry( pEntry->aBaseName, pCaller->GetOpenedBmp(1),
//STRIP001 							  pCaller->GetClosedBmp(1), 0, TRUE, nPos );
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SfxOrganizeMgr::Rescan()
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Aktualisieren der Datenbasis
//STRIP001 
//STRIP001 	[R"uckgabewert]
//STRIP001 
//STRIP001 	TRUE					es bestanden Unterschiede
//STRIP001 	FALSE					keine "Anderung
//STRIP001 
//STRIP001 	[Querverweise]
//STRIP001 
//STRIP001 	<SfxDocumentTemplates::Rescan()>
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	if(pTemplates->Rescan())
//STRIP001 	{
//STRIP001 		bModified = TRUE;
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxOrganizeMgr::SaveAll(Window *pParent)
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Schreiben aller ge"anderten Dokumente
//STRIP001 
//STRIP001 	[Parameter]
//STRIP001 
//STRIP001 	Window *pParent			Parent der Boxen f"ur Fehlermeldungen
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	USHORT nRangeCount = pTemplates->GetRegionCount();
//STRIP001 	USHORT i;
//STRIP001 	for(i = 0; i < nRangeCount; ++i)
//STRIP001 	{
//STRIP001 		if( pTemplates->IsRegionLoaded( i ))
//STRIP001 		{
//STRIP001 			const USHORT nCount = pTemplates->GetCount(i);
//STRIP001 			for(USHORT j = 0; j < nCount; ++j)
//STRIP001 			{
//STRIP001 				if(!pTemplates->DeleteObjectShell(i, j))
//STRIP001 				{
//STRIP001 					String aText = String(SfxResId(STR_ERROR_SAVE_TEMPLATE));
//STRIP001 					aText += pTemplates->GetName(i, j);
//STRIP001 					ErrorBox aBox(pParent,
//STRIP001 								  WinBits(WB_OK_CANCEL | WB_DEF_CANCEL),
//STRIP001 								  aText);
//STRIP001 					if(RET_CANCEL == aBox.Execute())
//STRIP001 						break;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	nRangeCount = pImpl->pDocList->Count();
//STRIP001 	for(i = 0; i < nRangeCount; ++i)
//STRIP001 	{
//STRIP001 		_FileListEntry *pEntry = (*pImpl->pDocList)[i];
//STRIP001 		if(!pEntry->DeleteObjectShell())
//STRIP001 		{
//STRIP001 			String aText(SfxResId(STR_ERROR_SAVE_TEMPLATE));
//STRIP001 			aText += pEntry->aBaseName;
//STRIP001 			ErrorBox aBox(pParent, WinBits(WB_OK_CANCEL | WB_DEF_CANCEL), aText);
//STRIP001 			if(RET_CANCEL == aBox.Execute())
//STRIP001 				break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }


}
