/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_chardlg.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:35:48 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef _UNO_LINGU_HXX
#include <unolingu.hxx>
#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <svtools/pathoptions.hxx>
#endif
#ifndef _CTRLTOOL_HXX //autogen
#include <svtools/ctrltool.hxx>
#endif
#ifndef _SFONTITM_HXX
#include <svtools/sfontitm.hxx>
#endif
#ifndef _SFX_PRINTER_HXX //autogen
#include <bf_sfx2/printer.hxx>
#endif
#ifndef _SFX_OBJSH_HXX //autogen
#include <bf_sfx2/objsh.hxx>
#endif
#ifndef _SFXVIEWSH_HXX
#include <bf_sfx2/viewsh.hxx>
#endif
#ifndef _SFX_BINDINGS_HXX
#include <bf_sfx2/bindings.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX
#include <bf_sfx2/viewfrm.hxx>
#endif
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif

#pragma hdrstop

#define _SVX_CHARDLG_CXX

#ifndef _SVTOOLS_LANGUAGEOPTIONS_HXX
#include <svtools/languageoptions.hxx>
#endif

#include "dialogs.hrc"
#include "svxitems.hrc"
#include "chardlg.hrc"
namespace binfilter {

//Erstmal definieren, damit die Klassendeklarionen angezogen werden.
#define ITEMID_FONT 			SID_ATTR_CHAR_FONT
#define ITEMID_POSTURE			SID_ATTR_CHAR_POSTURE
#define ITEMID_WEIGHT			SID_ATTR_CHAR_WEIGHT
#define ITEMID_SHADOWED 		SID_ATTR_CHAR_SHADOWED
#define ITEMID_WORDLINEMODE 	SID_ATTR_CHAR_WORDLINEMODE
#define ITEMID_CONTOUR			SID_ATTR_CHAR_CONTOUR
#define ITEMID_CROSSEDOUT		SID_ATTR_CHAR_STRIKEOUT
#define ITEMID_UNDERLINE		SID_ATTR_CHAR_UNDERLINE
#define ITEMID_FONTHEIGHT		SID_ATTR_CHAR_FONTHEIGHT
#define ITEMID_PROPSIZE 		SID_ATTR_CHAR_PROPSIZE
#define ITEMID_COLOR			SID_ATTR_CHAR_COLOR
#define ITEMID_KERNING			SID_ATTR_CHAR_KERNING
#define ITEMID_CASEMAP			SID_ATTR_CHAR_CASEMAP
#define ITEMID_LANGUAGE 		SID_ATTR_CHAR_LANGUAGE
#define ITEMID_ESCAPEMENT		SID_ATTR_CHAR_ESCAPEMENT
#define ITEMID_FONTLIST 		SID_ATTR_CHAR_FONTLIST
#define ITEMID_AUTOKERN 		SID_ATTR_CHAR_AUTOKERN
#define ITEMID_COLOR_TABLE		SID_COLOR_TABLE
#define ITEMID_BLINK			SID_ATTR_FLASH
#define ITEMID_BRUSH			SID_ATTR_BRUSH
#define ITEMID_EMPHASISMARK		SID_ATTR_CHAR_EMPHASISMARK
#define ITEMID_TWOLINES			SID_ATTR_CHAR_TWO_LINES
#define ITEMID_CHARROTATE		SID_ATTR_CHAR_ROTATED
#define ITEMID_CHARSCALE_W		SID_ATTR_CHAR_SCALEWIDTH
#define ITEMID_CHARRELIEF       SID_ATTR_CHAR_RELIEF

#include "xtable.hxx"		// XColorTable
#include "chardlg.hxx"
#include "fontitem.hxx"
#include "postitem.hxx"
#include "udlnitem.hxx"
#include "crsditem.hxx"
#include "cntritem.hxx"
#include "langitem.hxx"
#include "wghtitem.hxx"
#include "fhgtitem.hxx"
#include "shdditem.hxx"
#include "escpitem.hxx"
#include "prszitem.hxx"
#include "wrlmitem.hxx"
#include "cmapitem.hxx"
#include "kernitem.hxx"
#include "blnkitem.hxx"
#include "flstitem.hxx"
#include "akrnitem.hxx"
#include "brshitem.hxx"
#include "colritem.hxx"
#include "drawitem.hxx"
#include "dlgutil.hxx"
#include "dialmgr.hxx"
#include "htmlmode.hxx"
#include "charmap.hxx"
#include "chardlg.h"
#include "emphitem.hxx"
#include <charreliefitem.hxx>
#include "twolinesitem.hxx"

#ifndef _SVX_CHARSCALEITEM_HXX
#include <charscaleitem.hxx>
#endif
#ifndef _SVX_CHARROTATEITEM_HXX
#include <charrotateitem.hxx>
#endif

using namespace ::com::sun::star;

// define ----------------------------------------------------------------

//STRIP001 #define ISITEMSET	rSet.GetItemState(nWhich)>=SFX_ITEM_DEFAULT
//STRIP001 
//STRIP001 #define CLEARTITEM	rSet.InvalidateItem(nWhich)
//STRIP001 
//STRIP001 #define LW_NORMAL	0
//STRIP001 #define LW_GESPERRT 1
//STRIP001 #define LW_SCHMAL	2
//STRIP001 
//STRIP001 // static ----------------------------------------------------------------
//STRIP001 
//STRIP001 static USHORT pStdRanges[] =
//STRIP001 {
//STRIP001 	SID_ATTR_CHAR_FONT,
//STRIP001 	SID_ATTR_CHAR_SHADOWED,
//STRIP001 	SID_ATTR_CHAR_CONTOUR,
//STRIP001 	SID_ATTR_CHAR_COLOR,
//STRIP001 	SID_ATTR_CHAR_CASEMAP,
//STRIP001 	SID_ATTR_CHAR_FONTLIST,
//STRIP001 	0
//STRIP001 };
//STRIP001 
//STRIP001 static USHORT pExtRanges[] =
//STRIP001 {
//STRIP001 	SID_ATTR_CHAR_WORDLINEMODE,
//STRIP001 	SID_ATTR_CHAR_WORDLINEMODE,
//STRIP001 	SID_ATTR_CHAR_STRIKEOUT,
//STRIP001 	SID_ATTR_CHAR_UNDERLINE,
//STRIP001 	SID_ATTR_CHAR_PROPSIZE,
//STRIP001 	SID_ATTR_CHAR_PROPSIZE,
//STRIP001 	SID_ATTR_CHAR_KERNING,
//STRIP001 	SID_ATTR_CHAR_CASEMAP,
//STRIP001 	SID_ATTR_CHAR_ESCAPEMENT,
//STRIP001 	SID_ATTR_CHAR_ESCAPEMENT,
//STRIP001 	0
//STRIP001 };
//STRIP001 
//STRIP001 static USHORT pNameRanges[] =
//STRIP001 {
//STRIP001 	SID_ATTR_CHAR_FONT,
//STRIP001 	SID_ATTR_CHAR_WEIGHT,
//STRIP001 	SID_ATTR_CHAR_FONTHEIGHT,
//STRIP001 	SID_ATTR_CHAR_FONTHEIGHT,
//STRIP001 	SID_ATTR_CHAR_COLOR,
//STRIP001 	SID_ATTR_CHAR_COLOR,
//STRIP001 	SID_ATTR_CHAR_LANGUAGE,
//STRIP001 	SID_ATTR_CHAR_LANGUAGE,
//STRIP001 	SID_ATTR_CHAR_CJK_FONT,
//STRIP001 	SID_ATTR_CHAR_CJK_WEIGHT,
//STRIP001 	SID_ATTR_CHAR_CTL_FONT,
//STRIP001 	SID_ATTR_CHAR_CTL_WEIGHT,
//STRIP001 	0
//STRIP001 };
//STRIP001 
//STRIP001 static USHORT pEffectsRanges[] =
//STRIP001 {
//STRIP001 	SID_ATTR_CHAR_SHADOWED,
//STRIP001 	SID_ATTR_CHAR_UNDERLINE,
//STRIP001 	SID_ATTR_CHAR_CASEMAP,
//STRIP001 	SID_ATTR_CHAR_CASEMAP,
//STRIP001 	SID_ATTR_FLASH,
//STRIP001 	SID_ATTR_FLASH,
//STRIP001 	SID_ATTR_CHAR_EMPHASISMARK,
//STRIP001 	SID_ATTR_CHAR_EMPHASISMARK,
//STRIP001 	SID_ATTR_CHAR_RELIEF,
//STRIP001 	SID_ATTR_CHAR_RELIEF,
//STRIP001 	0
//STRIP001 };
//STRIP001 
//STRIP001 static USHORT pPositionRanges[] =
//STRIP001 {
//STRIP001 	SID_ATTR_CHAR_KERNING,
//STRIP001 	SID_ATTR_CHAR_KERNING,
//STRIP001 	SID_ATTR_CHAR_ESCAPEMENT,
//STRIP001 	SID_ATTR_CHAR_ESCAPEMENT,
//STRIP001 	SID_ATTR_CHAR_AUTOKERN,
//STRIP001 	SID_ATTR_CHAR_AUTOKERN,
//STRIP001 	SID_ATTR_CHAR_ROTATED,
//STRIP001 	SID_ATTR_CHAR_SCALEWIDTH,
//STRIP001 	SID_ATTR_CHAR_WIDTH_FIT_TO_LINE,
//STRIP001 	SID_ATTR_CHAR_WIDTH_FIT_TO_LINE,
//STRIP001 	0
//STRIP001 };
//STRIP001 
//STRIP001 static USHORT pTwoLinesRanges[] =
//STRIP001 {
//STRIP001 	SID_ATTR_CHAR_TWO_LINES,
//STRIP001 	SID_ATTR_CHAR_TWO_LINES,
//STRIP001 	0
//STRIP001 };
//STRIP001 
//STRIP001 // C-Funktion ------------------------------------------------------------
//STRIP001 
//STRIP001 inline BOOL StateToAttr( TriState aState )
//STRIP001 {
//STRIP001 	return ( STATE_CHECK == aState );
//STRIP001 }
//STRIP001 
//STRIP001 // class SvxCharBasePage -------------------------------------------------
//STRIP001 
//STRIP001 inline SvxFont& SvxCharBasePage::GetPreviewFont()
//STRIP001 {
//STRIP001 	return m_aPreviewWin.GetFont();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 inline SvxFont& SvxCharBasePage::GetPreviewCJKFont()
//STRIP001 {
//STRIP001 	return m_aPreviewWin.GetCJKFont();
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 inline SvxFont& SvxCharBasePage::GetPreviewCTLFont()
//STRIP001 {
//STRIP001 	return m_aPreviewWin.GetCTLFont();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxCharBasePage::SvxCharBasePage( Window* pParent, const ResId& rResId, const SfxItemSet& rItemset,
//STRIP001 								 USHORT nResIdPrewievWin, USHORT nResIdFontTypeFT ):
//STRIP001 	SfxTabPage( pParent, rResId, rItemset ),
//STRIP001     m_aPreviewWin( this, ResId( nResIdPrewievWin ) ),
//STRIP001     m_aFontTypeFT( this, ResId( nResIdFontTypeFT ) ),
//STRIP001 	m_bPreviewBackgroundToCharacter( FALSE )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxCharBasePage::~SvxCharBasePage()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 //void SvxCharBasePage::SetPrevFontAttributes( const SfxItemSet& rSet )
//STRIP001 void SvxCharBasePage::ActivatePage( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	SvxFont&		rFont = GetPreviewFont();
//STRIP001     SvxFont&		rCJKFont = GetPreviewCJKFont();
//STRIP001 	SvxFont&		rCTLFont = GetPreviewCTLFont();
//STRIP001 	USHORT			nWhich;
//STRIP001 
//STRIP001 	// Underline
//STRIP001 	FontUnderline eUnderline;
//STRIP001 	nWhich = GetWhich( SID_ATTR_CHAR_UNDERLINE );
//STRIP001 	if( ISITEMSET )
//STRIP001 	{
//STRIP001 		const SvxUnderlineItem& rItem = ( SvxUnderlineItem& ) rSet.Get( nWhich );
//STRIP001 		eUnderline = ( FontUnderline ) rItem.GetValue();
//STRIP001 		m_aPreviewWin.SetTextLineColor( rItem.GetColor() );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		eUnderline = UNDERLINE_NONE;
//STRIP001 
//STRIP001 	rFont.SetUnderline( eUnderline );
//STRIP001     rCJKFont.SetUnderline( eUnderline );
//STRIP001 	rCTLFont.SetUnderline( eUnderline );
//STRIP001 
//STRIP001 	//	Strikeout
//STRIP001 	FontStrikeout eStrikeout;
//STRIP001 	nWhich = GetWhich( SID_ATTR_CHAR_STRIKEOUT );
//STRIP001 	if( ISITEMSET )
//STRIP001 	{
//STRIP001 		const SvxCrossedOutItem& rItem = ( SvxCrossedOutItem& ) rSet.Get( nWhich );
//STRIP001 		eStrikeout = ( FontStrikeout ) rItem.GetValue();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		eStrikeout = STRIKEOUT_NONE;
//STRIP001 
//STRIP001 	rFont.SetStrikeout( eStrikeout );
//STRIP001     rCJKFont.SetStrikeout( eStrikeout );
//STRIP001 	rCTLFont.SetStrikeout( eStrikeout );
//STRIP001 
//STRIP001 	// WordLineMode
//STRIP001 	nWhich = GetWhich( SID_ATTR_CHAR_WORDLINEMODE );
//STRIP001 	if( ISITEMSET )
//STRIP001 	{
//STRIP001 		const SvxWordLineModeItem& rItem = ( SvxWordLineModeItem& ) rSet.Get( nWhich );
//STRIP001 		rFont.SetWordLineMode( rItem.GetValue() );
//STRIP001         rCJKFont.SetWordLineMode( rItem.GetValue() );
//STRIP001 		rCTLFont.SetWordLineMode( rItem.GetValue() );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Emphasis
//STRIP001 	nWhich = GetWhich( SID_ATTR_CHAR_EMPHASISMARK );
//STRIP001 	if( ISITEMSET )
//STRIP001 	{
//STRIP001 		const SvxEmphasisMarkItem& rItem = ( SvxEmphasisMarkItem& ) rSet.Get( nWhich );
//STRIP001 		FontEmphasisMark eMark = rItem.GetEmphasisMark();
//STRIP001 		rFont.SetEmphasisMark( eMark );
//STRIP001         rCJKFont.SetEmphasisMark( eMark );
//STRIP001 		rCTLFont.SetEmphasisMark( eMark );
//STRIP001 	}
//STRIP001 
//STRIP001     // Relief
//STRIP001     nWhich = GetWhich( SID_ATTR_CHAR_RELIEF );
//STRIP001     if( ISITEMSET )
//STRIP001 	{
//STRIP001         const SvxCharReliefItem& rItem = ( SvxCharReliefItem& ) rSet.Get( nWhich );
//STRIP001 		FontRelief eFontRelief = ( FontRelief ) rItem.GetValue();
//STRIP001         rFont.SetRelief( eFontRelief );
//STRIP001         rCJKFont.SetRelief( eFontRelief );
//STRIP001 		rCTLFont.SetRelief( eFontRelief );
//STRIP001     }
//STRIP001 
//STRIP001 	// Effects
//STRIP001 	nWhich = GetWhich( SID_ATTR_CHAR_CASEMAP );
//STRIP001 	if( ISITEMSET )
//STRIP001 	{
//STRIP001 		const SvxCaseMapItem& rItem = ( SvxCaseMapItem& ) rSet.Get( nWhich );
//STRIP001 		SvxCaseMap eCaseMap = ( SvxCaseMap ) rItem.GetValue();
//STRIP001 		rFont.SetCaseMap( eCaseMap );
//STRIP001         rCJKFont.SetCaseMap( eCaseMap );
//STRIP001 		rCTLFont.SetCaseMap( eCaseMap );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Outline
//STRIP001 	nWhich = GetWhich( SID_ATTR_CHAR_CONTOUR );
//STRIP001 	if( ISITEMSET )
//STRIP001 	{
//STRIP001 		const SvxContourItem& rItem = ( SvxContourItem& ) rSet.Get( nWhich );
//STRIP001 		BOOL bOutline = rItem.GetValue();
//STRIP001 		rFont.SetOutline( bOutline );
//STRIP001         rCJKFont.SetOutline( bOutline );
//STRIP001 		rCTLFont.SetOutline( bOutline );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Shadow
//STRIP001 	nWhich = GetWhich( SID_ATTR_CHAR_SHADOWED );
//STRIP001 	if( ISITEMSET )
//STRIP001 	{
//STRIP001 		const SvxShadowedItem& rItem = ( SvxShadowedItem& ) rSet.Get( nWhich );
//STRIP001 		BOOL bShadow = rItem.GetValue();
//STRIP001 		rFont.SetShadow( bShadow );
//STRIP001         rCJKFont.SetShadow( bShadow );
//STRIP001 		rCTLFont.SetShadow( bShadow );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Background
//STRIP001 	BOOL bTransparent;
//STRIP001     nWhich = GetWhich( m_bPreviewBackgroundToCharacter ? SID_ATTR_BRUSH : SID_ATTR_BRUSH_CHAR );
//STRIP001     if( ISITEMSET )
//STRIP001     {
//STRIP001          const SvxBrushItem& rBrush = ( SvxBrushItem& ) rSet.Get( nWhich );
//STRIP001          const Color& rColor = rBrush.GetColor();
//STRIP001 		 bTransparent = rColor.GetTransparency() > 0;
//STRIP001          rFont.SetFillColor( rColor );
//STRIP001          rCJKFont.SetFillColor( rColor );
//STRIP001 		 rCTLFont.SetFillColor( rColor );
//STRIP001     }
//STRIP001     else
//STRIP001         bTransparent = TRUE;
//STRIP001 
//STRIP001     rFont.SetTransparent( bTransparent );
//STRIP001     rCJKFont.SetTransparent( bTransparent );
//STRIP001 	rCTLFont.SetTransparent( bTransparent );
//STRIP001 
//STRIP001 	Color aBackCol( COL_TRANSPARENT );
//STRIP001 	if( !m_bPreviewBackgroundToCharacter )
//STRIP001 	{
//STRIP001 		nWhich = GetWhich( SID_ATTR_BRUSH );
//STRIP001 		if( ISITEMSET )
//STRIP001 		{
//STRIP001 			const SvxBrushItem& rBrush = ( SvxBrushItem& ) rSet.Get( nWhich );
//STRIP001 			if( GPOS_NONE == rBrush.GetGraphicPos() )
//STRIP001 				aBackCol = rBrush.GetColor();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	m_aPreviewWin.SetBackColor( aBackCol );
//STRIP001 
//STRIP001 	// Font
//STRIP001 	SetPrevFont( rSet, SID_ATTR_CHAR_FONT, rFont );
//STRIP001 	SetPrevFont( rSet, SID_ATTR_CHAR_CJK_FONT, rCJKFont );
//STRIP001 	SetPrevFont( rSet, SID_ATTR_CHAR_CTL_FONT, rCTLFont );
//STRIP001 
//STRIP001 	// Style
//STRIP001 	SetPrevFontStyle( rSet, SID_ATTR_CHAR_POSTURE, SID_ATTR_CHAR_WEIGHT, rFont );
//STRIP001 	SetPrevFontStyle( rSet, SID_ATTR_CHAR_CJK_POSTURE, SID_ATTR_CHAR_CJK_WEIGHT, rCJKFont );
//STRIP001 	SetPrevFontStyle( rSet, SID_ATTR_CHAR_CTL_POSTURE, SID_ATTR_CHAR_CTL_WEIGHT, rCTLFont );
//STRIP001 
//STRIP001 	// Size
//STRIP001 	SetPrevFontSize( rSet, SID_ATTR_CHAR_FONTHEIGHT, rFont );
//STRIP001 	SetPrevFontSize( rSet, SID_ATTR_CHAR_CJK_FONTHEIGHT, rCJKFont );
//STRIP001 	SetPrevFontSize( rSet, SID_ATTR_CHAR_CTL_FONTHEIGHT, rCTLFont );
//STRIP001 
//STRIP001 	// Color
//STRIP001 	nWhich = GetWhich( SID_ATTR_CHAR_COLOR );
//STRIP001 	if( ISITEMSET )
//STRIP001 	{
//STRIP001 		const SvxColorItem& rItem = ( SvxColorItem& ) rSet.Get( nWhich );
//STRIP001 		Color aCol( rItem.GetValue() );
//STRIP001 		rFont.SetColor( aCol );
//STRIP001         rCJKFont.SetColor( aCol );
//STRIP001 		rCTLFont.SetColor( aCol );
//STRIP001 
//STRIP001 		m_aPreviewWin.AutoCorrectFontColor();	// handle color COL_AUTO
//STRIP001 	}
//STRIP001 
//STRIP001 	// Kerning
//STRIP001 	nWhich = GetWhich( SID_ATTR_CHAR_KERNING );
//STRIP001 	if( ISITEMSET )
//STRIP001 	{
//STRIP001 		const SvxKerningItem& rItem = ( SvxKerningItem& ) rSet.Get( nWhich );
//STRIP001 		short nKern = ( short )
//STRIP001 						LogicToLogic( rItem.GetValue(), ( MapUnit ) rSet.GetPool()->GetMetric( nWhich ), MAP_TWIP );
//STRIP001 		rFont.SetFixKerning( nKern );
//STRIP001         rCJKFont.SetFixKerning( nKern );
//STRIP001 		rCTLFont.SetFixKerning( nKern );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Escapement
//STRIP001 	nWhich = GetWhich( SID_ATTR_CHAR_ESCAPEMENT );
//STRIP001 	const BYTE nProp = 100;
//STRIP001 	short nEsc;
//STRIP001 	BYTE nEscProp;
//STRIP001 	if( ISITEMSET )
//STRIP001 	{
//STRIP001 		const SvxEscapementItem& rItem = ( SvxEscapementItem& ) rSet.Get( nWhich );
//STRIP001 		nEsc = rItem.GetEsc();
//STRIP001 		nEscProp = rItem.GetProp();
//STRIP001 
//STRIP001 		if( nEsc == DFLT_ESC_AUTO_SUPER )
//STRIP001 			nEsc = DFLT_ESC_SUPER;
//STRIP001 		else if( nEsc == DFLT_ESC_AUTO_SUB )
//STRIP001 			nEsc = DFLT_ESC_SUB;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		nEsc  = 0;
//STRIP001 		nEscProp = 100;
//STRIP001 	}
//STRIP001 
//STRIP001 	SetPrevFontEscapement( nProp, nEscProp, nEsc );
//STRIP001 
//STRIP001 	// Font width scale
//STRIP001 	SetPrevFontWidthScale( rSet );
//STRIP001 
//STRIP001     m_aPreviewWin.Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxCharBasePage::SetPrevFontSize( const SfxItemSet& rSet, USHORT nSlot, SvxFont& rFont )
//STRIP001 {
//STRIP001 	USHORT nWhich = GetWhich( nSlot );
//STRIP001 	long nH;
//STRIP001 	if( rSet.GetItemState( nWhich ) >= SFX_ITEM_SET )
//STRIP001 	{
//STRIP001 		nH = LogicToLogic(	( ( SvxFontHeightItem& ) rSet.Get( nWhich ) ).GetHeight(),
//STRIP001 							( MapUnit ) rSet.GetPool()->GetMetric( nWhich ),
//STRIP001 							MAP_TWIP );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		nH = 240;	// as default 12pt
//STRIP001 
//STRIP001 	rFont.SetSize( Size( 0, nH ) );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxCharBasePage::SetPrevFont( const SfxItemSet& rSet, USHORT nSlot, SvxFont& rFont )
//STRIP001 {
//STRIP001 	USHORT nWhich = GetWhich( nSlot );
//STRIP001 	if( ISITEMSET )
//STRIP001 	{
//STRIP001 		const SvxFontItem& rFontItem = ( SvxFontItem& ) rSet.Get( nWhich );
//STRIP001 		rFont.SetFamily( rFontItem.GetFamily() );
//STRIP001 		rFont.SetName( rFontItem.GetFamilyName() );
//STRIP001 		rFont.SetPitch( rFontItem.GetPitch() );
//STRIP001 		rFont.SetCharSet( rFontItem.GetCharSet() );
//STRIP001 		rFont.SetStyleName( rFontItem.GetStyleName() );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxCharBasePage::SetPrevFontStyle( const SfxItemSet& rSet, USHORT nPosture, USHORT nWeight, SvxFont& rFont )
//STRIP001 {
//STRIP001 	USHORT nWhich = GetWhich( nPosture );
//STRIP001 	if( ISITEMSET )
//STRIP001 	{
//STRIP001 		const SvxPostureItem& rItem = ( SvxPostureItem& ) rSet.Get( nWhich );
//STRIP001 		rFont.SetItalic( ( FontItalic ) rItem.GetValue() != ITALIC_NONE ? ITALIC_NORMAL : ITALIC_NONE );
//STRIP001 	}
//STRIP001 
//STRIP001     nWhich = GetWhich( nWeight );
//STRIP001 	if( ISITEMSET )
//STRIP001 	{
//STRIP001 		SvxWeightItem& rItem = ( SvxWeightItem& ) rSet.Get( nWhich );
//STRIP001 		rFont.SetWeight( ( FontWeight ) rItem.GetValue() != WEIGHT_NORMAL ? WEIGHT_BOLD : WEIGHT_NORMAL );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxCharBasePage::SetPrevFontWidthScale( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	USHORT	nWhich = GetWhich( SID_ATTR_CHAR_SCALEWIDTH );
//STRIP001 	if( ISITEMSET )
//STRIP001 	{
//STRIP001 		const SvxCharScaleWidthItem&	rItem = ( SvxCharScaleWidthItem& ) rSet.Get( nWhich );
//STRIP001 
//STRIP001 		m_aPreviewWin.SetFontWidthScale( rItem.GetValue() );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 namespace
//STRIP001 {
//STRIP001 	// -----------------------------------------------------------------------
//STRIP001 	void setPrevFontEscapement(SvxFont& _rFont,BYTE nProp, BYTE nEscProp, short nEsc )
//STRIP001 	{
//STRIP001 		_rFont.SetPropr( nProp );
//STRIP001 		_rFont.SetProprRel( nEscProp );
//STRIP001 		_rFont.SetEscapement( nEsc );
//STRIP001 	}
//STRIP001 	// -----------------------------------------------------------------------
//STRIP001 	// -----------------------------------------------------------------------
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxCharBasePage::SetPrevFontEscapement( BYTE nProp, BYTE nEscProp, short nEsc )
//STRIP001 {
//STRIP001 	setPrevFontEscapement(GetPreviewFont(),nProp,nEscProp,nEsc);
//STRIP001 	setPrevFontEscapement(GetPreviewCJKFont(),nProp,nEscProp,nEsc);
//STRIP001 	setPrevFontEscapement(GetPreviewCTLFont(),nProp,nEscProp,nEsc);
//STRIP001     m_aPreviewWin.Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 // SvxCharNamePage_Impl --------------------------------------------------
//STRIP001 
//STRIP001 struct SvxCharNamePage_Impl
//STRIP001 {
//STRIP001 	Timer			m_aUpdateTimer;
//STRIP001 	String			m_aNoStyleText;
//STRIP001 	String			m_aTransparentText;
//STRIP001 	const FontList*	m_pFontList;
//STRIP001 	USHORT			m_nExtraEntryPos;
//STRIP001 	BOOL			m_bMustDelete;
//STRIP001 	BOOL			m_bInSearchMode;
//STRIP001 
//STRIP001 	SvxCharNamePage_Impl() :
//STRIP001 
//STRIP001 		m_pFontList		( NULL ),
//STRIP001 		m_nExtraEntryPos( LISTBOX_ENTRY_NOTFOUND ),
//STRIP001 		m_bMustDelete	( FALSE ),
//STRIP001         m_bInSearchMode ( FALSE )
//STRIP001 
//STRIP001 	{
//STRIP001 		m_aUpdateTimer.SetTimeout( 350 );
//STRIP001 	}
//STRIP001 
//STRIP001 	~SvxCharNamePage_Impl()
//STRIP001 	{
//STRIP001 		if ( m_bMustDelete )
//STRIP001 			delete m_pFontList;
//STRIP001 	}
//STRIP001 };
//STRIP001 
//STRIP001 // class SvxCharNamePage -------------------------------------------------
//STRIP001 
//STRIP001 SvxCharNamePage::SvxCharNamePage( Window* pParent, const SfxItemSet& rInSet ) :
//STRIP001 
//STRIP001 	SvxCharBasePage( pParent, SVX_RES( RID_SVXPAGE_CHAR_NAME ), rInSet, WIN_CHAR_PREVIEW, FT_CHAR_FONTTYPE ),
//STRIP001     m_pImpl                 ( new SvxCharNamePage_Impl )
//STRIP001 {
//STRIP001 	m_pImpl->m_aNoStyleText = String( ResId( STR_CHARNAME_NOSTYLE ) );
//STRIP001 	m_pImpl->m_aTransparentText = String( ResId( STR_CHARNAME_TRANSPARENT ) );
//STRIP001 
//STRIP001 	SvtLanguageOptions aLanguageOptions;
//STRIP001     sal_Bool bCJK = ( aLanguageOptions.IsCJKFontEnabled() || aLanguageOptions.IsCTLFontEnabled() );
//STRIP001 
//STRIP001     m_pWestLine         = new FixedLine( this, ResId( FL_WEST ) );
//STRIP001     m_pWestFontNameFT   = new FixedText( this, ResId( bCJK ? FT_WEST_NAME : FT_WEST_NAME_NOCJK ) );
//STRIP001     m_pWestFontNameLB   = new FontNameBox( this, ResId( bCJK ? LB_WEST_NAME : LB_WEST_NAME_NOCJK ) );
//STRIP001     m_pWestFontStyleFT  = new FixedText( this, ResId( bCJK ? FT_WEST_STYLE : FT_WEST_STYLE_NOCJK ) );
//STRIP001     m_pWestFontStyleLB  = new FontStyleBox( this, ResId( bCJK ? LB_WEST_STYLE : LB_WEST_STYLE_NOCJK ) );
//STRIP001     m_pWestFontSizeFT   = new FixedText( this, ResId( bCJK ? FT_WEST_SIZE : FT_WEST_SIZE_NOCJK ) );
//STRIP001     m_pWestFontSizeLB   = new FontSizeBox( this, ResId( bCJK ? LB_WEST_SIZE : LB_WEST_SIZE_NOCJK ) );
//STRIP001 
//STRIP001     if( !bCJK )
//STRIP001     {
//STRIP001         m_pColorFL  = new FixedLine( this, ResId( FL_COLOR2 ) );
//STRIP001         m_pColorFT  = new FixedText( this, ResId( FT_COLOR2 ) );
//STRIP001         m_pColorLB  = new ColorListBox( this, ResId( LB_COLOR2 ) );
//STRIP001     }
//STRIP001 
//STRIP001     m_pWestFontLanguageFT   = new FixedText( this, ResId( bCJK ? FT_WEST_LANG : FT_WEST_LANG_NOCJK ) );
//STRIP001     m_pWestFontLanguageLB   = new SvxLanguageBox( this, ResId( bCJK ? LB_WEST_LANG : LB_WEST_LANG_NOCJK ) );
//STRIP001 
//STRIP001     m_pEastLine             = new FixedLine( this, ResId( FL_EAST ) );
//STRIP001     m_pEastFontNameFT       = new FixedText( this, ResId( FT_EAST_NAME ) );
//STRIP001     m_pEastFontNameLB       = new FontNameBox( this, ResId( LB_EAST_NAME ) );
//STRIP001     m_pEastFontStyleFT      = new FixedText( this, ResId( FT_EAST_STYLE ) );
//STRIP001     m_pEastFontStyleLB      = new FontStyleBox( this, ResId( LB_EAST_STYLE ) );
//STRIP001     m_pEastFontSizeFT       = new FixedText( this, ResId( FT_EAST_SIZE ) );
//STRIP001     m_pEastFontSizeLB       = new FontSizeBox( this, ResId( LB_EAST_SIZE ) );
//STRIP001     m_pEastFontLanguageFT   = new FixedText( this, ResId( FT_EAST_LANG ) );
//STRIP001     m_pEastFontLanguageLB   = new SvxLanguageBox( this, ResId( LB_EAST_LANG ) );
//STRIP001 
//STRIP001     m_pCTLLine              = new FixedLine( this, ResId( FL_CTL ) );
//STRIP001     m_pCTLFontNameFT        = new FixedText( this, ResId( FT_CTL_NAME ) );
//STRIP001     m_pCTLFontNameLB        = new FontNameBox( this, ResId( LB_CTL_NAME ) );
//STRIP001     m_pCTLFontStyleFT		= new FixedText( this, ResId( FT_CTL_STYLE ) );
//STRIP001     m_pCTLFontStyleLB		= new FontStyleBox( this, ResId( LB_CTL_STYLE ) );
//STRIP001     m_pCTLFontSizeFT		= new FixedText( this, ResId( FT_CTL_SIZE ) );
//STRIP001     m_pCTLFontSizeLB		= new FontSizeBox( this, ResId( LB_CTL_SIZE ) );
//STRIP001     m_pCTLFontLanguageFT	= new FixedText( this, ResId( FT_CTL_LANG ) );
//STRIP001     m_pCTLFontLanguageLB	= new SvxLanguageBox( this, ResId( LB_CTL_LANG ) );
//STRIP001 
//STRIP001     if( bCJK )
//STRIP001     {
//STRIP001         m_pColorFL  = new FixedLine( this, ResId( FL_COLOR2 ) );
//STRIP001         m_pColorFT  = new FixedText( this, ResId( FT_COLOR2 ) );
//STRIP001         m_pColorLB  = new ColorListBox( this, ResId( LB_COLOR2 ) );
//STRIP001     }
//STRIP001 
//STRIP001     m_pWestLine             ->Show( bCJK );
//STRIP001     m_pColorFL              ->Show( bCJK );
//STRIP001 
//STRIP001 	bCJK = aLanguageOptions.IsCJKFontEnabled();
//STRIP001 	m_pEastLine             ->Show( bCJK );
//STRIP001     m_pEastFontNameFT       ->Show( bCJK );
//STRIP001     m_pEastFontNameLB       ->Show( bCJK );
//STRIP001     m_pEastFontStyleFT      ->Show( bCJK );
//STRIP001     m_pEastFontStyleLB      ->Show( bCJK );
//STRIP001     m_pEastFontSizeFT       ->Show( bCJK );
//STRIP001     m_pEastFontSizeLB       ->Show( bCJK );
//STRIP001     m_pEastFontLanguageFT   ->Show( bCJK );
//STRIP001     m_pEastFontLanguageLB   ->Show( bCJK );
//STRIP001 
//STRIP001 	sal_Bool bShowCTL = aLanguageOptions.IsCTLFontEnabled();
//STRIP001 	if ( bShowCTL && !bCJK )
//STRIP001 	{
//STRIP001 		// move CTL controls to the places of the CJK controls, if these controls aren't visible
//STRIP001 		m_pCTLLine             ->SetPosPixel( m_pEastLine->GetPosPixel() );
//STRIP001     	m_pCTLFontNameFT       ->SetPosPixel( m_pEastFontNameFT->GetPosPixel() );
//STRIP001     	m_pCTLFontNameLB       ->SetPosPixel( m_pEastFontNameLB->GetPosPixel() );
//STRIP001     	m_pCTLFontStyleFT      ->SetPosPixel( m_pEastFontStyleFT->GetPosPixel() );
//STRIP001     	m_pCTLFontStyleLB      ->SetPosPixel( m_pEastFontStyleLB->GetPosPixel() );
//STRIP001     	m_pCTLFontSizeFT       ->SetPosPixel( m_pEastFontSizeFT->GetPosPixel() );
//STRIP001     	m_pCTLFontSizeLB       ->SetPosPixel( m_pEastFontSizeLB->GetPosPixel() );
//STRIP001     	m_pCTLFontLanguageFT   ->SetPosPixel( m_pEastFontLanguageFT->GetPosPixel() );
//STRIP001     	m_pCTLFontLanguageLB   ->SetPosPixel( m_pEastFontLanguageLB->GetPosPixel() );
//STRIP001 	}
//STRIP001 	m_pCTLLine             ->Show( bShowCTL );
//STRIP001     m_pCTLFontNameFT       ->Show( bShowCTL );
//STRIP001     m_pCTLFontNameLB       ->Show( bShowCTL );
//STRIP001     m_pCTLFontStyleFT      ->Show( bShowCTL );
//STRIP001     m_pCTLFontStyleLB      ->Show( bShowCTL );
//STRIP001     m_pCTLFontSizeFT       ->Show( bShowCTL );
//STRIP001     m_pCTLFontSizeLB       ->Show( bShowCTL );
//STRIP001     m_pCTLFontLanguageFT   ->Show( bShowCTL );
//STRIP001     m_pCTLFontLanguageLB   ->Show( bShowCTL );
//STRIP001 
//STRIP001     FreeResource();
//STRIP001 
//STRIP001     m_pWestFontLanguageLB->SetLanguageList( LANG_LIST_WESTERN,	TRUE, FALSE, TRUE );
//STRIP001     m_pEastFontLanguageLB->SetLanguageList( LANG_LIST_CJK,		TRUE, FALSE, TRUE );
//STRIP001     m_pCTLFontLanguageLB->SetLanguageList( LANG_LIST_CTL,		TRUE, FALSE, TRUE );
//STRIP001 
//STRIP001 	Initialize();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxCharNamePage::~SvxCharNamePage()
//STRIP001 {
//STRIP001 	if ( m_pImpl->m_bMustDelete )
//STRIP001 		delete m_pImpl->m_pFontList;
//STRIP001 	delete m_pImpl;
//STRIP001 
//STRIP001     delete m_pWestLine;
//STRIP001     delete m_pWestFontNameFT;
//STRIP001     delete m_pWestFontNameLB;
//STRIP001     delete m_pWestFontStyleFT;
//STRIP001     delete m_pWestFontStyleLB;
//STRIP001     delete m_pWestFontSizeFT;
//STRIP001     delete m_pWestFontSizeLB;
//STRIP001     delete m_pWestFontLanguageFT;
//STRIP001     delete m_pWestFontLanguageLB;
//STRIP001 
//STRIP001     delete m_pEastLine;
//STRIP001     delete m_pEastFontNameFT;
//STRIP001     delete m_pEastFontNameLB;
//STRIP001     delete m_pEastFontStyleFT;
//STRIP001     delete m_pEastFontStyleLB;
//STRIP001     delete m_pEastFontSizeFT;
//STRIP001     delete m_pEastFontSizeLB;
//STRIP001     delete m_pEastFontLanguageFT;
//STRIP001     delete m_pEastFontLanguageLB;
//STRIP001 
//STRIP001     delete m_pCTLLine;
//STRIP001     delete m_pCTLFontNameFT;
//STRIP001     delete m_pCTLFontNameLB;
//STRIP001     delete m_pCTLFontStyleFT;
//STRIP001     delete m_pCTLFontStyleLB;
//STRIP001     delete m_pCTLFontSizeFT;
//STRIP001     delete m_pCTLFontSizeLB;
//STRIP001     delete m_pCTLFontLanguageFT;
//STRIP001     delete m_pCTLFontLanguageLB;
//STRIP001 
//STRIP001     delete m_pColorFL;
//STRIP001     delete m_pColorFT;
//STRIP001     delete m_pColorLB;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxCharNamePage::Initialize()
//STRIP001 {
//STRIP001 	// to handle the changes of the other pages
//STRIP001 	SetExchangeSupport();
//STRIP001 
//STRIP001 	// fill the color box
//STRIP001 	SfxObjectShell* pDocSh = SfxObjectShell::Current();
//STRIP001 	DBG_ASSERT( pDocSh, "DocShell not found!" );
//STRIP001 	XColorTable* pColorTable = NULL;
//STRIP001 	FASTBOOL bKillTable = FALSE;
//STRIP001 	const SfxPoolItem* pItem = NULL;
//STRIP001 
//STRIP001 	if ( pDocSh && ( pItem = pDocSh->GetItem( SID_COLOR_TABLE ) ) )
//STRIP001 		pColorTable = ( (SvxColorTableItem*)pItem )->GetColorTable();
//STRIP001 
//STRIP001 	if ( !pColorTable )
//STRIP001 	{
//STRIP001 		pColorTable = new XColorTable( SvtPathOptions().GetPalettePath() );
//STRIP001 		bKillTable = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001     m_pColorLB->SetUpdateMode( FALSE );
//STRIP001 
//STRIP001 	{
//STRIP001 		SfxPoolItem* pDummy;
//STRIP001 		SfxViewFrame* pFrame = SfxViewFrame::GetFirst( pDocSh );
//STRIP001 		if( !pFrame || SFX_ITEM_DEFAULT > pFrame->GetBindings().QueryState(
//STRIP001 									SID_ATTR_AUTO_COLOR_INVALID, pDummy ))
//STRIP001 	    	m_pColorLB->InsertEntry( Color( COL_AUTO ),
//STRIP001 								 	SVX_RESSTR( RID_SVXSTR_AUTOMATIC ));
//STRIP001 	}
//STRIP001     for ( long i = 0; i < pColorTable->Count(); i++ )
//STRIP001 	{
//STRIP001 		XColorEntry* pEntry = pColorTable->Get(i);
//STRIP001         m_pColorLB->InsertEntry( pEntry->GetColor(), pEntry->GetName() );
//STRIP001 	}
//STRIP001 
//STRIP001     m_pColorLB->SetUpdateMode( TRUE );
//STRIP001 
//STRIP001 	if ( bKillTable )
//STRIP001 		delete pColorTable;
//STRIP001 
//STRIP001     m_pColorLB->SetSelectHdl( LINK( this, SvxCharNamePage, ColorBoxSelectHdl_Impl ) );
//STRIP001 
//STRIP001 	Link aLink = LINK( this, SvxCharNamePage, FontModifyHdl_Impl );
//STRIP001     m_pWestFontNameLB->SetModifyHdl( aLink );
//STRIP001     m_pWestFontStyleLB->SetModifyHdl( aLink );
//STRIP001     m_pWestFontSizeLB->SetModifyHdl( aLink );
//STRIP001     m_pEastFontNameLB->SetModifyHdl( aLink );
//STRIP001     m_pEastFontStyleLB->SetModifyHdl( aLink );
//STRIP001     m_pEastFontSizeLB->SetModifyHdl( aLink );
//STRIP001     m_pCTLFontNameLB->SetModifyHdl( aLink );
//STRIP001     m_pCTLFontStyleLB->SetModifyHdl( aLink );
//STRIP001     m_pCTLFontSizeLB->SetModifyHdl( aLink );
//STRIP001 
//STRIP001 	m_pImpl->m_aUpdateTimer.SetTimeoutHdl( LINK( this, SvxCharNamePage, UpdateHdl_Impl ) );
//STRIP001 
//STRIP001     m_pColorFL->Hide();
//STRIP001     m_pColorFT->Hide();
//STRIP001     m_pColorLB->Hide();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 const FontList* SvxCharNamePage::GetFontList() const
//STRIP001 {
//STRIP001     if ( !m_pImpl->m_pFontList )
//STRIP001     {
//STRIP001         SfxObjectShell* pDocSh = SfxObjectShell::Current();
//STRIP001         const SfxPoolItem* pItem;
//STRIP001 
//STRIP001         /* #110771# SvxFontListItem::GetFontList can return NULL */
//STRIP001         if ( pDocSh && ( pItem = pDocSh->GetItem( SID_ATTR_CHAR_FONTLIST ) ) )
//STRIP001         {
//STRIP001             m_pImpl->m_pFontList = ( (SvxFontListItem*)pItem )->GetFontList();
//STRIP001             DBG_ASSERT(NULL != m_pImpl->m_pFontList,
//STRIP001                        "Where is the font list?")
//STRIP001         }
//STRIP001         if(!m_pImpl->m_pFontList)
//STRIP001         {
//STRIP001             m_pImpl->m_pFontList = 
//STRIP001                 new FontList( Application::GetDefaultDevice() );
//STRIP001             m_pImpl->m_bMustDelete = TRUE;
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     return m_pImpl->m_pFontList;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 namespace
//STRIP001 {
//STRIP001 	FontInfo calcFontInfo(	SvxFont& _rFont,
//STRIP001 					SvxCharNamePage* _pPage,
//STRIP001 					const FontNameBox* _pFontNameLB,
//STRIP001 					const FontStyleBox* _pFontStyleLB,
//STRIP001 					const FontSizeBox* _pFontSizeLB,
//STRIP001 					const FontList* _pFontList,
//STRIP001 					USHORT _nFontWhich,
//STRIP001 					USHORT _nFontHeightWhich)
//STRIP001 	{
//STRIP001 		Size aSize = _rFont.GetSize();
//STRIP001 		aSize.Width() = 0;
//STRIP001 		FontInfo aFontInfo;
//STRIP001 		String sFontName(_pFontNameLB->GetText());
//STRIP001 		BOOL bFontAvailable = _pFontList->IsAvailable( sFontName );
//STRIP001 		if(bFontAvailable  || _pFontNameLB->GetSavedValue() != sFontName)
//STRIP001 			aFontInfo = _pFontList->Get( sFontName, _pFontStyleLB->GetText() );
//STRIP001 		else
//STRIP001 		{
//STRIP001 			//get the font from itemset
//STRIP001 			SfxItemState eState = _pPage->GetItemSet().GetItemState( _nFontWhich );
//STRIP001 			if ( eState >= SFX_ITEM_DEFAULT )
//STRIP001 			{
//STRIP001 				const SvxFontItem* pFontItem = (const SvxFontItem*)&( _pPage->GetItemSet().Get( _nFontWhich ) );
//STRIP001 				aFontInfo.SetName(pFontItem->GetFamilyName());
//STRIP001 				aFontInfo.SetStyleName(pFontItem->GetStyleName());
//STRIP001 				aFontInfo.SetFamily(pFontItem->GetFamily());
//STRIP001 				aFontInfo.SetPitch(pFontItem->GetPitch());
//STRIP001 				aFontInfo.SetCharSet(pFontItem->GetCharSet());
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if ( _pFontSizeLB->IsRelative() )
//STRIP001 		{
//STRIP001 			DBG_ASSERT( _pPage->GetItemSet().GetParent(), "No parent set" );
//STRIP001 			const SvxFontHeightItem& rOldItem = (SvxFontHeightItem&)_pPage->GetItemSet().GetParent()->Get( _nFontHeightWhich );
//STRIP001 
//STRIP001 			// alter Wert, skaliert
//STRIP001 			long nHeight;
//STRIP001 			if ( _pFontSizeLB->IsPtRelative() )
//STRIP001 				nHeight = rOldItem.GetHeight() + PointToTwips( _pFontSizeLB->GetValue() / 10 );
//STRIP001 			else
//STRIP001 				nHeight = rOldItem.GetHeight() * _pFontSizeLB->GetValue() / 100;
//STRIP001 
//STRIP001 			// Umrechnung in twips fuer das Beispiel-Window
//STRIP001 			aSize.Height() =
//STRIP001 				ItemToControl( nHeight, _pPage->GetItemSet().GetPool()->GetMetric( _nFontHeightWhich ), SFX_FUNIT_TWIP );
//STRIP001 		}
//STRIP001 		else if ( _pFontSizeLB->GetText().Len() )
//STRIP001 			aSize.Height() = PointToTwips( _pFontSizeLB->GetValue() / 10 );
//STRIP001 		else
//STRIP001 			aSize.Height() = 200;	// default 10pt
//STRIP001 		aFontInfo.SetSize( aSize );
//STRIP001 
//STRIP001 		_rFont.SetFamily( aFontInfo.GetFamily() );
//STRIP001 		_rFont.SetName( aFontInfo.GetName() );
//STRIP001 		_rFont.SetStyleName( aFontInfo.GetStyleName() );
//STRIP001 		_rFont.SetPitch( aFontInfo.GetPitch() );
//STRIP001 		_rFont.SetCharSet( aFontInfo.GetCharSet() );
//STRIP001 		_rFont.SetWeight( aFontInfo.GetWeight() );
//STRIP001 		_rFont.SetItalic( aFontInfo.GetItalic() );
//STRIP001 		_rFont.SetSize( aFontInfo.GetSize() );
//STRIP001 
//STRIP001 		return aFontInfo;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxCharNamePage::UpdatePreview_Impl()
//STRIP001 {
//STRIP001 	SvxFont& rFont = GetPreviewFont();
//STRIP001     SvxFont& rCJKFont = GetPreviewCJKFont();
//STRIP001 	SvxFont& rCTLFont = GetPreviewCTLFont();
//STRIP001 	// Size
//STRIP001 	Size aSize = rFont.GetSize();
//STRIP001 	aSize.Width() = 0;
//STRIP001     Size aCJKSize = rCJKFont.GetSize();
//STRIP001     aCJKSize.Width() = 0;
//STRIP001 	Size aCTLSize = rCTLFont.GetSize();
//STRIP001     aCTLSize.Width() = 0;
//STRIP001 	// Font
//STRIP001 	const FontList* pFontList = GetFontList();
//STRIP001 	FontInfo aFontInfo =
//STRIP001 		calcFontInfo(rFont,this,m_pWestFontNameLB,m_pWestFontStyleLB,m_pWestFontSizeLB,pFontList,GetWhich( SID_ATTR_CHAR_FONT ),GetWhich( SID_ATTR_CHAR_FONTHEIGHT ));
//STRIP001 
//STRIP001 	calcFontInfo(rCJKFont,this,m_pEastFontNameLB,m_pEastFontStyleLB,m_pEastFontSizeLB,pFontList,GetWhich( SID_ATTR_CHAR_CJK_FONT ),GetWhich( SID_ATTR_CHAR_CJK_FONTHEIGHT ));
//STRIP001 
//STRIP001 	calcFontInfo(rCTLFont,this,m_pCTLFontNameLB,m_pCTLFontStyleLB,m_pCTLFontSizeLB,pFontList,GetWhich( SID_ATTR_CHAR_CTL_FONT ),GetWhich( SID_ATTR_CHAR_CTL_FONTHEIGHT ));
//STRIP001 
//STRIP001     m_aPreviewWin.Invalidate();
//STRIP001     m_aFontTypeFT.SetText( pFontList->GetFontMapText( aFontInfo ) );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxCharNamePage::FillStyleBox_Impl( const FontNameBox* pNameBox )
//STRIP001 {
//STRIP001 	const FontList* pFontList = GetFontList();
//STRIP001 	DBG_ASSERT( pFontList, "no fontlist" );
//STRIP001 
//STRIP001 	FontStyleBox* pStyleBox = NULL;
//STRIP001 
//STRIP001     if ( m_pWestFontNameLB == pNameBox )
//STRIP001 		pStyleBox = m_pWestFontStyleLB;
//STRIP001     else if ( m_pEastFontNameLB == pNameBox )
//STRIP001 		pStyleBox = m_pEastFontStyleLB;
//STRIP001     else if ( m_pCTLFontNameLB == pNameBox )
//STRIP001         pStyleBox = m_pCTLFontStyleLB;
//STRIP001 	else
//STRIP001 	{
//STRIP001 		DBG_ERRORFILE( "invalid font name box" );
//STRIP001 	}
//STRIP001 
//STRIP001 	pStyleBox->Fill( pNameBox->GetText(), pFontList );
//STRIP001 
//STRIP001 	if ( m_pImpl->m_bInSearchMode )
//STRIP001 	{
//STRIP001 		// Bei der Suche zus"atzliche Eintr"age:
//STRIP001 		// "Nicht Fett" und "Nicht Kursiv"
//STRIP001 		String aEntry = m_pImpl->m_aNoStyleText;
//STRIP001 		const sal_Char sS[] = "%s";
//STRIP001 		aEntry.SearchAndReplaceAscii( sS, pFontList->GetBoldStr() );
//STRIP001         m_pImpl->m_nExtraEntryPos = pStyleBox->InsertEntry( aEntry );
//STRIP001 		aEntry = m_pImpl->m_aNoStyleText;
//STRIP001 		aEntry.SearchAndReplaceAscii( sS, pFontList->GetItalicStr() );
//STRIP001         pStyleBox->InsertEntry( aEntry );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxCharNamePage::FillSizeBox_Impl( const FontNameBox* pNameBox )
//STRIP001 {
//STRIP001 	const FontList* pFontList = GetFontList();
//STRIP001 	DBG_ASSERT( pFontList, "no fontlist" );
//STRIP001 
//STRIP001 	FontStyleBox* pStyleBox = NULL;
//STRIP001 	FontSizeBox* pSizeBox = NULL;
//STRIP001 
//STRIP001     if ( m_pWestFontNameLB == pNameBox )
//STRIP001 	{
//STRIP001 		pStyleBox = m_pWestFontStyleLB;
//STRIP001 		pSizeBox = m_pWestFontSizeLB;
//STRIP001 	}
//STRIP001     else if ( m_pEastFontNameLB == pNameBox )
//STRIP001 	{
//STRIP001 		pStyleBox = m_pEastFontStyleLB;
//STRIP001 		pSizeBox = m_pEastFontSizeLB;
//STRIP001 	}
//STRIP001     else if ( m_pCTLFontNameLB == pNameBox )
//STRIP001 	{
//STRIP001         pStyleBox = m_pCTLFontStyleLB;
//STRIP001 		pSizeBox = m_pCTLFontSizeLB;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		DBG_ERRORFILE( "invalid font name box" );
//STRIP001 	}
//STRIP001 
//STRIP001 	pSizeBox->Fill( pFontList->Get( pNameBox->GetText(), pStyleBox->GetText() ), pFontList );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxCharNamePage::Reset_Impl( const SfxItemSet& rSet, LanguageGroup eLangGrp )
//STRIP001 {
//STRIP001     FixedText* pNameLabel = NULL;
//STRIP001     FontNameBox* pNameBox = NULL;
//STRIP001     FixedText* pStyleLabel = NULL;
//STRIP001     FontStyleBox* pStyleBox = NULL;
//STRIP001     FixedText* pSizeLabel = NULL;
//STRIP001     FontSizeBox* pSizeBox = NULL;
//STRIP001     FixedText* pLangFT = NULL;
//STRIP001     SvxLanguageBox* pLangBox = NULL;
//STRIP001 	USHORT nWhich = 0;
//STRIP001 
//STRIP001 	switch ( eLangGrp )
//STRIP001 	{
//STRIP001 		case Western :
//STRIP001 			pNameLabel = m_pWestFontNameFT;
//STRIP001 			pNameBox = m_pWestFontNameLB;
//STRIP001 			pStyleLabel = m_pWestFontStyleFT;
//STRIP001 			pStyleBox = m_pWestFontStyleLB;
//STRIP001 			pSizeLabel = m_pWestFontSizeFT;
//STRIP001 			pSizeBox = m_pWestFontSizeLB;
//STRIP001 			pLangFT = m_pWestFontLanguageFT;
//STRIP001 			pLangBox = m_pWestFontLanguageLB;
//STRIP001 			nWhich = GetWhich( SID_ATTR_CHAR_FONT );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case Asian :
//STRIP001 			pNameLabel = m_pEastFontNameFT;
//STRIP001 			pNameBox = m_pEastFontNameLB;
//STRIP001 			pStyleLabel = m_pEastFontStyleFT;
//STRIP001 			pStyleBox = m_pEastFontStyleLB;
//STRIP001 			pSizeLabel = m_pEastFontSizeFT;
//STRIP001 			pSizeBox = m_pEastFontSizeLB;
//STRIP001 			pLangFT = m_pEastFontLanguageFT;
//STRIP001 			pLangBox = m_pEastFontLanguageLB;
//STRIP001 			nWhich = GetWhich( SID_ATTR_CHAR_CJK_FONT );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case Ctl :
//STRIP001 			pNameLabel = m_pCTLFontNameFT;
//STRIP001 			pNameBox = m_pCTLFontNameLB;
//STRIP001 			pStyleLabel = m_pCTLFontStyleFT;
//STRIP001 			pStyleBox = m_pCTLFontStyleLB;
//STRIP001 			pSizeLabel = m_pCTLFontSizeFT;
//STRIP001 			pSizeBox = m_pCTLFontSizeLB;
//STRIP001 			pLangFT = m_pCTLFontLanguageFT;
//STRIP001 			pLangBox = m_pCTLFontLanguageLB;
//STRIP001 			nWhich = GetWhich( SID_ATTR_CHAR_CTL_FONT );
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	// die FontListBox fuellen
//STRIP001 	const FontList* pFontList = GetFontList();
//STRIP001 	pNameBox->Fill( pFontList );
//STRIP001 
//STRIP001 	// Font ermitteln
//STRIP001 	const SvxFontItem* pFontItem = NULL;
//STRIP001 	SfxItemState eState = rSet.GetItemState( nWhich );
//STRIP001 
//STRIP001 	if ( eState >= SFX_ITEM_DEFAULT )
//STRIP001 	{
//STRIP001 		pFontItem = (const SvxFontItem*)&( rSet.Get( nWhich ) );
//STRIP001 		pNameBox->SetText( pFontItem->GetFamilyName() );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pNameBox->SetText( String() );
//STRIP001 	}
//STRIP001 
//STRIP001 	FillStyleBox_Impl( pNameBox );
//STRIP001 
//STRIP001 	FASTBOOL bStyle = FALSE;
//STRIP001 	FASTBOOL bStyleAvailable = TRUE;
//STRIP001 	FontItalic eItalic = ITALIC_NONE;
//STRIP001 	FontWeight eWeight = WEIGHT_NORMAL;
//STRIP001 	switch ( eLangGrp )
//STRIP001 	{
//STRIP001 		case Western : nWhich = GetWhich( SID_ATTR_CHAR_POSTURE ); break;
//STRIP001 		case Asian : nWhich = GetWhich( SID_ATTR_CHAR_CJK_POSTURE ); break;
//STRIP001 		case Ctl : nWhich = GetWhich( SID_ATTR_CHAR_CTL_POSTURE ); break;
//STRIP001 	}
//STRIP001 	eState = rSet.GetItemState( nWhich );
//STRIP001 
//STRIP001 	if ( eState >= SFX_ITEM_DEFAULT )
//STRIP001 	{
//STRIP001 		const SvxPostureItem& rItem = (SvxPostureItem&)rSet.Get( nWhich );
//STRIP001 		eItalic = (FontItalic)rItem.GetValue();
//STRIP001 		bStyle = TRUE;
//STRIP001 	}
//STRIP001 	bStyleAvailable = bStyleAvailable && (eState >= SFX_ITEM_DONTCARE);
//STRIP001 
//STRIP001 	switch ( eLangGrp )
//STRIP001 	{
//STRIP001 		case Western : nWhich = GetWhich( SID_ATTR_CHAR_WEIGHT ); break;
//STRIP001 		case Asian : nWhich = GetWhich( SID_ATTR_CHAR_CJK_WEIGHT ); break;
//STRIP001 		case Ctl : nWhich = GetWhich( SID_ATTR_CHAR_CTL_WEIGHT ); break;
//STRIP001 	}
//STRIP001 	eState = rSet.GetItemState( nWhich );
//STRIP001 
//STRIP001 	if ( eState >= SFX_ITEM_DEFAULT )
//STRIP001 	{
//STRIP001 		SvxWeightItem& rItem = (SvxWeightItem&)rSet.Get( nWhich );
//STRIP001 		eWeight = (FontWeight)rItem.GetValue();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		bStyle = FALSE;
//STRIP001 	bStyleAvailable = bStyleAvailable && (eState >= SFX_ITEM_DONTCARE);
//STRIP001 
//STRIP001 	// Aktuell eingestellter Font
//STRIP001 	if ( bStyle && pFontItem )
//STRIP001 	{
//STRIP001 		FontInfo aInfo = pFontList->Get( pFontItem->GetFamilyName(), eWeight, eItalic );
//STRIP001 		pStyleBox->SetText( pFontList->GetStyleName( aInfo ) );
//STRIP001 	}
//STRIP001 	else if ( !m_pImpl->m_bInSearchMode || !bStyle )
//STRIP001 	{
//STRIP001 		pStyleBox->SetText( String() );
//STRIP001 	}
//STRIP001 	else if ( bStyle )
//STRIP001 	{
//STRIP001 		FontInfo aInfo = pFontList->Get( String(), eWeight, eItalic );
//STRIP001 		pStyleBox->SetText( pFontList->GetStyleName( aInfo ) );
//STRIP001 	}
//STRIP001 	if (!bStyleAvailable)
//STRIP001 	{
//STRIP001 		pStyleBox->Disable( );
//STRIP001 		pStyleLabel->Disable( );
//STRIP001 	}
//STRIP001 
//STRIP001 	// SizeBox fuellen
//STRIP001 	FillSizeBox_Impl( pNameBox );
//STRIP001 	switch ( eLangGrp )
//STRIP001 	{
//STRIP001 		case Western : nWhich = GetWhich( SID_ATTR_CHAR_FONTHEIGHT ); break;
//STRIP001 		case Asian : nWhich = GetWhich( SID_ATTR_CHAR_CJK_FONTHEIGHT ); break;
//STRIP001 		case Ctl : nWhich = GetWhich( SID_ATTR_CHAR_CTL_FONTHEIGHT ); break;
//STRIP001 	}
//STRIP001 	eState = rSet.GetItemState( nWhich );
//STRIP001 
//STRIP001 	if ( pSizeBox->IsRelativeMode() )
//STRIP001 	{
//STRIP001 		SfxMapUnit eUnit = rSet.GetPool()->GetMetric( nWhich );
//STRIP001 		const SvxFontHeightItem& rItem = (SvxFontHeightItem&)rSet.Get( nWhich );
//STRIP001 
//STRIP001 		if( rItem.GetProp() != 100 || SFX_MAPUNIT_RELATIVE != rItem.GetPropUnit() )
//STRIP001 		{
//STRIP001 			BOOL bPtRel = SFX_MAPUNIT_POINT == rItem.GetPropUnit();
//STRIP001 			pSizeBox->SetPtRelative( bPtRel );
//STRIP001 			pSizeBox->SetValue( bPtRel ? ((short)rItem.GetProp()) * 10 : rItem.GetProp() );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			pSizeBox->SetRelative();
//STRIP001 			pSizeBox->SetValue( (long)CalcToPoint( rItem.GetHeight(), eUnit, 10 ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( eState >= SFX_ITEM_DEFAULT )
//STRIP001 	{
//STRIP001 		SfxMapUnit eUnit = rSet.GetPool()->GetMetric( nWhich );
//STRIP001 		const SvxFontHeightItem& rItem = (SvxFontHeightItem&)rSet.Get( nWhich );
//STRIP001 		pSizeBox->SetValue( (long)CalcToPoint( rItem.GetHeight(), eUnit, 10 ) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pSizeBox->SetText( String() );
//STRIP001 		if ( eState <= SFX_ITEM_READONLY )
//STRIP001 		{
//STRIP001 			pSizeBox->Disable( );
//STRIP001 			pSizeLabel->Disable( );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	switch ( eLangGrp )
//STRIP001 	{
//STRIP001 		case Western : nWhich = GetWhich( SID_ATTR_CHAR_LANGUAGE ); break;
//STRIP001 		case Asian : nWhich = GetWhich( SID_ATTR_CHAR_CJK_LANGUAGE ); break;
//STRIP001 		case Ctl : nWhich = GetWhich( SID_ATTR_CHAR_CTL_LANGUAGE ); break;
//STRIP001 	}
//STRIP001 	pLangBox->SetNoSelection();
//STRIP001 	eState = rSet.GetItemState( nWhich );
//STRIP001 
//STRIP001 	switch ( eState )
//STRIP001 	{
//STRIP001 		case SFX_ITEM_UNKNOWN:
//STRIP001 			pLangFT->Hide();
//STRIP001 			pLangBox->Hide();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SFX_ITEM_DISABLED:
//STRIP001 		case SFX_ITEM_READONLY:
//STRIP001 			pLangFT->Disable();
//STRIP001 			pLangBox->Disable();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SFX_ITEM_DEFAULT:
//STRIP001 		case SFX_ITEM_SET:
//STRIP001 		{
//STRIP001 			const SvxLanguageItem& rItem = (SvxLanguageItem&)rSet.Get( nWhich );
//STRIP001 			LanguageType eLangType = (LanguageType)rItem.GetValue();
//STRIP001 			DBG_ASSERT( eLangType != LANGUAGE_SYSTEM, "LANGUAGE_SYSTEM not allowed" );
//STRIP001 			if ( eLangType != LANGUAGE_DONTKNOW )
//STRIP001 			{
//STRIP001 				for ( USHORT i = 0; i < pLangBox->GetEntryCount(); ++i )
//STRIP001 				{
//STRIP001 					if ( (LanguageType)(ULONG)pLangBox->GetEntryData(i) == eLangType )
//STRIP001 					{
//STRIP001 						pLangBox->SelectEntryPos(i);
//STRIP001 						break;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( Western == eLangGrp )
//STRIP001         m_aFontTypeFT.SetText( pFontList->GetFontMapText(
//STRIP001 			pFontList->Get( pNameBox->GetText(), pStyleBox->GetText() ) ) );
//STRIP001 
//STRIP001 	// save these settings
//STRIP001 	pNameBox->SaveValue();
//STRIP001 	pStyleBox->SaveValue();
//STRIP001 	pSizeBox->SaveValue();
//STRIP001 	pLangBox->SaveValue();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SvxCharNamePage::FillItemSet_Impl( SfxItemSet& rSet, LanguageGroup eLangGrp )
//STRIP001 {
//STRIP001 	BOOL bModified = FALSE;
//STRIP001 
//STRIP001     FontNameBox* pNameBox = NULL;
//STRIP001     FontStyleBox* pStyleBox = NULL;
//STRIP001     FontSizeBox* pSizeBox = NULL;
//STRIP001     SvxLanguageBox* pLangBox = NULL;
//STRIP001 	USHORT nWhich = 0;
//STRIP001 	USHORT nSlot = 0;
//STRIP001 
//STRIP001 	switch ( eLangGrp )
//STRIP001 	{
//STRIP001 		case Western :
//STRIP001 			pNameBox = m_pWestFontNameLB;
//STRIP001 			pStyleBox = m_pWestFontStyleLB;
//STRIP001 			pSizeBox = m_pWestFontSizeLB;
//STRIP001 			pLangBox = m_pWestFontLanguageLB;
//STRIP001 			nSlot = SID_ATTR_CHAR_FONT;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case Asian :
//STRIP001 			pNameBox = m_pEastFontNameLB;
//STRIP001 			pStyleBox = m_pEastFontStyleLB;
//STRIP001 			pSizeBox = m_pEastFontSizeLB;
//STRIP001 			pLangBox = m_pEastFontLanguageLB;
//STRIP001 			nSlot = SID_ATTR_CHAR_CJK_FONT;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case Ctl :
//STRIP001 			pNameBox = m_pCTLFontNameLB;
//STRIP001 			pStyleBox = m_pCTLFontStyleLB;
//STRIP001 			pSizeBox = m_pCTLFontSizeLB;
//STRIP001 			pLangBox = m_pCTLFontLanguageLB;
//STRIP001 			nSlot = SID_ATTR_CHAR_CTL_FONT;
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	nWhich = GetWhich( nSlot );
//STRIP001 	const SfxPoolItem* pItem = NULL;
//STRIP001 	const SfxItemSet& rOldSet = GetItemSet();
//STRIP001 	const SfxPoolItem* pOld = NULL;
//STRIP001 
//STRIP001 	const SfxItemSet* pExampleSet = GetTabDialog() ? GetTabDialog()->GetExampleSet() : NULL;
//STRIP001 
//STRIP001 	FASTBOOL bChanged = TRUE;
//STRIP001 	const String& rFontName  = pNameBox->GetText();
//STRIP001 	const FontList* pFontList = GetFontList();
//STRIP001 	String aStyleBoxText =pStyleBox->GetText();
//STRIP001 	USHORT nEntryPos = pStyleBox->GetEntryPos( aStyleBoxText );
//STRIP001 	if ( nEntryPos >= m_pImpl->m_nExtraEntryPos )
//STRIP001 		aStyleBoxText.Erase();
//STRIP001 	FontInfo aInfo( pFontList->Get( rFontName, aStyleBoxText ) );
//STRIP001 	SvxFontItem aFontItem( aInfo.GetFamily(), aInfo.GetName(), aInfo.GetStyleName(),
//STRIP001 						   aInfo.GetPitch(), aInfo.GetCharSet(), nWhich );
//STRIP001 	pOld = GetOldItem( rSet, nSlot );
//STRIP001 
//STRIP001 	if ( pOld )
//STRIP001 	{
//STRIP001 		const SvxFontItem& rItem = *( (const SvxFontItem*)pOld );
//STRIP001 
//STRIP001 		if ( rItem.GetFamilyName() == aFontItem.GetFamilyName() )
//STRIP001 			bChanged = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( !bChanged )
//STRIP001 		bChanged = !pNameBox->GetSavedValue().Len();
//STRIP001 
//STRIP001 	if ( !bChanged && pExampleSet &&
//STRIP001 		 pExampleSet->GetItemState( nWhich, FALSE, &pItem ) == SFX_ITEM_SET &&
//STRIP001 		 ( (SvxFontItem*)pItem )->GetFamilyName() != aFontItem.GetFamilyName() )
//STRIP001 		bChanged = TRUE;
//STRIP001 
//STRIP001 	if ( bChanged && rFontName.Len() )
//STRIP001 	{
//STRIP001 		rSet.Put( aFontItem );
//STRIP001 		bModified |= TRUE;
//STRIP001 	}
//STRIP001 	else if ( SFX_ITEM_DEFAULT == rOldSet.GetItemState( nWhich, FALSE ) )
//STRIP001 		rSet.ClearItem( nWhich );
//STRIP001 
//STRIP001 
//STRIP001 	bChanged = TRUE;
//STRIP001 	switch ( eLangGrp )
//STRIP001 	{
//STRIP001 		case Western : nSlot = SID_ATTR_CHAR_WEIGHT; break;
//STRIP001 		case Asian : nSlot = SID_ATTR_CHAR_CJK_WEIGHT; break;
//STRIP001 		case Ctl : nSlot = SID_ATTR_CHAR_CTL_WEIGHT; break;
//STRIP001 	}
//STRIP001 	nWhich = GetWhich( nSlot );
//STRIP001 	FontWeight eWeight = aInfo.GetWeight();
//STRIP001 	if ( nEntryPos >= m_pImpl->m_nExtraEntryPos )
//STRIP001 		eWeight = WEIGHT_NORMAL;
//STRIP001 	SvxWeightItem aWeightItem( eWeight, nWhich );
//STRIP001 	pOld = GetOldItem( rSet, nSlot );
//STRIP001 
//STRIP001 	if ( pOld )
//STRIP001 	{
//STRIP001 		const SvxWeightItem& rItem = *( (const SvxWeightItem*)pOld );
//STRIP001 
//STRIP001 		if ( rItem.GetValue() == aWeightItem.GetValue() )
//STRIP001 			bChanged = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( !bChanged )
//STRIP001 	{
//STRIP001 		bChanged = !pStyleBox->GetSavedValue().Len();
//STRIP001 
//STRIP001 		if ( m_pImpl->m_bInSearchMode && bChanged &&
//STRIP001 			 aInfo.GetWeight() == WEIGHT_NORMAL && aInfo.GetItalic() != ITALIC_NONE )
//STRIP001 			bChanged = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( !bChanged && pExampleSet &&
//STRIP001 		 pExampleSet->GetItemState( nWhich, FALSE, &pItem ) == SFX_ITEM_SET &&
//STRIP001 		 ( (SvxWeightItem*)pItem )->GetValue() != aWeightItem.GetValue() )
//STRIP001 		bChanged = TRUE;
//STRIP001 
//STRIP001 	if ( nEntryPos >= m_pImpl->m_nExtraEntryPos )
//STRIP001 		bChanged = ( nEntryPos == m_pImpl->m_nExtraEntryPos );
//STRIP001 
//STRIP001 	String aText( pStyleBox->GetText() ); // Tristate, dann Text leer
//STRIP001 
//STRIP001 	if ( bChanged && aText.Len() )
//STRIP001 	{
//STRIP001 		rSet.Put( aWeightItem );
//STRIP001 		bModified |= TRUE;
//STRIP001 	}
//STRIP001 	else if ( SFX_ITEM_DEFAULT == rOldSet.GetItemState( nWhich, FALSE ) )
//STRIP001 		CLEARTITEM;
//STRIP001 
//STRIP001 	bChanged = TRUE;
//STRIP001 	switch ( eLangGrp )
//STRIP001 	{
//STRIP001 		case Western : nSlot = SID_ATTR_CHAR_POSTURE; break;
//STRIP001 		case Asian : nSlot = SID_ATTR_CHAR_CJK_POSTURE; break;
//STRIP001 		case Ctl : nSlot = SID_ATTR_CHAR_CTL_POSTURE; break;
//STRIP001 	}
//STRIP001 	nWhich = GetWhich( nSlot );
//STRIP001 	FontItalic eItalic = aInfo.GetItalic();
//STRIP001 	if ( nEntryPos >= m_pImpl->m_nExtraEntryPos )
//STRIP001 		eItalic = ITALIC_NONE;
//STRIP001 	SvxPostureItem aPostureItem( eItalic, nWhich );
//STRIP001 	pOld = GetOldItem( rSet, nSlot );
//STRIP001 
//STRIP001 	if ( pOld )
//STRIP001 	{
//STRIP001 		const SvxPostureItem& rItem = *( (const SvxPostureItem*)pOld );
//STRIP001 
//STRIP001 		if ( rItem.GetValue() == aPostureItem.GetValue() )
//STRIP001 			bChanged = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( !bChanged )
//STRIP001 	{
//STRIP001 		bChanged = !pStyleBox->GetSavedValue().Len();
//STRIP001 
//STRIP001 		if ( m_pImpl->m_bInSearchMode && bChanged &&
//STRIP001 			 aInfo.GetItalic() == ITALIC_NONE && aInfo.GetWeight() != WEIGHT_NORMAL )
//STRIP001 			bChanged = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( !bChanged && pExampleSet &&
//STRIP001 		 pExampleSet->GetItemState( nWhich, FALSE, &pItem ) == SFX_ITEM_SET &&
//STRIP001 		 ( (SvxPostureItem*)pItem )->GetValue() != aPostureItem.GetValue() )
//STRIP001 		bChanged = TRUE;
//STRIP001 
//STRIP001 	if ( nEntryPos >= m_pImpl->m_nExtraEntryPos )
//STRIP001 		bChanged = ( nEntryPos == ( m_pImpl->m_nExtraEntryPos + 1 ) );
//STRIP001 
//STRIP001 	if ( bChanged && aText.Len() )
//STRIP001 	{
//STRIP001 		rSet.Put( aPostureItem );
//STRIP001 		bModified |= TRUE;
//STRIP001 	}
//STRIP001 	else if ( SFX_ITEM_DEFAULT == rOldSet.GetItemState( nWhich, FALSE ) )
//STRIP001 		CLEARTITEM;
//STRIP001 
//STRIP001 	// FontSize
//STRIP001 	long nSize = pSizeBox->GetValue();
//STRIP001 
//STRIP001 	if ( !pSizeBox->GetText().Len() )	// GetValue() gibt dann Min-Wert zurueck
//STRIP001 		nSize = 0;
//STRIP001 	long nSavedSize = pSizeBox->GetSavedValue().ToInt32();
//STRIP001 	FASTBOOL bRel = TRUE;
//STRIP001 
//STRIP001 	if ( !pSizeBox->IsRelative() )
//STRIP001 	{
//STRIP001 		nSavedSize *= 10;
//STRIP001 		bRel = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	switch ( eLangGrp )
//STRIP001 	{
//STRIP001 		case Western : nSlot = SID_ATTR_CHAR_FONTHEIGHT; break;
//STRIP001 		case Asian : nSlot = SID_ATTR_CHAR_CJK_FONTHEIGHT; break;
//STRIP001 		case Ctl : nSlot = SID_ATTR_CHAR_CTL_FONTHEIGHT; break;
//STRIP001 	}
//STRIP001 	nWhich = GetWhich( nSlot );
//STRIP001 	const SvxFontHeightItem* pOldHeight = (const SvxFontHeightItem*)GetOldItem( rSet, nSlot );
//STRIP001 	bChanged = ( nSize != nSavedSize );
//STRIP001 
//STRIP001 	if ( !bChanged && pExampleSet &&
//STRIP001 		 pExampleSet->GetItemState( nWhich, FALSE, &pItem ) == SFX_ITEM_SET )
//STRIP001 	{
//STRIP001 		float fSize = (float)nSize / 10;
//STRIP001 		long nVal = CalcToUnit( fSize, rSet.GetPool()->GetMetric( nWhich ) );
//STRIP001 		if ( ( (SvxFontHeightItem*)pItem )->GetHeight() != (UINT32)nVal )
//STRIP001 			bChanged = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bChanged || !pOldHeight ||
//STRIP001 		 bRel != ( SFX_MAPUNIT_RELATIVE != pOldHeight->GetPropUnit() || 100 != pOldHeight->GetProp() ) )
//STRIP001 	{
//STRIP001 		SfxMapUnit eUnit = rSet.GetPool()->GetMetric( nWhich );
//STRIP001 		if ( pSizeBox->IsRelative() )
//STRIP001 		{
//STRIP001 			DBG_ASSERT( GetItemSet().GetParent(), "No parent set" );
//STRIP001 			const SvxFontHeightItem& rOldItem =
//STRIP001 				(const SvxFontHeightItem&)GetItemSet().GetParent()->Get( nWhich );
//STRIP001 
//STRIP001 			SvxFontHeightItem aHeight( 240, 100, nWhich );
//STRIP001 			if ( pSizeBox->IsPtRelative() )
//STRIP001 				aHeight.SetHeight( rOldItem.GetHeight(), (USHORT)( nSize / 10 ), SFX_MAPUNIT_POINT, eUnit );
//STRIP001 			else
//STRIP001 				aHeight.SetHeight( rOldItem.GetHeight(), (USHORT)nSize, SFX_MAPUNIT_RELATIVE );
//STRIP001 			rSet.Put( aHeight );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			float fSize = (float)nSize / 10;
//STRIP001 			rSet.Put( SvxFontHeightItem( CalcToUnit( fSize, eUnit ), 100, nWhich ) );
//STRIP001 		}
//STRIP001 		bModified |= TRUE;
//STRIP001 	}
//STRIP001 	else if ( SFX_ITEM_DEFAULT == rOldSet.GetItemState( nWhich, FALSE ) )
//STRIP001 		CLEARTITEM;
//STRIP001 
//STRIP001 	bChanged = TRUE;
//STRIP001 	switch ( eLangGrp )
//STRIP001 	{
//STRIP001 		case Western : nSlot = SID_ATTR_CHAR_LANGUAGE; break;
//STRIP001 		case Asian : nSlot = SID_ATTR_CHAR_CJK_LANGUAGE; break;
//STRIP001 		case Ctl : nSlot = SID_ATTR_CHAR_CTL_LANGUAGE; break;
//STRIP001 	}
//STRIP001 	nWhich = GetWhich( nSlot );
//STRIP001 	pOld = GetOldItem( rSet, nSlot );
//STRIP001 	USHORT nLangPos = pLangBox->GetSelectEntryPos();
//STRIP001 	LanguageType eLangType = (LanguageType)(ULONG)pLangBox->GetEntryData( nLangPos );
//STRIP001 
//STRIP001 	if ( pOld )
//STRIP001 	{
//STRIP001 		const SvxLanguageItem& rItem = *( (const SvxLanguageItem*)pOld );
//STRIP001 
//STRIP001 		if ( nLangPos == LISTBOX_ENTRY_NOTFOUND || eLangType == (LanguageType)rItem.GetValue() )
//STRIP001 			bChanged = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( !bChanged )
//STRIP001 		bChanged = ( pLangBox->GetSavedValue() == LISTBOX_ENTRY_NOTFOUND );
//STRIP001 
//STRIP001 	if ( bChanged && nLangPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		rSet.Put( SvxLanguageItem( eLangType, nWhich ) );
//STRIP001 		bModified |= TRUE;
//STRIP001 	}
//STRIP001 	else if ( SFX_ITEM_DEFAULT == rOldSet.GetItemState( nWhich, FALSE ) )
//STRIP001 		CLEARTITEM;
//STRIP001 
//STRIP001 	return bModified;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxCharNamePage::ResetColor_Impl( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	USHORT nWhich = GetWhich( SID_ATTR_CHAR_COLOR );
//STRIP001 	SfxItemState eState = rSet.GetItemState( nWhich );
//STRIP001 
//STRIP001 	switch ( eState )
//STRIP001 	{
//STRIP001 		case SFX_ITEM_UNKNOWN:
//STRIP001             m_pColorLB->Hide();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SFX_ITEM_DISABLED:
//STRIP001 		case SFX_ITEM_READONLY:
//STRIP001             m_pColorLB->Disable();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SFX_ITEM_DONTCARE:
//STRIP001             m_pColorLB->SetNoSelection();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SFX_ITEM_DEFAULT:
//STRIP001 		case SFX_ITEM_SET:
//STRIP001 		{
//STRIP001 			SvxFont& rFont = GetPreviewFont();
//STRIP001             SvxFont& rCJKFont = GetPreviewCJKFont();
//STRIP001 			SvxFont& rCTLFont = GetPreviewCTLFont();
//STRIP001 			const SvxColorItem& rItem = (SvxColorItem&)rSet.Get( nWhich );
//STRIP001 			Color aColor = rItem.GetValue();
//STRIP001             rFont.SetColor( aColor.GetColor() == COL_AUTO ? Color(COL_BLACK) : aColor );
//STRIP001             rCJKFont.SetColor( aColor.GetColor() == COL_AUTO ? Color(COL_BLACK) : aColor );
//STRIP001 			rCTLFont.SetColor( aColor.GetColor() == COL_AUTO ? Color(COL_BLACK) : aColor );
//STRIP001 			m_aPreviewWin.Invalidate();
//STRIP001             USHORT nSelPos = m_pColorLB->GetEntryPos( aColor );
//STRIP001 			if ( nSelPos == LISTBOX_ENTRY_NOTFOUND && aColor == Color( COL_TRANSPARENT ) )
//STRIP001                 nSelPos = m_pColorLB->GetEntryPos( m_pImpl->m_aTransparentText );
//STRIP001 
//STRIP001 			if ( LISTBOX_ENTRY_NOTFOUND != nSelPos )
//STRIP001                 m_pColorLB->SelectEntryPos( nSelPos );
//STRIP001 			else
//STRIP001 			{
//STRIP001                 nSelPos = m_pColorLB->GetEntryPos( aColor );
//STRIP001 				if ( LISTBOX_ENTRY_NOTFOUND != nSelPos )
//STRIP001                     m_pColorLB->SelectEntryPos( nSelPos );
//STRIP001 				else
//STRIP001                     m_pColorLB->SelectEntryPos(
//STRIP001                         m_pColorLB->InsertEntry( aColor, String( SVX_RES( RID_SVXSTR_COLOR_USER ) ) ) );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SvxCharNamePage::FillItemSetColor_Impl( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	USHORT nWhich = GetWhich( SID_ATTR_CHAR_COLOR );
//STRIP001 	const SvxColorItem* pOld = (const SvxColorItem*)GetOldItem( rSet, SID_ATTR_CHAR_COLOR );
//STRIP001 	const SvxColorItem* pItem = NULL;
//STRIP001 	BOOL bChanged = TRUE;
//STRIP001 	const SfxItemSet* pExampleSet = GetTabDialog() ? GetTabDialog()->GetExampleSet() : NULL;
//STRIP001 	const SfxItemSet& rOldSet = GetItemSet();
//STRIP001 
//STRIP001 	Color aSelectedColor;
//STRIP001     if ( m_pColorLB->GetSelectEntry() == m_pImpl->m_aTransparentText )
//STRIP001 		aSelectedColor = Color( COL_TRANSPARENT );
//STRIP001 	else
//STRIP001         aSelectedColor = m_pColorLB->GetSelectEntryColor();
//STRIP001 
//STRIP001 	if ( pOld && pOld->GetValue() == aSelectedColor )
//STRIP001 		bChanged = FALSE;
//STRIP001 
//STRIP001 	if ( !bChanged )
//STRIP001         bChanged = ( m_pColorLB->GetSavedValue() == LISTBOX_ENTRY_NOTFOUND );
//STRIP001 
//STRIP001 	if ( !bChanged && pExampleSet &&
//STRIP001 		 pExampleSet->GetItemState( nWhich, FALSE, (const SfxPoolItem**)&pItem ) == SFX_ITEM_SET &&
//STRIP001 		 ( (SvxColorItem*)pItem )->GetValue() != aSelectedColor )
//STRIP001 		bChanged = TRUE;
//STRIP001 
//STRIP001 	BOOL bModified = FALSE;
//STRIP001 
//STRIP001     if ( bChanged && m_pColorLB->GetSelectEntryPos() != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		rSet.Put( SvxColorItem( aSelectedColor, nWhich ) );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 	else if ( SFX_ITEM_DEFAULT == rOldSet.GetItemState( nWhich, FALSE ) )
//STRIP001 		CLEARTITEM;
//STRIP001 
//STRIP001 	return bModified;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxCharNamePage, UpdateHdl_Impl, Timer*, EMPTYARG )
//STRIP001 {
//STRIP001 	UpdatePreview_Impl();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxCharNamePage, FontModifyHdl_Impl, void*, pNameBox )
//STRIP001 {
//STRIP001 	m_pImpl->m_aUpdateTimer.Start();
//STRIP001 
//STRIP001     if ( m_pWestFontNameLB == pNameBox || m_pEastFontNameLB == pNameBox || m_pCTLFontNameLB == pNameBox )
//STRIP001 	{
//STRIP001 		FillStyleBox_Impl( (FontNameBox*)pNameBox );
//STRIP001 		FillSizeBox_Impl( (FontNameBox*)pNameBox );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxCharNamePage, ColorBoxSelectHdl_Impl, ColorListBox*, pBox )
//STRIP001 {
//STRIP001 	SvxFont& rFont = GetPreviewFont();
//STRIP001     SvxFont& rCJKFont = GetPreviewCJKFont();
//STRIP001 	SvxFont& rCTLFont = GetPreviewCTLFont();
//STRIP001 	Color aSelectedColor;
//STRIP001 	if ( pBox->GetSelectEntry() == m_pImpl->m_aTransparentText )
//STRIP001 		aSelectedColor = Color( COL_TRANSPARENT );
//STRIP001 	else
//STRIP001 		aSelectedColor = pBox->GetSelectEntryColor();
//STRIP001     rFont.SetColor( aSelectedColor.GetColor() == COL_AUTO ? Color(COL_BLACK) : aSelectedColor );
//STRIP001     rCJKFont.SetColor( aSelectedColor.GetColor() == COL_AUTO ? Color(COL_BLACK) : aSelectedColor );
//STRIP001 	rCTLFont.SetColor( aSelectedColor.GetColor() == COL_AUTO ? Color(COL_BLACK) : aSelectedColor );
//STRIP001     m_aPreviewWin.Invalidate();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxCharNamePage::ActivatePage( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	SvxCharBasePage::ActivatePage( rSet );
//STRIP001 
//STRIP001 	UpdatePreview_Impl();		// instead of asynchronous calling in ctor
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 int SvxCharNamePage::DeactivatePage( SfxItemSet* pSet )
//STRIP001 {
//STRIP001 	if ( pSet )
//STRIP001 		FillItemSet( *pSet );
//STRIP001 	return LEAVE_PAGE;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabPage* SvxCharNamePage::Create( Window* pParent, const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	return new SvxCharNamePage( pParent, rSet );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 USHORT* SvxCharNamePage::GetRanges()
//STRIP001 {
//STRIP001 	return pNameRanges;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxCharNamePage::Reset( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	Reset_Impl( rSet, Western );
//STRIP001 	Reset_Impl( rSet, Asian );
//STRIP001 	Reset_Impl( rSet, Ctl );
//STRIP001 	ResetColor_Impl( rSet );
//STRIP001     m_pColorLB->SaveValue();
//STRIP001 
//STRIP001 	SetPrevFontWidthScale( rSet );
//STRIP001 	UpdatePreview_Impl();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SvxCharNamePage::FillItemSet( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	BOOL bModified = FillItemSet_Impl( rSet, Western );
//STRIP001 	bModified |= FillItemSet_Impl( rSet, Asian );
//STRIP001 	bModified |= FillItemSet_Impl( rSet, Ctl );
//STRIP001 //!	bModified |= FillItemSetColor_Impl( rSet );
//STRIP001 	return bModified;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxCharNamePage::SetFontList( const SvxFontListItem& rItem )
//STRIP001 {
//STRIP001 	if ( m_pImpl->m_bMustDelete )
//STRIP001 	{
//STRIP001 		delete m_pImpl->m_pFontList;
//STRIP001 		m_pImpl->m_bMustDelete = FALSE;
//STRIP001 	}
//STRIP001 	m_pImpl->m_pFontList = rItem.GetFontList();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 namespace
//STRIP001 {
//STRIP001 	void enableRelativeMode(SvxCharNamePage* _pPage,
//STRIP001 							FontSizeBox* _pFontSizeLB,
//STRIP001 							USHORT _nHeightWhich)
//STRIP001 	{
//STRIP001 		_pFontSizeLB->EnableRelativeMode( 5, 995, 5 ); // min 5%, max 995%, step 5
//STRIP001 
//STRIP001 		const SvxFontHeightItem& rHeightItem = (SvxFontHeightItem&)_pPage->GetItemSet().GetParent()->Get( _nHeightWhich );
//STRIP001 		SfxMapUnit eUnit = _pPage->GetItemSet().GetPool()->GetMetric( _nHeightWhich );
//STRIP001 		short nCurHeight = CalcToPoint( rHeightItem.GetHeight(), eUnit, 1 ) * 10;
//STRIP001 
//STRIP001 		// ausgehend von der akt. Hoehe:
//STRIP001 		//		- negativ bis minimal 2 pt
//STRIP001 		//		- positiv bis maximal 999 pt
//STRIP001 		_pFontSizeLB->EnablePtRelativeMode( -(nCurHeight - 20), (9999 - nCurHeight), 10 );
//STRIP001 	}
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxCharNamePage::EnableRelativeMode()
//STRIP001 {
//STRIP001 	DBG_ASSERT( GetItemSet().GetParent(), "RelativeMode, but no ParentSet!" );
//STRIP001 	enableRelativeMode(this,m_pWestFontSizeLB,GetWhich( SID_ATTR_CHAR_FONTHEIGHT ));
//STRIP001 	enableRelativeMode(this,m_pEastFontSizeLB,GetWhich( SID_ATTR_CHAR_CJK_FONTHEIGHT ));
//STRIP001 	enableRelativeMode(this,m_pCTLFontSizeLB,GetWhich( SID_ATTR_CHAR_CTL_FONTHEIGHT ));
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxCharNamePage::EnableSearchMode()
//STRIP001 {
//STRIP001 	m_pImpl->m_bInSearchMode = TRUE;
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 void SvxCharNamePage::DisableControls( USHORT nDisable )
//STRIP001 {
//STRIP001 	if ( DISABLE_LANGUAGE & nDisable )
//STRIP001 	{
//STRIP001 		if ( m_pWestFontLanguageFT ) m_pWestFontLanguageFT->Disable();
//STRIP001 		if ( m_pWestFontLanguageLB ) m_pWestFontLanguageLB->Disable();
//STRIP001 		if ( m_pEastFontLanguageFT ) m_pEastFontLanguageFT->Disable();
//STRIP001 		if ( m_pEastFontLanguageLB ) m_pEastFontLanguageLB->Disable();
//STRIP001 		if ( m_pCTLFontLanguageFT ) m_pCTLFontLanguageFT->Disable();
//STRIP001 		if ( m_pCTLFontLanguageLB ) m_pCTLFontLanguageLB->Disable();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( DISABLE_HIDE_LANGUAGE & nDisable )
//STRIP001 	{
//STRIP001 		if ( m_pWestFontLanguageFT ) m_pWestFontLanguageFT->Hide();
//STRIP001 		if ( m_pWestFontLanguageLB ) m_pWestFontLanguageLB->Hide();
//STRIP001 		if ( m_pEastFontLanguageFT ) m_pEastFontLanguageFT->Hide();
//STRIP001 		if ( m_pEastFontLanguageLB ) m_pEastFontLanguageLB->Hide();
//STRIP001 		if ( m_pCTLFontLanguageFT ) m_pCTLFontLanguageFT->Hide();
//STRIP001 		if ( m_pCTLFontLanguageLB ) m_pCTLFontLanguageLB->Hide();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 void SvxCharNamePage::SetPreviewBackgroundToCharacter()
//STRIP001 {
//STRIP001     m_bPreviewBackgroundToCharacter = sal_True;
//STRIP001 }
//STRIP001 
//STRIP001 // class SvxCharEffectsPage ----------------------------------------------
//STRIP001 
//STRIP001 SvxCharEffectsPage::SvxCharEffectsPage( Window* pParent, const SfxItemSet& rInSet ) :
//STRIP001 
//STRIP001 	SvxCharBasePage( pParent, SVX_RES( RID_SVXPAGE_CHAR_EFFECTS ), rInSet, WIN_EFFECTS_PREVIEW, FT_EFFECTS_FONTTYPE ),
//STRIP001 
//STRIP001 	m_aUnderlineFT			( this, ResId( FT_UNDERLINE ) ),
//STRIP001 	m_aUnderlineLB			( this, ResId( LB_UNDERLINE ) ),
//STRIP001 	m_aColorFT				( this, ResId( FT_UNDERLINE_COLOR ) ),
//STRIP001 	m_aColorLB				( this, ResId( LB_UNDERLINE_COLOR ) ),
//STRIP001 	m_aStrikeoutFT			( this, ResId( FT_STRIKEOUT ) ),
//STRIP001 	m_aStrikeoutLB			( this, ResId( LB_STRIKEOUT ) ),
//STRIP001 	m_aIndividualWordsBtn	( this, ResId( CB_INDIVIDUALWORDS ) ),
//STRIP001 	m_aEmphasisFT			( this, ResId( FT_EMPHASIS ) ),
//STRIP001 	m_aEmphasisLB			( this, ResId( LB_EMPHASIS ) ),
//STRIP001 	m_aPositionFT			( this, ResId( FT_POSITION ) ),
//STRIP001 	m_aPositionLB			( this, ResId( LB_POSITION ) ),
//STRIP001     m_aFontColorFT          ( this, ResId( FT_FONTCOLOR ) ),
//STRIP001     m_aFontColorLB          ( this, ResId( LB_FONTCOLOR ) ),
//STRIP001 
//STRIP001 	m_aEffectsFT			( this, ResId( FT_EFFECTS ) ),
//STRIP001 	m_aEffectsLB			( this, 0 ),
//STRIP001 
//STRIP001 	m_aEffects2LB			( this, ResId( LB_EFFECTS2 ) ),
//STRIP001 
//STRIP001     m_aReliefFT             ( this, ResId( FT_RELIEF ) ),
//STRIP001     m_aReliefLB             ( this, ResId( LB_RELIEF ) ),
//STRIP001 
//STRIP001 	m_aOutlineBtn			( this, ResId( CB_OUTLINE ) ),
//STRIP001 	m_aShadowBtn			( this, ResId( CB_SHADOW ) ),
//STRIP001 	m_aBlinkingBtn			( this, ResId( CB_BLINKING ) ),
//STRIP001 
//STRIP001 	m_aTransparentColorName	( ResId( STR_CHARNAME_TRANSPARENT ) )
//STRIP001 
//STRIP001 {
//STRIP001 	m_aEffectsLB.Hide();
//STRIP001 	FreeResource();
//STRIP001 	Initialize();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxCharEffectsPage::Initialize()
//STRIP001 {
//STRIP001 	// to handle the changes of the other pages
//STRIP001 	SetExchangeSupport();
//STRIP001 
//STRIP001 	// HTML-Mode
//STRIP001 	const SfxPoolItem* pItem;
//STRIP001 	SfxObjectShell* pShell;
//STRIP001 	if ( SFX_ITEM_SET == GetItemSet().GetItemState( SID_HTML_MODE, FALSE, &pItem ) ||
//STRIP001 		 ( NULL != ( pShell = SfxObjectShell::Current() ) &&
//STRIP001 		   NULL != ( pItem = pShell->GetItem( SID_HTML_MODE ) ) ) )
//STRIP001 	{
//STRIP001 		m_nHtmlMode = ( (const SfxUInt16Item*)pItem )->GetValue();
//STRIP001 		if ( ( m_nHtmlMode & HTMLMODE_ON ) == HTMLMODE_ON )
//STRIP001 		{
//STRIP001 			//!!! hide some controls please
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// fill the color box
//STRIP001 	SfxObjectShell* pDocSh = SfxObjectShell::Current();
//STRIP001 	DBG_ASSERT( pDocSh, "DocShell not found!" );
//STRIP001 	XColorTable* pColorTable = NULL;
//STRIP001 	FASTBOOL bKillTable = FALSE;
//STRIP001 
//STRIP001 	if ( pDocSh && ( pItem = pDocSh->GetItem( SID_COLOR_TABLE ) ) )
//STRIP001 		pColorTable = ( (SvxColorTableItem*)pItem )->GetColorTable();
//STRIP001 
//STRIP001 	if ( !pColorTable )
//STRIP001 	{
//STRIP001 		pColorTable = new XColorTable( SvtPathOptions().GetPalettePath() );
//STRIP001 		bKillTable = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	m_aColorLB.SetUpdateMode( FALSE );
//STRIP001 	m_aFontColorLB.SetUpdateMode( FALSE );
//STRIP001 
//STRIP001 	{
//STRIP001 		SfxPoolItem* pDummy;
//STRIP001 		SfxViewFrame* pFrame = SfxViewFrame::GetFirst( pDocSh );
//STRIP001 		if ( !pFrame ||
//STRIP001 			 SFX_ITEM_DEFAULT > pFrame->GetBindings().QueryState( SID_ATTR_AUTO_COLOR_INVALID, pDummy ) )
//STRIP001 		{
//STRIP001 			m_aColorLB.InsertAutomaticEntry();
//STRIP001 			m_aFontColorLB.InsertAutomaticEntry();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	for ( long i = 0; i < pColorTable->Count(); i++ )
//STRIP001 	{
//STRIP001 		XColorEntry* pEntry = pColorTable->Get(i);
//STRIP001 		m_aColorLB.InsertEntry( pEntry->GetColor(), pEntry->GetName() );
//STRIP001 		m_aFontColorLB.InsertEntry( pEntry->GetColor(), pEntry->GetName() );
//STRIP001 	}
//STRIP001 
//STRIP001 	m_aColorLB.SetUpdateMode( TRUE );
//STRIP001 	m_aFontColorLB.SetUpdateMode( TRUE );
//STRIP001     m_aFontColorLB.SetSelectHdl( LINK( this, SvxCharEffectsPage, ColorBoxSelectHdl_Impl ) );
//STRIP001 
//STRIP001 	if ( bKillTable )
//STRIP001 		delete pColorTable;
//STRIP001 
//STRIP001 	// handler
//STRIP001 	Link aLink = LINK( this, SvxCharEffectsPage, SelectHdl_Impl );
//STRIP001 	m_aUnderlineLB.SetSelectHdl( aLink );
//STRIP001 	m_aStrikeoutLB.SetSelectHdl( aLink );
//STRIP001 	m_aEmphasisLB.SetSelectHdl( aLink );
//STRIP001 	m_aPositionLB.SetSelectHdl( aLink );
//STRIP001 	m_aEffects2LB.SetSelectHdl( aLink );
//STRIP001     m_aReliefLB.SetSelectHdl( aLink );
//STRIP001     m_aColorLB.SetSelectHdl( aLink );
//STRIP001 
//STRIP001 	m_aUnderlineLB.SelectEntryPos( 0 );
//STRIP001 	m_aStrikeoutLB.SelectEntryPos( 0 );
//STRIP001 	m_aEmphasisLB.SelectEntryPos( 0 );
//STRIP001 	m_aPositionLB.SelectEntryPos( 0 );
//STRIP001 	m_aColorLB.SelectEntryPos( 0 );
//STRIP001 	SelectHdl_Impl( NULL );
//STRIP001 	SelectHdl_Impl( &m_aEmphasisLB );
//STRIP001 
//STRIP001 	m_aEffects2LB.SelectEntryPos( 0 );
//STRIP001 
//STRIP001     m_aIndividualWordsBtn.SetClickHdl( LINK( this, SvxCharEffectsPage, CbClickHdl_Impl ) );
//STRIP001     aLink = LINK( this, SvxCharEffectsPage, TristClickHdl_Impl );
//STRIP001 	m_aOutlineBtn.SetClickHdl( aLink );
//STRIP001 	m_aShadowBtn.SetClickHdl( aLink );
//STRIP001 
//STRIP001     if ( !SvtLanguageOptions().IsAsianTypographyEnabled() )
//STRIP001     {
//STRIP001         m_aEmphasisFT.Hide();
//STRIP001         m_aEmphasisLB.Hide();
//STRIP001         m_aPositionFT.Hide();
//STRIP001         m_aPositionLB.Hide();
//STRIP001 
//STRIP001 		m_aFontColorFT.SetPosPixel( m_aEmphasisFT.GetPosPixel() );
//STRIP001 		m_aFontColorLB.SetPosPixel( m_aEmphasisLB.GetPosPixel() );
//STRIP001 	}
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxCharEffectsPage::UpdatePreview_Impl()
//STRIP001 {
//STRIP001 	SvxFont& rFont = GetPreviewFont();
//STRIP001     SvxFont& rCJKFont = GetPreviewCJKFont();
//STRIP001 	SvxFont& rCTLFont = GetPreviewCTLFont();
//STRIP001 
//STRIP001 	USHORT nPos = m_aUnderlineLB.GetSelectEntryPos();
//STRIP001 	FontUnderline eUnderline = (FontUnderline)(ULONG)m_aUnderlineLB.GetEntryData( nPos );
//STRIP001 	nPos = m_aStrikeoutLB.GetSelectEntryPos();
//STRIP001 	FontStrikeout eStrikeout = (FontStrikeout)(ULONG)m_aStrikeoutLB.GetEntryData( nPos );
//STRIP001 	rFont.SetUnderline( eUnderline );
//STRIP001     rCJKFont.SetUnderline( eUnderline );
//STRIP001 	rCTLFont.SetUnderline( eUnderline );
//STRIP001 
//STRIP001 	m_aPreviewWin.SetTextLineColor( m_aColorLB.GetSelectEntryColor() );
//STRIP001 	rFont.SetStrikeout( eStrikeout );
//STRIP001     rCJKFont.SetStrikeout( eStrikeout );
//STRIP001 	rCTLFont.SetStrikeout( eStrikeout );
//STRIP001 
//STRIP001 	nPos = m_aPositionLB.GetSelectEntryPos();
//STRIP001 	BOOL bUnder = ( CHRDLG_POSITION_UNDER == (ULONG)m_aPositionLB.GetEntryData( nPos ) );
//STRIP001 	FontEmphasisMark eMark = (FontEmphasisMark)m_aEmphasisLB.GetSelectEntryPos();
//STRIP001 	eMark |= bUnder ? EMPHASISMARK_POS_BELOW : EMPHASISMARK_POS_ABOVE;
//STRIP001 	rFont.SetEmphasisMark( eMark );
//STRIP001     rCJKFont.SetEmphasisMark( eMark );
//STRIP001 	rCTLFont.SetEmphasisMark( eMark );
//STRIP001 
//STRIP001     USHORT nRelief = m_aReliefLB.GetSelectEntryPos();
//STRIP001     if(LISTBOX_ENTRY_NOTFOUND != nRelief)
//STRIP001     {
//STRIP001         rFont.SetRelief( (FontRelief)nRelief );
//STRIP001         rCJKFont.SetRelief( (FontRelief)nRelief );
//STRIP001 		rCTLFont.SetRelief( (FontRelief)nRelief );
//STRIP001     }
//STRIP001 
//STRIP001     rFont.SetOutline( StateToAttr( m_aOutlineBtn.GetState() ) );
//STRIP001     rCJKFont.SetOutline( rFont.IsOutline() );
//STRIP001 	rCTLFont.SetOutline( rFont.IsOutline() );
//STRIP001 
//STRIP001     rFont.SetShadow( StateToAttr( m_aShadowBtn.GetState() ) );
//STRIP001     rCJKFont.SetShadow( rFont.IsShadow() );
//STRIP001 	rCTLFont.SetShadow( rFont.IsShadow() );
//STRIP001 
//STRIP001 	USHORT nCapsPos = m_aEffects2LB.GetSelectEntryPos();
//STRIP001 	if ( nCapsPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001     {
//STRIP001 		rFont.SetCaseMap( (SvxCaseMap)nCapsPos );
//STRIP001         rCJKFont.SetCaseMap( (SvxCaseMap)nCapsPos );
//STRIP001 		rCTLFont.SetCaseMap( (SvxCaseMap)nCapsPos );
//STRIP001     }
//STRIP001 
//STRIP001     BOOL bWordLine = m_aIndividualWordsBtn.IsChecked();
//STRIP001     rFont.SetWordLineMode( bWordLine );
//STRIP001     rCJKFont.SetWordLineMode( bWordLine );
//STRIP001 	rCTLFont.SetWordLineMode( bWordLine );
//STRIP001 
//STRIP001     m_aPreviewWin.Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxCharEffectsPage::SetCaseMap_Impl( SvxCaseMap eCaseMap )
//STRIP001 {
//STRIP001 	if ( SVX_CASEMAP_END > eCaseMap )
//STRIP001 		m_aEffects2LB.SelectEntryPos( eCaseMap );
//STRIP001 	else
//STRIP001 	{
//STRIP001 		m_aEffects2LB.SetNoSelection();
//STRIP001 		eCaseMap = SVX_CASEMAP_NOT_MAPPED;
//STRIP001 	}
//STRIP001 
//STRIP001 	UpdatePreview_Impl();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxCharEffectsPage::ResetColor_Impl( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	USHORT nWhich = GetWhich( SID_ATTR_CHAR_COLOR );
//STRIP001 	SfxItemState eState = rSet.GetItemState( nWhich );
//STRIP001 
//STRIP001 	switch ( eState )
//STRIP001 	{
//STRIP001 		case SFX_ITEM_UNKNOWN:
//STRIP001             m_aFontColorFT.Hide();
//STRIP001             m_aFontColorLB.Hide();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SFX_ITEM_DISABLED:
//STRIP001 		case SFX_ITEM_READONLY:
//STRIP001             m_aFontColorFT.Disable();
//STRIP001             m_aFontColorLB.Disable();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SFX_ITEM_DONTCARE:
//STRIP001             m_aFontColorLB.SetNoSelection();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SFX_ITEM_DEFAULT:
//STRIP001 		case SFX_ITEM_SET:
//STRIP001 		{
//STRIP001 			SvxFont& rFont = GetPreviewFont();
//STRIP001             SvxFont& rCJKFont = GetPreviewCJKFont();
//STRIP001 			SvxFont& rCTLFont = GetPreviewCTLFont();
//STRIP001 
//STRIP001 			const SvxColorItem& rItem = (SvxColorItem&)rSet.Get( nWhich );
//STRIP001 			Color aColor = rItem.GetValue();
//STRIP001             rFont.SetColor( aColor.GetColor() == COL_AUTO ? Color(COL_BLACK) : aColor );
//STRIP001             rCJKFont.SetColor( aColor.GetColor() == COL_AUTO ? Color(COL_BLACK) : aColor );
//STRIP001 			rCTLFont.SetColor( aColor.GetColor() == COL_AUTO ? Color(COL_BLACK) : aColor );
//STRIP001 
//STRIP001 			m_aPreviewWin.Invalidate();
//STRIP001             USHORT nSelPos = m_aFontColorLB.GetEntryPos( aColor );
//STRIP001 			if ( nSelPos == LISTBOX_ENTRY_NOTFOUND && aColor == Color( COL_TRANSPARENT ) )
//STRIP001 				nSelPos = m_aFontColorLB.GetEntryPos( m_aTransparentColorName );
//STRIP001 
//STRIP001 			if ( LISTBOX_ENTRY_NOTFOUND != nSelPos )
//STRIP001                 m_aFontColorLB.SelectEntryPos( nSelPos );
//STRIP001 			else
//STRIP001 			{
//STRIP001                 nSelPos = m_aFontColorLB.GetEntryPos( aColor );
//STRIP001 				if ( LISTBOX_ENTRY_NOTFOUND != nSelPos )
//STRIP001                     m_aFontColorLB.SelectEntryPos( nSelPos );
//STRIP001 				else
//STRIP001                     m_aFontColorLB.SelectEntryPos(
//STRIP001                         m_aFontColorLB.InsertEntry( aColor, String( SVX_RES( RID_SVXSTR_COLOR_USER ) ) ) );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SvxCharEffectsPage::FillItemSetColor_Impl( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	USHORT nWhich = GetWhich( SID_ATTR_CHAR_COLOR );
//STRIP001 	const SvxColorItem* pOld = (const SvxColorItem*)GetOldItem( rSet, SID_ATTR_CHAR_COLOR );
//STRIP001 	const SvxColorItem* pItem = NULL;
//STRIP001 	BOOL bChanged = TRUE;
//STRIP001 	const SfxItemSet* pExampleSet = GetTabDialog() ? GetTabDialog()->GetExampleSet() : NULL;
//STRIP001 	const SfxItemSet& rOldSet = GetItemSet();
//STRIP001 
//STRIP001 	Color aSelectedColor;
//STRIP001     if ( m_aFontColorLB.GetSelectEntry() == m_aTransparentColorName )
//STRIP001 		aSelectedColor = Color( COL_TRANSPARENT );
//STRIP001 	else
//STRIP001         aSelectedColor = m_aFontColorLB.GetSelectEntryColor();
//STRIP001 
//STRIP001 	if ( pOld && pOld->GetValue() == aSelectedColor )
//STRIP001 		bChanged = FALSE;
//STRIP001 
//STRIP001 	if ( !bChanged )
//STRIP001         bChanged = ( m_aFontColorLB.GetSavedValue() == LISTBOX_ENTRY_NOTFOUND );
//STRIP001 
//STRIP001 	if ( !bChanged && pExampleSet &&
//STRIP001 		 pExampleSet->GetItemState( nWhich, FALSE, (const SfxPoolItem**)&pItem ) == SFX_ITEM_SET &&
//STRIP001 		 ( (SvxColorItem*)pItem )->GetValue() != aSelectedColor )
//STRIP001 		bChanged = TRUE;
//STRIP001 
//STRIP001 	BOOL bModified = FALSE;
//STRIP001 
//STRIP001     if ( bChanged && m_aFontColorLB.GetSelectEntryPos() != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		rSet.Put( SvxColorItem( aSelectedColor, nWhich ) );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 	else if ( SFX_ITEM_DEFAULT == rOldSet.GetItemState( nWhich, FALSE ) )
//STRIP001 		CLEARTITEM;
//STRIP001 
//STRIP001 	return bModified;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxCharEffectsPage, SelectHdl_Impl, ListBox*, pBox )
//STRIP001 {
//STRIP001 	if ( &m_aEmphasisLB == pBox )
//STRIP001 	{
//STRIP001 		USHORT nEPos = m_aEmphasisLB.GetSelectEntryPos();
//STRIP001 		BOOL bEnable = ( nEPos > 0 && nEPos != LISTBOX_ENTRY_NOTFOUND );
//STRIP001 		m_aPositionFT.Enable( bEnable );
//STRIP001 		m_aPositionLB.Enable( bEnable );
//STRIP001 	}
//STRIP001     else if( &m_aReliefLB == pBox)
//STRIP001     {
//STRIP001         BOOL bEnable = ( pBox->GetSelectEntryPos() == 0 );
//STRIP001         m_aOutlineBtn.Enable( bEnable );
//STRIP001         m_aShadowBtn.Enable( bEnable );
//STRIP001     }
//STRIP001     else if ( &m_aPositionLB != pBox )
//STRIP001 	{
//STRIP001 		USHORT nUPos = m_aUnderlineLB.GetSelectEntryPos(), nSPos = m_aStrikeoutLB.GetSelectEntryPos();
//STRIP001         BOOL bEnable = ( nUPos > 0 && nUPos != LISTBOX_ENTRY_NOTFOUND );
//STRIP001 		m_aColorFT.Enable( bEnable );
//STRIP001 		m_aColorLB.Enable( bEnable );
//STRIP001         m_aIndividualWordsBtn.Enable( bEnable || ( nSPos > 0 && nSPos != LISTBOX_ENTRY_NOTFOUND ) );
//STRIP001 	}
//STRIP001     UpdatePreview_Impl();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxCharEffectsPage, UpdatePreview_Impl, ListBox*, EMPTYARG )
//STRIP001 {
//STRIP001 	BOOL bEnable = ( ( m_aUnderlineLB.GetSelectEntryPos() > 0 ) |
//STRIP001 					( m_aStrikeoutLB.GetSelectEntryPos() > 0 ) );
//STRIP001 	m_aIndividualWordsBtn.Enable( bEnable );
//STRIP001 
//STRIP001     UpdatePreview_Impl();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxCharEffectsPage, CbClickHdl_Impl, CheckBox*, EMPTYARG )
//STRIP001 {
//STRIP001 	UpdatePreview_Impl();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxCharEffectsPage, TristClickHdl_Impl, TriStateBox*, EMPTYARG )
//STRIP001 {
//STRIP001 	UpdatePreview_Impl();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxCharEffectsPage, ColorBoxSelectHdl_Impl, ColorListBox*, pBox )
//STRIP001 {
//STRIP001 	SvxFont& rFont = GetPreviewFont();
//STRIP001     SvxFont& rCJKFont = GetPreviewCJKFont();
//STRIP001 	SvxFont& rCTLFont = GetPreviewCTLFont();
//STRIP001 
//STRIP001 	Color aSelectedColor;
//STRIP001 	if ( pBox->GetSelectEntry() == m_aTransparentColorName )
//STRIP001 		aSelectedColor = Color( COL_TRANSPARENT );
//STRIP001 	else
//STRIP001 		aSelectedColor = pBox->GetSelectEntryColor();
//STRIP001     rFont.SetColor( aSelectedColor.GetColor() == COL_AUTO ? Color(COL_BLACK) : aSelectedColor );
//STRIP001     rCJKFont.SetColor( aSelectedColor.GetColor() == COL_AUTO ? Color(COL_BLACK) : aSelectedColor );
//STRIP001 	rCTLFont.SetColor( aSelectedColor.GetColor() == COL_AUTO ? Color(COL_BLACK) : aSelectedColor );
//STRIP001 
//STRIP001     m_aPreviewWin.Invalidate();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 int SvxCharEffectsPage::DeactivatePage( SfxItemSet* pSet )
//STRIP001 {
//STRIP001 	if ( pSet )
//STRIP001 		FillItemSet( *pSet );
//STRIP001 	return LEAVE_PAGE;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabPage* SvxCharEffectsPage::Create( Window* pParent, const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	return new SvxCharEffectsPage( pParent, rSet );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 USHORT* SvxCharEffectsPage::GetRanges()
//STRIP001 {
//STRIP001 	return pEffectsRanges;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxCharEffectsPage::Reset( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	SvxFont& rFont = GetPreviewFont();
//STRIP001     SvxFont& rCJKFont = GetPreviewCJKFont();
//STRIP001 	SvxFont& rCTLFont = GetPreviewCTLFont();
//STRIP001 
//STRIP001 	BOOL bEnable = FALSE;
//STRIP001 
//STRIP001 	// Underline
//STRIP001 	USHORT nWhich = GetWhich( SID_ATTR_CHAR_UNDERLINE );
//STRIP001 	rFont.SetUnderline( UNDERLINE_NONE );
//STRIP001     rCJKFont.SetUnderline( UNDERLINE_NONE );
//STRIP001 	rCTLFont.SetUnderline( UNDERLINE_NONE );
//STRIP001 
//STRIP001 	m_aUnderlineLB.SelectEntryPos( 0 );
//STRIP001 	SfxItemState eState = rSet.GetItemState( nWhich );
//STRIP001 
//STRIP001 	if ( eState >= SFX_ITEM_DONTCARE )
//STRIP001 	{
//STRIP001 		if ( eState == SFX_ITEM_DONTCARE )
//STRIP001 			m_aUnderlineLB.SetNoSelection();
//STRIP001 		else
//STRIP001 		{
//STRIP001 			const SvxUnderlineItem& rItem = (SvxUnderlineItem&)rSet.Get( nWhich );
//STRIP001 			FontUnderline eUnderline = (FontUnderline)rItem.GetValue();
//STRIP001 			rFont.SetUnderline( eUnderline );
//STRIP001             rCJKFont.SetUnderline( eUnderline );
//STRIP001 			rCTLFont.SetUnderline( eUnderline );
//STRIP001 
//STRIP001 			if ( eUnderline != UNDERLINE_NONE )
//STRIP001 			{
//STRIP001 				for ( USHORT i = 0; i < m_aUnderlineLB.GetEntryCount(); ++i )
//STRIP001 				{
//STRIP001 					if ( (FontUnderline)(ULONG)m_aUnderlineLB.GetEntryData(i) == eUnderline )
//STRIP001 					{
//STRIP001 						m_aUnderlineLB.SelectEntryPos(i);
//STRIP001 						bEnable |= TRUE;
//STRIP001 						break;
//STRIP001 					}
//STRIP001 				}
//STRIP001 
//STRIP001 				Color aColor = rItem.GetColor();
//STRIP001 				USHORT nPos = m_aColorLB.GetEntryPos( aColor );
//STRIP001 
//STRIP001 				if ( LISTBOX_ENTRY_NOTFOUND != nPos )
//STRIP001 					m_aColorLB.SelectEntryPos( nPos );
//STRIP001 				else
//STRIP001 				{
//STRIP001 					nPos = m_aColorLB.GetEntryPos( aColor );
//STRIP001 					if ( LISTBOX_ENTRY_NOTFOUND != nPos )
//STRIP001 						m_aColorLB.SelectEntryPos( nPos );
//STRIP001 					else
//STRIP001 						m_aColorLB.SelectEntryPos(
//STRIP001 							m_aColorLB.InsertEntry( aColor,
//STRIP001 								String( SVX_RES( RID_SVXSTR_COLOR_USER ) ) ) );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				m_aColorLB.SelectEntry( Color( COL_AUTO ));
//STRIP001 				m_aColorLB.Disable();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//	Strikeout
//STRIP001 	nWhich = GetWhich( SID_ATTR_CHAR_STRIKEOUT );
//STRIP001 	rFont.SetStrikeout( STRIKEOUT_NONE );
//STRIP001     rCJKFont.SetStrikeout( STRIKEOUT_NONE );
//STRIP001 	rCTLFont.SetStrikeout( STRIKEOUT_NONE );
//STRIP001 
//STRIP001 	m_aStrikeoutLB.SelectEntryPos( 0 );
//STRIP001 	eState = rSet.GetItemState( nWhich );
//STRIP001 
//STRIP001 	if ( eState >= SFX_ITEM_DONTCARE )
//STRIP001 	{
//STRIP001 		if ( eState == SFX_ITEM_DONTCARE )
//STRIP001 			m_aStrikeoutLB.SetNoSelection();
//STRIP001 		else
//STRIP001 		{
//STRIP001 			const SvxCrossedOutItem& rItem = (SvxCrossedOutItem&)rSet.Get( nWhich );
//STRIP001 			FontStrikeout eStrikeout = (FontStrikeout)rItem.GetValue();
//STRIP001 			rFont.SetStrikeout( eStrikeout );
//STRIP001             rCJKFont.SetStrikeout( eStrikeout );
//STRIP001 			rCTLFont.SetStrikeout( eStrikeout );
//STRIP001 
//STRIP001 			if ( eStrikeout != STRIKEOUT_NONE )
//STRIP001 			{
//STRIP001 				for ( USHORT i = 0; i < m_aStrikeoutLB.GetEntryCount(); ++i )
//STRIP001 				{
//STRIP001 					if ( (FontStrikeout)(ULONG)m_aStrikeoutLB.GetEntryData(i) == eStrikeout )
//STRIP001 					{
//STRIP001 						m_aStrikeoutLB.SelectEntryPos(i);
//STRIP001 						bEnable |= TRUE;
//STRIP001 						break;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// WordLineMode
//STRIP001 	nWhich = GetWhich( SID_ATTR_CHAR_WORDLINEMODE );
//STRIP001 	switch ( eState )
//STRIP001 	{
//STRIP001 		case SFX_ITEM_UNKNOWN:
//STRIP001 			m_aIndividualWordsBtn.Hide();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SFX_ITEM_DISABLED:
//STRIP001 		case SFX_ITEM_READONLY:
//STRIP001 			m_aIndividualWordsBtn.Disable();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SFX_ITEM_DONTCARE:
//STRIP001 			m_aIndividualWordsBtn.SetState( STATE_DONTKNOW );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SFX_ITEM_DEFAULT:
//STRIP001 		case SFX_ITEM_SET:
//STRIP001 		{
//STRIP001 			const SvxWordLineModeItem& rItem = (SvxWordLineModeItem&)rSet.Get( nWhich );
//STRIP001 			rFont.SetWordLineMode( rItem.GetValue() );
//STRIP001         	rCJKFont.SetWordLineMode( rItem.GetValue() );
//STRIP001 			rCTLFont.SetWordLineMode( rItem.GetValue() );
//STRIP001 
//STRIP001 			m_aIndividualWordsBtn.Check( rItem.GetValue() );
//STRIP001 			m_aIndividualWordsBtn.Enable( bEnable );
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Emphasis
//STRIP001 	nWhich = GetWhich( SID_ATTR_CHAR_EMPHASISMARK );
//STRIP001 	eState = rSet.GetItemState( nWhich );
//STRIP001 
//STRIP001 	if ( eState >= SFX_ITEM_DEFAULT )
//STRIP001 	{
//STRIP001 		const SvxEmphasisMarkItem& rItem = (SvxEmphasisMarkItem&)rSet.Get( nWhich );
//STRIP001 		FontEmphasisMark eMark = rItem.GetEmphasisMark();
//STRIP001 		rFont.SetEmphasisMark( eMark );
//STRIP001         rCJKFont.SetEmphasisMark( eMark );
//STRIP001 		rCTLFont.SetEmphasisMark( eMark );
//STRIP001 
//STRIP001 		m_aEmphasisLB.SelectEntryPos( (USHORT)( eMark & EMPHASISMARK_STYLE ) );
//STRIP001         eMark &= ~EMPHASISMARK_STYLE;
//STRIP001         ULONG nEntryData = ( eMark == EMPHASISMARK_POS_ABOVE )
//STRIP001 			? CHRDLG_POSITION_OVER
//STRIP001 			: ( eMark == EMPHASISMARK_POS_BELOW ) ? CHRDLG_POSITION_UNDER : 0;
//STRIP001 
//STRIP001         for ( int i = 0; i < m_aPositionLB.GetEntryCount(); i++ )
//STRIP001         {
//STRIP001             if ( nEntryData == (ULONG)m_aPositionLB.GetEntryData(i) )
//STRIP001             {
//STRIP001                 m_aPositionLB.SelectEntryPos(i);
//STRIP001                 break;
//STRIP001             }
//STRIP001         }
//STRIP001 	}
//STRIP001 	else if ( eState == SFX_ITEM_DONTCARE )
//STRIP001 		m_aEmphasisLB.SetNoSelection( );
//STRIP001 	else if ( eState == SFX_ITEM_UNKNOWN )
//STRIP001 	{
//STRIP001 		m_aEmphasisFT.Hide();
//STRIP001 		m_aEmphasisLB.Hide();
//STRIP001 	}
//STRIP001 	else // SFX_ITEM_DISABLED or SFX_ITEM_READONLY
//STRIP001 	{
//STRIP001 		m_aEmphasisFT.Disable();
//STRIP001 		m_aEmphasisLB.Disable();
//STRIP001 	}
//STRIP001 
//STRIP001 	// the select handler for the underline/strikeout list boxes
//STRIP001 //	SelectHdl_Impl( NULL );
//STRIP001 	DBG_ASSERT(m_aUnderlineLB.GetSelectHdl() == m_aStrikeoutLB.GetSelectHdl(),
//STRIP001 		"SvxCharEffectsPage::Reset: inconsistence (1)!");
//STRIP001 	m_aUnderlineLB.GetSelectHdl().Call(NULL);
//STRIP001 		// don't call SelectHdl_Impl directly!
//STRIP001 		// in DisableControls, we may have re-reouted the select handler
//STRIP001 		// 30.05.2001 - 86262 - frank.schoenheit@germany.sun.com
//STRIP001 
//STRIP001 	// the select handler for the emphasis listbox
//STRIP001 //	SelectHdl_Impl( &m_aEmphasisLB );
//STRIP001 	DBG_ASSERT(m_aEmphasisLB.GetSelectHdl() == LINK(this, SvxCharEffectsPage, SelectHdl_Impl),
//STRIP001 		"SvxCharEffectsPage::Reset: inconsistence (2)!");
//STRIP001 	m_aEmphasisLB.GetSelectHdl().Call( &m_aEmphasisLB );
//STRIP001 		// this is for consistency only. Here it would be allowed to call SelectHdl_Impl directly ...
//STRIP001 
//STRIP001 	// Effects
//STRIP001 	SvxCaseMap eCaseMap = SVX_CASEMAP_END;
//STRIP001 	nWhich = GetWhich( SID_ATTR_CHAR_CASEMAP );
//STRIP001 	eState = rSet.GetItemState( nWhich );
//STRIP001 	switch ( eState )
//STRIP001 	{
//STRIP001 		case SFX_ITEM_UNKNOWN:
//STRIP001 			m_aEffectsFT.Hide();
//STRIP001 			m_aEffects2LB.Hide();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SFX_ITEM_DISABLED:
//STRIP001 		case SFX_ITEM_READONLY:
//STRIP001 			m_aEffectsFT.Disable();
//STRIP001 			m_aEffects2LB.Disable();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SFX_ITEM_DONTCARE:
//STRIP001 			m_aEffects2LB.SetNoSelection();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SFX_ITEM_DEFAULT:
//STRIP001 		case SFX_ITEM_SET:
//STRIP001 		{
//STRIP001 			const SvxCaseMapItem& rItem = (const SvxCaseMapItem&)rSet.Get( nWhich );
//STRIP001 			eCaseMap = (SvxCaseMap)rItem.GetValue();
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	SetCaseMap_Impl( eCaseMap );
//STRIP001 
//STRIP001     //Relief
//STRIP001     nWhich = GetWhich(SID_ATTR_CHAR_RELIEF);
//STRIP001 	eState = rSet.GetItemState( nWhich );
//STRIP001 	switch ( eState )
//STRIP001 	{
//STRIP001 		case SFX_ITEM_UNKNOWN:
//STRIP001 			m_aReliefFT.Hide();
//STRIP001 			m_aReliefLB.Hide();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SFX_ITEM_DISABLED:
//STRIP001 		case SFX_ITEM_READONLY:
//STRIP001 			m_aReliefFT.Disable();
//STRIP001 			m_aReliefLB.Disable();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SFX_ITEM_DONTCARE:
//STRIP001 			m_aReliefLB.SetNoSelection();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SFX_ITEM_DEFAULT:
//STRIP001 		case SFX_ITEM_SET:
//STRIP001 		{
//STRIP001         	const SvxCharReliefItem& rItem = (const SvxCharReliefItem&)rSet.Get( nWhich );
//STRIP001         	m_aReliefLB.SelectEntryPos(rItem.GetValue());
//STRIP001         	SelectHdl_Impl(&m_aReliefLB);
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001     // Outline
//STRIP001 	nWhich = GetWhich( SID_ATTR_CHAR_CONTOUR );
//STRIP001 	eState = rSet.GetItemState( nWhich );
//STRIP001 	switch ( eState )
//STRIP001 	{
//STRIP001 		case SFX_ITEM_UNKNOWN:
//STRIP001 			m_aOutlineBtn.Hide();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SFX_ITEM_DISABLED:
//STRIP001 		case SFX_ITEM_READONLY:
//STRIP001 			m_aOutlineBtn.Disable();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SFX_ITEM_DONTCARE:
//STRIP001 			m_aOutlineBtn.SetState( STATE_DONTKNOW );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SFX_ITEM_DEFAULT:
//STRIP001 		case SFX_ITEM_SET:
//STRIP001 		{
//STRIP001 			const SvxContourItem& rItem = (SvxContourItem&)rSet.Get( nWhich );
//STRIP001 			m_aOutlineBtn.SetState( (TriState)rItem.GetValue() );
//STRIP001 			m_aOutlineBtn.EnableTriState( FALSE );
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Shadow
//STRIP001 	nWhich = GetWhich( SID_ATTR_CHAR_SHADOWED );
//STRIP001 	eState = rSet.GetItemState( nWhich );
//STRIP001 
//STRIP001 	switch ( eState )
//STRIP001 	{
//STRIP001 		case SFX_ITEM_UNKNOWN:
//STRIP001 			m_aShadowBtn.Hide();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SFX_ITEM_DISABLED:
//STRIP001 		case SFX_ITEM_READONLY:
//STRIP001 			m_aShadowBtn.Disable();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SFX_ITEM_DONTCARE:
//STRIP001 			m_aShadowBtn.SetState( STATE_DONTKNOW );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SFX_ITEM_DEFAULT:
//STRIP001 		case SFX_ITEM_SET:
//STRIP001 		{
//STRIP001 			const SvxShadowedItem& rItem = (SvxShadowedItem&)rSet.Get( nWhich );
//STRIP001 			m_aShadowBtn.SetState( (TriState)rItem.GetValue() );
//STRIP001 			m_aShadowBtn.EnableTriState( FALSE );
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Blinking
//STRIP001 	nWhich = GetWhich( SID_ATTR_FLASH );
//STRIP001 	eState = rSet.GetItemState( nWhich );
//STRIP001 
//STRIP001 	switch ( eState )
//STRIP001 	{
//STRIP001 		case SFX_ITEM_UNKNOWN:
//STRIP001 			m_aBlinkingBtn.Hide();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SFX_ITEM_DISABLED:
//STRIP001 		case SFX_ITEM_READONLY:
//STRIP001 			m_aBlinkingBtn.Disable();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SFX_ITEM_DONTCARE:
//STRIP001 			m_aBlinkingBtn.SetState( STATE_DONTKNOW );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SFX_ITEM_DEFAULT:
//STRIP001 		case SFX_ITEM_SET:
//STRIP001 		{
//STRIP001 			const SvxBlinkItem& rItem = (SvxBlinkItem&)rSet.Get( nWhich );
//STRIP001 			m_aBlinkingBtn.SetState( (TriState)rItem.GetValue() );
//STRIP001 			m_aBlinkingBtn.EnableTriState( FALSE );
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	SetPrevFontWidthScale( rSet );
//STRIP001 	ResetColor_Impl( rSet );
//STRIP001 
//STRIP001 	// preview update
//STRIP001 	m_aPreviewWin.Invalidate();
//STRIP001 
//STRIP001 	// save this settings
//STRIP001 	m_aUnderlineLB.SaveValue();
//STRIP001 	m_aColorLB.SaveValue();
//STRIP001 	m_aStrikeoutLB.SaveValue();
//STRIP001 	m_aIndividualWordsBtn.SaveValue();
//STRIP001 	m_aEmphasisLB.SaveValue();
//STRIP001 	m_aPositionLB.SaveValue();
//STRIP001 	m_aEffects2LB.SaveValue();
//STRIP001     m_aReliefLB.SaveValue();
//STRIP001     m_aOutlineBtn.SaveValue();
//STRIP001 	m_aShadowBtn.SaveValue();
//STRIP001 	m_aBlinkingBtn.SaveValue();
//STRIP001 	m_aFontColorLB.SaveValue();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SvxCharEffectsPage::FillItemSet( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	const SfxPoolItem* pOld = 0;
//STRIP001 	const SfxItemSet& rOldSet = GetItemSet();
//STRIP001 	BOOL bModified = FALSE;
//STRIP001 	FASTBOOL bChanged = TRUE;
//STRIP001 
//STRIP001 	// Underline
//STRIP001 	USHORT nWhich = GetWhich( SID_ATTR_CHAR_UNDERLINE );
//STRIP001 	pOld = GetOldItem( rSet, SID_ATTR_CHAR_UNDERLINE );
//STRIP001 	USHORT nPos = m_aUnderlineLB.GetSelectEntryPos();
//STRIP001 	FontUnderline eUnder = (FontUnderline)(ULONG)m_aUnderlineLB.GetEntryData( nPos );
//STRIP001 
//STRIP001 	if ( pOld )
//STRIP001 	{
//STRIP001         //! if there are different underline styles in the selection the
//STRIP001         //! item-state in the 'rOldSet' will be invalid. In this case
//STRIP001         //! changing the underline style will be allowed if a style is
//STRIP001         //! selected in the listbox.
//STRIP001         BOOL bAllowChg = LISTBOX_ENTRY_NOTFOUND != nPos  &&
//STRIP001                          SFX_ITEM_DEFAULT > rOldSet.GetItemState( nWhich, TRUE );
//STRIP001 
//STRIP001 		const SvxUnderlineItem& rItem = *( (const SvxUnderlineItem*)pOld );
//STRIP001 		if ( (FontUnderline)rItem.GetValue() == eUnder &&
//STRIP001              ( UNDERLINE_NONE == eUnder || rItem.GetColor() == m_aColorLB.GetSelectEntryColor() ) &&
//STRIP001              ! bAllowChg )
//STRIP001 			bChanged = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bChanged )
//STRIP001 	{
//STRIP001 		SvxUnderlineItem aNewItem( eUnder, nWhich );
//STRIP001 		aNewItem.SetColor( m_aColorLB.GetSelectEntryColor() );
//STRIP001 		rSet.Put( aNewItem );
//STRIP001 		bModified |= TRUE;
//STRIP001 	}
//STRIP001  	else if ( SFX_ITEM_DEFAULT == rOldSet.GetItemState( nWhich, FALSE ) )
//STRIP001 		CLEARTITEM;
//STRIP001 
//STRIP001 	bChanged = TRUE;
//STRIP001 
//STRIP001 	// Strikeout
//STRIP001 	nWhich = GetWhich( SID_ATTR_CHAR_STRIKEOUT );
//STRIP001 	pOld = GetOldItem( rSet, SID_ATTR_CHAR_STRIKEOUT );
//STRIP001 	nPos = m_aStrikeoutLB.GetSelectEntryPos();
//STRIP001 	FontStrikeout eStrike = (FontStrikeout)(ULONG)m_aStrikeoutLB.GetEntryData( nPos );
//STRIP001 
//STRIP001 	if ( pOld )
//STRIP001 	{
//STRIP001         //! if there are different strikeout styles in the selection the
//STRIP001         //! item-state in the 'rOldSet' will be invalid. In this case
//STRIP001         //! changing the strikeout style will be allowed if a style is
//STRIP001         //! selected in the listbox.
//STRIP001         BOOL bAllowChg = LISTBOX_ENTRY_NOTFOUND != nPos  &&
//STRIP001                          SFX_ITEM_DEFAULT > rOldSet.GetItemState( nWhich, TRUE );
//STRIP001 
//STRIP001 		const SvxCrossedOutItem& rItem = *( (const SvxCrossedOutItem*)pOld );
//STRIP001         if ( !m_aStrikeoutLB.IsEnabled()
//STRIP001             || ((FontStrikeout)rItem.GetValue() == eStrike  && !bAllowChg) )
//STRIP001 			bChanged = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bChanged )
//STRIP001 	{
//STRIP001 		rSet.Put( SvxCrossedOutItem( eStrike, nWhich ) );
//STRIP001 		bModified |= TRUE;
//STRIP001 	}
//STRIP001 	else if ( SFX_ITEM_DEFAULT == rOldSet.GetItemState( nWhich, FALSE ) )
//STRIP001 		CLEARTITEM;
//STRIP001 
//STRIP001 	bChanged = TRUE;
//STRIP001 
//STRIP001 	// Individual words
//STRIP001 	nWhich = GetWhich( SID_ATTR_CHAR_WORDLINEMODE );
//STRIP001 	pOld = GetOldItem( rSet, SID_ATTR_CHAR_WORDLINEMODE );
//STRIP001 
//STRIP001 	if ( pOld )
//STRIP001 	{
//STRIP001 		const SvxWordLineModeItem& rItem = *( (const SvxWordLineModeItem*)pOld );
//STRIP001 		if ( rItem.GetValue() == m_aIndividualWordsBtn.IsChecked() )
//STRIP001 			bChanged = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( rOldSet.GetItemState( nWhich ) == SFX_ITEM_DONTCARE &&
//STRIP001 		 m_aIndividualWordsBtn.IsChecked() == m_aIndividualWordsBtn.GetSavedValue() )
//STRIP001 		bChanged = FALSE;
//STRIP001 
//STRIP001 	if ( bChanged )
//STRIP001 	{
//STRIP001 		rSet.Put( SvxWordLineModeItem( m_aIndividualWordsBtn.IsChecked(), nWhich ) );
//STRIP001 		bModified |= TRUE;
//STRIP001 	}
//STRIP001 	else if ( SFX_ITEM_DEFAULT == rOldSet.GetItemState( nWhich, FALSE ) )
//STRIP001 		CLEARTITEM;
//STRIP001 
//STRIP001 	bChanged = TRUE;
//STRIP001 
//STRIP001 	// Emphasis
//STRIP001 	nWhich = GetWhich( SID_ATTR_CHAR_EMPHASISMARK );
//STRIP001 	pOld = GetOldItem( rSet, SID_ATTR_CHAR_EMPHASISMARK );
//STRIP001 	USHORT nMarkPos = m_aEmphasisLB.GetSelectEntryPos();
//STRIP001 	USHORT nPosPos = m_aPositionLB.GetSelectEntryPos();
//STRIP001 	FontEmphasisMark eMark = (FontEmphasisMark)nMarkPos;
//STRIP001 	if ( m_aPositionLB.IsEnabled() )
//STRIP001 	{
//STRIP001 		eMark |= ( CHRDLG_POSITION_UNDER == (ULONG)m_aPositionLB.GetEntryData( nPosPos ) )
//STRIP001 			? EMPHASISMARK_POS_BELOW : EMPHASISMARK_POS_ABOVE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pOld )
//STRIP001 	{
//STRIP001     	if( rOldSet.GetItemState( nWhich ) != SFX_ITEM_DONTCARE )
//STRIP001         {
//STRIP001 		    const SvxEmphasisMarkItem& rItem = *( (const SvxEmphasisMarkItem*)pOld );
//STRIP001 		    if ( rItem.GetEmphasisMark() == eMark )
//STRIP001 			    bChanged = FALSE;
//STRIP001         }
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( rOldSet.GetItemState( nWhich ) == SFX_ITEM_DONTCARE &&
//STRIP001 		 m_aEmphasisLB.GetSavedValue() == nMarkPos && m_aPositionLB.GetSavedValue() == nPosPos )
//STRIP001 		bChanged = FALSE;
//STRIP001 
//STRIP001 	if ( bChanged )
//STRIP001 	{
//STRIP001 		rSet.Put( SvxEmphasisMarkItem( eMark, nWhich ) );
//STRIP001 		bModified |= TRUE;
//STRIP001 	}
//STRIP001 	else if ( SFX_ITEM_DEFAULT == rOldSet.GetItemState( nWhich, FALSE ) )
//STRIP001 		CLEARTITEM;
//STRIP001 
//STRIP001 	bChanged = TRUE;
//STRIP001 
//STRIP001 	// Effects
//STRIP001 	nWhich = GetWhich( SID_ATTR_CHAR_CASEMAP );
//STRIP001 	pOld = GetOldItem( rSet, SID_ATTR_CHAR_CASEMAP );
//STRIP001 	SvxCaseMap eCaseMap = SVX_CASEMAP_NOT_MAPPED;
//STRIP001 	FASTBOOL bChecked = FALSE;
//STRIP001 	USHORT nCapsPos = m_aEffects2LB.GetSelectEntryPos();
//STRIP001 	if ( nCapsPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		eCaseMap = (SvxCaseMap)nCapsPos;
//STRIP001 		bChecked = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pOld )
//STRIP001 	{
//STRIP001         //! if there are different effect styles in the selection the
//STRIP001         //! item-state in the 'rOldSet' will be invalid. In this case
//STRIP001         //! changing the effect style will be allowed if a style is
//STRIP001         //! selected in the listbox.
//STRIP001         BOOL bAllowChg = LISTBOX_ENTRY_NOTFOUND != nPos  &&
//STRIP001                          SFX_ITEM_DEFAULT > rOldSet.GetItemState( nWhich, TRUE );
//STRIP001 
//STRIP001         const SvxCaseMapItem& rItem = *( (const SvxCaseMapItem*)pOld );
//STRIP001         if ( (SvxCaseMap)rItem.GetValue() == eCaseMap  &&  !bAllowChg )
//STRIP001 			bChanged = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bChanged && bChecked )
//STRIP001 	{
//STRIP001 		rSet.Put( SvxCaseMapItem( eCaseMap, nWhich ) );
//STRIP001 		bModified |= TRUE;
//STRIP001 	}
//STRIP001 	else if ( SFX_ITEM_DEFAULT == rOldSet.GetItemState( nWhich, FALSE ) )
//STRIP001 		CLEARTITEM;
//STRIP001 
//STRIP001 	bChanged = TRUE;
//STRIP001 
//STRIP001     //Relief
//STRIP001     nWhich = GetWhich(SID_ATTR_CHAR_RELIEF);
//STRIP001     if(m_aReliefLB.GetSelectEntryPos() != m_aReliefLB.GetSavedValue())
//STRIP001     {
//STRIP001         m_aReliefLB.SaveValue();
//STRIP001         SvxCharReliefItem aRelief((FontRelief)m_aReliefLB.GetSelectEntryPos(), nWhich);
//STRIP001         rSet.Put(aRelief);
//STRIP001     }
//STRIP001 
//STRIP001     // Outline
//STRIP001 	const SfxItemSet* pExampleSet = GetTabDialog() ? GetTabDialog()->GetExampleSet() : NULL;
//STRIP001 	nWhich = GetWhich( SID_ATTR_CHAR_CONTOUR );
//STRIP001 	pOld = GetOldItem( rSet, SID_ATTR_CHAR_CONTOUR );
//STRIP001 	TriState eState = m_aOutlineBtn.GetState();
//STRIP001 	const SfxPoolItem* pItem;
//STRIP001 
//STRIP001 	if ( pOld )
//STRIP001 	{
//STRIP001 		const SvxContourItem& rItem = *( (const SvxContourItem*)pOld );
//STRIP001 		if ( rItem.GetValue() == StateToAttr( eState ) && m_aOutlineBtn.GetSavedValue() == eState )
//STRIP001 			bChanged = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( !bChanged && pExampleSet && pExampleSet->GetItemState( nWhich, FALSE, &pItem ) == SFX_ITEM_SET &&
//STRIP001 		 !StateToAttr( eState ) && ( (SvxContourItem*)pItem )->GetValue() )
//STRIP001 		bChanged = TRUE;
//STRIP001 
//STRIP001 	if ( bChanged && eState != STATE_DONTKNOW )
//STRIP001 	{
//STRIP001 		rSet.Put( SvxContourItem( StateToAttr( eState ), nWhich ) );
//STRIP001 		bModified |= TRUE;
//STRIP001 	}
//STRIP001 	else if ( SFX_ITEM_DEFAULT == rOldSet.GetItemState( nWhich, FALSE ) )
//STRIP001 		CLEARTITEM;
//STRIP001 
//STRIP001 	bChanged = TRUE;
//STRIP001 
//STRIP001 	// Shadow
//STRIP001 	nWhich = GetWhich( SID_ATTR_CHAR_SHADOWED );
//STRIP001 	pOld = GetOldItem( rSet, SID_ATTR_CHAR_SHADOWED );
//STRIP001 	eState = m_aShadowBtn.GetState();
//STRIP001 
//STRIP001 	if ( pOld )
//STRIP001 	{
//STRIP001 		const SvxShadowedItem& rItem = *( (const SvxShadowedItem*)pOld );
//STRIP001 		if ( rItem.GetValue() == StateToAttr( eState ) && m_aShadowBtn.GetSavedValue() == eState )
//STRIP001 			bChanged = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( !bChanged && pExampleSet && pExampleSet->GetItemState( nWhich, FALSE, &pItem ) == SFX_ITEM_SET &&
//STRIP001 		 !StateToAttr( eState ) && ( (SvxShadowedItem*)pItem )->GetValue() )
//STRIP001 		bChanged = TRUE;
//STRIP001 
//STRIP001 	if ( bChanged && eState != STATE_DONTKNOW )
//STRIP001 	{
//STRIP001 		rSet.Put( SvxShadowedItem( StateToAttr( eState ), nWhich ) );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 	else if ( SFX_ITEM_DEFAULT == rOldSet.GetItemState( nWhich, FALSE ) )
//STRIP001 		CLEARTITEM;
//STRIP001 
//STRIP001 	bChanged = TRUE;
//STRIP001 
//STRIP001 	// Blinking
//STRIP001 	nWhich = GetWhich( SID_ATTR_FLASH );
//STRIP001 	pOld = GetOldItem( rSet, SID_ATTR_FLASH );
//STRIP001 	eState = m_aBlinkingBtn.GetState();
//STRIP001 
//STRIP001 	if ( pOld )
//STRIP001 	{
//STRIP001 		const SvxBlinkItem& rItem = *( (const SvxBlinkItem*)pOld );
//STRIP001 		if ( rItem.GetValue() == StateToAttr( eState ) && m_aBlinkingBtn.GetSavedValue() == eState )
//STRIP001 			bChanged = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( !bChanged && pExampleSet && pExampleSet->GetItemState( nWhich, FALSE, &pItem ) == SFX_ITEM_SET &&
//STRIP001 		 !StateToAttr( eState ) && ( (SvxBlinkItem*)pItem )->GetValue() )
//STRIP001 		bChanged = TRUE;
//STRIP001 
//STRIP001 	if ( bChanged && eState != STATE_DONTKNOW )
//STRIP001 	{
//STRIP001 		rSet.Put( SvxBlinkItem( StateToAttr( eState ), nWhich ) );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 	else if ( SFX_ITEM_DEFAULT == rOldSet.GetItemState( nWhich, FALSE ) )
//STRIP001 		CLEARTITEM;
//STRIP001 
//STRIP001 
//STRIP001 	bModified |= FillItemSetColor_Impl( rSet );
//STRIP001 
//STRIP001 	return bModified;
//STRIP001 }
//STRIP001 
//STRIP001 void SvxCharEffectsPage::DisableControls( USHORT nDisable )
//STRIP001 {
//STRIP001 	if ( ( DISABLE_CASEMAP & nDisable ) == DISABLE_CASEMAP )
//STRIP001 	{
//STRIP001 		m_aEffectsFT.Disable();
//STRIP001 		m_aEffects2LB.Disable();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( ( DISABLE_WORDLINE & nDisable ) == DISABLE_WORDLINE )
//STRIP001 		m_aIndividualWordsBtn.Disable();
//STRIP001 
//STRIP001 	if ( ( DISABLE_BLINK & nDisable ) == DISABLE_BLINK )
//STRIP001 		m_aBlinkingBtn.Disable();
//STRIP001 
//STRIP001 	if ( ( DISABLE_UNDERLINE_COLOR & nDisable ) == DISABLE_UNDERLINE_COLOR )
//STRIP001 	{
//STRIP001 		// disable the controls
//STRIP001 		m_aColorFT.Disable( );
//STRIP001 		m_aColorLB.Disable( );
//STRIP001 		// and reroute the selection handler of the controls which normally would affect the color box dis-/enabling
//STRIP001 		m_aUnderlineLB.SetSelectHdl(LINK(this, SvxCharEffectsPage, UpdatePreview_Impl));
//STRIP001 		m_aStrikeoutLB.SetSelectHdl(LINK(this, SvxCharEffectsPage, UpdatePreview_Impl));
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 void SvxCharEffectsPage::EnableFlash()
//STRIP001 {
//STRIP001 	if ( !( ( m_nHtmlMode & HTMLMODE_ON ) && !( m_nHtmlMode & HTMLMODE_BLINK ) ) )
//STRIP001 		m_aBlinkingBtn.Show();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 void SvxCharEffectsPage::SetPreviewBackgroundToCharacter()
//STRIP001 {
//STRIP001     m_bPreviewBackgroundToCharacter = TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 // class SvxCharPositionPage ---------------------------------------------
//STRIP001 
//STRIP001 SvxCharPositionPage::SvxCharPositionPage( Window* pParent, const SfxItemSet& rInSet ) :
//STRIP001 
//STRIP001 	SvxCharBasePage( pParent, SVX_RES( RID_SVXPAGE_CHAR_POSITION ), rInSet, WIN_POS_PREVIEW, FT_POS_FONTTYPE ),
//STRIP001 
//STRIP001 	m_aPositionLine		( this, ResId( FL_POSITION ) ),
//STRIP001 	m_aHighPosBtn		( this, ResId( RB_HIGHPOS ) ),
//STRIP001 	m_aNormalPosBtn		( this, ResId( RB_NORMALPOS ) ),
//STRIP001 	m_aLowPosBtn		( this, ResId( RB_LOWPOS ) ),
//STRIP001 	m_aHighLowFT		( this, ResId( FT_HIGHLOW ) ),
//STRIP001 	m_aHighLowEdit		( this, ResId( ED_HIGHLOW ) ),
//STRIP001 	m_aHighLowRB		( this, ResId( CB_HIGHLOW ) ),
//STRIP001 	m_aFontSizeFT		( this, ResId( FT_FONTSIZE ) ),
//STRIP001 	m_aFontSizeEdit		( this, ResId( ED_FONTSIZE ) ),
//STRIP001 	m_aRotationScalingFL( this, ResId( FL_ROTATION_SCALING ) ),
//STRIP001 	m_aScalingFL		( this, ResId( FL_SCALING ) ),
//STRIP001 	m_a0degRB			( this, ResId( RB_0_DEG ) ),
//STRIP001 	m_a90degRB			( this, ResId( RB_90_DEG ) ),
//STRIP001 	m_a270degRB			( this, ResId( RB_270_DEG ) ),
//STRIP001 	m_aFitToLineCB		( this, ResId( CB_FIT_TO_LINE ) ),
//STRIP001 	m_aScaleWidthFT		( this, ResId( FT_SCALE_WIDTH ) ),
//STRIP001 	m_aScaleWidthMF		( this, ResId( MF_SCALE_WIDTH ) ),
//STRIP001 
//STRIP001 	m_aKerningLine		( this, ResId( FL_KERNING2 ) ),
//STRIP001 	m_aKerningLB		( this, ResId( LB_KERNING2 ) ),
//STRIP001 	m_aKerningFT		( this, ResId( FT_KERNING2 ) ),
//STRIP001 	m_aKerningEdit		( this, ResId( ED_KERNING2 ) ),
//STRIP001 	m_aPairKerningBtn	( this, ResId( CB_PAIRKERNING ) ),
//STRIP001 
//STRIP001 	m_nSuperEsc			( (short)DFLT_ESC_SUPER ),
//STRIP001 	m_nSubEsc			( (short)DFLT_ESC_SUB ),
//STRIP001 	m_nScaleWidthItemSetVal	( 100 ),
//STRIP001 	m_nScaleWidthInitialVal	( 100 ),
//STRIP001 	m_nSuperProp		( (BYTE)DFLT_ESC_PROP ),
//STRIP001     m_nSubProp          ( (BYTE)DFLT_ESC_PROP )
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 	Initialize();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxCharPositionPage::Initialize()
//STRIP001 {
//STRIP001 	// to handle the changes of the other pages
//STRIP001 	SetExchangeSupport();
//STRIP001 
//STRIP001 	GetPreviewFont().SetSize( Size( 0, 240 ) );
//STRIP001     GetPreviewCJKFont().SetSize( Size( 0, 240 ) );
//STRIP001 	GetPreviewCTLFont().SetSize( Size( 0, 240 ) );
//STRIP001 
//STRIP001 	m_aNormalPosBtn.Check();
//STRIP001 	PositionHdl_Impl( &m_aNormalPosBtn );
//STRIP001 	m_aKerningLB.SelectEntryPos( 0 );
//STRIP001 	KerningSelectHdl_Impl( NULL );
//STRIP001 
//STRIP001 	Link aLink = LINK( this, SvxCharPositionPage, PositionHdl_Impl );
//STRIP001 	m_aHighPosBtn.SetClickHdl( aLink );
//STRIP001 	m_aNormalPosBtn.SetClickHdl( aLink );
//STRIP001 	m_aLowPosBtn.SetClickHdl( aLink );
//STRIP001 
//STRIP001 	aLink = LINK( this, SvxCharPositionPage, RotationHdl_Impl );
//STRIP001 	m_a0degRB  .SetClickHdl( aLink );
//STRIP001 	m_a90degRB .SetClickHdl( aLink );
//STRIP001 	m_a270degRB.SetClickHdl( aLink );
//STRIP001 
//STRIP001 	aLink = LINK( this, SvxCharPositionPage, FontModifyHdl_Impl );
//STRIP001 	m_aHighLowEdit.SetModifyHdl( aLink );
//STRIP001 	m_aFontSizeEdit.SetModifyHdl( aLink );
//STRIP001 
//STRIP001 	aLink = LINK( this, SvxCharPositionPage, LoseFocusHdl_Impl );
//STRIP001 	m_aHighLowEdit.SetLoseFocusHdl( aLink );
//STRIP001 	m_aFontSizeEdit.SetLoseFocusHdl( aLink );
//STRIP001 
//STRIP001 	m_aHighLowRB.SetClickHdl( LINK( this, SvxCharPositionPage, AutoPositionHdl_Impl ) );
//STRIP001 	m_aFitToLineCB.SetClickHdl( LINK( this, SvxCharPositionPage, FitToLineHdl_Impl ) );
//STRIP001 	m_aKerningLB.SetSelectHdl( LINK( this, SvxCharPositionPage, KerningSelectHdl_Impl ) );
//STRIP001 	m_aKerningEdit.SetModifyHdl( LINK( this, SvxCharPositionPage, KerningModifyHdl_Impl ) );
//STRIP001 	m_aPairKerningBtn.SetClickHdl( LINK( this, SvxCharPositionPage, PairKerningHdl_Impl ) );
//STRIP001 	m_aScaleWidthMF.SetModifyHdl( LINK( this, SvxCharPositionPage, ScaleWidthModifyHdl_Impl ) );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxCharPositionPage::UpdatePreview_Impl( BYTE nProp, BYTE nEscProp, short nEsc )
//STRIP001 {
//STRIP001 	SetPrevFontEscapement( nProp, nEscProp, nEsc );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxCharPositionPage::SetEscapement_Impl( USHORT nEsc )
//STRIP001 {
//STRIP001 	SvxEscapementItem aEscItm( (SvxEscapement)nEsc );
//STRIP001 
//STRIP001 	if ( SVX_ESCAPEMENT_SUPERSCRIPT == nEsc )
//STRIP001 	{
//STRIP001 		aEscItm.GetEsc() = m_nSuperEsc;
//STRIP001 		aEscItm.GetProp() = m_nSuperProp;
//STRIP001 	}
//STRIP001 	else if ( SVX_ESCAPEMENT_SUBSCRIPT == nEsc )
//STRIP001 	{
//STRIP001 		aEscItm.GetEsc() = m_nSubEsc;
//STRIP001 		aEscItm.GetProp() = m_nSubProp;
//STRIP001 	}
//STRIP001 
//STRIP001 	short nFac = aEscItm.GetEsc() < 0 ? -1 : 1;
//STRIP001 
//STRIP001 	m_aHighLowEdit.SetValue( aEscItm.GetEsc() * nFac );
//STRIP001 	m_aFontSizeEdit.SetValue( aEscItm.GetProp() );
//STRIP001 
//STRIP001 	if ( SVX_ESCAPEMENT_OFF == nEsc )
//STRIP001 	{
//STRIP001 		m_aHighLowFT.Disable();
//STRIP001 		m_aHighLowEdit.Disable();
//STRIP001 		m_aFontSizeFT.Disable();
//STRIP001 		m_aFontSizeEdit.Disable();
//STRIP001 		m_aHighLowRB.Disable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		m_aFontSizeFT.Enable();
//STRIP001 		m_aFontSizeEdit.Enable();
//STRIP001 		m_aHighLowRB.Enable();
//STRIP001 
//STRIP001 		if ( !m_aHighLowRB.IsChecked() )
//STRIP001 		{
//STRIP001 			m_aHighLowFT.Enable();
//STRIP001 			m_aHighLowEdit.Enable();
//STRIP001 		}
//STRIP001 		else
//STRIP001 			AutoPositionHdl_Impl( &m_aHighLowRB );
//STRIP001 	}
//STRIP001 
//STRIP001 	UpdatePreview_Impl( 100, aEscItm.GetProp(), aEscItm.GetEsc() );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxCharPositionPage, PositionHdl_Impl, RadioButton*, pBtn )
//STRIP001 {
//STRIP001 	USHORT nEsc = SVX_ESCAPEMENT_OFF;	// also when pBtn == NULL
//STRIP001 
//STRIP001 	if ( &m_aHighPosBtn == pBtn )
//STRIP001 		nEsc = SVX_ESCAPEMENT_SUPERSCRIPT;
//STRIP001 	else if ( &m_aLowPosBtn == pBtn )
//STRIP001 		nEsc = SVX_ESCAPEMENT_SUBSCRIPT;
//STRIP001 
//STRIP001 	SetEscapement_Impl( nEsc );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxCharPositionPage, RotationHdl_Impl, RadioButton*, pBtn )
//STRIP001 {
//STRIP001 	BOOL bEnable = FALSE;
//STRIP001 	if (&m_a90degRB == pBtn  ||  &m_a270degRB == pBtn)
//STRIP001 		bEnable = TRUE;
//STRIP001 	else if (&m_a0degRB != pBtn)
//STRIP001 		DBG_ERROR( "unexpected button" );
//STRIP001 	m_aFitToLineCB.Enable( bEnable );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxCharPositionPage, FontModifyHdl_Impl, MetricField*, EMPTYARG )
//STRIP001 {
//STRIP001 	BYTE nEscProp = (BYTE)m_aFontSizeEdit.GetValue();
//STRIP001 	short nEsc	= (short)m_aHighLowEdit.GetValue();
//STRIP001 	nEsc *= m_aLowPosBtn.IsChecked() ? -1 : 1;
//STRIP001 	UpdatePreview_Impl( 100, nEscProp, nEsc );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxCharPositionPage, AutoPositionHdl_Impl, CheckBox*, pBox )
//STRIP001 {
//STRIP001 	if ( pBox->IsChecked() )
//STRIP001 	{
//STRIP001 		m_aHighLowFT.Disable();
//STRIP001 		m_aHighLowEdit.Disable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		PositionHdl_Impl( m_aHighPosBtn.IsChecked() ? &m_aHighPosBtn
//STRIP001 													  : m_aLowPosBtn.IsChecked() ? &m_aLowPosBtn
//STRIP001 													  							 : &m_aNormalPosBtn );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxCharPositionPage, FitToLineHdl_Impl, CheckBox*, pBox )
//STRIP001 {
//STRIP001 	if ( &m_aFitToLineCB == pBox)
//STRIP001 	{
//STRIP001 		UINT16 nVal = m_nScaleWidthInitialVal;
//STRIP001 		if (m_aFitToLineCB.IsChecked())
//STRIP001 			nVal = m_nScaleWidthItemSetVal;
//STRIP001 		m_aScaleWidthMF.SetValue( nVal );
//STRIP001 
//STRIP001 		m_aPreviewWin.SetFontWidthScale( nVal );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxCharPositionPage, KerningSelectHdl_Impl, ListBox*, EMPTYARG )
//STRIP001 {
//STRIP001 	if ( m_aKerningLB.GetSelectEntryPos() > 0 )
//STRIP001 	{
//STRIP001 		m_aKerningFT.Enable();
//STRIP001 		m_aKerningEdit.Enable();
//STRIP001 
//STRIP001 		if ( m_aKerningLB.GetSelectEntryPos() == 2 )
//STRIP001 		{
//STRIP001 			// Condensed -> max value == 1/6 of the current font height
//STRIP001 			SvxFont& rFont = GetPreviewFont();
//STRIP001 			long nMax = rFont.GetSize().Height() / 6;
//STRIP001 			m_aKerningEdit.SetMax( m_aKerningEdit.Normalize( nMax ), FUNIT_TWIP );
//STRIP001 			m_aKerningEdit.SetLast( m_aKerningEdit.GetMax( m_aKerningEdit.GetUnit() ) );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			m_aKerningEdit.SetMax( 9999 );
//STRIP001 			m_aKerningEdit.SetLast( 9999 );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		m_aKerningEdit.SetValue( 0 );
//STRIP001 		m_aKerningFT.Disable();
//STRIP001 		m_aKerningEdit.Disable();
//STRIP001 	}
//STRIP001 
//STRIP001 	KerningModifyHdl_Impl( NULL );
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxCharPositionPage, KerningModifyHdl_Impl, MetricField*, EMPTYARG )
//STRIP001 {
//STRIP001 	long nVal = m_aKerningEdit.GetValue();
//STRIP001 	nVal = LogicToLogic( nVal, MAP_POINT, MAP_TWIP );
//STRIP001 	long nKern = (short)m_aKerningEdit.Denormalize( nVal );
//STRIP001 
//STRIP001 	// Condensed? -> then negative
//STRIP001 	if ( m_aKerningLB.GetSelectEntryPos() == 2 )
//STRIP001 		nKern *= -1;
//STRIP001 
//STRIP001 	SvxFont& rFont = GetPreviewFont();
//STRIP001     SvxFont& rCJKFont = GetPreviewCJKFont();
//STRIP001 	SvxFont& rCTLFont = GetPreviewCTLFont();
//STRIP001 
//STRIP001 	rFont.SetFixKerning( (short)nKern );
//STRIP001     rCJKFont.SetFixKerning( (short)nKern );
//STRIP001 	rCTLFont.SetFixKerning( (short)nKern );
//STRIP001 	m_aPreviewWin.Invalidate();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxCharPositionPage, PairKerningHdl_Impl, CheckBox*, EMPTYARG )
//STRIP001 {
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxCharPositionPage, LoseFocusHdl_Impl, MetricField*, pField )
//STRIP001 {
//STRIP001 	sal_Bool bHigh = m_aHighPosBtn.IsChecked();
//STRIP001 	sal_Bool bLow = m_aLowPosBtn.IsChecked();
//STRIP001 	DBG_ASSERT( bHigh || bLow, "normal position is not valid" );
//STRIP001 
//STRIP001 	if ( &m_aHighLowEdit == pField )
//STRIP001 	{
//STRIP001 		if ( bLow )
//STRIP001 			m_nSubEsc = (short)m_aHighLowEdit.GetValue() * -1;
//STRIP001 		else
//STRIP001 			m_nSuperEsc = (short)m_aHighLowEdit.GetValue();
//STRIP001 	}
//STRIP001 	else if ( &m_aFontSizeEdit == pField )
//STRIP001 	{
//STRIP001 		if ( bLow )
//STRIP001 			m_nSubProp = (BYTE)m_aFontSizeEdit.GetValue();
//STRIP001 		else
//STRIP001 			m_nSuperProp = (BYTE)m_aFontSizeEdit.GetValue();
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxCharPositionPage, ScaleWidthModifyHdl_Impl, MetricField*, pField )
//STRIP001 {
//STRIP001 	m_aPreviewWin.SetFontWidthScale( USHORT( m_aScaleWidthMF.GetValue() ) );
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 int SvxCharPositionPage::DeactivatePage( SfxItemSet* pSet )
//STRIP001 {
//STRIP001 	if ( pSet )
//STRIP001 		FillItemSet( *pSet );
//STRIP001 	return LEAVE_PAGE;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabPage* SvxCharPositionPage::Create( Window* pParent, const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	return new SvxCharPositionPage( pParent, rSet );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 USHORT* SvxCharPositionPage::GetRanges()
//STRIP001 {
//STRIP001 	return pPositionRanges;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 #define ENABLE_AND_CHECK( aCheckBox )	\
//STRIP001 	if ( !aCheckBox.IsEnabled() )		\
//STRIP001 		aCheckBox.Enable();				\
//STRIP001 	aCheckBox.Check( TRUE )
//STRIP001 
//STRIP001 void SvxCharPositionPage::Reset( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	String sUser = GetUserData();
//STRIP001 
//STRIP001 	if ( sUser.Len() )
//STRIP001 	{
//STRIP001 		m_nSuperEsc = (short)sUser.GetToken( 0 ).ToInt32();
//STRIP001 		m_nSubEsc = (short)sUser.GetToken( 1 ).ToInt32();
//STRIP001 		m_nSuperProp = (BYTE)sUser.GetToken( 2 ).ToInt32();
//STRIP001 		m_nSubProp = (BYTE)sUser.GetToken( 3 ).ToInt32();
//STRIP001 	}
//STRIP001 
//STRIP001 	short nEsc = 0;
//STRIP001 	BYTE nEscProp = 100;
//STRIP001 	BYTE nProp = 100;
//STRIP001 
//STRIP001 	m_aHighLowFT.Disable();
//STRIP001 	m_aHighLowEdit.Disable();
//STRIP001 	m_aFontSizeFT.Disable();
//STRIP001 	m_aFontSizeEdit.Disable();
//STRIP001 
//STRIP001 	SvxFont& rFont = GetPreviewFont();
//STRIP001     SvxFont& rCJKFont = GetPreviewCJKFont();
//STRIP001 	SvxFont& rCTLFont = GetPreviewCTLFont();
//STRIP001 	USHORT nWhich = GetWhich( SID_ATTR_CHAR_ESCAPEMENT );
//STRIP001 
//STRIP001 	if ( rSet.GetItemState( nWhich ) >= SFX_ITEM_DEFAULT )
//STRIP001 	{
//STRIP001 		const SvxEscapementItem& rItem = (SvxEscapementItem&)rSet.Get( nWhich );
//STRIP001 		nEsc = rItem.GetEsc();
//STRIP001 		nEscProp = rItem.GetProp();
//STRIP001 
//STRIP001 		if ( nEsc != 0 )
//STRIP001 		{
//STRIP001 			m_aHighLowFT.Enable();
//STRIP001 			m_aHighLowEdit.Enable();
//STRIP001 			m_aFontSizeFT.Enable();
//STRIP001 			m_aFontSizeEdit.Enable();
//STRIP001 
//STRIP001 			short nFac;
//STRIP001 
//STRIP001 			if ( nEsc > 0 )
//STRIP001 			{
//STRIP001 				nFac = 1;
//STRIP001 				m_aHighPosBtn.Check( TRUE );
//STRIP001 				if ( nEsc == DFLT_ESC_AUTO_SUPER )
//STRIP001 				{
//STRIP001 					ENABLE_AND_CHECK( m_aHighLowRB );
//STRIP001 					nEsc = DFLT_ESC_SUPER;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				nFac = -1;
//STRIP001 				m_aLowPosBtn.Check( TRUE );
//STRIP001 				if ( nEsc == DFLT_ESC_AUTO_SUB )
//STRIP001 				{
//STRIP001 					ENABLE_AND_CHECK( m_aHighLowRB );
//STRIP001 					nEsc = DFLT_ESC_SUB;
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( m_aHighLowRB.IsChecked() )
//STRIP001 			{
//STRIP001 				m_aHighLowFT.Disable();
//STRIP001 				m_aHighLowEdit.Disable();
//STRIP001 			}
//STRIP001 			m_aHighLowEdit.SetValue( m_aHighLowEdit.Normalize( nFac * nEsc ) );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			m_aNormalPosBtn.Check( TRUE );
//STRIP001 			m_aHighLowRB.Check( TRUE );
//STRIP001 			PositionHdl_Impl( NULL );
//STRIP001 		}
//STRIP001 	    //the height has to be set after the handler is called to keep the value also if the escapement is zero
//STRIP001         m_aFontSizeEdit.SetValue( m_aFontSizeEdit.Normalize( nEscProp ) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		m_aHighPosBtn.Check( FALSE );
//STRIP001 		m_aNormalPosBtn.Check( FALSE );
//STRIP001 		m_aLowPosBtn.Check( FALSE );
//STRIP001 	}
//STRIP001 
//STRIP001 	// BspFont setzen
//STRIP001 	SetPrevFontEscapement( nProp, nEscProp, nEsc );
//STRIP001 
//STRIP001 	// Kerning
//STRIP001 	nWhich = GetWhich( SID_ATTR_CHAR_KERNING );
//STRIP001 
//STRIP001 	if ( rSet.GetItemState( nWhich ) >= SFX_ITEM_DEFAULT )
//STRIP001 	{
//STRIP001 		const SvxKerningItem& rItem = (SvxKerningItem&)rSet.Get( nWhich );
//STRIP001 		SfxMapUnit eUnit = rSet.GetPool()->GetMetric( nWhich );
//STRIP001 		MapUnit eOrgUnit = (MapUnit)eUnit;
//STRIP001 		MapUnit ePntUnit( MAP_POINT );
//STRIP001 		long nBig = m_aKerningEdit.Normalize( (long)rItem.GetValue() );
//STRIP001 		long nKerning = LogicToLogic( nBig, eOrgUnit, ePntUnit );
//STRIP001 
//STRIP001 		// Kerning am Font setzen, vorher in Twips umrechnen
//STRIP001 		long nKern = LogicToLogic( rItem.GetValue(), (MapUnit)eUnit, MAP_TWIP );
//STRIP001 		rFont.SetFixKerning( (short)nKern );
//STRIP001         rCJKFont.SetFixKerning( (short)nKern );
//STRIP001 		rCTLFont.SetFixKerning( (short)nKern );
//STRIP001 
//STRIP001 		if ( nKerning > 0 )
//STRIP001 		{
//STRIP001 			m_aKerningFT.Enable();
//STRIP001 			m_aKerningEdit.Enable();
//STRIP001 			m_aKerningEdit.SetValue( nKerning );
//STRIP001 			m_aKerningLB.SelectEntryPos( LW_GESPERRT );
//STRIP001 		}
//STRIP001 		else if ( nKerning < 0 )
//STRIP001 		{
//STRIP001 			m_aKerningFT.Enable();
//STRIP001 			m_aKerningEdit.Enable();
//STRIP001 			m_aKerningEdit.SetValue( -nKerning );
//STRIP001 			m_aKerningLB.SelectEntryPos( LW_SCHMAL );
//STRIP001 			long nMax = rFont.GetSize().Height() / 6;
//STRIP001 			m_aKerningEdit.SetMax( m_aKerningEdit.Normalize( nMax ), FUNIT_TWIP );
//STRIP001 			m_aKerningEdit.SetLast( m_aKerningEdit.GetMax( m_aKerningEdit.GetUnit() ) );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			m_aKerningFT.Disable();
//STRIP001 			m_aKerningEdit.Disable();
//STRIP001 			m_aKerningEdit.SetValue( 0 );
//STRIP001 			m_aKerningLB.SelectEntryPos( LW_NORMAL );
//STRIP001 			m_aKerningEdit.SetMax( 9999 );
//STRIP001 			m_aKerningEdit.SetLast( 9999 );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		m_aKerningEdit.SetText( String() );
//STRIP001 
//STRIP001 	// Pair kerning
//STRIP001 	nWhich = GetWhich( SID_ATTR_CHAR_AUTOKERN );
//STRIP001 
//STRIP001 	if ( rSet.GetItemState( nWhich ) >= SFX_ITEM_DEFAULT )
//STRIP001 	{
//STRIP001 		const SvxAutoKernItem& rItem = (SvxAutoKernItem&)rSet.Get( nWhich );
//STRIP001 		m_aPairKerningBtn.Check( rItem.GetValue() );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		m_aPairKerningBtn.Check( FALSE );
//STRIP001 
//STRIP001 	// Scale Width
//STRIP001 	nWhich = GetWhich( SID_ATTR_CHAR_SCALEWIDTH );
//STRIP001 	if ( rSet.GetItemState( nWhich ) >= SFX_ITEM_DEFAULT )
//STRIP001 	{
//STRIP001 		const SvxCharScaleWidthItem& rItem = ( SvxCharScaleWidthItem& ) rSet.Get( nWhich );
//STRIP001 		m_nScaleWidthInitialVal = rItem.GetValue();
//STRIP001 		m_aScaleWidthMF.SetValue( m_nScaleWidthInitialVal );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		m_aScaleWidthMF.SetValue( 100 );
//STRIP001 
//STRIP001     nWhich = GetWhich( SID_ATTR_CHAR_WIDTH_FIT_TO_LINE );
//STRIP001 	if ( rSet.GetItemState( nWhich ) >= SFX_ITEM_DEFAULT )
//STRIP001 		m_nScaleWidthItemSetVal = ((SfxUInt16Item&) rSet.Get( nWhich )).GetValue();
//STRIP001 
//STRIP001 	// Rotation
//STRIP001 	nWhich = GetWhich( SID_ATTR_CHAR_ROTATED );
//STRIP001 	SfxItemState eState = rSet.GetItemState( nWhich );
//STRIP001 	if( SFX_ITEM_UNKNOWN == eState )
//STRIP001 	{
//STRIP001 		m_aRotationScalingFL.Hide();
//STRIP001 		m_aScalingFL.Show();
//STRIP001 		m_a0degRB.Hide();
//STRIP001 		m_a90degRB.Hide();
//STRIP001 		m_a270degRB.Hide();
//STRIP001 		m_aFitToLineCB.Hide();
//STRIP001         m_aFitToLineCB .Hide();
//STRIP001 
//STRIP001 
//STRIP001         // move the following controls upwards
//STRIP001 		Window* aCntrlArr[] = {
//STRIP001 			&m_aScaleWidthFT, &m_aScaleWidthMF, &m_aKerningLine,
//STRIP001 			&m_aKerningLB, &m_aKerningFT, &m_aKerningEdit, &m_aPairKerningBtn,
//STRIP001 			0 };
//STRIP001 
//STRIP001         long nDiff = m_aScaleWidthMF.GetPosPixel().Y() -
//STRIP001                         m_a0degRB.GetPosPixel().Y();
//STRIP001 
//STRIP001 		for( Window** ppW = aCntrlArr; *ppW; ++ppW )
//STRIP001 		{
//STRIP001 			Point aPnt( (*ppW)->GetPosPixel() );
//STRIP001 			aPnt.Y() -= nDiff;
//STRIP001 			(*ppW)->SetPosPixel( aPnt );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		m_aScalingFL.Hide();
//STRIP001 
//STRIP001 		Link aOldLink( m_aFitToLineCB.GetClickHdl() );
//STRIP001 		m_aFitToLineCB.SetClickHdl( Link() );
//STRIP001 		if( eState >= SFX_ITEM_DEFAULT )
//STRIP001 		{
//STRIP001 			const SvxCharRotateItem& rItem =
//STRIP001 					(SvxCharRotateItem&) rSet.Get( nWhich );
//STRIP001 			if (rItem.IsBottomToTop())
//STRIP001 				m_a90degRB.Check( TRUE );
//STRIP001 			else if (rItem.IsTopToBotton())
//STRIP001 				m_a270degRB.Check( TRUE );
//STRIP001 			else
//STRIP001 			{
//STRIP001 				DBG_ASSERT( 0 == rItem.GetValue(), "incorrect value" );
//STRIP001 				m_a0degRB.Check( TRUE );
//STRIP001 			}
//STRIP001 			m_aFitToLineCB.Check( rItem.IsFitToLine() );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if( eState == SFX_ITEM_DONTCARE )
//STRIP001 			{
//STRIP001 				m_a0degRB.Check( FALSE );
//STRIP001 				m_a90degRB.Check( FALSE );
//STRIP001 				m_a270degRB.Check( FALSE );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				m_a0degRB.Check( TRUE );
//STRIP001 
//STRIP001 			m_aFitToLineCB.Check( FALSE );
//STRIP001 		}
//STRIP001 		m_aFitToLineCB.SetClickHdl( aOldLink );
//STRIP001 		m_aFitToLineCB.Enable( !m_a0degRB.IsChecked() );
//STRIP001 
//STRIP001 		// is this value set?
//STRIP001 		if( SFX_ITEM_UNKNOWN == rSet.GetItemState( GetWhich(
//STRIP001 										SID_ATTR_CHAR_WIDTH_FIT_TO_LINE ) ))
//STRIP001 			m_aFitToLineCB.Hide();
//STRIP001 	}
//STRIP001 
//STRIP001 	m_aHighPosBtn.SaveValue();
//STRIP001 	m_aNormalPosBtn.SaveValue();
//STRIP001 	m_aLowPosBtn.SaveValue();
//STRIP001 	m_a0degRB.SaveValue();
//STRIP001 	m_a90degRB.SaveValue();
//STRIP001 	m_a270degRB.SaveValue();
//STRIP001 	m_aFitToLineCB.SaveValue();
//STRIP001 	m_aScaleWidthMF.SaveValue();
//STRIP001 	m_aKerningLB.SaveValue();
//STRIP001 	m_aKerningEdit.SaveValue();
//STRIP001 	m_aPairKerningBtn.SaveValue();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SvxCharPositionPage::FillItemSet( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	//	Position (hoch, normal oder tief)
//STRIP001 	const SfxItemSet& rOldSet = GetItemSet();
//STRIP001 	BOOL bModified = FALSE, bChanged = TRUE;
//STRIP001 	USHORT nWhich = GetWhich( SID_ATTR_CHAR_ESCAPEMENT );
//STRIP001 	const SfxPoolItem* pOld = GetOldItem( rSet, SID_ATTR_CHAR_ESCAPEMENT );
//STRIP001 	const FASTBOOL bHigh = m_aHighPosBtn.IsChecked();
//STRIP001 	short nEsc;
//STRIP001 	BYTE  nEscProp;
//STRIP001 
//STRIP001 	if ( bHigh || m_aLowPosBtn.IsChecked() )
//STRIP001 	{
//STRIP001 		if ( m_aHighLowRB.IsChecked() )
//STRIP001 			nEsc = bHigh ? DFLT_ESC_AUTO_SUPER : DFLT_ESC_AUTO_SUB;
//STRIP001 		else
//STRIP001 		{
//STRIP001 			nEsc = (short)m_aHighLowEdit.Denormalize( m_aHighLowEdit.GetValue() );
//STRIP001 			nEsc *= bHigh ? 1 : -1;
//STRIP001 		}
//STRIP001 		nEscProp = (BYTE)m_aFontSizeEdit.Denormalize( m_aFontSizeEdit.GetValue() );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		nEsc  = 0;
//STRIP001 		nEscProp = 100;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pOld )
//STRIP001 	{
//STRIP001 		const SvxEscapementItem& rItem = *( (const SvxEscapementItem*)pOld );
//STRIP001 		if ( rItem.GetEsc() == nEsc && rItem.GetProp() == nEscProp	)
//STRIP001 			bChanged = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( !bChanged && !m_aHighPosBtn.GetSavedValue() &&
//STRIP001 		 !m_aNormalPosBtn.GetSavedValue() && !m_aLowPosBtn.GetSavedValue() )
//STRIP001 		bChanged = TRUE;
//STRIP001 
//STRIP001 	if ( bChanged &&
//STRIP001 		 ( m_aHighPosBtn.IsChecked() || m_aNormalPosBtn.IsChecked() || m_aLowPosBtn.IsChecked() ) )
//STRIP001 	{
//STRIP001 		rSet.Put( SvxEscapementItem( nEsc, nEscProp, nWhich ) );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 	else if ( SFX_ITEM_DEFAULT == rOldSet.GetItemState( nWhich, FALSE ) )
//STRIP001 		CLEARTITEM;
//STRIP001 
//STRIP001 	bChanged = TRUE;
//STRIP001 
//STRIP001 	// Kerning
//STRIP001 	nWhich = GetWhich( SID_ATTR_CHAR_KERNING );
//STRIP001 	pOld = GetOldItem( rSet, SID_ATTR_CHAR_KERNING );
//STRIP001 	USHORT nPos = m_aKerningLB.GetSelectEntryPos();
//STRIP001 	short nKerning = 0;
//STRIP001 	SfxMapUnit eUnit = rSet.GetPool()->GetMetric( nWhich );
//STRIP001 
//STRIP001 	if ( nPos == LW_GESPERRT || nPos == LW_SCHMAL )
//STRIP001 	{
//STRIP001 		long nTmp = m_aKerningEdit.GetValue();
//STRIP001 		long nVal = LogicToLogic( nTmp, MAP_POINT, (MapUnit)eUnit );
//STRIP001 		nKerning = (short)m_aKerningEdit.Denormalize( nVal );
//STRIP001 
//STRIP001 		if ( nPos == LW_SCHMAL )
//STRIP001 			nKerning *= - 1;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pOld )
//STRIP001 	{
//STRIP001 		const SvxKerningItem& rItem = *( (const SvxKerningItem*)pOld );
//STRIP001 		if ( rItem.GetValue() == nKerning )
//STRIP001 			bChanged = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( !bChanged &&
//STRIP001 		 ( m_aKerningLB.GetSavedValue() == LISTBOX_ENTRY_NOTFOUND ||
//STRIP001 		   ( !m_aKerningEdit.GetSavedValue().Len() && m_aKerningEdit.IsEnabled() ) ) )
//STRIP001 		bChanged = TRUE;
//STRIP001 
//STRIP001 	if ( bChanged && nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		rSet.Put( SvxKerningItem( nKerning, nWhich ) );
//STRIP001 		bModified |= TRUE;
//STRIP001 	}
//STRIP001 	else if ( SFX_ITEM_DEFAULT == rOldSet.GetItemState( nWhich, FALSE ) )
//STRIP001 		CLEARTITEM;
//STRIP001 
//STRIP001 	bChanged = TRUE;
//STRIP001 
//STRIP001 	// Pair-Kerning
//STRIP001 	nWhich = GetWhich( SID_ATTR_CHAR_AUTOKERN );
//STRIP001 
//STRIP001 	if ( m_aPairKerningBtn.IsChecked() != m_aPairKerningBtn.GetSavedValue() )
//STRIP001 	{
//STRIP001 		rSet.Put( SvxAutoKernItem( m_aPairKerningBtn.IsChecked(), nWhich ) );
//STRIP001 		bModified |= TRUE;
//STRIP001 	}
//STRIP001 	else if ( SFX_ITEM_DEFAULT == rOldSet.GetItemState( nWhich, FALSE ) )
//STRIP001 		CLEARTITEM;
//STRIP001 
//STRIP001 	// Scale Width
//STRIP001 	nWhich = GetWhich( SID_ATTR_CHAR_SCALEWIDTH );
//STRIP001 	if ( m_aScaleWidthMF.GetText() != m_aScaleWidthMF.GetSavedValue() )
//STRIP001 	{
//STRIP001 		rSet.Put( SvxCharScaleWidthItem( (USHORT)m_aScaleWidthMF.GetValue(), nWhich ) );
//STRIP001 		bModified |= TRUE;
//STRIP001 	}
//STRIP001 	else if ( SFX_ITEM_DEFAULT == rOldSet.GetItemState( nWhich, FALSE ) )
//STRIP001 		CLEARTITEM;
//STRIP001 
//STRIP001 	// Rotation
//STRIP001 	nWhich = GetWhich( SID_ATTR_CHAR_ROTATED );
//STRIP001 	if ( m_a0degRB     .IsChecked() != m_a0degRB     .GetSavedValue()  ||
//STRIP001 		 m_a90degRB    .IsChecked() != m_a90degRB    .GetSavedValue()  ||
//STRIP001 		 m_a270degRB   .IsChecked() != m_a270degRB   .GetSavedValue()  ||
//STRIP001 		 m_aFitToLineCB.IsChecked() != m_aFitToLineCB.GetSavedValue() )
//STRIP001 	{
//STRIP001 		SvxCharRotateItem aItem( 0, m_aFitToLineCB.IsChecked(), nWhich );
//STRIP001 		sal_uInt16 nVal = 0;
//STRIP001 		if (m_a90degRB.IsChecked())
//STRIP001 			aItem.SetBottomToTop();
//STRIP001 		else if (m_a270degRB.IsChecked())
//STRIP001 			aItem.SetTopToBotton();
//STRIP001 		rSet.Put( aItem );
//STRIP001 		bModified |= TRUE;
//STRIP001 	}
//STRIP001 	else if ( SFX_ITEM_DEFAULT == rOldSet.GetItemState( nWhich, FALSE ) )
//STRIP001 		CLEARTITEM;
//STRIP001 
//STRIP001 	return bModified;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxCharPositionPage::FillUserData()
//STRIP001 {
//STRIP001 	const sal_Unicode cTok = ';';
//STRIP001 
//STRIP001 	String sUser( UniString::CreateFromInt32( m_nSuperEsc ) );
//STRIP001 	sUser.Append( cTok );
//STRIP001 	sUser.Append( UniString::CreateFromInt32( m_nSubEsc ) );
//STRIP001 	sUser.Append( cTok );
//STRIP001 	sUser.Append( UniString::CreateFromInt32( m_nSuperProp ) );
//STRIP001 	sUser.Append( cTok );
//STRIP001 	sUser.Append( UniString::CreateFromInt32( m_nSubProp ) );
//STRIP001 	SetUserData( sUser );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 void SvxCharPositionPage::SetPreviewBackgroundToCharacter()
//STRIP001 {
//STRIP001     m_bPreviewBackgroundToCharacter = TRUE;
//STRIP001 }
//STRIP001 // class SvxCharTwoLinesPage ------------------------------------------------
//STRIP001 
//STRIP001 SvxCharTwoLinesPage::SvxCharTwoLinesPage( Window* pParent, const SfxItemSet& rInSet ) :
//STRIP001 
//STRIP001 	SvxCharBasePage( pParent, SVX_RES( RID_SVXPAGE_CHAR_TWOLINES ), rInSet, WIN_TWOLINES_PREVIEW, FT_TWOLINES_FONTTYPE ),
//STRIP001 
//STRIP001 	m_aSwitchOnLine		( this, ResId( FL_SWITCHON ) ),
//STRIP001 	m_aTwoLinesBtn		( this, ResId( CB_TWOLINES ) ),
//STRIP001 
//STRIP001 	m_aEncloseLine		( this, ResId( FL_ENCLOSE ) ),
//STRIP001 	m_aStartBracketFT	( this, ResId( FT_STARTBRACKET ) ),
//STRIP001 	m_aStartBracketLB	( this, ResId( ED_STARTBRACKET ) ),
//STRIP001 	m_aEndBracketFT		( this, ResId( FT_ENDBRACKET ) ),
//STRIP001 	m_aEndBracketLB		( this, ResId( ED_ENDBRACKET ) )
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 	Initialize();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxCharTwoLinesPage::Initialize()
//STRIP001 {
//STRIP001 	Size aSize = m_aStartBracketLB.GetSizePixel();
//STRIP001     aSize.Height() = m_aStartBracketLB.CalcSize( 1, 6 ).Height();
//STRIP001 	m_aStartBracketLB.SetSizePixel( aSize );
//STRIP001 	aSize = m_aEndBracketLB.GetSizePixel();
//STRIP001     aSize.Height() = m_aEndBracketLB.CalcSize( 1, 6 ).Height();
//STRIP001 	m_aEndBracketLB.SetSizePixel( aSize );
//STRIP001 
//STRIP001 	m_aTwoLinesBtn.Check( FALSE );
//STRIP001 	TwoLinesHdl_Impl( NULL );
//STRIP001 
//STRIP001 	m_aTwoLinesBtn.SetClickHdl( LINK( this, SvxCharTwoLinesPage, TwoLinesHdl_Impl ) );
//STRIP001 
//STRIP001 	Link aLink = LINK( this, SvxCharTwoLinesPage, CharacterMapHdl_Impl );
//STRIP001 	m_aStartBracketLB.SetSelectHdl( aLink );
//STRIP001 	m_aEndBracketLB.SetSelectHdl( aLink );
//STRIP001 
//STRIP001 	SvxFont& rFont = GetPreviewFont();
//STRIP001     SvxFont& rCJKFont = GetPreviewCJKFont();
//STRIP001 	SvxFont& rCTLFont = GetPreviewCTLFont();
//STRIP001 	rFont.SetSize( Size( 0, 220 ) );
//STRIP001     rCJKFont.SetSize( Size( 0, 220 ) );
//STRIP001 	rCTLFont.SetSize( Size( 0, 220 ) );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxCharTwoLinesPage::SelectCharacter( ListBox* pBox )
//STRIP001 {
//STRIP001 	SvxCharacterMap aDlg( this );
//STRIP001 	aDlg.DisableFontSelection();
//STRIP001 
//STRIP001 	if ( aDlg.Execute() == RET_OK )
//STRIP001 	{
//STRIP001 		sal_Unicode cChar = aDlg.GetChar();
//STRIP001 		USHORT nPos = pBox->InsertEntry( String( cChar ) );
//STRIP001 		pBox->SelectEntryPos( nPos );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxCharTwoLinesPage::SetBracket( sal_Unicode cBracket, BOOL bStart )
//STRIP001 {
//STRIP001 	ListBox* pBox = bStart ? &m_aStartBracketLB : &m_aEndBracketLB;
//STRIP001 	if ( 0 == cBracket )
//STRIP001 		pBox->SelectEntryPos(0);
//STRIP001 	else
//STRIP001 	{
//STRIP001 		FASTBOOL bFound = FALSE;
//STRIP001 		for ( USHORT i = 1; i < pBox->GetEntryCount(); ++i )
//STRIP001 		{
//STRIP001 			if ( (ULONG)pBox->GetEntryData(i) != CHRDLG_ENCLOSE_SPECIAL_CHAR )
//STRIP001 			{
//STRIP001 				const sal_Unicode cChar = pBox->GetEntry(i).GetChar(0);
//STRIP001 				if ( cChar == cBracket )
//STRIP001 				{
//STRIP001 					pBox->SelectEntryPos(i);
//STRIP001 					bFound = TRUE;
//STRIP001 					break;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( !bFound )
//STRIP001 			pBox->SelectEntryPos( pBox->InsertEntry( String( cBracket ) ) );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxCharTwoLinesPage, TwoLinesHdl_Impl, CheckBox*, EMPTYARG )
//STRIP001 {
//STRIP001 	BOOL bChecked = m_aTwoLinesBtn.IsChecked();
//STRIP001 	m_aStartBracketFT.Enable( bChecked );
//STRIP001 	m_aStartBracketLB.Enable( bChecked );
//STRIP001 	m_aEndBracketFT.Enable( bChecked );
//STRIP001 	m_aEndBracketLB.Enable( bChecked );
//STRIP001 
//STRIP001 	UpdatePreview_Impl();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxCharTwoLinesPage, CharacterMapHdl_Impl, ListBox*, pBox )
//STRIP001 {
//STRIP001 	USHORT nPos = pBox->GetSelectEntryPos();
//STRIP001 	if ( CHRDLG_ENCLOSE_SPECIAL_CHAR == (ULONG)pBox->GetEntryData( nPos ) )
//STRIP001 		SelectCharacter( pBox );
//STRIP001 	UpdatePreview_Impl();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 int SvxCharTwoLinesPage::DeactivatePage( SfxItemSet* pSet )
//STRIP001 {
//STRIP001 	if ( pSet )
//STRIP001 		FillItemSet( *pSet );
//STRIP001 	return LEAVE_PAGE;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabPage* SvxCharTwoLinesPage::Create( Window* pParent, const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	return new SvxCharTwoLinesPage( pParent, rSet );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 USHORT* SvxCharTwoLinesPage::GetRanges()
//STRIP001 {
//STRIP001 	return pTwoLinesRanges;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxCharTwoLinesPage::Reset( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	m_aTwoLinesBtn.Check( FALSE );
//STRIP001 	USHORT nWhich = GetWhich( SID_ATTR_CHAR_TWO_LINES );
//STRIP001 	SfxItemState eState = rSet.GetItemState( nWhich );
//STRIP001 
//STRIP001 	if ( eState >= SFX_ITEM_DONTCARE )
//STRIP001 	{
//STRIP001 		const SvxTwoLinesItem& rItem = (SvxTwoLinesItem&)rSet.Get( nWhich );
//STRIP001 		m_aTwoLinesBtn.Check( rItem.GetValue() );
//STRIP001 
//STRIP001 		if ( rItem.GetValue() )
//STRIP001 		{
//STRIP001 			SetBracket( rItem.GetStartBracket(), TRUE );
//STRIP001 			SetBracket( rItem.GetEndBracket(), FALSE );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	TwoLinesHdl_Impl( NULL );
//STRIP001 
//STRIP001 	SetPrevFontWidthScale( rSet );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SvxCharTwoLinesPage::FillItemSet( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	const SfxItemSet& rOldSet = GetItemSet();
//STRIP001 	BOOL bModified = FALSE, bChanged = TRUE;
//STRIP001 	USHORT nWhich = GetWhich( SID_ATTR_CHAR_TWO_LINES );
//STRIP001 	const SfxPoolItem* pOld = GetOldItem( rSet, SID_ATTR_CHAR_TWO_LINES );
//STRIP001 	sal_Bool bOn = m_aTwoLinesBtn.IsChecked();
//STRIP001 	sal_Unicode cStart = ( bOn && m_aStartBracketLB.GetSelectEntryPos() > 0 )
//STRIP001 		? m_aStartBracketLB.GetSelectEntry().GetChar(0) : 0;
//STRIP001 	sal_Unicode cEnd = ( bOn && m_aEndBracketLB.GetSelectEntryPos() > 0 )
//STRIP001 		? m_aEndBracketLB.GetSelectEntry().GetChar(0) : 0;
//STRIP001 
//STRIP001 	if ( pOld )
//STRIP001 	{
//STRIP001 		const SvxTwoLinesItem& rItem = *( (const SvxTwoLinesItem*)pOld );
//STRIP001 		if ( rItem.GetValue() ==  bOn &&
//STRIP001 			 ( !bOn || ( rItem.GetStartBracket() == cStart && rItem.GetEndBracket() == cEnd ) ) )
//STRIP001 			bChanged = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bChanged )
//STRIP001 	{
//STRIP001 		rSet.Put( SvxTwoLinesItem( bOn, cStart, cEnd, nWhich ) );
//STRIP001 		bModified |= TRUE;
//STRIP001 	}
//STRIP001 	else if ( SFX_ITEM_DEFAULT == rOldSet.GetItemState( nWhich, FALSE ) )
//STRIP001 		CLEARTITEM;
//STRIP001 
//STRIP001 	return bModified;
//STRIP001 }
//STRIP001 /* -----------------------------04.12.00 09:48--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void	SvxCharTwoLinesPage::UpdatePreview_Impl()
//STRIP001 {
//STRIP001 	sal_Unicode cStart = m_aStartBracketLB.GetSelectEntryPos() > 0
//STRIP001 		? m_aStartBracketLB.GetSelectEntry().GetChar(0) : 0;
//STRIP001 	sal_Unicode cEnd = m_aEndBracketLB.GetSelectEntryPos() > 0
//STRIP001 		? m_aEndBracketLB.GetSelectEntry().GetChar(0) : 0;
//STRIP001 	m_aPreviewWin.SetBrackets(cStart, cEnd);
//STRIP001 	m_aPreviewWin.SetTwoLines(m_aTwoLinesBtn.IsChecked());
//STRIP001     m_aPreviewWin.Invalidate();
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 void SvxCharTwoLinesPage::SetPreviewBackgroundToCharacter()
//STRIP001 {
//STRIP001     m_bPreviewBackgroundToCharacter = TRUE;
//STRIP001 }

}
