/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_hangulhanja.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:45:46 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SVX_HANGUL_HANJA_CONVERSION_HXX
#include "hangulhanja.hxx"
#endif
#ifndef SVX_HANGUL_HANJA_DLG_HXX
#include "hangulhanjadlg.hxx"
#endif

#ifndef _SV_MSGBOX_HXX 
#include <vcl/msgbox.hxx>
#endif

#include <set>
#include <map>

#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_ 
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _COM_SUN_STAR_I18N_XBREAKITERATOR_HPP_
#include <com/sun/star/i18n/XBreakIterator.hpp>
#endif
#ifndef _COM_SUN_STAR_I18N_SCRIPTTYPE_HPP_
#include <com/sun/star/i18n/ScriptType.hpp>
#endif
#ifndef _COM_SUN_STAR_I18N_UNICODESCRIPT_HPP_
#include <com/sun/star/i18n/UnicodeScript.hpp>
#endif
#ifndef _COM_SUN_STAR_I18N_XTEXTCONVERSION_HPP_
#include <com/sun/star/i18n/XTextConversion.hpp>
#endif
#ifndef _COM_SUN_STAR_I18N_TEXTCONVERSIONTYPE_HPP_
#include <com/sun/star/i18n/TextConversionType.hpp>
#endif
#ifndef _COM_SUN_STAR_I18N_TEXTCONVERSIONOPTION_HPP_
#include <com/sun/star/i18n/TextConversionOption.hpp>
#endif
#ifndef _COM_SUN_STAR_I18N_WORDTYPE_HPP_
#include <com/sun/star/i18n/WordType.hpp>
#endif

#ifndef _VCL_STDTEXT_HXX 
#include <vcl/stdtext.hxx>
#endif
#ifndef _UNOTOOLS_CHARCLASS_HXX
#include <unotools/charclass.hxx>
#endif
namespace binfilter {

#define HHC HangulHanjaConversion

//.............................................................................
//STRIP001 namespace svx
//STRIP001 {
//STRIP001 //.............................................................................
//STRIP001 
//STRIP001 	using namespace ::com::sun::star::uno;
//STRIP001 	using namespace ::com::sun::star::i18n;
//STRIP001     using namespace ::com::sun::star::i18n::TextConversionOption;
//STRIP001     using namespace ::com::sun::star::i18n::TextConversionType;
//STRIP001 	using namespace ::com::sun::star::lang;
//STRIP001 /*
//STRIP001 	using HangulHanjaConversion::ReplacementAction;
//STRIP001 	using HangulHanjaConversion::eExchange;
//STRIP001 	using HangulHanjaConversion::eReplacementBracketed;
//STRIP001 	using HangulHanjaConversion::eOriginalBracketed;
//STRIP001 	using HangulHanjaConversion::eReplacementAbove;
//STRIP001 	using HangulHanjaConversion::eOriginalAbove;
//STRIP001 	using HangulHanjaConversion::eReplacementBelow;
//STRIP001 	using HangulHanjaConversion::eOriginalBelow;
//STRIP001 
//STRIP001 	using HangulHanjaConversion::eHangulToHanja;
//STRIP001 	using HangulHanjaConversion::eHanjaToHangul;
//STRIP001 
//STRIP001 	using HangulHanjaConversion::eSimpleConversion;
//STRIP001 	using HangulHanjaConversion::eHangulBracketed;
//STRIP001 	using HangulHanjaConversion::eHanjaBracketed;
//STRIP001 	using HangulHanjaConversion::eRubyHanjaAbove;
//STRIP001 	using HangulHanjaConversion::eRubyHanjaBelow;
//STRIP001 	using HangulHanjaConversion::eRubyHangulAbove;
//STRIP001 	using HangulHanjaConversion::eRubyHangulBelow;
//STRIP001 
//STRIP001 	using ::com::sun::star::i18n::TextConversionType::TO_HANJA;
//STRIP001 	using ::com::sun::star::i18n::TextConversionType::TO_HANGUL;
//STRIP001 	using ::com::sun::star::i18n::TextConversionOption::CHARACTER_BY_CHARACTER;
//STRIP001 	using ::com::sun::star::i18n::TextConversionOption::NONE;
//STRIP001 */
//STRIP001 	//=========================================================================
//STRIP001 	//= HangulHanjaConversion_Impl
//STRIP001 	//=========================================================================
//STRIP001     //using HangulHanjaConversion::ConversionFormat;
//STRIP001 
//STRIP001 	class HangulHanjaConversion_Impl
//STRIP001 	{
//STRIP001 	private:
//STRIP001 		typedef	::std::set< ::rtl::OUString, ::std::less< ::rtl::OUString > >					StringBag;
//STRIP001 		typedef ::std::map< ::rtl::OUString, ::rtl::OUString, ::std::less< ::rtl::OUString > >	StringMap;
//STRIP001 
//STRIP001 	private:
//STRIP001 		static	StringBag						m_sIgnoreList;
//STRIP001 				StringMap						m_aChangeList;
//STRIP001 
//STRIP001 		// general
//STRIP001 		HangulHanjaConversionDialog*
//STRIP001 								m_pConversionDialog;	// the dialog to display for user interaction
//STRIP001 		Window*					m_pUIParent;			// the parent window for any UI we raise
//STRIP001 		Reference< XMultiServiceFactory >
//STRIP001 								m_xORB;					// the service factory to use
//STRIP001 		Reference< XTextConversion >
//STRIP001 								m_xConverter;			// the text conversion service
//STRIP001 		Locale					m_aLocale;				// the locale we're working with
//STRIP001 
//STRIP001 		HangulHanjaConversion*	m_pAntiImpl;			// our "anti-impl" instance
//STRIP001 
//STRIP001 		// options
//STRIP001 		sal_Bool				m_bByCharacter;					// are we in "by character" mode currently?
//STRIP001         HHC::ConversionFormat       m_eConversionFormat;            // the current format for the conversion
//STRIP001         HHC::ConversionDirection        m_ePrimaryConversionDirection;  // the primary conversion direction
//STRIP001         HHC::ConversionDirection        m_eCurrentConversionDirection;  // the primary conversion direction
//STRIP001 
//STRIP001 		// state
//STRIP001 		::rtl::OUString			m_sCurrentPortion;		// the text which we are currently working on
//STRIP001 		sal_Int32				m_nCurrentStartIndex;	// the start index within m_sCurrentPortion of the current convertible portion
//STRIP001 		sal_Int32				m_nCurrentEndIndex;		// the end index (excluding) within m_sCurrentPortion of the current convertible portion
//STRIP001 		sal_Int32				m_nReplacementBaseIndex;// index which ReplaceUnit-calls need to be relative to
//STRIP001 		Sequence< ::rtl::OUString >
//STRIP001 								m_aCurrentSuggestions;	// the suggestions for the current unit
//STRIP001 														// (means for the text [m_nCurrentStartIndex, m_nCurrentEndIndex) in m_sCurrentPortion)
//STRIP001 
//STRIP001 #ifdef FS_HANGUL_HANJA
//STRIP001 	public:
//STRIP001 		::rtl::OUString			m_sRememberPos;
//STRIP001 #endif
//STRIP001 
//STRIP001 	public:
//STRIP001 		HangulHanjaConversion_Impl(
//STRIP001 			Window* _pUIParent,
//STRIP001 			const Reference< XMultiServiceFactory >& _rxORB,
//STRIP001 			const Locale& _rLocale,
//STRIP001 			HangulHanjaConversion* _pAntiImpl );
//STRIP001 
//STRIP001 	public:
//STRIP001 				void		DoDocumentConversion( );
//STRIP001 
//STRIP001 		inline	sal_Bool	IsByCharacter( ) const { return m_bByCharacter; }
//STRIP001 
//STRIP001 		inline	sal_Bool	IsValid() const { return m_xConverter.is(); }
//STRIP001 
//STRIP001 	protected:
//STRIP001 		void	createDialog();
//STRIP001 
//STRIP001 		/** continue with the conversion, return <TRUE/> if and only if the complete conversion is done
//STRIP001 			@param _bRepeatCurrentUnit
//STRIP001 				if <TRUE/>, an implNextConvertible will be called initially to advance to the next convertible.
//STRIP001 				if <FALSE/>, the method will initially work with the current convertible unit
//STRIP001 		*/
//STRIP001 		sal_Bool ContinueConversion( bool _bRepeatCurrentUnit );
//STRIP001 
//STRIP001 	private:
//STRIP001 		DECL_LINK( OnIgnore, void* );
//STRIP001 		DECL_LINK( OnIgnoreAll, void* );
//STRIP001 		DECL_LINK( OnChange, void* );
//STRIP001 		DECL_LINK( OnChangeAll, void* );
//STRIP001 		DECL_LINK( OnByCharClicked, CheckBox* );
//STRIP001 		DECL_LINK( OnConversionTypeChanged, void* );
//STRIP001 		DECL_LINK( OnFind, void* );
//STRIP001 
//STRIP001 		/** proceed, after the current convertible has been handled
//STRIP001 
//STRIP001 			<p><b>Attention:</b>
//STRIP001 				When returning from this method, the dialog may have been deleted!</p>
//STRIP001 
//STRIP001 			@param _bRepeatCurrentUnit
//STRIP001 				will be passed to the <member>ContinueConversion</member> call
//STRIP001 		*/
//STRIP001 		void	implProceed( bool _bRepeatCurrentUnit );
//STRIP001 
//STRIP001 		// change the current convertible, and do _not_ proceed
//STRIP001 		void	implChange( const ::rtl::OUString& _rChangeInto );
//STRIP001 
//STRIP001 		/** find the next convertible piece of text, with possibly advancing to the next portion
//STRIP001 
//STRIP001 			@see HangulHanjaConversion::GetNextPortion
//STRIP001 		*/
//STRIP001 		sal_Bool	implNextConvertible( bool _bRepeatUnit );
//STRIP001 
//STRIP001 		/** find the next convertible unit within the current portion
//STRIP001 			@param _bRepeatUnit
//STRIP001 				if <TRUE/>, the search will start at the beginning of the current unit,
//STRIP001 				if <FALSE/>, it will start at the end of the current unit
//STRIP001 		*/
//STRIP001 		bool		implNextConvertibleUnit( const sal_Int32 _nStartAt );
//STRIP001 
//STRIP001 		/** retrieves the next portion, with setting the index members properly
//STRIP001 			@return
//STRIP001 				<TRUE/> if and only if there is a next portion
//STRIP001 		*/
//STRIP001 		bool		implRetrieveNextPortion( );
//STRIP001 
//STRIP001 		/** fill in m_ePrimaryConversionDirection from m_sCurrentPortion
//STRIP001 			@return
//STRIP001 				<FALSE/> if and only if something went wrong
//STRIP001 		*/
//STRIP001 		bool		implDeterminePrimaryDirection( );
//STRIP001 	};
//STRIP001 
//STRIP001 	//=========================================================================
//STRIP001 	//= HangulHanjaConversion_Impl
//STRIP001 	//=========================================================================
//STRIP001 	HangulHanjaConversion_Impl::StringBag HangulHanjaConversion_Impl::m_sIgnoreList;
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	HangulHanjaConversion_Impl::HangulHanjaConversion_Impl( Window* _pUIParent,
//STRIP001 		const Reference< XMultiServiceFactory >& _rxORB, const Locale& _rLocale, HangulHanjaConversion* _pAntiImpl )
//STRIP001 		:m_pUIParent( _pUIParent )
//STRIP001 		,m_pAntiImpl( _pAntiImpl )
//STRIP001 		,m_bByCharacter( sal_False )
//STRIP001 		,m_pConversionDialog( NULL )
//STRIP001         ,m_eConversionFormat( HHC::eSimpleConversion )
//STRIP001         ,m_ePrimaryConversionDirection( HHC::eHangulToHanja )
//STRIP001         ,m_eCurrentConversionDirection( HHC::eHangulToHanja )
//STRIP001 		,m_nCurrentStartIndex( 0 )
//STRIP001 		,m_nCurrentEndIndex( 0 )
//STRIP001 		,m_nReplacementBaseIndex( 0 )
//STRIP001 		,m_xORB( _rxORB )
//STRIP001 		,m_aLocale( _rLocale )
//STRIP001 	{
//STRIP001 		DBG_ASSERT( m_xORB.is(), "HangulHanjaConversion_Impl::HangulHanjaConversion_Impl: no ORB!" );
//STRIP001 		// TODO: initialize m_bByCharacter and m_eConversionFormat from the configuration?
//STRIP001 
//STRIP001 		if ( m_xORB.is() )
//STRIP001 		{
//STRIP001 			::rtl::OUString sTextConversionService( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.i18n.TextConversion" ) );
//STRIP001 			m_xConverter = m_xConverter.query( m_xORB->createInstance( sTextConversionService ) );
//STRIP001 			if ( !m_xConverter.is() )
//STRIP001 				ShowServiceNotAvailableError( m_pUIParent, sTextConversionService, sal_True );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	void HangulHanjaConversion_Impl::createDialog()
//STRIP001 	{
//STRIP001 		if ( !m_pConversionDialog )
//STRIP001 		{
//STRIP001 			m_pConversionDialog = new HangulHanjaConversionDialog( m_pUIParent, m_ePrimaryConversionDirection );
//STRIP001 
//STRIP001 			m_pConversionDialog->SetByCharacter( m_bByCharacter );
//STRIP001 			m_pConversionDialog->SetConversionFormat( m_eConversionFormat );
//STRIP001 
//STRIP001 			// the handlers
//STRIP001 			m_pConversionDialog->SetIgnoreHdl( LINK( this, HangulHanjaConversion_Impl, OnIgnore ) );
//STRIP001 			m_pConversionDialog->SetIgnoreAllHdl( LINK( this, HangulHanjaConversion_Impl, OnIgnoreAll ) );
//STRIP001 			m_pConversionDialog->SetChangeHdl( LINK( this, HangulHanjaConversion_Impl, OnChange ) );
//STRIP001 			m_pConversionDialog->SetChangeAllHdl( LINK( this, HangulHanjaConversion_Impl, OnChangeAll ) );
//STRIP001 			m_pConversionDialog->SetClickByCharacterHdl( LINK( this, HangulHanjaConversion_Impl, OnByCharClicked ) );
//STRIP001 			m_pConversionDialog->SetConversionFormatChangedHdl( LINK( this, HangulHanjaConversion_Impl, OnConversionTypeChanged ) );
//STRIP001 			m_pConversionDialog->SetFindHdl( LINK( this, HangulHanjaConversion_Impl, OnFind ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 #ifdef FS_HANGUL_HANJA
//STRIP001 	static bool lcl_isConvertible( const sal_Unicode _c )
//STRIP001 	{
//STRIP001 		return (	(	( _c >= 'a' )
//STRIP001 					&&	( _c <= 'z' )
//STRIP001 					)
//STRIP001 				||	(	( _c >= 'A' )
//STRIP001 					&&	( _c <= 'Z' )
//STRIP001 					)
//STRIP001 				);
//STRIP001 	}
//STRIP001 #endif
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	bool HangulHanjaConversion_Impl::implNextConvertibleUnit( const sal_Int32 _nStartAt )
//STRIP001 	{
//STRIP001 		m_aCurrentSuggestions.realloc( 0 );
//STRIP001 
//STRIP001 #ifdef FS_HANGUL_HANJA
//STRIP001 		// until we have a text conversion service, do some dummy implementations here
//STRIP001 		// use the break iterator to iterate over all words
//STRIP001 		::rtl::OUString sBreakIteratorService( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.i18n.BreakIterator" ) );
//STRIP001 		Reference< XBreakIterator > xBreakIter( m_xORB->createInstance( ::rtl::OUString( sBreakIteratorService ) ), UNO_QUERY );
//STRIP001 
//STRIP001 		sal_Int32 nStartAt( _nStartAt );
//STRIP001 		Boundary aWordBoundary = xBreakIter->getWordBoundary( m_sCurrentPortion, nStartAt, m_aLocale, WordType::ANYWORD_IGNOREWHITESPACES, sal_True );
//STRIP001 		if ( m_sCurrentPortion.getStr()[ aWordBoundary.startPos ] == ' ' )
//STRIP001 		{	// HACK
//STRIP001 			aWordBoundary = xBreakIter->nextWord( m_sCurrentPortion, aWordBoundary.startPos, m_aLocale, WordType::ANYWORD_IGNOREWHITESPACES );
//STRIP001 			nStartAt = aWordBoundary.startPos;
//STRIP001 		}
//STRIP001 		if ( IsByCharacter() )
//STRIP001 		{
//STRIP001 			if ( nStartAt < aWordBoundary.endPos )
//STRIP001 				aWordBoundary.startPos = nStartAt;
//STRIP001 			else
//STRIP001 				aWordBoundary = xBreakIter->nextWord( m_sCurrentPortion, aWordBoundary.endPos, m_aLocale, WordType::ANYWORD_IGNOREWHITESPACES );
//STRIP001 
//STRIP001 			aWordBoundary.endPos = aWordBoundary.startPos + 1;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			while	(	( aWordBoundary.startPos == aWordBoundary.endPos )			// empty word
//STRIP001 					&&	( aWordBoundary.endPos < m_sCurrentPortion.getLength() )	// still characters left
//STRIP001 					)
//STRIP001 				aWordBoundary = xBreakIter->nextWord( m_sCurrentPortion, aWordBoundary.endPos, m_aLocale, WordType::ANYWORD_IGNOREWHITESPACES );
//STRIP001 		}
//STRIP001 		m_nCurrentStartIndex = aWordBoundary.startPos;
//STRIP001 		m_nCurrentEndIndex = aWordBoundary.endPos;
//STRIP001 
//STRIP001 		// for testing reasons, we add all rotations of the original word as suggestions
//STRIP001 		m_aCurrentSuggestions.realloc( 0 );
//STRIP001 		if ( m_nCurrentStartIndex < m_sCurrentPortion.getLength() )
//STRIP001 		{
//STRIP001 			::rtl::OUString sCurrentUnit = m_sCurrentPortion.copy( m_nCurrentStartIndex, m_nCurrentEndIndex - m_nCurrentStartIndex );
//STRIP001 			m_aCurrentSuggestions.realloc( sCurrentUnit.getLength() );
//STRIP001 			::rtl::OUString* pSuggestion = m_aCurrentSuggestions.getArray();
//STRIP001 			String sSuggestion( sCurrentUnit );
//STRIP001 			for ( sal_Int32 i = 0; i < sCurrentUnit.getLength(); ++i, ++pSuggestion )
//STRIP001 			{
//STRIP001 				*pSuggestion = sSuggestion = sSuggestion.Copy( 1 ).Append( sSuggestion.GetBuffer()[0] );
//STRIP001 			}
//STRIP001 		}
//STRIP001 #else
//STRIP001 		// ask the TextConversion service for the next convertible piece of text
//STRIP001 		sal_Int32 nStartLookupAt = _nStartAt;
//STRIP001 
//STRIP001 		// parameters for the converter
//STRIP001         sal_Int32 nLength = m_sCurrentPortion.getLength() - _nStartAt;
//STRIP001 
//STRIP001         sal_Int16 nConversionType = HHC::eHangulToHanja == m_ePrimaryConversionDirection ? TO_HANJA : TO_HANGUL;
//STRIP001 		sal_Int32 nConversionOption = IsByCharacter() ? CHARACTER_BY_CHARACTER : NONE;
//STRIP001 
//STRIP001 		sal_Bool bTryBothDirections = m_pConversionDialog ? m_pConversionDialog->GetUseBothDirections() : sal_True;
//STRIP001 
//STRIP001 		// until we know better, assume that this very conversion attempt will end up with
//STRIP001 		// the conversion direction which is our primary direction
//STRIP001 		m_eCurrentConversionDirection = m_ePrimaryConversionDirection;
//STRIP001 
//STRIP001         sal_Bool bFoundAny = sal_True;
//STRIP001 		try
//STRIP001 		{
//STRIP001 			TextConversionResult aResult = m_xConverter->getConversions(
//STRIP001 				m_sCurrentPortion,
//STRIP001 				_nStartAt,
//STRIP001 				nLength,
//STRIP001 				m_aLocale,
//STRIP001 				nConversionType,
//STRIP001 				nConversionOption
//STRIP001 			);
//STRIP001             sal_Bool bFoundPrimary = aResult.Boundary.startPos < aResult.Boundary.endPos;
//STRIP001 			bFoundAny = bFoundPrimary;
//STRIP001 
//STRIP001 			if ( bTryBothDirections )
//STRIP001 			{	// see if we find another convertible when assuming the other direction
//STRIP001 				TextConversionResult aSecondResult = m_xConverter->getConversions(
//STRIP001 					m_sCurrentPortion,
//STRIP001 					_nStartAt,
//STRIP001 					nLength,
//STRIP001 					m_aLocale,
//STRIP001                     HHC::eHangulToHanja == m_ePrimaryConversionDirection ? TO_HANGUL : TO_HANJA,    // switched!
//STRIP001 					nConversionOption
//STRIP001 				);
//STRIP001 				if ( aSecondResult.Boundary.startPos < aSecondResult.Boundary.endPos )
//STRIP001 				{	// we indeed found such a convertible
//STRIP001 
//STRIP001 					// in case the first attempt (with the original conversion direction)
//STRIP001 					// didn't find anything
//STRIP001 					if	(	!bFoundPrimary
//STRIP001 						// or if the second location is _before_ the first one
//STRIP001 						||	( aSecondResult.Boundary.startPos < aResult.Boundary.startPos )
//STRIP001 						)
//STRIP001 					{
//STRIP001 						// then use the second finding
//STRIP001 						aResult = aSecondResult;
//STRIP001 
//STRIP001 						// our current conversion direction changed now
//STRIP001                         m_eCurrentConversionDirection = ( HHC::eHangulToHanja == m_ePrimaryConversionDirection )
//STRIP001                             ? HHC::eHanjaToHangul : HHC::eHangulToHanja;
//STRIP001 						bFoundAny = sal_True;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			m_aCurrentSuggestions = aResult.Candidates;
//STRIP001 			m_nCurrentStartIndex = aResult.Boundary.startPos;
//STRIP001 			m_nCurrentEndIndex = aResult.Boundary.endPos;
//STRIP001 		}
//STRIP001 		catch( const Exception& e )
//STRIP001 		{
//STRIP001 			e;	// make compiler happy
//STRIP001 			DBG_ERROR( "HangulHanjaConversion_Impl::implNextConvertibleUnit: caught an exception!" );
//STRIP001 		}
//STRIP001 #endif
//STRIP001 
//STRIP001         return  bFoundAny && 
//STRIP001                 (m_nCurrentStartIndex < m_sCurrentPortion.getLength());
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	bool HangulHanjaConversion_Impl::implRetrieveNextPortion( )
//STRIP001 	{
//STRIP001 		m_sCurrentPortion = ::rtl::OUString();
//STRIP001 		m_pAntiImpl->GetNextPortion( m_sCurrentPortion );
//STRIP001 		m_nReplacementBaseIndex = 0;
//STRIP001 		m_nCurrentStartIndex = m_nCurrentEndIndex = 0;
//STRIP001 
//STRIP001 		return 0 != m_sCurrentPortion.getLength();
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	sal_Bool HangulHanjaConversion_Impl::implNextConvertible( bool _bRepeatUnit )
//STRIP001 	{
//STRIP001 		if ( _bRepeatUnit || ( m_nCurrentEndIndex < m_sCurrentPortion.getLength() ) )
//STRIP001 		{
//STRIP001 			if ( implNextConvertibleUnit(
//STRIP001 						_bRepeatUnit
//STRIP001 					?	( IsByCharacter() ? m_nCurrentStartIndex : m_nCurrentStartIndex )
//STRIP001 					:	m_nCurrentEndIndex
//STRIP001 				) )
//STRIP001 				return sal_True;
//STRIP001 		}
//STRIP001 
//STRIP001 		// no convertible text in the current portion anymore
//STRIP001 		// -> advance to the next portion
//STRIP001 		do
//STRIP001 		{
//STRIP001 			// next portion
//STRIP001 			if ( implRetrieveNextPortion( ) )
//STRIP001 			{	// there is a next portion
//STRIP001 				// -> find the next convertible unit in the current portion
//STRIP001 				if ( implNextConvertibleUnit( 0 ) )
//STRIP001 					return sal_True;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		while ( m_sCurrentPortion.getLength() );
//STRIP001 
//STRIP001 		// no more portions
//STRIP001 		return sal_False;
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	sal_Bool HangulHanjaConversion_Impl::ContinueConversion( bool _bRepeatCurrentUnit )
//STRIP001 	{
//STRIP001 		sal_Bool bNeedUserInteraction = sal_False;	// when we leave here, do we need user interaction?
//STRIP001 		sal_Bool bDocumentDone = sal_False;			// did we already check the whole document?
//STRIP001 
//STRIP001 		while ( !bDocumentDone && !bNeedUserInteraction && implNextConvertible( _bRepeatCurrentUnit ) )
//STRIP001 		{
//STRIP001 			DBG_ASSERT( m_nCurrentStartIndex < m_sCurrentPortion.getLength(),
//STRIP001 				"HangulHanjaConversion_Impl::ContinueConversion: invalid index into current portion!" );
//STRIP001 			DBG_ASSERT( m_nCurrentStartIndex <= m_nCurrentEndIndex,
//STRIP001 				"HangulHanjaConversion_Impl::ContinueConversion: invalid interval!" );
//STRIP001 
//STRIP001 			::rtl::OUString sCurrentUnit = m_sCurrentPortion.copy( m_nCurrentStartIndex, m_nCurrentEndIndex - m_nCurrentStartIndex );
//STRIP001 
//STRIP001 			// do we need to ignore it?
//STRIP001 			sal_Bool bAlwaysIgnoreThis = m_sIgnoreList.end() != m_sIgnoreList.find( sCurrentUnit );
//STRIP001 
//STRIP001 			// do we need to change it?
//STRIP001 			StringMap::const_iterator aChangeListPos = m_aChangeList.find( sCurrentUnit );
//STRIP001 			sal_Bool bAlwaysChangeThis = m_aChangeList.end() != aChangeListPos;
//STRIP001 
//STRIP001 			if ( bAlwaysChangeThis )
//STRIP001 			{
//STRIP001 				implChange( aChangeListPos->second );
//STRIP001 			}
//STRIP001 			else if ( !bAlwaysIgnoreThis )
//STRIP001 			{
//STRIP001 				// here we need to ask the user for what to do with the text
//STRIP001 				// for this, allow derivees to highlight the current text unit in a possible document view
//STRIP001 				m_pAntiImpl->HandleNewUnit( m_nCurrentStartIndex - m_nReplacementBaseIndex, m_nCurrentEndIndex - m_nReplacementBaseIndex );
//STRIP001 
//STRIP001 				if ( !m_pConversionDialog )
//STRIP001 				{
//STRIP001 					// the dialog does not yet exists (it's our first encounter)
//STRIP001 					createDialog();
//STRIP001 					// initially fill the dialog
//STRIP001 					m_pConversionDialog->SetCurrentString( sCurrentUnit, m_aCurrentSuggestions );
//STRIP001 					// execute it. It will automatically advance
//STRIP001 					m_pConversionDialog->Execute();
//STRIP001 					// we're done
//STRIP001 					DELETEZ( m_pConversionDialog );
//STRIP001 
//STRIP001 					bDocumentDone = sal_True;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					m_pConversionDialog->SetCurrentString( sCurrentUnit, m_aCurrentSuggestions );
//STRIP001 
//STRIP001 					// do not look for the next convertible: We have to wait for the user to interactivly
//STRIP001 					// decide what happens with the current convertible
//STRIP001 					bNeedUserInteraction = sal_True;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		/*
//STRIP001 		if ( bDocumentDone )
//STRIP001 			return sal_True;			// we explicitly know that the complete document is done
//STRIP001 		else if ( bNeedUserInteraction )
//STRIP001 			return sal_False;			// the doc is not done, we found a convertible, but need the user to decide
//STRIP001 		else
//STRIP001 			return sal_True;			// we did not find a next convertible, so the document is implicitly done
//STRIP001 		*/
//STRIP001 
//STRIP001 		return	bDocumentDone || !bNeedUserInteraction;
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	bool HangulHanjaConversion_Impl::implDeterminePrimaryDirection( )
//STRIP001 	{
//STRIP001         m_ePrimaryConversionDirection = HHC::eHangulToHanja;    // default
//STRIP001 
//STRIP001 		bool bSuccess = false;
//STRIP001 		try
//STRIP001 		{
//STRIP001 			// get the break iterator service
//STRIP001 			::rtl::OUString sBreakIteratorService( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.i18n.BreakIterator" ) );
//STRIP001 			Reference< XInterface > xBI( m_xORB->createInstance( ::rtl::OUString( sBreakIteratorService ) ) );
//STRIP001 			Reference< XBreakIterator > xBreakIter( xBI, UNO_QUERY );
//STRIP001 			if ( !xBreakIter.is() )
//STRIP001 			{
//STRIP001 				ShowServiceNotAvailableError( m_pUIParent, sBreakIteratorService, sal_True );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				sal_Int32 nNextAsianScript = xBreakIter->beginOfScript( m_sCurrentPortion, m_nCurrentStartIndex, ScriptType::ASIAN );
//STRIP001 				if ( -1 == nNextAsianScript )
//STRIP001 					nNextAsianScript = xBreakIter->nextScript( m_sCurrentPortion, m_nCurrentStartIndex, ScriptType::ASIAN );
//STRIP001 				if ( ( nNextAsianScript >= m_nCurrentStartIndex ) && ( nNextAsianScript < m_sCurrentPortion.getLength() ) )
//STRIP001 				{	// found asian text
//STRIP001 
//STRIP001 					// determine if it's Hangul
//STRIP001 					CharClass aCharClassificaton( m_xORB, m_aLocale );
//STRIP001 					sal_Int16 nScript = aCharClassificaton.getScript( m_sCurrentPortion, nNextAsianScript );
//STRIP001 					if	(	( UnicodeScript_kHangulJamo == nScript )
//STRIP001 						||	( UnicodeScript_kHangulCompatibilityJamo == nScript )
//STRIP001 						||	( UnicodeScript_kHangulSyllable == nScript )
//STRIP001 						)
//STRIP001 					{
//STRIP001                         m_ePrimaryConversionDirection = HHC::eHangulToHanja;
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001                         m_ePrimaryConversionDirection = HHC::eHanjaToHangul;
//STRIP001 					}
//STRIP001 
//STRIP001 					bSuccess = true;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		catch( const Exception& e )
//STRIP001 		{
//STRIP001 			e;	// make compiler happy
//STRIP001 			DBG_ERROR( "HangulHanjaConversion_Impl::implDeterminePrimaryDirection: caught an exception!" );
//STRIP001 		}
//STRIP001 		return bSuccess;
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	void HangulHanjaConversion_Impl::DoDocumentConversion( )
//STRIP001 	{
//STRIP001 		// clear the change-all list - it's to be re-initialized for every single document
//STRIP001         {
//STRIP001             StringMap aEmpty;
//STRIP001             m_aChangeList.swap( aEmpty );
//STRIP001         }
//STRIP001 
//STRIP001 		// first of all, we need to guess the direction of our conversion - it is determined by the first
//STRIP001 		// hangul or hanja character in the first text
//STRIP001 		if ( !implRetrieveNextPortion( ) )
//STRIP001 		{
//STRIP001 			DBG_ERROR( "HangulHanjaConversion_Impl::DoDocumentConversion: why did you call me if you do have nothing to convert?" );
//STRIP001 			// nothing to do
//STRIP001 			return;
//STRIP001 		}
//STRIP001 		if ( !implDeterminePrimaryDirection( ) )
//STRIP001 			// something went wrong, has already been asserted
//STRIP001 			return;
//STRIP001 
//STRIP001 #ifdef DBG_UTIL
//STRIP001 		sal_Bool bCompletelyDone =
//STRIP001 #endif
//STRIP001 		ContinueConversion( sal_False );
//STRIP001 		DBG_ASSERT( bCompletelyDone, "HangulHanjaConversion_Impl::DoDocumentConversion: ContinueConversion should have returned true here!" );
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	void HangulHanjaConversion_Impl::implProceed( bool _bRepeatCurrentUnit )
//STRIP001 	{
//STRIP001 		if ( ContinueConversion( _bRepeatCurrentUnit ) )
//STRIP001 		{	// we're done with the whole document
//STRIP001 			DBG_ASSERT( m_pConversionDialog, "HangulHanjaConversion_Impl::implProceed: we should not reach this here without dialog!" );
//STRIP001 			if ( m_pConversionDialog )
//STRIP001 				m_pConversionDialog->EndDialog( RET_OK );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	void HangulHanjaConversion_Impl::implChange( const ::rtl::OUString& _rChangeInto )
//STRIP001 	{
//STRIP001 		// translate the conversion format into a replacement action
//STRIP001 		// this translation depends on whether we have a Hangul original, or a Hanja original
//STRIP001 
//STRIP001 		// is the original we're about to change in Hangul?
//STRIP001         sal_Bool bOriginalIsHangul = HHC::eHangulToHanja == m_eCurrentConversionDirection;
//STRIP001 
//STRIP001         HHC::ReplacementAction eAction( HHC::eExchange );
//STRIP001 		switch ( m_eConversionFormat )
//STRIP001 		{
//STRIP001             case HHC::eSimpleConversion: eAction = HHC::eExchange; break;
//STRIP001             case HHC::eHangulBracketed:  eAction = bOriginalIsHangul ? HHC::eOriginalBracketed : HHC::eReplacementBracketed; break;
//STRIP001             case HHC::eHanjaBracketed:   eAction = bOriginalIsHangul ? HHC::eReplacementBracketed : HHC::eOriginalBracketed; break;
//STRIP001             case HHC::eRubyHanjaAbove:   eAction = bOriginalIsHangul ? HHC::eReplacementAbove : HHC::eOriginalAbove; break;
//STRIP001             case HHC::eRubyHanjaBelow:   eAction = bOriginalIsHangul ? HHC::eReplacementBelow : HHC::eOriginalBelow; break;
//STRIP001             case HHC::eRubyHangulAbove:  eAction = bOriginalIsHangul ? HHC::eOriginalAbove : HHC::eReplacementAbove; break;
//STRIP001             case HHC::eRubyHangulBelow:  eAction = bOriginalIsHangul ? HHC::eOriginalBelow : HHC::eReplacementBelow; break;
//STRIP001 			default:
//STRIP001 				DBG_ERROR( "HangulHanjaConversion_Impl::implChange: invalid/unexpected conversion format!" );
//STRIP001 		}
//STRIP001 
//STRIP001 		// the proper indicies (the wrapper implementation needs indicies relative to the
//STRIP001 		// previous replacement)
//STRIP001 		DBG_ASSERT( ( m_nReplacementBaseIndex <= m_nCurrentStartIndex ) && ( m_nReplacementBaseIndex <= m_nCurrentEndIndex ),
//STRIP001 			"HangulHanjaConversion_Impl::implChange: invalid replacement base!" );
//STRIP001 
//STRIP001 		sal_Int32 nStartIndex = m_nCurrentStartIndex - m_nReplacementBaseIndex;
//STRIP001 		sal_Int32 nEndIndex = m_nCurrentEndIndex - m_nReplacementBaseIndex;
//STRIP001 
//STRIP001 		// do the replacement
//STRIP001 		m_pAntiImpl->ReplaceUnit( nStartIndex, nEndIndex, _rChangeInto, eAction );
//STRIP001 
//STRIP001 		// adjust the replacement base
//STRIP001 		m_nReplacementBaseIndex = m_nCurrentEndIndex;
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	IMPL_LINK( HangulHanjaConversion_Impl, OnIgnore, void*, NOTINTERESTEDIN )
//STRIP001 	{
//STRIP001 		// simply ignore, and proceed
//STRIP001 		implProceed( sal_False );
//STRIP001 		return 0L;
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	IMPL_LINK( HangulHanjaConversion_Impl, OnIgnoreAll, void*, NOTINTERESTEDIN )
//STRIP001 	{
//STRIP001 		DBG_ASSERT( m_pConversionDialog, "HangulHanjaConversion_Impl::OnIgnoreAll: no dialog! How this?" );
//STRIP001 
//STRIP001 		if ( m_pConversionDialog )
//STRIP001 		{
//STRIP001 			String sCurrentUnit = m_pConversionDialog->GetCurrentString();
//STRIP001 			DBG_ASSERT( m_sIgnoreList.end() == m_sIgnoreList.find( sCurrentUnit ),
//STRIP001 				"HangulHanjaConversion_Impl, OnIgnoreAll: shouldn't this have been ignored before" );
//STRIP001 
//STRIP001 			// put into the "ignore all" list
//STRIP001 			m_sIgnoreList.insert( sCurrentUnit );
//STRIP001 
//STRIP001 			// and proceed
//STRIP001 			implProceed( sal_False );
//STRIP001 		}
//STRIP001 
//STRIP001 		return 0L;
//STRIP001 	}
//STRIP001 	
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	IMPL_LINK( HangulHanjaConversion_Impl, OnChange, void*, NOTINTERESTEDIN )
//STRIP001 	{
//STRIP001 		// change
//STRIP001 		implChange( m_pConversionDialog->GetCurrentSuggestion( ) );
//STRIP001 		// and proceed
//STRIP001 		implProceed( sal_False );
//STRIP001 
//STRIP001 		return 0L;
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	IMPL_LINK( HangulHanjaConversion_Impl, OnChangeAll, void*, NOTINTERESTEDIN )
//STRIP001 	{
//STRIP001 		DBG_ASSERT( m_pConversionDialog, "HangulHanjaConversion_Impl::OnChangeAll: no dialog! How this?" );
//STRIP001 		if ( m_pConversionDialog )
//STRIP001 		{
//STRIP001 			::rtl::OUString sCurrentUnit( m_pConversionDialog->GetCurrentString() );
//STRIP001 			::rtl::OUString sChangeInto( m_pConversionDialog->GetCurrentSuggestion( ) );
//STRIP001 
//STRIP001 			// change the current occurence
//STRIP001 			implChange( sChangeInto );
//STRIP001 
//STRIP001 			// put into the "change all" list
//STRIP001 			m_aChangeList.insert( StringMap::value_type( sCurrentUnit, sChangeInto ) );
//STRIP001 
//STRIP001 			// and proceed
//STRIP001 			implProceed( sal_False );
//STRIP001 		}
//STRIP001 
//STRIP001 		return 0L;
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	IMPL_LINK( HangulHanjaConversion_Impl, OnByCharClicked, CheckBox*, _pBox )
//STRIP001 	{
//STRIP001 		m_bByCharacter = _pBox->IsChecked();
//STRIP001 
//STRIP001 		// continue conversion, without advancing to the next unit, but instead continuing with the current unit
//STRIP001 		implProceed( m_bByCharacter ? sal_True : sal_False );
//STRIP001 			// if we just switched to "by character", then we want to start over with the current word
//STRIP001 			// if we just switched to "by word", then we don't want to start over with word which contains the current
//STRIP001 			//    character, because this may be potentially dagerous in case a character within this word
//STRIP001 			//    has already been replaced
//STRIP001 		return 0L;
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	IMPL_LINK( HangulHanjaConversion_Impl, OnConversionTypeChanged, void*, NOTINTERESTEDIN )
//STRIP001 	{
//STRIP001 		m_eConversionFormat = m_pConversionDialog->GetConversionFormat( );
//STRIP001 		return 0L;
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	IMPL_LINK( HangulHanjaConversion_Impl, OnFind, void*, NOTINTERESTEDIN )
//STRIP001 	{
//STRIP001 		DBG_ASSERT( m_pConversionDialog, "HangulHanjaConversion_Impl::OnFind: where did this come from?" );
//STRIP001 		if ( m_pConversionDialog )
//STRIP001 		{
//STRIP001 			try
//STRIP001 			{
//STRIP001 				::rtl::OUString sNewOriginal( m_pConversionDialog->GetCurrentSuggestion( ) );
//STRIP001 				Sequence< ::rtl::OUString > aSuggestions;
//STRIP001 #ifdef FS_HANGUL_HANJA
//STRIP001 				// for testing reasons, we add all rotations of the original word as suggestions
//STRIP001 				aSuggestions.realloc( sNewOriginal.getLength() );
//STRIP001 				::rtl::OUString* pSuggestion = aSuggestions.getArray();
//STRIP001 				String sSuggestion( sNewOriginal );
//STRIP001 				for ( sal_Int32 i = 0; i < sNewOriginal.getLength(); ++i, ++pSuggestion )
//STRIP001 				{
//STRIP001 					*pSuggestion = sSuggestion = sSuggestion.Copy( 1 ).Append( sSuggestion.GetBuffer()[0] );
//STRIP001 				}
//STRIP001 #else
//STRIP001 				DBG_ASSERT( m_xConverter.is(), "HangulHanjaConversion_Impl::OnFind: no converter!" );
//STRIP001 				TextConversionResult aToHanja = m_xConverter->getConversions(
//STRIP001 					sNewOriginal,
//STRIP001 					0, sNewOriginal.getLength(),
//STRIP001 					m_aLocale,
//STRIP001 					TextConversionType::TO_HANJA,
//STRIP001 					TextConversionOption::NONE
//STRIP001 				);
//STRIP001 				TextConversionResult aToHangul = m_xConverter->getConversions(
//STRIP001 					sNewOriginal,
//STRIP001 					0, sNewOriginal.getLength(),
//STRIP001 					m_aLocale,
//STRIP001 					TextConversionType::TO_HANGUL,
//STRIP001 					TextConversionOption::NONE
//STRIP001 				);
//STRIP001 
//STRIP001 				bool bHaveToHanja = ( aToHanja.Boundary.startPos < aToHanja.Boundary.endPos );
//STRIP001 				bool bHaveToHangul = ( aToHangul.Boundary.startPos < aToHangul.Boundary.endPos );
//STRIP001 
//STRIP001 				TextConversionResult* pResult = NULL;
//STRIP001 				if ( bHaveToHanja && bHaveToHangul )
//STRIP001 				{	// it found convertibles in both directions -> use the first
//STRIP001 					if ( aToHangul.Boundary.startPos < aToHanja.Boundary.startPos )
//STRIP001 						pResult = &aToHangul;
//STRIP001 					else
//STRIP001 						pResult = &aToHanja;
//STRIP001 				}
//STRIP001 				else if ( bHaveToHanja )
//STRIP001 				{	// only found toHanja
//STRIP001 					pResult = &aToHanja;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{	// only found toHangul
//STRIP001 					pResult = &aToHangul;
//STRIP001 				}
//STRIP001 				if ( pResult )
//STRIP001 					aSuggestions = pResult->Candidates;
//STRIP001 #endif
//STRIP001 
//STRIP001 				m_pConversionDialog->SetCurrentString( sNewOriginal, aSuggestions, false );
//STRIP001 				m_pConversionDialog->FocusSuggestion();
//STRIP001 			}
//STRIP001 			catch( const Exception& e )
//STRIP001 			{
//STRIP001 				e;	// make compiler happy
//STRIP001 				DBG_ERROR( "HangulHanjaConversion_Impl::OnFind: caught an exception!" );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		return 0L;
//STRIP001 	}
//STRIP001 
//STRIP001 	//=========================================================================
//STRIP001 	//= HangulHanjaConversion
//STRIP001 	//=========================================================================
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	HangulHanjaConversion::HangulHanjaConversion( Window* _pUIParent, const Reference< XMultiServiceFactory >& _rxORB, const Locale& _rLocale )
//STRIP001 		:m_pImpl( new HangulHanjaConversion_Impl( _pUIParent, _rxORB, _rLocale, this ) )
//STRIP001 	{
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	HangulHanjaConversion::~HangulHanjaConversion( )
//STRIP001 	{
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	void HangulHanjaConversion::HandleNewUnit( const sal_Int32 _nStartIndex, const sal_Int32 _nEndIndex )
//STRIP001 	{
//STRIP001 		// nothing to do, only derived classes need this.
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	void HangulHanjaConversion::GetNextPortion( ::rtl::OUString& /* [out] */ _rNextPortion )
//STRIP001 	{
//STRIP001 #ifdef FS_HANGUL_HANJA
//STRIP001 		#define TEST_TEXT "깔끔?외형, 아름답게 디자인된 ?부분과 기능?집약성으? 디지?카메?1300은 쉽게 명함?이미지?촬영하여 PDA?컴퓨터의 주소록으?데이터를 변환할?있다."
//STRIP001 		static ::rtl::OUString sPortion(
//STRIP001 			TEST_TEXT, sizeof( TEST_TEXT ) - 1,
//STRIP001 			RTL_TEXTENCODING_UTF8
//STRIP001 		);
//STRIP001 		
//STRIP001 		if ( m_pImpl->m_sRememberPos == sPortion )
//STRIP001 			_rNextPortion = ::rtl::OUString();
//STRIP001 		else
//STRIP001 			m_pImpl->m_sRememberPos = _rNextPortion = sPortion;
//STRIP001 #else
//STRIP001 		DBG_ERROR( "HangulHanjaConversion::GetNextPortion: to be overridden!" );
//STRIP001 #endif
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	void HangulHanjaConversion::ReplaceUnit( const sal_Int32 _nUnitStart, const sal_Int32 _nUnitEnd,
//STRIP001 			const ::rtl::OUString& _rReplaceWith, ReplacementAction _eAction )
//STRIP001 	{
//STRIP001 #ifndef FS_HANGUL_HANJA
//STRIP001 		DBG_ERROR( "HangulHanjaConversion::ReplaceUnit: to be overridden!" );
//STRIP001 #endif
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	void HangulHanjaConversion::ConvertDocument()
//STRIP001 	{
//STRIP001 #ifndef FS_HANGUL_HANJA
//STRIP001 		if ( m_pImpl->IsValid() )
//STRIP001 #endif
//STRIP001 			m_pImpl->DoDocumentConversion( );
//STRIP001 	}
//STRIP001 
//STRIP001 //.............................................................................
//STRIP001 }	// namespace svx
//.............................................................................
}
