/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_uivwimp.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 06:48:32 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop
#include <cmdid.h>
#include "globals.hrc"


#ifndef _COM_SUN_STAR_SCANNER_XSCANNERMANAGER_HPP_
#include <com/sun/star/scanner/XScannerManager.hpp>
#endif
#ifndef _COM_SUN_STAR_DATATRANSFER_CLIPBOARD_XCLIPBOARDNOTIFIER_HPP_
#include <com/sun/star/datatransfer/clipboard/XClipboardNotifier.hpp>
#endif
#ifndef _COM_SUN_STAR_DATATRANSFER_CLIPBOARD_XCLIPBOARD_HPP_
#include <com/sun/star/datatransfer/clipboard/XClipboard.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif
#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _SV_WRKWIN_HXX
#include <vcl/wrkwin.hxx>
#endif
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX
#include <bf_sfx2/viewfrm.hxx>
#endif
#ifndef _SFX_BINDINGS_HXX
#include <bf_sfx2/bindings.hxx>
#endif

#include <bf_sfx2/request.hxx>

#ifndef _UIVWIMP_HXX
#include <uivwimp.hxx>
#endif
#ifndef _SWWVIEW_HXX //autogen
#include <wview.hxx>
#endif
#ifndef _UNOTXVW_HXX
#include <unotxvw.hxx>
#endif
#ifndef _UNODISPATCH_HXX
#include <unodispatch.hxx>
#endif
#ifndef _SWMODULE_HXX
#include <swmodule.hxx>
#endif
#ifndef _SWDTFLVR_HXX
#include <swdtflvr.hxx>
#endif
#ifndef _EDTWIN_HXX
#include <edtwin.hxx>
#endif

#include <view.hrc>
#ifndef _LEGACYBINFILTERMGR_HXX
#include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
#endif
namespace binfilter {

using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::scanner;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::datatransfer::clipboard;

/* -----------------02.06.98 15:31-------------------
 *
 * --------------------------------------------------*/
/*N*/ SwView_Impl::SwView_Impl(SwView* pShell) :
/*N*/ 		pView(pShell),
/*N*/ 		pxXTextView(new uno::Reference<view::XSelectionSupplier>),
/*N*/ 		eShellMode(SEL_TEXT)
/*N*/ {
/*N*/ 	*pxXTextView = new SwXTextView(pView);
/*N*/ 	xDisProvInterceptor = new SwXDispatchProviderInterceptor(*pView);
/*N*/ }

/*-----------------13.12.97 09:51-------------------

--------------------------------------------------*/
/*N*/ SwView_Impl::~SwView_Impl()
/*N*/ {
/*N*/     Reference<XUnoTunnel> xDispTunnel(xDisProvInterceptor, UNO_QUERY);
/*N*/     SwXDispatchProviderInterceptor* pInterceptor = 0;
/*N*/     if(xDispTunnel.is() &&
/*N*/         0 != (pInterceptor = (SwXDispatchProviderInterceptor*)xDispTunnel->getSomething(
/*N*/             SwXDispatchProviderInterceptor::getUnoTunnelId())))
/*N*/     {
/*N*/         pInterceptor->Invalidate();
/*N*/     }
/*N*/     view::XSelectionSupplier* pTextView = pxXTextView->get();
/*N*/ 	((SwXTextView*)pTextView)->Invalidate();
/*N*/ 	delete pxXTextView;
/*N*/ 	if( xScanEvtLstnr.is() )
/*?*/ 	   	pScanEvtLstnr->ViewDestroyed();
/*N*/ 	if( xClipEvtLstnr.is() )
/*N*/ 	{
/*N*/ 		pClipEvtLstnr->AddRemoveListener( FALSE );
/*N*/ 		pClipEvtLstnr->ViewDestroyed();
/*N*/ 	}
/*N*/ }

/*-----------------13.12.97 09:54-------------------

--------------------------------------------------*/
/*N*/ void SwView_Impl::SetShellMode(ShellModes eSet)
/*N*/ {
/*N*/ 	eShellMode = eSet;
/*N*/ }
/*-----------------13.12.97 09:59-------------------

--------------------------------------------------*/
/*N*/ view::XSelectionSupplier*	SwView_Impl::GetUNOObject()
/*N*/ {
/*N*/ 	return pxXTextView->get();
/*N*/ }
/* -----------------02.06.98 15:29-------------------
 *
 * --------------------------------------------------*/
/*N*/ SwXTextView*	SwView_Impl::GetUNOObject_Impl()
/*N*/ {
/*N*/ 		view::XSelectionSupplier* pTextView = pxXTextView->get();
/*N*/ 		return ((SwXTextView*)pTextView);
/*N*/ }
/* -----------------------------29.05.00 09:04--------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 void SwView_Impl::ExecuteScan( SfxRequest& rReq )
//STRIP001 {
//STRIP001     USHORT nSlot = rReq.GetSlot();
//STRIP001 	switch(nSlot)
//STRIP001 	{
//STRIP001 		case SID_TWAIN_SELECT:
//STRIP001 		{
//STRIP001 			BOOL bDone = FALSE;
//STRIP001 			Reference< XScannerManager > xScanMgr = SW_MOD()->GetScannerManager();
//STRIP001 
//STRIP001 			if( xScanMgr.is() )
//STRIP001 			{
//STRIP001 //JP 26.06.00: the appwindow doen't exist
//STRIP001 //				Application::GetAppWindow()->EnableInput( FALSE );
//STRIP001 
//STRIP001 				try
//STRIP001 				{
//STRIP001 					const Sequence< ScannerContext >
//STRIP001 						aContexts( xScanMgr->getAvailableScanners() );
//STRIP001 
//STRIP001 					if( aContexts.getLength() )
//STRIP001 					{
//STRIP001 						ScannerContext aContext( aContexts.getConstArray()[ 0 ] );
//STRIP001 						bDone = xScanMgr->configureScanner( aContext );
//STRIP001 					}
//STRIP001 				}
//STRIP001 				catch(...)
//STRIP001 				{
//STRIP001 				}
//STRIP001 
//STRIP001 //JP 26.06.00: the appwindow doen't exist
//STRIP001 //				Application::GetAppWindow()->EnableInput( TRUE );
//STRIP001 			}
//STRIP001             if( bDone )
//STRIP001                 rReq.Done();
//STRIP001             else
//STRIP001             {
//STRIP001                 rReq.Ignore();
//STRIP001 // KA 04.07.2002 
//STRIP001 //              InfoBox( 0, SW_RES(MSG_SCAN_NOSOURCE) ).Execute();
//STRIP001             }
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001         case SID_TWAIN_TRANSFER:
//STRIP001 		{
//STRIP001 			BOOL bDone = FALSE;
//STRIP001 
//STRIP001 			Reference< XScannerManager > xScanMgr = SW_MOD()->GetScannerManager();
//STRIP001 			if( xScanMgr.is() )
//STRIP001 			{
//STRIP001 				SwScannerEventListener& rListener = GetScannerEventListener();
//STRIP001 //JP 26.06.00: the appwindow doen't exist
//STRIP001 //				Application::GetAppWindow()->EnableInput( FALSE );
//STRIP001 				try
//STRIP001 				{
//STRIP001 					const Sequence< scanner::ScannerContext >aContexts( xScanMgr->getAvailableScanners() );
//STRIP001 					if( aContexts.getLength() )
//STRIP001 					{
//STRIP001 						Reference< XEventListener > xLstner = &rListener;
//STRIP001 						xScanMgr->startScan( aContexts.getConstArray()[ 0 ], xLstner );
//STRIP001 						bDone = TRUE;
//STRIP001 					}
//STRIP001 				}
//STRIP001 				catch(...)
//STRIP001 				{
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			if( !bDone )
//STRIP001 			{
//STRIP001 //JP 26.06.00: the appwindow doen't exist
//STRIP001 //				Application::GetAppWindow()->EnableInput( TRUE );
//STRIP001 				InfoBox( 0, SW_RES(MSG_SCAN_NOSOURCE) ).Execute();
//STRIP001                 rReq.Ignore();
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001                 rReq.Done();
//STRIP001 				SfxBindings& rBind = pView->GetViewFrame()->GetBindings();
//STRIP001 				rBind.Invalidate( SID_TWAIN_SELECT );
//STRIP001 				rBind.Invalidate( SID_TWAIN_TRANSFER );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	}
//STRIP001 }

/* -----------------------------29.05.00 08:26--------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 SwScannerEventListener& SwView_Impl::GetScannerEventListener()
//STRIP001 {
//STRIP001 	if(!xScanEvtLstnr.is())
//STRIP001 		xScanEvtLstnr = pScanEvtLstnr = new SwScannerEventListener(*pView);
//STRIP001 	return *pScanEvtLstnr;
//STRIP001 }


/*N*/ void SwView_Impl::AddClipboardListener()
/*N*/ {
/*N*/ 	if(!xClipEvtLstnr.is())
/*N*/ 	{
/*N*/ 		xClipEvtLstnr = pClipEvtLstnr = new SwClipboardChangeListener( *pView );
/*N*/ 		pClipEvtLstnr->AddRemoveListener( TRUE );
/*N*/ 	}
/*N*/ }
/* -----------------3/31/2003 11:42AM----------------

 --------------------------------------------------*/
/*N*/ void SwView_Impl::Invalidate()
/*N*/ {
/*N*/     GetUNOObject_Impl()->Invalidate();
/*N*/     Reference< XUnoTunnel > xTunnel(xTransferable.get(), UNO_QUERY);
/*N*/     if(xTunnel.is())
/*N*/ 
/*N*/     {
/*?*/         SwTransferable* pTransferable = (SwTransferable*)xTunnel->getSomething(SwTransferable::getUnoTunnelId());
/*?*/         if(pTransferable)
/*?*/             pTransferable->Invalidate();
/*N*/     }            
/*N*/ }        
/* -----------------3/31/2003 12:40PM----------------

 --------------------------------------------------*/
//STRIP001 void SwView_Impl::AddTransferable(SwTransferable& rTransferable)
//STRIP001 {
//STRIP001     //prevent removing of the non-referenced SwTransferable
//STRIP001     rTransferable.m_refCount++;;
//STRIP001     {
//STRIP001         xTransferable = Reference<XUnoTunnel> (&rTransferable);
//STRIP001     }
//STRIP001     rTransferable.m_refCount--;
//STRIP001 }        

// ------------------------- SwScannerEventListener ---------------------

//STRIP001 SwScannerEventListener::~SwScannerEventListener()
//STRIP001 {
//STRIP001 }

//STRIP001 void SAL_CALL SwScannerEventListener::disposing( const EventObject& rEventObject) throw(::com::sun::star::uno::RuntimeException)
//STRIP001 {
//STRIP001 	if( pView )
//STRIP001 		pView->ScannerEventHdl( rEventObject );
//STRIP001 }

// ------------------------- SwClipboardChangeListener ---------------------

/*N*/ SwClipboardChangeListener::~SwClipboardChangeListener()
/*N*/ {
/*N*/ }

//STRIP001 void SAL_CALL SwClipboardChangeListener::disposing( const EventObject& rEventObject )
//STRIP001 	throw ( RuntimeException )
//STRIP001 {
//STRIP001 }

/*N*/ void SAL_CALL SwClipboardChangeListener::changedContents( const CLIP_NMSPC::ClipboardEvent& rEventObject )
/*N*/ 	throw ( RuntimeException )
/*N*/ 
/*N*/ {
/*N*/ 	if( pView )
/*N*/ 	{
/*N*/ 		{
/*N*/ 		const ::vos::OGuard aGuard( Application::GetSolarMutex() );
/*N*/ 
/*N*/ 		TransferableDataHelper aDataHelper( rEventObject.Contents );
/*N*/ 		SwWrtShell& rSh = pView->GetWrtShell();
/*N*/ 
/*N*/ 		pView->nLastPasteDestination = SwTransferable::GetSotDestination( rSh );
/*N*/ 		pView->bPasteState = aDataHelper.GetXTransferable().is() &&
/*N*/ 						SwTransferable::IsPaste( rSh, aDataHelper );
/*N*/ 
/*N*/ 		pView->bPasteSpecialState = aDataHelper.GetXTransferable().is() &&
/*N*/ 					SwTransferable::IsPasteSpecial( rSh, aDataHelper );
/*N*/ 		}
/*N*/ 
/*N*/ 		SfxBindings& rBind = pView->GetViewFrame()->GetBindings();
/*N*/ 		rBind.Invalidate( SID_PASTE );
/*N*/ 		rBind.Invalidate( FN_PASTESPECIAL );
/*N*/         rBind.Invalidate( SID_CLIPBOARD_FORMAT_ITEMS );
/*N*/ 	}
/*N*/ }

/*N*/ void SwClipboardChangeListener::AddRemoveListener( BOOL bAdd )
/*N*/ {
/*N*/ 	try
/*N*/ 	{
/*N*/ 		do {
/*N*/ 
/*N*/ #ifdef _DONT_WORD_FOR_WEBTOP_
/*N*/ JP 4.7.2001: change for WebTop - get Clipboard from the Window.
/*N*/ 			Reference< XMultiServiceFactory > xFact(
/*N*/ 								::legacy_binfilters::getLegacyProcessServiceFactory() );
/*N*/ 			if( !xFact.is() )
/*N*/ 				break;
/*N*/ 			Reference< XClipboard > xClipboard( xFact->createInstance(
/*N*/ 				::rtl::OUString::createFromAscii(
/*N*/ 					"com.sun.star.datatransfer.clipboard.SystemClipboard" )),
/*N*/ 				UNO_QUERY );
/*N*/ #else
/*N*/ 			Reference< XClipboard > xClipboard(
/*N*/ 					pView->GetEditWin().GetClipboard() );
/*N*/ #endif
/*N*/ 			if( !xClipboard.is() )
/*N*/ 				break;
/*N*/ 
/*N*/ 			Reference< XClipboardNotifier > xClpbrdNtfr( xClipboard, UNO_QUERY );
/*N*/ 			if( xClpbrdNtfr.is() )
/*N*/ 			{
/*N*/ 				Reference< XClipboardListener >	xClipEvtLstnr( this );
/*N*/ 				if( bAdd )
/*N*/ 					xClpbrdNtfr->addClipboardListener( xClipEvtLstnr );
/*N*/ 				else
/*N*/ 					xClpbrdNtfr->removeClipboardListener( xClipEvtLstnr );
/*N*/ 			}
/*N*/ 		}  while ( FALSE );
/*N*/ 	}
/*N*/ 	catch( const ::com::sun::star::uno::Exception& )
/*N*/ 	{
/*N*/ 	}
/*N*/ }


}
