/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: iniwrap.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 10:49:07 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SBA_INIWRAP_HXX
#define _SBA_INIWRAP_HXX

#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif
namespace binfilter {

// Zahl der maximal m"oglichen Zuordnungen im Ini-Eintrag AddressBookFields
const USHORT ADDR_BOOK_FIELDS_CNT = 31;

class SbaStringList;
class SfxIniManager;

//==================================================================
// SbaIniWrap
//==================================================================

class SbaIniWrap
{
public:
	enum FieldKey
	{
		COMPANY,
		DEPARTMENT,
		FIRSTNAME,
		LASTNAME,
		ADDRESS,
		COUNTRY,
		POSTALCODE,
		CITY,
		TITLE,
		POSITION,
		PREFIX,
		INITIALS,
		SALUTATION,
		HOMEPHONE,
		WORKPHONE,
		FAX,
		EMAIL,
		URL,
		NOTE,
		OLDFIELD1,
		OLDFIELD2,
		OLDFIELD3,
		OLDFIELD4,
		ID,
		STATE,
		OFFICEPHONE,
		PAGER,
		HANDYPHONE,
		OTHERPHONE,
		CALENDARURL,
		INVITE
	};

private:
	SfxIniManager*	pIni;
	String			aGroupName;
	String			aFieldMap[ADDR_BOOK_FIELDS_CNT];	// Hier werden den SbaFieldKeys (Index) die KeyStrings der Ini zugeordnet

public:
	SbaIniWrap();
	~SbaIniWrap();

	String		GetDefaultDatabase();
	void		SetDefaultDatabase( const String& rAliasName );
	String		GetDefaultDatabasePath();
	void		SetDefaultDatabasePath( const String& rPath );

	String		GetAdressDB() const;
	String		GetAdressTable() const;
	void		SetAdressDB(const String& rDB, const String& rTable);

	// Feldnamen in Landessprachen
	String		GetAddressFields() const;
	void		SetAddressFields( const String& rFields );


	String		GetAssocFieldName( FieldKey eKey );
	INT16		GetAssocCtrlPos( const String& rField );
};


} //namespace binfilter
#endif

