/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: strg_ifc.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 16:38:11 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_autodoc.hxx"


#include <precomp.h>
#include <store/strg_ifc.hxx>


// NOT FULLY DEFINED SERVICES
#include <store/storage.hxx>
#include <store/c_stgifc.hxx>
#include <store/g_stgifc.hxx>
#include <store/l_stgifc.hxx>


namespace ary
{
namespace store
{


//***************************       CheshireCat       ************************//

struct Interface::CheshireCat
{
    Dyn<Interface_Cpp>  pCpp;
    Dyn<Locations_Ifc>  pLocations;
    Dyn<Groups_Ifc>     pGroups;

    Storage *           pStorage;

                        CheshireCat(
                            Storage &           io_rStorage );
};

Interface::
CheshireCat::CheshireCat( Storage & io_rStorage )
    :   pCpp( new Interface_Cpp(io_rStorage) ),
        pLocations( new Locations_Ifc(io_rStorage.TheLocations()) ),
        pGroups( new Groups_Ifc(io_rStorage.TheIndependentGroups()) ),
        pStorage( &io_rStorage )
{
}


//***************************       Interface       ************************//

Interface::Interface( Storage & io_rStorage )
    :   pi( new CheshireCat(io_rStorage) )
{
}

Interface::~Interface()
{
}

Interface_Cpp &
Interface::Ifc_Cpp()
{
    return *pi->pCpp;
}

Locations_Ifc &
Interface::Ifc_Locations()
{
    return *pi->pLocations;
}

// Groups_Ifc &
// Interface::Ifc_GlobalGroups()
// {
//     return *pi->pGroups;
// }


} // namespace store
} // namespace ary


