/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dlg_RotateDiagram.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 12:58:23 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_chart2.hxx"
#include "dlg_RotateDiagram.hxx"
#include "dlg_RotateDiagram.hrc"

#include "ResId.hxx"

#ifndef INCLUDED_RTL_MATH_HXX
#include <rtl/math.hxx>
#endif

//.............................................................................
namespace chart
{
//.............................................................................

RotateDiagramDialog::RotateDiagramDialog( Window* pWindow, double fXAngleDegree,
                                         double fYAngleDegree, double fZAngleDegree ) :
				ModalDialog 	( pWindow, SchResId( DLG_3D_VIEW ) ),
				aFtXAxis		( this, ResId( FT_X_AXIS ) ),
				aMtrFldXAxis	( this, ResId( MTR_FLD_X_AXIS ) ),
				aFtYAxis		( this, ResId( FT_Y_AXIS ) ),
				aMtrFldYAxis	( this, ResId( MTR_FLD_Y_AXIS ) ),
				aFtZAxis		( this, ResId( FT_Z_AXIS ) ),
				aMtrFldZAxis	( this, ResId( MTR_FLD_Z_AXIS ) ),
				aFlAxis			( this, ResId( FL_AXIS ) ),
				aBtnOK			( this, ResId( BTN_OK ) ),
				aBtnCancel		( this, ResId( BTN_CANCEL ) ),
				aBtnHelp		( this, ResId( BTN_HELP ) )
{
	FreeResource();

	aMtrFldXAxis.SetValue(static_cast<long>(fXAngleDegree*pow(10.0,aMtrFldXAxis.GetDecimalDigits())));
	aMtrFldYAxis.SetValue(static_cast<long>(-1*fYAngleDegree*pow(10.0,aMtrFldYAxis.GetDecimalDigits())));
	aMtrFldZAxis.SetValue(static_cast<long>(fZAngleDegree*pow(10.0,aMtrFldZAxis.GetDecimalDigits())));
}

RotateDiagramDialog::~RotateDiagramDialog()
{
}

void RotateDiagramDialog::getAngle( double& fXAngleDegree, double& fYAngleDegree, double& fZAngleDegree )
{
    fXAngleDegree = double(aMtrFldXAxis.GetValue())/double(pow(10.0,aMtrFldXAxis.GetDecimalDigits()));
    fYAngleDegree = double(-1*aMtrFldYAxis.GetValue())/double(pow(10.0,aMtrFldYAxis.GetDecimalDigits()));
    fZAngleDegree = double(aMtrFldZAxis.GetValue())/double(pow(10.0,aMtrFldZAxis.GetDecimalDigits()));
}

//.............................................................................
} //namespace chart
//.............................................................................
