/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dlg_RotateDiagram.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 00:28:20 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _CHART2_DLG_ROTATE_DIAGRAM_HXX
#define _CHART2_DLG_ROTATE_DIAGRAM_HXX

// header for class ModalDialog
#ifndef _SV_DIALOG_HXX
#include <vcl/dialog.hxx>
#endif
// header for class FixedLine
#ifndef _SV_FIXED_HXX
#include <vcl/fixed.hxx>
#endif
// header for class MetricField
#ifndef _SV_FIELD_HXX
#include <vcl/field.hxx>
#endif
// header for class OKButton
#ifndef _SV_BUTTON_HXX
#include <vcl/button.hxx>
#endif

//.............................................................................
namespace chart
{
//.............................................................................

class RotateDiagramDialog : public ModalDialog
{
public:
	RotateDiagramDialog( Window* pWindow, double fXAngleDegree,
						  double fYAngleDegree, double fZAngleDegree );
	~RotateDiagramDialog();

    void getAngle( double& fXAngleDegree, double& fYAngleDegree, double& fZAngleDegree );

private:
	FixedText		aFtXAxis;
	MetricField		aMtrFldXAxis;
	FixedText		aFtYAxis;
	MetricField		aMtrFldYAxis;
	FixedText		aFtZAxis;
	MetricField		aMtrFldZAxis;
	FixedLine		aFlAxis;
	OKButton		aBtnOK;
	CancelButton	aBtnCancel;
	HelpButton		aBtnHelp;
};

//.............................................................................
} //namespace chart
//.............................................................................

#endif

