/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: chdescr.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: ihi $ $Date: 2006/11/14 14:53:55 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"
#include "chdescr.hxx"
#include "chaxis.hxx"

#ifndef _SVDPAGE_HXX //autogen
#include <svx/svdpage.hxx>
#endif
#include "float.h"
#include "globfunc.hxx"
#include "schgroup.hxx"
#include "chtscene.hxx"

ChartDataDescription::ChartDataDescription(long nCols, long nRows, SdrObjList *pList,
										   ChartModel* pModel, BOOL bEnable) :
		mnRows(nRows),
		mnCols(nCols),
		mpList(pList),
		mpModel(pModel),
		mbEnable(bEnable),
		mpDescrLists(NULL),
		mpDescrArray(NULL),
		mpDescrGroups(NULL)
{
}

void ChartDataDescription::Build( BOOL bRowDescr )
{
	Dirty2D( bRowDescr );
	if(mpList && mpDescrGroups)
	{
		for( long nRow=0; nRow<mnRows; nRow++ )
		{
			if(mpDescrGroups[nRow])
				mpList->NbcInsertObject( mpDescrGroups[nRow] );
		}
	}
}

void ChartDataDescription::Build3D( ChartScene *pScene, ::basegfx::B3DHomMatrix* pMatrix )
{
	if(pScene && mpDescrGroups)
	{
		for( long nRow=0; nRow<mnRows; nRow++ )
		{
			for( long nCol=0; nCol<mnCols; nCol++ )
			{
				long nIndex = nCol + nRow * mnCols;
				if( mpDescrArray[nIndex].fValue != DBL_MIN )
				{
					mpDescrArray[nIndex].pLabelObj->SetMarkProtect(TRUE);
					E3dLabelObj* pLabel=new E3dLabelObj(mpDescrArray[nIndex].aTextPos3D,
														mpDescrArray[nIndex].pLabelObj);

					CHART_TRACE3( "Descr::Build3D TextPos = (%ld, %ld, %ld)",
								  (long)mpDescrArray[ nIndex ].aTextPos3D.getX(),
								  (long)mpDescrArray[ nIndex ].aTextPos3D.getY(),
								  (long)mpDescrArray[ nIndex ].aTextPos3D.getZ() );
					
					pLabel->SetMarkProtect(TRUE);
					pScene->Insert3DObj(pLabel);
					if(pMatrix)
						pLabel->NbcSetTransform(*pMatrix);
				}
			}
		}
	}
}

ChartDataDescription::~ChartDataDescription()
{
	if(mpDescrLists)
		delete[] mpDescrLists;
	if(mpDescrGroups)
		delete[] mpDescrGroups;
	if(mpDescrArray)
		delete[] mpDescrArray;
}

void ChartDataDescription::Create(long nRow)
{
	if(!mpDescrArray)
	{
		mpDescrArray = new DataDescription[ mnRows * mnCols ];
		long nElements = mnRows * mnCols;
		while(nElements)
		{
			nElements--;
			mpDescrArray[nElements].bSymbol = FALSE;
			mpDescrArray[nElements].pLabelObj   = NULL;
			mpDescrArray[nElements].fValue  = DBL_MIN;
			mpDescrArray[nElements].aTextPos2D = ::basegfx::B2DPoint(0.0,0.0);
		}
	}
	if(!mpDescrLists)
	{
		mpDescrLists =new SdrObjList*[mnRows];
		mpDescrGroups=new SchObjGroup*[mnRows];
		for(long n=0;n<mnRows;n++)
		{
			mpDescrLists[n] =NULL;
			mpDescrGroups[n]=NULL;
		}
	}
	
	if(!mpDescrLists[nRow])
	{
		mpDescrGroups[nRow] = (SchObjGroup*)CreateSimpleGroup( CHOBJID_DIAGRAM_DESCRGROUP, TRUE, TRUE );
		mpDescrGroups[nRow]->InsertUserData( new SchDataRow(nRow) );
		mpDescrLists[nRow] = mpDescrGroups[nRow]->GetSubList();
	}
}

DataDescription* ChartDataDescription::Insert( long nCol, long nRow, const SfxItemSet& rAttr, const ::basegfx::B2DPoint& rPos,
											   BOOL bPercent, ChartAdjust eAdjust, ChartAxis* pAxis )
{
	SvxChartDataDescr eDescr = ((const SvxChartDataDescrItem&)rAttr.Get(SCHATTR_DATADESCR_DESCR)).GetValue();

	if(mbEnable && eDescr != CHDESCR_NONE)
	{
		Create(nRow); //evtl. Array und Liste erstellen
		long nIndex = nCol + nRow * mnCols;

		mpDescrArray[nIndex].eDescr  = eDescr;
		mpDescrArray[nIndex].bSymbol = ((const SfxBoolItem&)rAttr.Get(SCHATTR_DATADESCR_SHOW_SYM)).GetValue();
		mpDescrArray[nIndex].fValue  = mpModel->GetData(nCol,nRow,bPercent);
		mpDescrArray[nIndex].eAdjust = eAdjust;
		mpDescrArray[nIndex].aTextPos2D = rPos;
		mpModel->CreateDataDescr(mpDescrArray[nIndex],nCol,nRow,pAxis,bPercent);
		return &mpDescrArray[nIndex];
	}
	return NULL;
}

void ChartDataDescription::Dirty2D( BOOL bRowDescr )
{

	if(mpDescrLists)
	{
		for( long nRow = 0; nRow < mnRows; nRow ++ )
		{
			if( mpDescrLists[nRow] )
			{
				for( long nCol = 0; nCol < mnCols; nCol++ )
				{
						long nIndex = nCol + nRow * mnCols;
						if (mpDescrArray[nIndex].fValue != DBL_MIN)
							if (mpDescrArray[nIndex].pLabelObj)
								mpDescrLists[nRow]->NbcInsertObject(mpDescrArray[nIndex].pLabelObj);
				}
			}
		}
	}
}

