/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: objfac.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 19:55:31 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"


#include "axisid.hxx"
#include "schgroup.hxx"
#include "objfac.hxx"
#include "objid.hxx"
#include "objadj.hxx"
#include "datarow.hxx"
#include "datapoin.hxx"
#include "lightfac.hxx"
#include "glob.hxx"


/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchObjFactory::SchObjFactory() :
	bInserted(FALSE)
{
}

/*************************************************************************
|*
|* Chart-interne Objekte erzeugen
|*
\************************************************************************/

IMPL_LINK( SchObjFactory, MakeObject, SdrObjFactory*, pObjFactory)
{
	if (pObjFactory->nInventor == SchInventor &&
		pObjFactory->nIdentifier == SCH_OBJGROUP_ID)
		pObjFactory->pNewObj = new SchObjGroup;

	return 0;
}

/*************************************************************************
|*
|* Chart-Userdata erzeugen
|*
\************************************************************************/

IMPL_LINK( SchObjFactory, MakeUserData, SdrObjFactory* ,pObjFactory)
{
	if (pObjFactory->nInventor == SchInventor)
		switch (pObjFactory->nIdentifier)
		{
			case SCH_OBJECTID_ID:
				pObjFactory->pNewData = new SchObjectId;
				break;

			case SCH_OBJECTADJUST_ID:
				pObjFactory->pNewData = new SchObjectAdjust;
				break;

			case SCH_DATAROW_ID:
				pObjFactory->pNewData = new SchDataRow;
				break;

			case SCH_DATAPOINT_ID:
				pObjFactory->pNewData = new SchDataPoint;
				break;

			case SCH_LIGHTFACTOR_ID:
				pObjFactory->pNewData = new SchLightFactor;
				DBG_ERROR("SCH_LIGHTFACTOR_ID no longer available");
				break;

			case SCH_AXIS_ID :
				pObjFactory->pNewData = new SchAxisId;
				break;
		}

		return 0;
}



