/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: docshel1.cxx,v $
 *
 *  $Revision: 1.17 $
 *
 *  last change: $Author: ihi $ $Date: 2006/11/14 14:58:33 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"

#ifndef _SVX_SVXIDS_HRC
#define ITEMID_FONTLIST 		SID_ATTR_CHAR_FONTLIST
#define ITEMID_NUMBERINFO		SID_ATTR_NUMBERFORMAT_INFO
#define ITEMID_COLOR_TABLE		SID_COLOR_TABLE
#define ITEMID_GRADIENT_LIST	SID_GRADIENT_LIST
#define ITEMID_HATCH_LIST		SID_HATCH_LIST
#define ITEMID_BITMAP_LIST		SID_BITMAP_LIST
#define ITEMID_DASH_LIST		SID_DASH_LIST
#define ITEMID_LINEEND_LIST 	SID_LINEEND_LIST
#include <svx/svxids.hrc>
#endif

#ifndef _REF_HXX
#include <tools/ref.hxx>
#endif

#ifndef _CTRLTOOL_HXX
#include <svtools/ctrltool.hxx>
#endif
#include <svx/flstitem.hxx>
#ifndef _SFXDISPATCH_HXX
#include <sfx2/dispatch.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX
#include <sfx2/viewfrm.hxx>
#endif

#include "app.hrc"
#include "strings.hrc"
#include "res_bmp.hrc"
#include "memchrt.hxx"
#include "schview.hxx"
#include "docshell.hxx"
#include "stlpool.hxx"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "schresid.hxx"

#include "viewshel.hxx"

/*************************************************************************
|*
|*  Zeichnen der DocShell (mittels der Hilfsklasse SchViewSpecial)
|*
\************************************************************************/

class SchViewSpecial : public SchView
{
	BOOL bDontRecurse;

 public:
	SchViewSpecial(SchChartDocShell* pDocSh, OutputDevice* pOutDev,
				   SchViewShell* pShell) :
		SchView(pDocSh, pOutDev, pShell),
		bDontRecurse (FALSE)
	{
	}

	virtual ~SchViewSpecial() {};

	// Wenn die View kein Invalidate() an den Fenstern durchfuehren soll, muss
	// man diese beiden folgenden Methoden ueberladen und entsprechend anders
	// reagieren.
	virtual void InvalidateOneWin(Window& rWin);

	virtual void InvalidateOneWin(Window& rWin, const Rectangle& rRect);

	BOOL &DontRecurse ()
	{
		return bDontRecurse;
	}
};

void SchViewSpecial::InvalidateOneWin(Window& rWin)
{
	Region aRegion;
	CompleteRedraw(&rWin, aRegion);
}

void SchViewSpecial::InvalidateOneWin(Window& rWin, const Rectangle& rRect)
{
	if (!bDontRecurse)
	{
		bDontRecurse = TRUE;
		CompleteRedraw(&rWin, rRect);
	}
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchChartDocShell::Draw( OutputDevice* pOut, const JobSetup& rSetup,
							 USHORT nAspect) throw()
{
	CHART_TRACE( "SchChartDocShell::Draw" );

	OutDevType eOutDevType = pOut->GetOutDevType();

    OutDevViewType eViewType =  pOut->GetOutDevViewType();
    BOOL bForceAutoColor = SvtAccessibilityOptions().GetIsAutomaticFontColor();
    BOOL bEnableAutoColor = TRUE;
    //#106611# don't use automatic colors in WYSIWYG Print Previews
    if(eViewType==OUTDEV_VIEWTYPE_PRINTPREVIEW
        && !SvtAccessibilityOptions().GetIsForPagePreviews())
    {
        bForceAutoColor = FALSE;
        bEnableAutoColor = FALSE;
    }

    pChDoc->GetOutliner()->EnableAutoColor(bEnableAutoColor);
    pChDoc->GetDrawOutliner().EnableAutoColor(bEnableAutoColor);

    pChDoc->GetOutliner()->ForceAutoColor(bForceAutoColor);
    pChDoc->GetDrawOutliner().ForceAutoColor(bForceAutoColor);

	Rectangle aVisArea = GetVisArea(ASPECT_CONTENT);

	if (!pChDoc->IsInitialized())
	{
		CHART_TRACE( "SchChartDocShell::Draw - Initializing" );
		SetVisArea(aVisArea);   // Groesse der Seite auf VisArea setzen
		pChDoc->Initialize();
	}

	pOut->IntersectClipRegion(aVisArea);

	SchViewSpecial* pChView = new SchViewSpecial(this, pOut, NULL);

	pChView->SetPageVisible (FALSE);
//    pChView->DontRecurse () = TRUE;

	// BM tried it out without offset and gives his okay. Nonetheless,
	// we agree to add an assert here.
	DBG_ASSERT(0 == aVisArea.Left() && 0 == aVisArea.Top() ,"SchChartDocShell::Draw: Offset not zero at ShowPage (!)");
	pChView->ShowSdrPage(pChView->GetModel()->GetPage(0));
	pChView->DontRecurse () = FALSE;

	if (eOutDevType != OUTDEV_WINDOW)
	{
		MapMode aOldMapMode = pOut->GetMapMode();

		if (eOutDevType == OUTDEV_PRINTER)
		{
			MapMode aMapMode = aOldMapMode;
			Point aOrigin = aMapMode.GetOrigin();
			aOrigin.X() += 1;
			aOrigin.Y() += 1;
			aMapMode.SetOrigin(aOrigin);
			pOut->SetMapMode(aMapMode);
		}

		Region aRegion (aVisArea);
		pChView->CompleteRedraw(pOut, aRegion);

		if (eOutDevType == OUTDEV_PRINTER)
			pOut->SetMapMode(aOldMapMode);
	}

	delete pChView;
}

/*************************************************************************
|*
|*	Bitmap der StyleFamily zurueckgeben (zunaechst Dummy)
|*
\************************************************************************/

SfxStyleSheetBasePool* SchChartDocShell::GetStyleSheetPool() throw()
{
	return (SfxStyleSheetBasePool*)pChDoc->GetStyleSheetPool();
}

/*************************************************************************
|*
|*	Vorlage einfuegen (zunaechst nur Dummy)
|*
\************************************************************************/

BOOL SchChartDocShell::Insert( SfxObjectShell &rSource, USHORT nSourceIdx1,
							   USHORT nSourceIdx2, USHORT nSourceIdx3,
							   USHORT &nIdx1, USHORT &nIdx2, USHORT &nIdx3,
							   USHORT &nDeleted )  throw()
{
	CHART_TRACE( "SchChartDocShell::Insert" );

	BOOL bRet = FALSE;

	if (INDEX_IGNORE == nIdx1 && CONTENT_STYLE == nSourceIdx1)
		nIdx1 = CONTENT_STYLE;

	if (CONTENT_STYLE == nSourceIdx1 && CONTENT_STYLE == nIdx1)
	{
		SfxStyleSheetBasePool* pHisPool  = rSource.GetStyleSheetPool();
		SfxStyleSheetBasePool* pMyPool	 = GetStyleSheetPool();
		SfxStyleSheetBase*	   pHisSheet = (*pHisPool)[nSourceIdx2];

		if (nIdx2 == INDEX_IGNORE)
			nIdx2 = pMyPool->Count();

		// wenn so eine Vorlage schon existiert: loeschen!
		String			aOldName(pHisSheet->GetName());
		SfxStyleFamily	eOldFamily = pHisSheet->GetFamily();

		SfxStyleSheetBase* pExist = pMyPool->Find(aOldName, eOldFamily);
		// USHORT nOldHelpId = pExist->GetHelpId(??? VB ueberlegt sich was);
		if (pExist)
		{
			// gleich wird's geloescht; vorher noch den Index feststellen
			SfxStyleSheetBase* pScan = pMyPool->First();
			USHORT nCount = 0;
			while(pScan)
			{
				if (pScan == pExist)
				{
					nDeleted = nCount;
					break;
				}
				nCount++;
				pScan = pMyPool->Next();
			}

			pMyPool->Erase(pExist);
			pExist = NULL;
		}

		SfxStyleSheetBase& rNewSheet = pMyPool->Make(aOldName, eOldFamily,
												pHisSheet->GetMask(), nIdx2);

		// ItemSet der neuen Vorlage fuellen
		rNewSheet.GetItemSet().Put(pHisSheet->GetItemSet());

		// wer bekommt den Neuen als Parent? wer benutzt den Neuen als Follow?
		SfxStyleSheetBase* pTestSheet = pMyPool->First();
		while (pTestSheet)
		{
			if (pTestSheet->GetFamily() == eOldFamily &&
				pTestSheet->HasParentSupport()		  &&
				pTestSheet->GetParent() == aOldName)
				pTestSheet->SetParent(aOldName); // Verknuepfung neu aufbauen

			if (pTestSheet->GetFamily() == eOldFamily &&
				pTestSheet->HasFollowSupport()		  &&
				pTestSheet->GetFollow() == aOldName)
				pTestSheet->SetFollow(aOldName); // Verknuepfung neu aufbauen

			pTestSheet = pMyPool->Next();
		}

		// hat der Neue einen Parent? wenn ja, mit gleichem Namen bei uns suchen
		if (pHisSheet->HasParentSupport())
		{
			const String& rParentName = pHisSheet->GetParent();
			if (0 != rParentName.Len())
			{
				SfxStyleSheetBase* pParentOfNew = pMyPool->Find(rParentName,
																eOldFamily);
				if (pParentOfNew)
					rNewSheet.SetParent(rParentName);
			}
		}

		// hat der Neue einen Follow? wenn ja, mit gleichem Namen bei uns suchen
		if (pHisSheet->HasFollowSupport())
		{
			const String& rFollowName = pHisSheet->GetFollow();
			if (0 != rFollowName.Len())
			{
				SfxStyleSheetBase* pFollowOfNew = pMyPool->Find(rFollowName,
																eOldFamily);
				if (pFollowOfNew)
					rNewSheet.SetFollow(rFollowName);
			}
		}

		// Model geaendert
		pChDoc->SetChanged(TRUE);
		SetModified(TRUE);

		bRet = TRUE;
	}

	return bRet;
}

/*************************************************************************
|*
|*	Vorlage entfernen (zunaechst nur Dummy)
|*
\************************************************************************/

BOOL SchChartDocShell::Remove( USHORT nIdx1, USHORT nIdx2, USHORT nIdx3 ) throw()
{

	CHART_TRACE( "SchChartDocShell::Remove" );

	BOOL bRet = FALSE;

	if (CONTENT_STYLE == nIdx1)
	{
		SfxStyleSheetBasePool* pMyPool	= GetStyleSheetPool();
		SfxStyleSheetBase*	   pMySheet =  (*pMyPool)[nIdx2];
		String			aName(pMySheet->GetName());
		String			aEmpty;
		SfxStyleFamily	eFamily = pMySheet->GetFamily();
		if (pMySheet)
		{
			pMyPool->Erase(pMySheet);
			bRet = TRUE;
		}

		SfxStyleSheetBase* pTestSheet = pMyPool->First();
		while (pTestSheet)
		{
			if (pTestSheet->GetFamily() == eFamily &&
				pTestSheet->HasParentSupport()	   &&
				pTestSheet->GetParent() == aName)
				pTestSheet->SetParent(aEmpty); // Verknuepfung aufloesen

			if (pTestSheet->GetFamily() == eFamily &&
				pTestSheet->HasFollowSupport()		  &&
				pTestSheet->GetFollow() == aName)
				pTestSheet->SetFollow(aEmpty); // Verknuepfung aufloesen

			pTestSheet = pMyPool->Next();
		}

	}

	// Model geaendert
	pChDoc->SetChanged(TRUE);
	SetModified(TRUE);

	return bRet;
}

/*************************************************************************
|*
|*	Chart updaten
|*
\************************************************************************/

void SchChartDocShell::UpdateChart( OutputDevice* pOut ) throw()
{
	pChDoc->BuildChart(TRUE);
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

Rectangle SchChartDocShell::GetVisArea(USHORT nAspect) const throw()
{
    return SfxObjectShell::GetVisArea((nAspect == ASPECT_THUMBNAIL) ?
										 ASPECT_CONTENT : nAspect);
}

/*************************************************************************
|*
|* VisArea fuer InPlace setzen
|*
\************************************************************************/

void SchChartDocShell::SetVisArea(const Rectangle& rRect) throw()
{
    // #i38809# minimum width/height is 2mm
    const long aMinExtent = 200;

	Rectangle aRect(rRect);
	aRect.SetPos(Point(0, 0));
    if( aRect.getWidth() < aMinExtent )
        aRect.setWidth( aMinExtent );
    if( aRect.getHeight() < aMinExtent )
        aRect.setHeight( aMinExtent );

    SfxObjectShell::SetVisArea( aRect );

    // #107434# propagate modified status to changed status at model
    // --> OD 2004-11-22 #i36203# - check, if not already changed, in order to
    // avoid incorrect change-/modify-notifications.
    if( pChDoc && IsModified() && !pChDoc->IsChanged() )
    // <--
        pChDoc->SetChanged( TRUE );

    if( GetCreateMode() != SFX_CREATE_MODE_INTERNAL )
	{
		Size aSize = GetVisArea(ASPECT_CONTENT).GetSize();

        SdrPage* pPage = pChDoc->GetPage(0);

		if(aSize.Width() > 0 && aSize.Height() > 0)
		{
			if( !pPage || aSize != pPage->GetSize() )
			{
				SfxViewFrame* pViewFrame = GetFrame();
				if( pViewFrame )
					pViewFrame->GetDispatcher()->Execute( SID_TOOL_SELECT,
														  SFX_CALLMODE_SYNCHRON );
				pChDoc->ResizePage(aSize);

                // notify the controller
                // note: the controller is only available in in-place
                Broadcast( SchVisAreaChangedHint( aRect ) );
			}
		}
	}
}

/*************************************************************************
|*
|* OLE-Status
|*
\************************************************************************/

ULONG SchChartDocShell::GetMiscStatus() const throw()
{
	// Chart soll stets selber resizen
    ULONG nStatus = SVOBJ_MISCSTATUS_SERVERRESIZE     |
					SVOBJ_MISCSTATUS_RESIZEONPRINTERCHANGE;

	return nStatus;
}

void SchChartDocShell::SetModified( BOOL bModified ) throw()
{
	if( IsEnableSetModified() )
	{
        SfxObjectShell::SetModified( bModified );
		DBG_ASSERT( pChDoc, "Invalid ChartModel" );
		if( ! pChDoc->IsLockedBuild())
			Broadcast( SfxSimpleHint( SFX_HINT_DOCCHANGED ) );
	}
}



