/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fugrid.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: ihi $ $Date: 2006/11/14 14:59:39 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"



#include "dlg_grid.hxx"

#include "schattr.hxx"
#include "schview.hxx"
#include "viewshel.hxx"
#include "fugrid.hxx"


/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchFuGrid::SchFuGrid(SchViewShell* pViewSh, SchWindow* pWin, SchView* pView,
				 ChartModel* pDoc, SfxRequest& rReq)
	   : SchFuPoor(pViewSh, pWin, pView, pDoc, rReq)
{
	UINT32	lValueX, lValueY, lFineX, lFineY;

	const SfxItemSet* pArgs = rReq.GetArgs();

	if( !pArgs )
	{
		SfxItemSet aNewAttr( pViewSh->GetPool(), ATTR_GRID_START, ATTR_GRID_END );

		// Zeichengitter
		lValueX = pView->GetGridCoarse().Width();
		lValueY = pView->GetGridCoarse().Height();
		aNewAttr.Put( SfxUInt32Item( ATTR_GRID_DRAW_X, lValueX ) );
		aNewAttr.Put( SfxUInt32Item( ATTR_GRID_DRAW_Y, lValueY ) );

		// Unterteilung
		lFineX = pView->GetGridFine().Width();
		lFineY = pView->GetGridFine().Height();
		aNewAttr.Put( SfxUInt16Item( ATTR_GRID_DIVISION_X, lFineX ? (UINT16) (lValueX / lFineX) : 0 ) );
		aNewAttr.Put( SfxUInt16Item( ATTR_GRID_DIVISION_Y, lFineY ? (UINT16) (lValueY / lFineY) : 0 ) );

		// Fangraster
		lValueX = long(pView->GetSnapGridWidthX());
		lValueY = long(pView->GetSnapGridWidthY());
		aNewAttr.Put( SfxUInt32Item( ATTR_GRID_SNAP_X, lValueX ) );
		aNewAttr.Put( SfxUInt32Item( ATTR_GRID_SNAP_Y, lValueY ) );

		// Ursprung
		Point aPt; // = pView->GetGridOrigin(); <-- ???
		aNewAttr.Put( SfxUInt32Item( ATTR_GRID_ORIGIN_X, aPt.X() ) );
		aNewAttr.Put( SfxUInt32Item( ATTR_GRID_ORIGIN_Y, aPt.Y() ) );

		aNewAttr.Put( SfxBoolItem( ATTR_GRID_USE, pView->IsGridSnap() ) );

//      FG: Mit dieser Zeile erhaelt man keinen modalen Dialog => Absturz falls ein Resize im Chart
//      stattfindet waehrend dieser Dialog geoeffnet ist.
//		SdGridDlg* pDlg = new SdGridDlg( &( pViewSh->GetViewFrame()->GetWindow() ), aNewAttr );
		SdGridDlg* pDlg = new SdGridDlg( NULL, aNewAttr );

		USHORT nResult = pDlg->Execute();

		switch( nResult )
		{
			case RET_OK:
			{
				pDlg->GetAttr( aNewAttr );
				rReq.Done( aNewAttr );

				pArgs = rReq.GetArgs();
			}
			break;

			default:
			{
				delete( pDlg );
			}
			return; // Abbruch
		}
		delete( pDlg );

		pChDoc->CanRebuild (TRUE);
	}
	else pChDoc->CanRebuild (FALSE);

	// Zeichengitter
	lValueX = ( ( const SfxUInt32Item& ) pArgs->
					Get( ATTR_GRID_DRAW_X ) ).GetValue();
	lValueY = ( ( const SfxUInt32Item& ) pArgs->
					Get( ATTR_GRID_DRAW_Y ) ).GetValue();
	pView->SetGridCoarse( Size( lValueX, lValueY ) );

	// Unterteilung
	UINT16 nValueX = ( ( const SfxUInt16Item& ) pArgs->
					Get( ATTR_GRID_DIVISION_X ) ).GetValue();
	UINT16 nValueY = ( ( const SfxUInt16Item& ) pArgs->
					Get( ATTR_GRID_DIVISION_Y ) ).GetValue();
	pView->SetGridFine( Size( nValueX ? (long) (lValueX / nValueX) : 0,
							  nValueY ? (long) (lValueY / nValueY) : 0 ) );

	// Fangraster
	lValueX = ( ( const SfxUInt32Item& ) pArgs->
					Get( ATTR_GRID_SNAP_X ) ).GetValue();
	lValueY = ( ( const SfxUInt32Item& ) pArgs->
					Get( ATTR_GRID_SNAP_Y ) ).GetValue();
	pView->SetSnapGridWidth(Fraction(lValueX, 1), Fraction(lValueY, 1));

	// Ursprung ???
	// lValueX = ( ( const SfxUInt32Item& ) pArgs->
	//				Get( ATTR_GRID_ORIGIN_X ) ).GetValue();
	// lValueY = ( ( const SfxUInt32Item& ) pArgs->
	//				Get( ATTR_GRID_ORIGIN_Y ) ).GetValue();
	// pView->SetGridOrigin( Point( lValueX, lValueY ) ); <-- ???

	pView->SetGridSnap( ( ( const SfxBoolItem& ) pArgs->
					Get( ATTR_GRID_USE ) ).GetValue() );
}



