/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: uninsleg.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 20:20:08 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"

//svdraw.hxx
//#define _SVDRAW_HXX
#define _SDR_NOITEMS
#define _SDR_NOTOUCH
#define _SDR_NOTRANSFORM
//#define _SDR_NOOBJECTS
//#define _SDR_NOVIEWS
#define _SDR_NOVIEWMARKER
#define _SDR_NODRAGMETHODS
#define _SDR_NOUNDO
#define _SDR_NOXOUTDEV



#include "schattr.hxx"
#define ITEMID_CHARTLEGENDPOS	SCHATTR_LEGEND_POS
#include <svx/chrtitem.hxx>

#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "uninsleg.hxx"

TYPEINIT1(SchUndoInsertLegend, SchUndoAction);


/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchUndoInsertLegend::Undo()
{
	SfxItemSet aAttr(rDoc.GetLegendAttr());
	aAttr.Put(SvxChartLegendPosItem(eOldLegendPos));
	rDoc.SetShowLegend (bOldVisibility);
	rDoc.ChangeLegendAttr(aAttr);//, FALSE);
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchUndoInsertLegend::Redo()
{
	SfxItemSet aAttr (rDoc.GetLegendAttr());
	aAttr.Put(SvxChartLegendPosItem(eNewLegendPos));
	rDoc.SetShowLegend (bNewVisibility);
	rDoc.ChangeLegendAttr(aAttr);//, FALSE);
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

BOOL SchUndoInsertLegend::CanRepeat(SfxRepeatTarget& rView) const
{
	return FALSE;
}



