/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: schdrgmt.cxx,v $
 *
 *  $Revision: 1.11 $
 *
 *  last change: $Author: ihi $ $Date: 2006/11/14 15:03:17 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"

// header for SdrPageView
#ifndef _SVDPAGV_HXX
#include <svx/svdpagv.hxx>
#endif
// header for SdrDragView
#ifndef _SVDDRGV_HXX
#include <svx/svddrgv.hxx>
#endif
// header for XOutputDevice
#ifndef _XOUTX_HXX
#include <svx/xoutx.hxx>
#endif
// header for SdrPathObj
#ifndef _SVDOPATH_HXX
#include <svx/svdopath.hxx>
#endif

#ifndef _BGFX_MATRIX_B2DHOMMATRIX_HXX
#include <basegfx/matrix/b2dhommatrix.hxx>
#endif

#include "chtmodel.hxx"
#include "datapoin.hxx"
#include "schview.hxx"
#include "schdrgmt.hxx"
#include "schresid.hxx"
#include "strings.hrc"

//************************************************************
//   SchDragConstrainedToVector
//************************************************************

TYPEINIT1(SchDragConstrainedToVector,SdrDragMethod);

SchDragConstrainedToVector::SchDragConstrainedToVector( SdrDragView& rNewView, ::basegfx::B2DVector aConstraint, double fCurrPercent ) :
		SdrDragMethod( rNewView ),
		aConstraintVector( aConstraint ),
		fStartShift( fCurrPercent/100.0 ),
		fRadiusPercent( 0.0 )
{
	fConstraintVecScalar = aConstraint.scalar( aConstraint );
}

void SchDragConstrainedToVector::TakeComment( String& rStr ) const
{
	rStr = String( SchResId( STR_PIE_SEGMENT_EXPLODED ) );
	rStr.SearchAndReplaceAscii( "$(PERCENT)", String::CreateFromInt32( (long)fRadiusPercent ));
}

FASTBOOL SchDragConstrainedToVector::Beg()
{
	aTranslationVector = ::basegfx::B2DVector( DragStat().GetStart().X(), DragStat().GetStart().Y() );
	DragStat().SetActionRect( GetMarkedRect() );

	SdrPageView* pPV = rView.GetSdrPageView();

	if( pPV )
	{
		SdrObject* pObj = rView.GetMarkedObjectList().GetMark( 0 )->GetMarkedSdrObj();
		if( pObj )
		{
			pPV->setDragPoly0(pObj->TakeXorPoly(sal_True));
			pPV->setDragPoly(pPV->getDragPoly0());
		}
	}

	Show();

	return TRUE;
}

void SchDragConstrainedToVector::Mov(const Point& rPnt)
{
	if( DragStat().CheckMinMoved( rPnt ) )
	{
		::basegfx::B2DVector aShiftVector(( ::basegfx::B2DVector( rPnt.X(), rPnt.Y() ) - aTranslationVector ));
		double fShift = aConstraintVector.scalar( aShiftVector ) / fConstraintVecScalar;	// projection

		if( fShift )
		{
			if( fShift < -fStartShift )
				fShift = -fStartShift;
			else if( fShift > 1.0 - fStartShift )
				fShift = 1.0 - fStartShift;

			fRadiusPercent = fShift * 100.0;

			::basegfx::B2DVector aNewPosVect = aTranslationVector + (aConstraintVector * fShift);
			Point aNewPos = Point( (long)(aNewPosVect.getX()), (long)(aNewPosVect.getY()) );
			if( aNewPos != DragStat().GetNow() )
			{
				DragStat().NextMove( aNewPos );
				Hide();
				SdrPageView* pPV = rView.GetSdrPageView();

				if( pPV->HasMarkedObjPageView() )
				{
					::basegfx::B2DPolyPolygon aDragPolyPoygon(pPV->getDragPoly0());
					::basegfx::B2DHomMatrix aMatrix;

					aMatrix.translate(DragStat().GetDX(), DragStat().GetDY());
					aDragPolyPoygon.transform(aMatrix);

					pPV->setDragPoly(aDragPolyPoygon);
				}
				Show();
			}
		}
	}
}

FASTBOOL SchDragConstrainedToVector::End(FASTBOOL bCopy)
{
//  	rView.MoveMarkedObj( Size( DragStat().GetDX(), DragStat().GetDY() ), bCopy );
	Hide();

	// this is done to transfer the result to the chart objects
	// If sometimes the pies are more specific objects than SdrCircObjs
	// they will get a method for the transfer
	ChartModel& rModel = SAL_STATIC_CAST( SchView&, rView ).GetDoc();

	SdrObject*  pObj = rView.GetMarkedObjectList().GetMark(0)->GetMarkedSdrObj();

	SchDataPoint* pPoint = GetDataPoint( *pObj );
	DBG_ASSERT( pPoint, "Pie has no data point user data" );

	if( pPoint )
		rModel.SetPieSegOfs( pPoint->GetCol(),
                             rModel.PieSegOfs( pPoint->GetCol())
                             + (long)fRadiusPercent );

	return TRUE;
}

Pointer SchDragConstrainedToVector::GetPointer() const
{
	return Pointer(POINTER_MOVE);
}

FASTBOOL SchDragConstrainedToVector::IsMoveOnly() const
{
	return TRUE;
}

