/*
 * SelectPathVisualPanel.java
 *
 * Created on February 12, 2003
 */

package org.openoffice.netbeans.modules.office.wizard;

import java.util.Hashtable;
import java.util.Enumeration;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;

import org.openide.util.NbBundle;
import org.openoffice.idesupport.SVersionRCFile;
import org.openoffice.idesupport.OfficeInstallation;
import org.openoffice.netbeans.modules.office.options.OfficeSettings;

/** A single panel for a wizard - the GUI portion.
 *
 * @author tomaso
 */
public class SelectPathVisualPanel extends javax.swing.JPanel {
    
    /** The wizard panel descriptor associated with this GUI panel.
     * If you need to fire state changes or something similar, you can
     * use this handle to do so.
     */
    private final SelectPathPanel panel;
    
    /** Create the wizard panel and set up some basic properties. */
    public SelectPathVisualPanel(SelectPathPanel panel) {
        this.panel = panel;
        initComponents();
        OfficeInstallation orig = panel.getSelectedPath();

        try {
            Enumeration enumer = SVersionRCFile.createInstance().getVersions();

            while (enumer.hasMoreElements()) {
                OfficeInstallation oi = (OfficeInstallation)enumer.nextElement();
                installationsComboBox.addItem(oi);
            }
        }
        catch (IOException ioe) {
            installationsComboBox.addItem("<empty>");
        }

        if (orig != null) {
            installationsComboBox.setSelectedItem(orig);
            installPath.setText(orig.getPath());
        }

        installationsComboBox.addActionListener(
            new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
                    installationsComboBoxActionPerformed(evt);
                }
            }
        );

        // Provide a name in the title bar.
        setName(NbBundle.getMessage(SelectPathVisualPanel.class, "TITLE_SelectPathVisualPanel"));
        /*
        // Optional: provide a special description for this pane.
        // You must have turned on WizardDescriptor.WizardPanel_helpDisplayed
        // (see descriptor in standard iterator template for an example of this).
        try {
            putClientProperty("WizardPanel_helpURL", // NOI18N
                new URL("nbresloc:/org/openoffice/netbeans/modules/office/wizard/SelectPathVisualHelp.html")); // NOI18N
        } catch (MalformedURLException mfue) {
            throw new IllegalStateException(mfue.toString());
        }
         */
    }
    
    private void installationsComboBoxActionPerformed(
        java.awt.event.ActionEvent evt) {

        OfficeInstallation oi =
            (OfficeInstallation)installationsComboBox.getSelectedItem();

        installPath.setText(oi.getPath());
        panel.setSelectedPath(oi);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        installPath = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        installationsComboBox = new javax.swing.JComboBox();
        jPanel1 = new javax.swing.JPanel();
        browseButton = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        setPreferredSize(new java.awt.Dimension(600, 300));
        jLabel1.setText("Installations Detected");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 11, 2);
        add(jLabel1, gridBagConstraints);

        installPath.setEditable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 11, 11);
        add(installPath, gridBagConstraints);

        jLabel2.setText("Installation Directory");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 11, 12);
        add(jLabel2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(11, 0, 11, 11);
        add(installationsComboBox, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.weighty = 1.0;
        add(jPanel1, gridBagConstraints);

        browseButton.setText("Browse...");
        browseButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                browseButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        add(browseButton, gridBagConstraints);

    }//GEN-END:initComponents

    private void browseButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browseButtonActionPerformed
        // Add your handling code here:
        File target = null;
        
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        int result = chooser.showDialog(null, null);
        
        if (result == JFileChooser.APPROVE_OPTION) {
            target = chooser.getSelectedFile();

            String path;
            try {
                path = target.getCanonicalPath();
            }
            catch (IOException ioe) {
                path = target.getAbsolutePath();
            }
            
            OfficeInstallation oi = new OfficeInstallation(path, path);

            if (oi.supportsFramework()) {
                installPath.setText(path);
                panel.setSelectedPath(oi);
            }
        }

    }//GEN-LAST:event_browseButtonActionPerformed
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField installPath;
    private javax.swing.JButton browseButton;
    private javax.swing.JComboBox installationsComboBox;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    // End of variables declaration//GEN-END:variables
}
