/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: parametricpolypolygon.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: kz $ $Date: 2006/12/13 15:43:10 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SLIDESHOW_PARAMETRICPOLYPOLYGON_HXX
#define _SLIDESHOW_PARAMETRICPOLYPOLYGON_HXX

#include <basegfx/polygon/b2dpolypolygon.hxx>

#include <boost/shared_ptr.hpp>


/* Definition of ParametricPolyPolygon interface */

namespace slideshow
{
    namespace internal
    {
        /** Interface defining a parametric poly-polygon.

        	This interface defines a poly-polygon, whose actual shape
        	is parameterized by a floating point value. This is
        	e.g. used to generically access the various clip polygon
        	generators for transition effects.

            Since for every parametric poly-polygon, there is a set of
            variations, which can easily be generated by simple
            transformations or change in parameter range sweep
            direction, objects implementing this interface only
            generate <em>one</em> prototypical instance of the
            parametric poly-polygon. Generally speaking, the main
            effect direction should be horizontal, it should make
            increasingly more area visible (transition 'in'), and when
            there is a designated direction given, that should be
            left-to-right.
         */
        class ParametricPolyPolygon
        {
        public:
            virtual ~ParametricPolyPolygon() {}

            /** Retrieve the poly-polygon for value t.

                @param t
                Current parameter value to retrieve the corresponding
                poly-polygon for. Permissible values for t must be in
                the range [0,1].

                @return a poly-polygon corresponding to the given
                parameter value. The poly-polygon is interpreted as
                living in the unit rectangle (i.e. [0,1]x[0,1]), but
                is not necessarily constrained to completely lie in
                this area (this very much depends on the actual effect
                to be generated). Although, from a performance
                perspective, it currently <em>is</em> advantageous to
                try to keep the poly-polygon within these bounds (at
                least if there are no hard reasons not to do so),
                because then reversion or out transformations are
                potentially faster to compute (see the
                TransitionInfo::meReverseMethod member in
                transitionfactory.cxx). Furthermore, if one of the
                polygon modifications involve subtraction (also see
                TransitionInfo::meReverseMethod), all generated
                polygons should be oriented clock-wise
                (i.e. traversing the polygon vertices with increasing
                vertex index should generate a clock-wise movement).
             */
            virtual ::basegfx::B2DPolyPolygon operator()( double t ) = 0;
        };

        typedef ::boost::shared_ptr< ParametricPolyPolygon > ParametricPolyPolygonSharedPtr;

    }
}

#endif /* _SLIDESHOW_PARAMETRICPOLYPOLYGON_HXX */
