/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: viewcoll.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 23:24:47 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sw.hxx"



#include "cmdid.h"
#include "uiitems.hxx"

#ifndef _LIST_HXX //autogen
#include <tools/list.hxx>
#endif

#ifndef _SV_WINDOW_HXX //autogen
#include <vcl/window.hxx>
#endif
#ifndef _SFXREQUEST_HXX //autogen
#include <sfx2/request.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX //autogen
#include <sfx2/viewfrm.hxx>
#endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
#ifndef _RSCSFX_HXX //autogen
#include <rsc/rscsfx.hxx>
#endif


#include "errhdl.hxx"
#include "view.hxx"
#include "wrtsh.hxx"
#include "basesh.hxx"


void SwView::ExecColl(SfxRequest &rReq)
{
	Window *pMDI = &GetViewFrame()->GetWindow();
	const SfxItemSet* pArgs = rReq.GetArgs();
	const SfxPoolItem* pItem = 0;
	USHORT nWhich = rReq.GetSlot();
	switch( nWhich )
	{
		case FN_SET_PAGE:
		{
			DBG_ASSERT(!this, "Not implemented")
		}
		break;
		case FN_SET_PAGE_STYLE:
		{
			if( pArgs )
			{
				if (pArgs &&
					SFX_ITEM_SET == pArgs->GetItemState( nWhich , TRUE, &pItem ))
				{
					if( ((SfxStringItem*)pItem)->GetValue() !=
											GetWrtShell().GetCurPageStyle(FALSE) )
					{
						SfxStringItem aName(SID_STYLE_APPLY,
								   ((SfxStringItem*)pItem)->GetValue());
						SfxUInt16Item aFamItem( SID_STYLE_FAMILY,
											SFX_STYLE_FAMILY_PAGE);
						SwPtrItem aShell(FN_PARAM_WRTSHELL, GetWrtShellPtr());
						SfxRequest aReq(SID_STYLE_APPLY, 0, GetPool());
						aReq.AppendItem(aName);
						aReq.AppendItem(aFamItem);
						aReq.AppendItem(aShell);
						GetCurShell()->ExecuteSlot(aReq);
					}
				}
			}
			else
			{
				SfxRequest aReq(FN_FORMAT_PAGE_DLG, 0, GetPool());
				GetCurShell()->ExecuteSlot(aReq);
			}
		}
		break;
		default:
			ASSERT(FALSE, falscher CommandProcessor fuer Dispatch);
			return;
	}
}



