/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: offmgr_appimp.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: hr $ $Date: 2007/01/02 16:52:03 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "appimp.hxx"

#ifndef _CONFIG_HXX
#include <tools/config.hxx>
#endif
#ifndef _SFXSMPLHINT_HXX //autogen
#include <svtools/smplhint.hxx>
#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _SV_SETTINGS_HXX
#include <vcl/settings.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <svtools/pathoptions.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_ACCESSIBILITYOPTIONS_HXX
#include "svtools/accessibilityoptions.hxx"
#endif

#define _SVSTDARR_USHORTS
#include <svtools/svstdarr.hxx>

#ifndef _XTABLE_HXX
#include <bf_svx/xtable.hxx>
#endif
#ifndef _XPOOL_HXX
#include <bf_svx/xpool.hxx>
#endif

#include "app.hxx"
#include "osplcfg.hxx"
#include "htmlcfg.hxx"
#include "fltrcfg.hxx"
#include "ofaaccfg.hxx"
#include "apearcfg.hxx"
#include "splnote.hxx"
namespace binfilter {

#define HELP_TIP_TIMEOUT 0xffff     // max. timeout setting to pretend a non-timeout

using namespace ::com::sun::star::uno;

// ------------------------------------------------------------------------

/*N*/ OfficeData_Impl::OfficeData_Impl( SfxBroadcaster& rBroadcast) :
/*N*/ 		pHtmlOptions( NULL ),
/*N*/ 		pAutoCorrCfg( NULL ),
/*N*/         //pBasicIDE( NULL ),
/*N*/ 		pSearchEngCfg( NULL ),
/*N*/ 		pFontSubstCfg( NULL ),
/*N*/ 		pStdColorTable( NULL ),
/*N*/ 		pXOutdevItemPool( NULL ),
/*N*/ 		pTabAppearanceConfig( NULL ),
/*N*/ 		pSpellNote( NULL ),
/*N*/ 		pWordDeInitFct( NULL ),
/*N*/ 		pFilterOptions( NULL ),
/*N*/ 		nChangeUserDataEvent( 0 ),
/*N*/         bDoSearchCfg( sal_True ),
/*N*/         pAccessibilityOptions(new SvtAccessibilityOptions)
/*N*/ {
/*N*/     StartListening(rBroadcast);
/*N*/     StartListening(*pAccessibilityOptions);
/*N*/ }
/* -----------------------------22.05.2002 13:50------------------------------

 ---------------------------------------------------------------------------*/
/*N*/ OfficeData_Impl::~OfficeData_Impl()
/*N*/ {
/*N*/     delete pAccessibilityOptions;
/*N*/ }
/* -----------------------------22.05.2002 13:24------------------------------

 ---------------------------------------------------------------------------*/
/*N*/ void OfficeData_Impl::SetVCLSettings()
/*N*/ {
/*N*/ 	AllSettings aAllSettings = Application::GetSettings();
/*N*/     HelpSettings aHelpSettings = aAllSettings.GetHelpSettings();
/*N*/     aHelpSettings.SetTipTimeout(
/*N*/         pAccessibilityOptions->GetIsHelpTipsDisappear() ?
/*N*/             pAccessibilityOptions->GetHelpTipSeconds() * 1000 : HELP_TIP_TIMEOUT);
/*N*/     aAllSettings.SetHelpSettings(aHelpSettings);
/*N*/     if(aAllSettings.GetStyleSettings().GetUseSystemUIFonts() != pAccessibilityOptions->GetIsSystemFont() )
/*N*/     {
/*?*/         StyleSettings aStyleSettings = aAllSettings.GetStyleSettings();
/*?*/         aStyleSettings.SetUseSystemUIFonts( pAccessibilityOptions->GetIsSystemFont()  );
/*?*/         aAllSettings.SetStyleSettings(aStyleSettings);
/*?*/         Application::MergeSystemSettings( aAllSettings );
/*N*/     }
/*N*/     Application::SetSettings(aAllSettings);
/*N*/ }

// ------------------------------------------------------------------------

/*N*/ OfaHtmlOptions*	OfficeApplication::GetHtmlOptions()
/*N*/ {
/*N*/ 	if(!pDataImpl->pHtmlOptions)
/*N*/ 	{
/*N*/ 		pDataImpl->pHtmlOptions = new OfaHtmlOptions();
/*N*/ 	}
/*N*/ 	return pDataImpl->pHtmlOptions;
/*N*/ }

// ------------------------------------------------------------------------

/*N*/ OfaFilterOptions* OfficeApplication::GetFilterOptions()
/*N*/ {
/*N*/ 	if( !pDataImpl->pFilterOptions )
/*N*/ 	{
/*N*/ 		pDataImpl->pFilterOptions = new OfaFilterOptions();
/*N*/ 	}
/*N*/ 	return pDataImpl->pFilterOptions;
/*N*/ }

// ------------------------------------------------------------------------

/*N*/ XColorTable* OfficeApplication::GetStdColorTable()
/*N*/ {
/*N*/ 	if(!pDataImpl->pStdColorTable)
/*N*/ 		pDataImpl->pStdColorTable = new XColorTable( SvtPathOptions().GetPalettePath() );
/*N*/ 	return pDataImpl->pStdColorTable;
/*N*/ }

// ------------------------------------------------------------------------


// ------------------------------------------------------------------------
#ifdef WNT
/*N*/ OfaTabAppearanceCfg*	OfficeApplication::GetTabAppearanceConfig()
/*N*/ {
/*N*/ 	if(!pDataImpl->pTabAppearanceConfig)
/*N*/ 	{
/*N*/ 		pDataImpl->pTabAppearanceConfig = new OfaTabAppearanceCfg();
/*N*/ 	}
/*N*/ 	return pDataImpl->pTabAppearanceConfig;
/*N*/ }
#endif

// ------------------------------------------------------------------------

/*N*/ void OfficeApplication::CreateDataImpl()
/*N*/ {
/*N*/ }

// ------------------------------------------------------------------------
// ConfigItems muessen frueher geloescht werden
/*N*/ void OfficeData_Impl::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
/*N*/ {
/*N*/     if(rHint.ISA(SfxSimpleHint))
/*N*/     {
/*N*/         switch(((SfxSimpleHint&)rHint).GetId())
/*N*/         {
/*N*/             case SFX_HINT_DEINITIALIZING:
/*N*/             {
/*N*/                 DELETEZ(pHtmlOptions		);
/*N*/                 DELETEZ(pAutoCorrCfg		);
/*N*/                 DELETEZ(pTabAppearanceConfig);
/*N*/                 DELETEZ(pFilterOptions		);
/*N*/             }
/*N*/             break;
/*N*/ 
/*N*/             case SFX_HINT_ACCESSIBILITY_CHANGED :
/*?*/                 SetVCLSettings();
/*N*/             break;
/*N*/         }
/*N*/     }
/*N*/ }
// ------------------------------------------------------------------------
/*N*/ void OfficeApplication::DeleteDataImpl()
/*N*/ {
/*N*/ 
/*N*/ 	delete pDataImpl->pStdColorTable;
/*N*/ 	delete pDataImpl->pXOutdevItemPool;
/*N*/ 	delete pDataImpl->pSpellNote;
/*N*/ 	delete pDataImpl->pSearchEngCfg;
/*N*/ 	delete pDataImpl->pFontSubstCfg;
/*N*/ 	delete pDataImpl;
/*N*/ }

// ------------------------------------------------------------------------

	// Autokorrektur
/*N*/ OfaAutoCorrCfg*	OfficeApplication::GetAutoCorrConfig()
/*N*/ {
/*N*/ 	if( !pDataImpl->pAutoCorrCfg )
/*N*/ 	{
/*N*/ 		pDataImpl->pAutoCorrCfg = new OfaAutoCorrCfg;
/*N*/ 	}
/*N*/ 	return pDataImpl->pAutoCorrCfg;
/*N*/ }

// ------------------------------------------------------------------------

	// Autokorrektur
/*N*/ SvxAutoCorrect*	OfficeApplication::GetAutoCorrect()
/*N*/ {
/*N*/ 	if( !pDataImpl->pAutoCorrCfg )
/*?*/ 		GetAutoCorrConfig();
/*N*/ 	return pDataImpl->pAutoCorrCfg->GetAutoCorrect();
/*N*/ }

/*N*/IMPL_LINK( OfficeApplication, ImplGetAutoCorrect, void*, EMPTY_ARG )
/*N*/{
/*N*/	return (long)GetAutoCorrect();
/*N*/}

// ------------------------------------------------------------------------

}
