/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_tbinsert.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 15:42:56 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// System - Includes -----------------------------------------------------

#include <string> // HACK: prevent conflict between STLPORT and Workshop headers

#ifdef PCH
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

#include <svtools/intitem.hxx>
#include <bf_sfx2/dispatch.hxx>

#ifndef _SVTOOLS_IMGDEF_HXX
#include <svtools/imgdef.hxx>
#endif

#include "tbinsert.hxx"
#include "tbinsert.hrc"
#include "scmod.hxx"
#include "bf_sc.hrc"
namespace binfilter {

// -----------------------------------------------------------------------

/*N*/ SFX_IMPL_TOOLBOX_CONTROL( ScTbxInsertCtrl, SfxUInt16Item);

//------------------------------------------------------------------
//
//	ToolBox - Controller
//
//------------------------------------------------------------------

/*N*/ ScTbxInsertCtrl::ScTbxInsertCtrl( USHORT nId, ToolBox& rTbx, SfxBindings& rBind ) :
/*N*/ 		SfxToolBoxControl( nId, rTbx, rBind ),
/*N*/ 		nLastSlotId(0)
/*N*/ {
/*N*/ }

/*N*/ __EXPORT ScTbxInsertCtrl::~ScTbxInsertCtrl()
/*N*/ {
/*N*/ }

/*N*/ void __EXPORT ScTbxInsertCtrl::StateChanged( USHORT nSID, SfxItemState eState,
/*N*/ 											  const SfxPoolItem* pState )
/*N*/ {
/*N*/ 	GetToolBox().EnableItem( GetId(), (GetItemState(pState) != SFX_ITEM_DISABLED) );
/*N*/ 
/*N*/ 	if( eState == SFX_ITEM_AVAILABLE )
/*N*/ 	{
/*N*/ 		const SfxUInt16Item* pItem = PTR_CAST( SfxUInt16Item, pState );
/*N*/ 		if(pItem)
/*N*/ 		{
/*N*/ 			nLastSlotId = pItem->GetValue();
/*N*/ 			USHORT nImageId = nLastSlotId ? nLastSlotId : GetId();
/*N*/             Image aImage = GetBindings().GetImageManager()->GetImage( nImageId,
/*N*/ 		           		GetToolBox().GetDisplayBackground().GetColor().IsDark(),
/*N*/ 		           		SC_MOD() );
/*N*/ 			GetToolBox().SetItemImage(GetId(), aImage);
/*N*/ 		}
/*N*/ 	}
/*N*/ }




//------------------------------------------------------------------
//
//	Popup - Window
//
//------------------------------------------------------------------










}
