/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_undoblk3.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 16:58:51 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#endif

#pragma hdrstop

//----------------------------------------------------------------------------

#define _MACRODLG_HXX
#define _BIGINT_HXX
#define _SVDXOUT_HXX
#define _SVDATTR_HXX
#define _SVDSURO_HXX

// INCLUDE -------------------------------------------------------------------

#include "scitems.hxx"
#include <bf_svx/boxitem.hxx>

#include "undoblk.hxx"
#include "bf_sc.hrc"
#include "globstr.hrc"
#include "patattr.hxx"
#include "docpool.hxx"
#include "docsh.hxx"
#include "tabvwsh.hxx"

#ifndef _SFX_SRCHITEM_HXX
#include <bf_sfx2/srchitem.hxx>
#endif

namespace binfilter {

// STATIC DATA ---------------------------------------------------------------



// To Do:
/*A*/	// SetOptimalHeight auf Dokument, wenn keine View


//============================================================================
//	class ScUndoDeleteContents
//
//	Inhalte loeschen

//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------





//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//============================================================================
//	class ScUndoFillTable
//
//	Tabellen ausfuellen
//	(Bearbeiten|Ausfuellen|...)

//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------





//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//============================================================================
//	class ScUndoSelectionAttr
//
//	Zellformat aendern

//----------------------------------------------------------------------------

/*N*/ ScUndoSelectionAttr::ScUndoSelectionAttr( ScDocShell* pNewDocShell,
/*N*/ 				const ScMarkData& rMark,
/*N*/ 				USHORT nStartX, USHORT nStartY, USHORT nStartZ,
/*N*/ 				USHORT nEndX, USHORT nEndY, USHORT nEndZ,
/*N*/ 				ScDocument* pNewUndoDoc, BOOL bNewMulti,
/*N*/ 				const ScPatternAttr* pNewApply,
/*N*/ 				const SvxBoxItem* pNewOuter, const SvxBoxInfoItem* pNewInner )
/*N*/ 		//
/*N*/ 	:	ScSimpleUndo( pNewDocShell ),
/*N*/ 		//
/*N*/ 		aMarkData	( rMark ),
/*N*/ 		aRange		( nStartX, nStartY, nStartZ, nEndX, nEndY, nEndZ ),
/*N*/ 		pUndoDoc	( pNewUndoDoc ),
/*N*/ 		bMulti		( bNewMulti )
/*N*/ {
/*N*/ 	ScDocumentPool* pPool = pDocShell->GetDocument()->GetPool();
/*N*/ 	pApplyPattern = (ScPatternAttr*) &pPool->Put( *pNewApply );
/*N*/ 	pLineOuter = pNewOuter ? (SvxBoxItem*) &pPool->Put( *pNewOuter ) : NULL;
/*N*/ 	pLineInner = pNewInner ? (SvxBoxInfoItem*) &pPool->Put( *pNewInner ) : NULL;
/*N*/ }


//----------------------------------------------------------------------------

/*N*/ __EXPORT ScUndoSelectionAttr::~ScUndoSelectionAttr()
/*N*/ {
/*N*/ 	ScDocumentPool* pPool = pDocShell->GetDocument()->GetPool();
/*N*/ 	pPool->Remove(*pApplyPattern);
/*N*/ 	if (pLineOuter)
/*?*/ 		pPool->Remove(*pLineOuter);
/*N*/ 	if (pLineInner)
/*?*/ 		pPool->Remove(*pLineInner);
/*N*/ 
/*N*/ 	delete pUndoDoc;
/*N*/ }


//----------------------------------------------------------------------------

/*N*/ String __EXPORT ScUndoSelectionAttr::GetComment() const
/*N*/ {
/*N*/ 	//"Attribute" "/Linien"
/*N*/ 	return ScGlobal::GetRscString( pLineOuter ? STR_UNDO_SELATTRLINES : STR_UNDO_SELATTR );
/*N*/ }


//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------

/*N*/ BOOL __EXPORT ScUndoSelectionAttr::CanRepeat(SfxRepeatTarget& rTarget) const
/*N*/ {
/*N*/ 	return (rTarget.ISA(ScTabViewTarget));
/*N*/ }


//============================================================================
//	class ScUndoAutoFill
//
//	Auto-Fill (nur einfache Bloecke)

//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------





//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//============================================================================
//	class ScUndoMerge
//
//	Zellen zusammenfassen / Zusammenfassung aufheben

//----------------------------------------------------------------------------

/*N*/ ScUndoMerge::ScUndoMerge( ScDocShell* pNewDocShell,
/*N*/ 							USHORT nStartX, USHORT nStartY, USHORT nStartZ,
/*N*/ 							USHORT nEndX, USHORT nEndY, USHORT nEndZ,
/*N*/ 							BOOL bNewDoMerge, ScDocument* pNewUndoDoc )
/*N*/ 		//
/*N*/ 	:	ScSimpleUndo( pNewDocShell ),
/*N*/ 		//
/*N*/ 		aRange	( nStartX, nStartY, nStartZ, nEndX, nEndY, nEndZ ),
/*N*/ 		bDoMerge( bNewDoMerge ),
/*N*/ 		pUndoDoc( pNewUndoDoc )
/*N*/ {
/*N*/ }


//----------------------------------------------------------------------------

/*N*/ __EXPORT ScUndoMerge::~ScUndoMerge()
/*N*/ {
/*N*/ 	delete pUndoDoc;
/*N*/ }


//----------------------------------------------------------------------------

/*N*/ String __EXPORT ScUndoMerge::GetComment() const
/*N*/ {
/*N*/ 	// "Zusammenfassen" "Zusammenfassung aufheben"
/*N*/ 	return bDoMerge ?
/*N*/ 		ScGlobal::GetRscString( STR_UNDO_MERGE ) :
/*N*/ 		ScGlobal::GetRscString( STR_UNDO_REMERGE );
/*N*/ }


//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------

/*N*/ BOOL __EXPORT ScUndoMerge::CanRepeat(SfxRepeatTarget& rTarget) const
/*N*/ {
/*N*/ 	return (rTarget.ISA(ScTabViewTarget));
/*N*/ }


//============================================================================
//	class ScUndoAutoFormat
//
//		Auto-Format (nur einfache Bloecke)

//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//============================================================================
//	class ScUndoReplace
//
//		Ersetzen

//----------------------------------------------------------------------------

/*N*/ ScUndoReplace::ScUndoReplace( ScDocShell* pNewDocShell, const ScMarkData& rMark,
/*N*/ 									USHORT nCurX, USHORT nCurY, USHORT nCurZ,
/*N*/ 									const String& rNewUndoStr, ScDocument* pNewUndoDoc,
/*N*/ 									const SvxSearchItem* pItem )
/*N*/ 		//
/*N*/ 	:	ScSimpleUndo( pNewDocShell ),
/*N*/ 		//
/*N*/ 		aMarkData	( rMark ),
/*N*/ 		aCursorPos	( nCurX, nCurY, nCurZ ),
/*N*/ 		aUndoStr	( rNewUndoStr ),
/*N*/ 		pUndoDoc	( pNewUndoDoc )
/*N*/ {
/*?*/ 	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pSearchItem = new SvxSearchItem( *pItem );
/*N*/ }


//----------------------------------------------------------------------------

/*N*/ __EXPORT ScUndoReplace::~ScUndoReplace()
/*N*/ {
/*N*/ 	delete pUndoDoc;
/*N*/ 	delete pSearchItem;
/*N*/ }


//----------------------------------------------------------------------------


//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//============================================================================
//	class ScUndoTabOp
//
//	Mehrfachoperation (nur einfache Bloecke)

//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//============================================================================
//	class ScUndoSpelling
//
//	Spelling

//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------


//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//============================================================================
//	class ScUndoRefreshLink
//
//	Link aktualisieren / aendern

//----------------------------------------------------------------------------

/*N*/ ScUndoRefreshLink::ScUndoRefreshLink( ScDocShell* pNewDocShell,
/*N*/ 									ScDocument* pNewUndoDoc )
/*N*/ 		//
/*N*/ 	:	ScSimpleUndo( pNewDocShell ),
/*N*/ 		//
/*N*/ 		pUndoDoc( pNewUndoDoc ),
/*N*/ 		pRedoDoc( NULL )
/*N*/ {
/*N*/ 	ScDocument* pDoc = pDocShell->GetDocument();
/*N*/ }


//----------------------------------------------------------------------------

/*N*/ __EXPORT ScUndoRefreshLink::~ScUndoRefreshLink()
/*N*/ {
/*N*/ 	delete pUndoDoc;
/*N*/ 	delete pRedoDoc;
/*N*/ }


//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//============================================================================
//	class ScUndoInsertAreaLink
//
//	Bereichs-Verknuepfung einfuegen

//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//============================================================================
//	class ScUndoRemoveAreaLink
//
//	Bereichs-Verknuepfung loeschen

//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//============================================================================
//	class ScUndoUpdateAreaLink
//
//	Bereichs-Verknuepfung aktualisieren

//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------



//----------------------------------------------------------------------------





}
