/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_gridwin3.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 17:11:12 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

#include "scitems.hxx"
#define ITEMID_FIELD EE_FEATURE_FIELD

#include <bf_svx/svdoutl.hxx>

#include "gridwin.hxx"
#include "dbfunc.hxx"
#include "output.hxx"
#include "drawview.hxx"
#include "fupoor.hxx"

#include "drawutil.hxx"
#include "document.hxx"
namespace binfilter {


// STATIC DATA -----------------------------------------------------------

// -----------------------------------------------------------------------





/*N*/ void ScGridWindow::DrawEndAction()
/*N*/ {
/*N*/ 	ScDrawView* pDrView = pViewData->GetScDrawView();
/*N*/ 	if ( pDrView && pDrView->IsAction() )
/*?*/ 		pDrView->BrkAction();
/*N*/ 
/*N*/ 	FuPoor* pDraw = pViewData->GetView()->GetDrawFuncPtr();
/*N*/ 	if (pDraw)
/*N*/ 		pDraw->StopDragTimer();
/*N*/ 
/*N*/ 	//	ReleaseMouse beim Aufruf
/*N*/ }



/*N*/ void ScGridWindow::DrawRedraw( ScOutputData& rOutputData, const Rectangle& rDrawingRect,
/*N*/ 									ScUpdateMode eMode, ULONG nLayer )
/*N*/ {
/*N*/ 	//!		eMode auswerten !!!
/*N*/ 
/*N*/ 	USHORT nObjectFlags = 0;
/*N*/ 	const ScViewOptions& rOpts = pViewData->GetOptions();
/*N*/ 	if ( rOpts.GetObjMode( VOBJ_TYPE_OLE ) == VOBJ_MODE_SHOW )
/*N*/ 		nObjectFlags |=	SC_OBJECTS_OLE;
/*N*/ 	if ( rOpts.GetObjMode( VOBJ_TYPE_CHART ) == VOBJ_MODE_SHOW )
/*N*/ 		nObjectFlags |=	SC_OBJECTS_CHARTS;
/*N*/ 	if ( rOpts.GetObjMode( VOBJ_TYPE_DRAW ) == VOBJ_MODE_SHOW )
/*N*/ 		nObjectFlags |=	SC_OBJECTS_DRAWING;
/*N*/ 
/*N*/ 	USHORT nDummyFlags = 0;
/*N*/ 	if ( rOpts.GetObjMode( VOBJ_TYPE_OLE ) == VOBJ_MODE_DUMMY )
/*N*/ 		nDummyFlags |=	SC_OBJECTS_OLE;
/*N*/ 	if ( rOpts.GetObjMode( VOBJ_TYPE_CHART ) == VOBJ_MODE_DUMMY )
/*N*/ 		nDummyFlags |=	SC_OBJECTS_CHARTS;
/*N*/ 	if ( rOpts.GetObjMode( VOBJ_TYPE_DRAW ) == VOBJ_MODE_DUMMY )
/*N*/ 		nDummyFlags |=	SC_OBJECTS_DRAWING;
/*N*/ 
/*N*/ 	if (nObjectFlags || nDummyFlags)
/*N*/ 	{
/*N*/ 		if ( eMode == SC_UPDATE_CHANGED )
/*N*/ 			rOutputData.DrawingSingle( (USHORT) nLayer, nObjectFlags, nDummyFlags );
/*N*/ 		else
				{DBG_BF_ASSERT(0, "STRIP");}  //STRIP001 /*?*/ 			rOutputData.DrawSelectiveObjects( (USHORT) nLayer, rDrawingRect,
/*N*/ 	}
/*N*/ }

/*N*/ void ScGridWindow::DrawSdrGrid( const Rectangle& rDrawingRect )
/*N*/ {
/*N*/ 	//	Draw-Gitterlinien
/*N*/ 
/*N*/ 	ScDrawView* pDrView = pViewData->GetView()->GetScDrawView();
/*N*/ 	if ( pDrView && pDrView->IsGridVisible() )
/*N*/ 	{
/*?*/ 		SdrPageView* pPV = pDrView->GetPageViewPvNum(0);
/*?*/ 		DBG_ASSERT(pPV, "keine PageView");
/*?*/ 		if (pPV)
/*?*/ 		{
/*?*/          DBG_BF_ASSERT(0, "STRIP"); //STRIP001    SetLineColor(COL_GRAY);
/*?*/ 		}
/*N*/ 	}
/*N*/ }

/*N*/ MapMode ScGridWindow::GetDrawMapMode( BOOL bForce )
/*N*/ {
/*N*/ 	MapMode aDrawMode = pViewData->GetLogicMode();
/*N*/ 
/*N*/ 	ScDrawView* pDrView = pViewData->GetView()->GetScDrawView();
/*N*/ 	if ( pDrView || bForce )
/*N*/ 	{
/*N*/ 		Fraction aScaleX;
/*N*/ 		Fraction aScaleY;
/*N*/ 		if (pDrView)
/*N*/ 			pDrView->GetScale( aScaleX, aScaleY );
/*N*/ 		else
/*N*/ 		{
/*?*/ 			ScDocument* pDoc = pViewData->GetDocument();
/*?*/ 			USHORT nTab = pViewData->GetTabNo();
/*?*/ 			USHORT nEndCol = 0;
/*?*/ 			USHORT nEndRow = 0;
/*?*/ 			pDoc->GetTableArea( nTab, nEndCol, nEndRow );
/*?*/ 			if (nEndCol<20) nEndCol = 20;
/*?*/ 			if (nEndRow<20) nEndRow = 20;
/*?*/ 			ScDrawUtil::CalcScale( pDoc, nTab, 0,0, nEndCol,nEndRow, this,
/*?*/ 									pViewData->GetZoomX(),pViewData->GetZoomY(),
/*?*/ 									pViewData->GetPPTX(),pViewData->GetPPTY(),
/*?*/ 									aScaleX,aScaleY );
/*N*/ 		}
/*N*/ 		aDrawMode.SetScaleX(aScaleX);
/*N*/ 		aDrawMode.SetScaleY(aScaleY);
/*N*/ 	}
/*N*/ 	aDrawMode.SetOrigin(Point());
/*N*/ 	aDrawMode.SetOrigin( PixelToLogic( pViewData->GetPixPos(eWhich), aDrawMode ) );
/*N*/ 
/*N*/ 	return aDrawMode;
/*N*/ }



/*N*/ void ScGridWindow::DrawMarks()
/*N*/ {
/*N*/ 	ScDrawView* pDrView = pViewData->GetView()->GetScDrawView();
/*N*/ 	if (pDrView)
/*N*/ 		pDrView->DrawMarks(this);
/*N*/ }

/*N*/ BOOL ScGridWindow::NeedDrawMarks()
/*N*/ {
/*N*/ 	ScDrawView* pDrView = pViewData->GetView()->GetScDrawView();
/*N*/ 	return pDrView && pDrView->IsMarkHdlShown() && pDrView->HasMarkedObj();
/*N*/ }



/*N*/ SdrObject* ScGridWindow::GetEditObject()
/*N*/ {
/*N*/ 	ScDrawView* pDrView = pViewData->GetView()->GetScDrawView();
/*N*/ 	if (pDrView)
/*N*/ 	{
/*N*/ 		OutlinerView* pOlView = pDrView->GetTextEditOutlinerView();
/*N*/ 		if (pOlView && pOlView->GetWindow() == this)
/*?*/ 			return pDrView->GetTextEditObject();
/*N*/ 	}
/*N*/ 
/*N*/ 	return NULL;
/*N*/ }



/*N*/ void ScGridWindow::DrawStartTimer()
/*N*/ {
/*N*/ 	ScDrawView* pDrView = pViewData->GetView()->GetScDrawView();
/*N*/ 	if (pDrView)
/*N*/ 	{
		/* jetzt in DrawMarks
		USHORT nWinNum = pDrView->FindWin(this);
	    if (nWinNum!=SDRVIEWWIN_NOTFOUND)
	        pDrView->AfterInitRedraw(nWinNum);
        */
/*N*/ 
/*N*/ 		pDrView->PostPaint();
/*N*/ 		pDrView->RestartAfterPaintTimer();
/*N*/ 	}
/*N*/ }




}
