/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_hdrcont.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 17:11:44 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------


#include "bf_sc.hrc"
#include "hdrcont.hxx"
#include "scmod.hxx"		// Optionen
#include "inputopt.hxx"		// Optionen
namespace binfilter {

// -----------------------------------------------------------------------

#define SC_DRAG_MIN		2

//	passes in paint
//	(selection left/right must be first because the continuous lines
//	are partly overwritten later)

#define SC_HDRPAINT_SEL_RIGHT	0
#define SC_HDRPAINT_SEL_LEFT	1
#define SC_HDRPAINT_TOP			2
#define SC_HDRPAINT_SEL_TOP		3
#define SC_HDRPAINT_SEL_BOTTOM	4
#define SC_HDRPAINT_BOTTOM		5
#define SC_HDRPAINT_TEXT		6
#define SC_HDRPAINT_COUNT		7

//==================================================================

/*M*/ ScHeaderControl::ScHeaderControl( Window* pParent, SelectionEngine* pSelectionEngine,
/*M*/ 									USHORT nNewSize, USHORT nNewFlags ) :
/*M*/ 			Window		( pParent ),
/*M*/ 			pSelEngine	( pSelectionEngine ),
/*M*/ 			nSize		( nNewSize ),
/*M*/ 			nFlags		( nNewFlags ),
/*M*/ 			bVertical	( (nNewFlags & HDR_VERTICAL) != 0 ),
/*M*/ 			bDragging	( FALSE ),
/*M*/ 			bIgnoreMove	( FALSE ),
/*M*/ 			nMarkStart	( 0 ),
/*M*/ 			nMarkEnd	( 0 ),
/*M*/ 			bMarkRange	( FALSE )
/*M*/ {
/*M*/     // --- RTL --- no default mirroring for this window, the spreadsheet itself
/*M*/     // is also not mirrored
/*N*/     // #107811# mirror the vertical window for correct border drawing
/*N*/     EnableRTL ( bVertical );
/*M*/ 
/*M*/ 	aNormFont = GetFont();
/*M*/ 	aNormFont.SetTransparent( TRUE );		//! WEIGHT_NORMAL hart setzen ???
/*M*/ 	aBoldFont = aNormFont;
/*M*/ 	aBoldFont.SetWeight( WEIGHT_BOLD );
/*M*/ 
/*M*/ 	SetFont(aBoldFont);
/*M*/ 	bBoldSet = TRUE;
/*M*/ 
/*M*/ 	Size aSize = LogicToPixel( Size(
/*M*/ 		GetTextWidth( String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("8888")) ),
/*M*/ 		GetTextHeight() ) );
/*M*/ 	aSize.Width()  += 4;	// Platz fuer hervorgehobene Umrandung
/*M*/ 	aSize.Height() += 3;
/*M*/ 	SetSizePixel( aSize );
/*M*/ 
/*M*/ 	nWidth = nSmallWidth = aSize.Width();
/*M*/ 	nBigWidth = LogicToPixel( Size( GetTextWidth(
/*M*/ 		String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("88888")) ), 0 ) ).Width() + 4;
/*M*/ 
/*M*/ 	SetBackground();	// sonst Probleme auf OS/2 !?!?!
/*M*/ }

/*N*/ void ScHeaderControl::SetWidth( long nNew )
/*N*/ {
/*N*/ 	DBG_ASSERT( bVertical, "SetDigits nur fuer Zeilenkoepfe erlaubt" );
/*N*/ 	if ( nNew != nWidth )
/*N*/ 	{
/*N*/ 		Size aSize( nNew, GetSizePixel().Height() );	// Hoehe nicht aendern
/*N*/ 		SetSizePixel( aSize );
/*N*/ 
/*N*/ 		nWidth = nNew;
/*N*/ 
/*N*/ 		Invalidate();		// neu zentrieren
/*N*/ 	}
/*N*/ }

/*N*/ __EXPORT ScHeaderControl::~ScHeaderControl()
/*N*/ {
/*N*/ }

/*N*/ void ScHeaderControl::DoPaint( USHORT nStart, USHORT nEnd )
/*N*/ {
/*N*/ 	Rectangle aRect( Point(0,0), GetOutputSizePixel() );
/*N*/ 	if ( bVertical )
/*N*/ 	{
/*N*/ 		aRect.Top() = GetScrPos( nStart );
/*N*/ 		aRect.Bottom() = GetScrPos( nEnd+1 )-1;
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		aRect.Left() = GetScrPos( nStart );
/*N*/ 		aRect.Right() = GetScrPos( nEnd+1 )-1;
/*N*/ 	}
/*N*/ 	Invalidate(aRect);
/*N*/ }

/*N*/ void ScHeaderControl::SetMark( BOOL bNewSet, USHORT nNewStart, USHORT nNewEnd )
/*N*/ {
/*N*/ 	BOOL bEnabled = SC_MOD()->GetInputOptions().GetMarkHeader();	//! cachen?
/*N*/ 	if (!bEnabled)
/*N*/ 		bNewSet = FALSE;
/*N*/ 
/*N*/ 	//	Variablen setzen
/*N*/ 
/*N*/ 	BOOL bOldSet	 = bMarkRange;
/*N*/ 	USHORT nOldStart = nMarkStart;
/*N*/ 	USHORT nOldEnd	 = nMarkEnd;
/*N*/ 	PutInOrder( nNewStart, nNewEnd );
/*N*/ 	bMarkRange = bNewSet;
/*N*/ 	nMarkStart = nNewStart;
/*N*/ 	nMarkEnd   = nNewEnd;
/*N*/ 
/*N*/ 	//	Paint
/*N*/ 
/*N*/ 	if ( bNewSet )
/*N*/ 	{
/*N*/ 		if ( bOldSet )
/*N*/ 		{
/*N*/ 			if ( nNewStart == nOldStart )
/*N*/ 			{
/*N*/ 				if ( nNewEnd != nOldEnd )
/*?*/ 					DoPaint( Min( nNewEnd, nOldEnd ) + 1, Max( nNewEnd, nOldEnd ) );
/*N*/ 				// sonst nix
/*N*/ 			}
/*N*/ 			else if ( nNewEnd == nOldEnd )
/*?*/ 				DoPaint( Min( nNewStart, nOldStart ), Max( nNewStart, nOldStart ) - 1 );
/*N*/ 			else if ( nNewStart > nOldEnd || nNewEnd < nOldStart )
/*N*/ 			{
/*?*/ 				//	zwei Bereiche...
/*?*/ 				DoPaint( nOldStart, nOldEnd );
/*?*/ 				DoPaint( nNewStart, nNewEnd );
/*N*/ 			}
/*N*/ 			else				//	irgendwie ueberlappend... (kommt eh nicht oft vor)
/*?*/ 				DoPaint( Min( nNewStart, nOldStart ), Max( nNewEnd, nOldEnd ) );
/*N*/ 		}
/*N*/ 		else
/*N*/ 			DoPaint( nNewStart, nNewEnd );		//	komplett neu
/*N*/ 	}
/*N*/ 	else if ( bOldSet )
/*?*/ 		DoPaint( nOldStart, nOldEnd );			//	komplett aufheben
/*N*/ 
/*N*/ 	//	sonst war nix, is nix
/*N*/ }

/*N*/ long ScHeaderControl::GetScrPos( USHORT nEntryNo )
/*N*/ {
/*N*/ 	long nScrPos;
/*N*/ 
/*N*/ 	long nMax = ( bVertical ? GetOutputSizePixel().Height() : GetOutputSizePixel().Width() ) + 1;
/*N*/ 	if (nEntryNo >= nSize)
/*N*/ 		nScrPos = nMax;
/*N*/ 	else
/*N*/ 	{
/*N*/ 		nScrPos = 0;
/*N*/ 		for (USHORT i=GetPos(); i<nEntryNo && nScrPos<nMax; i++)
/*N*/ 		{
/*N*/ 			USHORT nAdd = GetEntrySize(i);
/*N*/ 			if (nAdd)
/*N*/ 				nScrPos += nAdd;
/*N*/ 			else
/*N*/ 			{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	return nScrPos;
/*N*/ }

//
//		Paint
//


//
//		Maus - Handling
//







/*N*/ void ScHeaderControl::StopMarking()
/*N*/ {
/*N*/ 	if ( bDragging )
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 DrawInvert( nDragPos );
/*N*/ 	}
/*N*/ 
/*N*/ 	SetMarking( FALSE );
/*N*/ 	bIgnoreMove = TRUE;

	//	#86260# don't call pSelEngine->Reset, so selection across the parts of
	//	a split/frozen view is possible

/*N*/ 	ReleaseMouse();
/*N*/ }



// -----------------------------------------------------------------------
//					Dummys fuer virtuelle Methoden
// -----------------------------------------------------------------------







/*N*/ void ScHeaderControl::SetMarking( BOOL bSet )
/*N*/ {
/*N*/ }



}
