/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_output2.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 17:12:35 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#endif

#pragma hdrstop


// INCLUDE ---------------------------------------------------------------

#include "scitems.hxx"
#define ITEMID_FIELD EE_FEATURE_FIELD

#include <bf_svx/algitem.hxx>
#include <svtools/colorcfg.hxx>
#include <vcl/svapp.hxx>
#include <vcl/metric.hxx>
#include <vcl/outdev.hxx>
#include <math.h>

#include "output.hxx"
#include "document.hxx"
#include "patattr.hxx"
#include "editutil.hxx"
#include "scmod.hxx"
namespace binfilter {

			//!	Autofilter-Breite mit column.cxx zusammenfassen
#define DROPDOWN_BITMAP_SIZE		17

#define DRAWTEXT_MAX	32767


// STATIC DATA -----------------------------------------------------------

// -----------------------------------------------------------------------

class ScDrawStringsVars
{
	ScOutputData*		pOutput;				// Verbindung
	SvNumberFormatter*	pFormatter;

	const ScPatternAttr* pPattern;				// Attribute
	const SfxItemSet*	pCondSet;				// aus bedingter Formatierung

	Font				aFont;					// aus Attributen erzeugt
	FontMetric			aMetric;
	long				nAscentPixel;			// always pixels
	SvxCellOrientation	eAttrOrient;
	SvxCellHorJustify	eAttrHorJust;
	SvxCellVerJustify	eAttrVerJust;
	const SvxMarginItem* pMargin;
	USHORT				nIndent;
	BOOL				bRotated;

	String				aString;				// Inhalte
	Size				aTextSize;
	long				nOriginalWidth;

	ScBaseCell*			pLastCell;
	ULONG				nValueFormat;
	BOOL				bLineBreak;

	BOOL				bPixelToLogic;
	BOOL				bCellContrast;

	Color				aBackConfigColor;		// used for ScPatternAttr::GetFont calls
	Color				aTextConfigColor;

public:
				ScDrawStringsVars(ScOutputData* pData, BOOL bPTL);
				~ScDrawStringsVars();

				//	SetPattern = ex-SetVars
				//	SetPatternSimple: ohne Font



	const ScPatternAttr*	GetPattern() const		{ return pPattern; }
	SvxCellOrientation		GetOrient() const		{ return eAttrOrient; }
	SvxCellHorJustify		GetHorJust() const		{ return eAttrHorJust; }
	SvxCellVerJustify		GetVerJust() const		{ return eAttrVerJust; }
	const SvxMarginItem*	GetMargin() const		{ return pMargin; }

	USHORT	GetLeftTotal() const		{ return pMargin->GetLeftMargin() + nIndent; }

	const String&			GetString() const		{ return aString; }
	const Size&				GetTextSize() const		{ return aTextSize; }
	long					GetOriginalWidth() const { return nOriginalWidth; }

	ULONG	GetValueFormat() const					{ return nValueFormat; }
	BOOL	GetLineBreak() const					{ return bLineBreak; }

	long	GetAscent() const	{ return nAscentPixel; }
	BOOL	IsRotated() const	{ return bRotated; }

	BOOL	HasCondHeight() const	{ return pCondSet && SFX_ITEM_SET ==
										pCondSet->GetItemState( ATTR_FONT_HEIGHT, TRUE ); }

	BOOL	IsRightToLeftAttr() const;
};

//==================================================================

/*M*/ ScDrawStringsVars::ScDrawStringsVars(ScOutputData* pData, BOOL bPTL) :
/*M*/ 	pOutput		( pData ),
/*M*/ 	bPixelToLogic( bPTL ),
/*M*/ 	pPattern	( NULL ),
/*M*/ 	pCondSet	( NULL ),
/*M*/ 	pMargin		( NULL ),
/*M*/ 	nOriginalWidth( 0 ),
/*M*/ 	nIndent		( 0 ),
/*M*/ 	bRotated	( FALSE ),
/*M*/ 	eAttrHorJust( SVX_HOR_JUSTIFY_STANDARD ),
/*M*/ 	eAttrVerJust( SVX_VER_JUSTIFY_BOTTOM ),
/*M*/ 	eAttrOrient	( SVX_ORIENTATION_STANDARD ),
/*M*/ 	bLineBreak	( FALSE ),
/*M*/ 	nValueFormat( 0 ),
/*M*/ 	pLastCell	( NULL )
/*M*/ {
/*M*/ 	pFormatter = pData->pDoc->GetFormatTable();
/*M*/ 
/*M*/ 	ScModule* pScMod = SC_MOD();
/*N*/ 	//	#105733# SvtAccessibilityOptions::GetIsForBorders is no longer used (always assumed TRUE)
/*N*/ 	bCellContrast = pOutput->bUseStyleColor &&
/*N*/ 			Application::GetSettings().GetStyleSettings().GetHighContrastMode();
/*N*/ 
/*N*/     const svtools::ColorConfig& rColorConfig = pScMod->GetColorConfig();
/*N*/     aBackConfigColor.SetColor( rColorConfig.GetColorValue(svtools::DOCCOLOR).nColor );
/*N*/     aTextConfigColor.SetColor( rColorConfig.GetColorValue(svtools::FONTCOLOR).nColor );
/*M*/ }

/*N*/ ScDrawStringsVars::~ScDrawStringsVars()
/*N*/ {
/*N*/ }


/*	s.u.
	if (nValueFormat != nOld)
		pLastCell = NULL;			// immer neu formatieren
*/







//==================================================================


//==================================================================

//
//	Strings ausgeben
//





									// weiter solange versteckt
/*	if (!bDoMerge)
		return FALSE;
*/





/*N*/ void ScOutputData::DrawStrings( BOOL bPixelToLogic )
/*N*/ {
/*N*/ 	DBG_ASSERT( pDev == pRefDevice ||
/*N*/ 				pDev->GetMapMode().GetMapUnit() == pRefDevice->GetMapMode().GetMapUnit(),
/*N*/ 				"DrawStrings: unterschiedliche MapUnits ?!?!" );
/*N*/ 
/*N*/ 	BOOL bWasIdleDisabled = pDoc->IsIdleDisabled();
/*N*/ 	pDoc->DisableIdle( TRUE );
/*N*/ 	Size aMinSize = pRefDevice->PixelToLogic(Size(0,100));		// erst darueber wird ausgegeben
/*N*/ 	UINT32 nMinHeight = aMinSize.Height() / 200;				// 1/2 Pixel
/*N*/ 
/*N*/ 	ScDrawStringsVars aVars( this, bPixelToLogic );
/*N*/ 
/*N*/ 	const ScPatternAttr* pOldPattern = NULL;
/*N*/ 	const SfxItemSet* pOldCondSet = NULL;
/*N*/ 	BYTE nOldScript = 0;
/*N*/ 
/*N*/ 	BOOL bProgress = FALSE;
/*N*/ 
/*N*/ 	long nPosY = nScrY;
/*N*/ 	for (USHORT nArrY=1; nArrY+1<nArrCount; nArrY++)
/*N*/ 	{
/*N*/ 		RowInfo* pThisRowInfo = &pRowInfo[nArrY];
/*N*/ 		if ( pThisRowInfo->bChanged )
				{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ 		}
/*N*/ 		nPosY += pRowInfo[nArrY].nHeight;
/*N*/ 	}
/*N*/ 	if ( bProgress )
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 ScProgress::DeleteInterpretProgress();
/*N*/ 	pDoc->DisableIdle( bWasIdleDisabled );
/*N*/ }

//	-------------------------------------------------------------------------------


/*N*/ void ScOutputData::DrawEdit(BOOL bPixelToLogic)
/*N*/ {
/*N*/ 	Size aMinSize = pRefDevice->PixelToLogic(Size(0,100));		// erst darueber wird ausgegeben
/*N*/ 	UINT32 nMinHeight = aMinSize.Height() / 200;				// 1/2 Pixel
/*N*/ 
/*N*/ 	SvNumberFormatter* pFormatter = pDoc->GetFormatTable();
/*N*/ 
/*M*/ 	ScModule* pScMod = SC_MOD();
/*N*/     sal_Int32 nConfBackColor = pScMod->GetColorConfig().GetColorValue(svtools::DOCCOLOR).nColor;
/*N*/ 	//	#105733# SvtAccessibilityOptions::GetIsForBorders is no longer used (always assumed TRUE)
/*N*/ 	BOOL bCellContrast = bUseStyleColor &&
/*N*/ 			Application::GetSettings().GetStyleSettings().GetHighContrastMode();
/*M*/ 
/*N*/ 	ScFieldEditEngine* pEngine = NULL;
/*N*/ 	BOOL bHyphenatorSet = FALSE;
/*N*/ 	const ScPatternAttr* pPattern;
/*N*/ 	const SfxItemSet*	 pCondSet;
/*N*/ 	const ScPatternAttr* pOldPattern = NULL;
/*N*/ 	const SfxItemSet*	 pOldCondSet = NULL;
/*N*/ 	ScBaseCell* pCell = NULL;
/*N*/ 
/*N*/ 	long nRowPosY = nScrY;
/*N*/ 	for (USHORT nArrY=0; nArrY+1<nArrCount; nArrY++)			// 0 fuer Reste von zusammengefassten
/*N*/ 	{
/*N*/ 		RowInfo* pThisRowInfo = &pRowInfo[nArrY];
/*N*/ 		long nCellHeight = (long) pThisRowInfo->nHeight;
/*N*/ 		if (nArrY==1) nRowPosY = nScrY;							// vorher wird einzeln berechnet
/*N*/ 
/*N*/ 		if ( pThisRowInfo->bChanged || nArrY==0 )
/*N*/ 		{
/*N*/ 			long nPosX = 0;
/*N*/ 			for (USHORT nX=0; nX<=nX2; nX++)					// wegen Ueberhaengen
/*N*/ 			{
/*N*/ 				if (nX==nX1) nPosX = nScrX;						// vorher wird einzeln berechnet
/*N*/ 
/*N*/ 				CellInfo*	pInfo = &pThisRowInfo->pCellInfo[nX+1];
/*N*/ 				if (pInfo->bEditEngine)
/*N*/ 				{
/*?*/ 					USHORT nY = pThisRowInfo->nRowNo;
/*?*/ 
/*?*/ 					BOOL bHidden = FALSE;
/*?*/ 					if (bEditMode)
/*?*/ 						if ( nX == nEditCol && nY == nEditRow )
/*?*/ 							bHidden = TRUE;
/*?*/ 
/*?*/ 					if (!bHidden)
						{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ 					}
/*N*/ 				}
/*N*/ 				nPosX += pRowInfo[0].pCellInfo[nX+1].nWidth;
/*N*/ 			}
/*N*/ 		}
/*N*/ 		nRowPosY += pRowInfo[nArrY].nHeight;
/*N*/ 	}
/*N*/ 
/*N*/ 	delete pEngine;
/*N*/ 
/*N*/ 	if (bAnyRotated)
			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 		DrawRotated(bPixelToLogic);		//! von aussen rufen ?
/*N*/ }

//	-------------------------------------------------------------------------------




}
