/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_tabcont.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 17:14:34 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------


#include "tabcont.hxx"
#include "tabvwsh.hxx"
#include "docsh.hxx"
#include "bf_sc.hrc"
#include "globstr.hrc"
namespace binfilter {


// STATIC DATA -----------------------------------------------------------

//==================================================================

/*N*/ ScTabControl::ScTabControl( Window* pParent, ScViewData* pData ) :
/*N*/ 			TabBar( pParent, WinBits( WB_BORDER | WB_3DLOOK | WB_SCROLL |
/*N*/ 									WB_RANGESELECT | WB_MULTISELECT | WB_DRAG | WB_SIZEABLE ) ),
/*N*/ 			DropTargetHelper( this ),
/*N*/ 			DragSourceHelper( this ),
/*N*/ 			pViewData( pData ),
/*N*/ 			bErrorShown( FALSE ),
/*N*/ 			bAddDown( FALSE )
/*N*/ {
/*N*/ 	ScDocument* pDoc = pViewData->GetDocument();
/*N*/ 
/*N*/ 	String aString;
/*N*/ 	USHORT nCount = pDoc->GetTableCount();
/*N*/ 	for (USHORT i=0; i<nCount; i++)
/*N*/ 	{
/*N*/ 		if (pDoc->IsVisible(i))
/*N*/ 			if (pDoc->GetName(i,aString))
/*N*/ 				if ( pDoc->IsScenario(i) )
/*N*/ 					InsertPage( i+1, aString, TPB_SPECIAL );
/*N*/ 				else
/*N*/ 					InsertPage( i+1, aString );
/*N*/ 	}
/*N*/ 
/*N*/ 	SetCurPageId( pViewData->GetTabNo() + 1 );
/*N*/ 
/*N*/ 	SetSizePixel( Size(SC_TABBAR_DEFWIDTH, 0) );
/*N*/ 
/*N*/ 	SetSplitHdl( LINK( pViewData->GetView(), ScTabView, TabBarResize ) );
/*N*/ 
/*N*/ 	EnableEditMode();
/*N*/ }

/*N*/ __EXPORT ScTabControl::~ScTabControl()
/*N*/ {
/*N*/ }

/*N*/ USHORT ScTabControl::GetMaxId() const
/*N*/ {
/*N*/ 	USHORT nVisCnt = GetPageCount();
/*N*/ 	if (nVisCnt)
/*N*/ 		return GetPageId(nVisCnt-1);
/*N*/ 
/*N*/ 	return 0;
/*N*/ }





/*		Markierungen werden per Default nicht pro Tabelle gehalten
	USHORT nSelCnt = GetSelectPageCount();
	if (nSelCnt>1)
		pDoc->ExtendMarksFromTable( nPage );
*/


/*N*/ void ScTabControl::UpdateStatus()
/*N*/ {
/*N*/ 	ScDocument* pDoc = pViewData->GetDocument();
/*N*/ 	ScMarkData& rMark = pViewData->GetMarkData();
/*N*/ 	BOOL bActive = pViewData->IsActive();
/*N*/ 
/*N*/ 	USHORT nCount = pDoc->GetTableCount();
/*N*/ 	USHORT i;
/*N*/ 	String aString;
/*N*/ 	USHORT nMaxCnt = Max( nCount, GetMaxId() );
/*N*/ 
/*N*/ 	BOOL bModified = FALSE;										// Tabellen-Namen
/*N*/ 	for (i=0; i<nMaxCnt && !bModified; i++)
/*N*/ 	{
/*N*/ 		if (pDoc->IsVisible(i))
/*N*/ 			pDoc->GetName(i,aString);
/*N*/ 		else
/*N*/ 			aString.Erase();
/*N*/ 
/*N*/ 		if (GetPageText(i+1) != aString)
/*N*/ 			bModified = TRUE;
/*N*/ 	}
/*N*/ 
/*N*/ 	if (bModified)
/*N*/ 	{
/*N*/ 		Clear();
/*N*/ 		for (i=0; i<nCount; i++)
/*N*/ 			if (pDoc->IsVisible(i))
/*N*/ 				if (pDoc->GetName(i,aString))
/*N*/ 				if ( pDoc->IsScenario(i) )
/*?*/ 					InsertPage( i+1, aString, TPB_SPECIAL );
/*N*/ 				else
/*N*/ 					InsertPage( i+1, aString );
/*N*/ 	}
/*N*/ 	SetCurPageId( pViewData->GetTabNo() + 1 );
/*N*/ 
/*N*/ 	if (bActive)
/*N*/ 	{
/*N*/ 		bModified = FALSE;											// Selektion
/*N*/ 		for (i=0; i<nMaxCnt && !bModified; i++)
/*N*/ 			if ( rMark.GetTableSelect(i) != IsPageSelected(i+1) )
/*N*/ 				bModified = TRUE;
/*N*/ 
/*N*/ 		if ( bModified )
/*?*/ 			for (i=0; i<nCount; i++)
/*?*/ 				SelectPage( i+1, rMark.GetTableSelect(i) );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 	}
/*N*/ }


	/*
	USHORT i;
	for (i=0; i<nCount; i++)
	{
		SelectPage( i+1, FALSE );
		if (bActivate)
			rMark.SelectTable( i, FALSE );
	}
	*/

			/*
			USHORT nId = GetPageId( rCEvt.GetMousePosPixel() );
			if (nId)
			{
				SetCurPageId( nId );
				USHORT nCount = GetMaxId();

				for (USHORT i=1; i<=nCount; i++)
					SelectPage( i, i==nId );
				Select();
			}
			*/












}
