/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_tabview4.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 17:15:47 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#endif

#pragma hdrstop

//------------------------------------------------------------------

#define _MACRODLG_HXX
#define _BIGINT_HXX
#define _SVCONTNR_HXX
#define BASIC_NODIALOGS
#define _SFXMNUITEM_HXX
#define _SVDXOUT_HXX
#define _SVDATTR_HXX
#define _SFXMNUITEM_HXX
#define _DLGCFG_HXX
#define _SFXMNUMGR_HXX
#define _SFXBASIC_HXX
#define _MODALDLG_HXX
#define _SFX_TEMPLDLG_HXX
#define _SFXSTBMGR_HXX
#define _SFXTBXMGR_HXX
#define _BASE_DLGS_HXX
#define _SFXIMGMGR_HXX
#define _SFXMNUMGR_HXX
#define _SFXSTBITEM_HXX
#define _SFXTBXCTRL_HXX
#define _PASSWD_HXX
//#define _SFXFILEDLG_HXX
//#define _SFXREQUEST_HXX
#define _SFXOBJFACE_HXX

// INCLUDE ---------------------------------------------------------------


#include "tabview.hxx"
#include "docsh.hxx"
#include "scmod.hxx"
#include "globstr.hrc"
#include "cell.hxx"
#include "dociter.hxx"
namespace binfilter {

extern USHORT nScFillModeMouseModifier;				// global.cxx

// STATIC DATA -----------------------------------------------------------

//==================================================================

//
// ---	Referenz-Eingabe / Fill-Cursor
//








//	UpdateScrollBars - sichtbaren Bereich und Scrollweite der Scrollbars einstellen

/*N*/ long lcl_UpdateBar( ScrollBar& rScroll, USHORT nSize )		// Size = (komplette) Zellen
/*N*/ {
/*N*/ 	long nOldPos;
/*N*/ 	long nNewPos;
/*N*/ 
/*N*/ 	nOldPos = rScroll.GetThumbPos();
/*N*/ 	rScroll.SetPageSize( nSize );
/*N*/ 	nNewPos = rScroll.GetThumbPos();
/*N*/ #ifndef UNX
/*N*/ 	rScroll.SetPageSize( 1 );				// immer moeglich !
/*N*/ #endif
/*N*/ 
/*N*/ 	return nNewPos - nOldPos;
/*N*/ }

/*N*/ void lcl_SetScrollRange( ScrollBar& rBar, USHORT nDocEnd, USHORT nPos, USHORT nVis,
/*N*/ 							USHORT nMax, USHORT nStart )
/*N*/ {
/*N*/ 	++nVis;
/*N*/ 	++nMax;		// fuer teilweise sichtbare Zellen
/*N*/ 	USHORT nEnd = Max(nDocEnd, (USHORT)(nPos+nVis)) + nVis;
/*N*/ 	if (nEnd > nMax)
/*N*/ 		nEnd = nMax;
/*N*/ 
/*N*/ 	rBar.SetRangeMax( nEnd - nStart );		// RangeMin muss selber verwaltet werden
/*N*/ }

/*N*/ void ScTabView::UpdateScrollBars()
/*N*/ {
/*N*/ 	long		nDiff;
/*N*/ 	BOOL		bTop =   ( aViewData.GetVSplitMode() != SC_SPLIT_NONE );
/*N*/ 	BOOL		bRight = ( aViewData.GetHSplitMode() != SC_SPLIT_NONE );
/*N*/ 	ScDocument*	pDoc = aViewData.GetDocument();
/*N*/ 	USHORT		nTab = aViewData.GetTabNo();
/*N*/ 	USHORT		nUsedX;
/*N*/ 	USHORT		nUsedY;
/*N*/ 	pDoc->GetTableArea( nTab, nUsedX, nUsedY );		//! cachen !!!!!!!!!!!!!!!
/*N*/ 
/*N*/ 	USHORT nVisXL = 0;
/*N*/ 	USHORT nVisXR = 0;
/*N*/ 	USHORT nVisYB = 0;
/*N*/ 	USHORT nVisYT = 0;
/*N*/ 
/*N*/ 	USHORT nStartX = 0;
/*N*/ 	USHORT nStartY = 0;
/*N*/ 	if (aViewData.GetHSplitMode()==SC_SPLIT_FIX)
/*?*/ 		nStartX = aViewData.GetFixPosX();
/*N*/ 	if (aViewData.GetVSplitMode()==SC_SPLIT_FIX)
/*?*/ 		nStartY = aViewData.GetFixPosY();
/*N*/ 
/*N*/ 	nVisXL = aViewData.VisibleCellsX( SC_SPLIT_LEFT );
/*N*/ 	lcl_SetScrollRange( aHScrollLeft, nUsedX, aViewData.GetPosX(SC_SPLIT_LEFT), nVisXL,
/*N*/ 							MAXCOL, 0 );
/*N*/ 	aHScrollLeft.SetVisibleSize( nVisXL );
/*N*/ 	aHScrollLeft.SetThumbPos( aViewData.GetPosX( SC_SPLIT_LEFT ) );
/*N*/ 
/*N*/ 	nVisYB = aViewData.VisibleCellsY( SC_SPLIT_BOTTOM );
/*N*/ 	lcl_SetScrollRange( aVScrollBottom, nUsedY, aViewData.GetPosY(SC_SPLIT_BOTTOM), nVisYB,
/*N*/ 							MAXROW, nStartY );
/*N*/ 	aVScrollBottom.SetVisibleSize( nVisYB );
/*N*/ 	aVScrollBottom.SetThumbPos( aViewData.GetPosY( SC_SPLIT_BOTTOM ) - nStartY );
/*N*/ 
/*N*/ 	if (bRight)
/*N*/ 	{
/*?*/ 		nVisXR = aViewData.VisibleCellsX( SC_SPLIT_RIGHT );
/*?*/ 		lcl_SetScrollRange( aHScrollRight, nUsedX, aViewData.GetPosX(SC_SPLIT_RIGHT), nVisXR,
/*?*/ 							MAXCOL, nStartX );
/*?*/ 		aHScrollRight.SetVisibleSize( nVisXR );
/*?*/ 		aHScrollRight.SetThumbPos( aViewData.GetPosX( SC_SPLIT_RIGHT ) - nStartX );
/*N*/ 	}
/*N*/ 
/*N*/ 	if (bTop)
/*N*/ 	{
/*?*/ 		nVisYT = aViewData.VisibleCellsY( SC_SPLIT_TOP );
/*?*/ 		lcl_SetScrollRange( aVScrollTop, nUsedY, aViewData.GetPosY(SC_SPLIT_TOP), nVisYT,
/*?*/ 							MAXROW, 0 );
/*?*/ 		aVScrollTop.SetVisibleSize( nVisYT );
/*?*/ 		aVScrollTop.SetThumbPos( aViewData.GetPosY( SC_SPLIT_TOP ) );
/*N*/ 	}
/*N*/ 
/*N*/ 	//		Bereich testen
/*N*/ 
/*N*/ 	nDiff = lcl_UpdateBar( aHScrollLeft, nVisXL );
/*N*/ 	if (nDiff) ScrollX( nDiff, SC_SPLIT_LEFT );
/*N*/ 	if (bRight)
/*N*/ 	{
/*?*/ 		nDiff = lcl_UpdateBar( aHScrollRight, nVisXR );
/*?*/ 		if (nDiff) ScrollX( nDiff, SC_SPLIT_RIGHT );
/*N*/ 	}
/*N*/ 
/*N*/ 	nDiff = lcl_UpdateBar( aVScrollBottom, nVisYB );
/*N*/ 	if (nDiff) ScrollY( nDiff, SC_SPLIT_BOTTOM );
/*N*/ 	if (bTop)
/*N*/ 	{
/*?*/ 		nDiff = lcl_UpdateBar( aVScrollTop, nVisYT );
/*?*/ 		if (nDiff) ScrollY( nDiff, SC_SPLIT_TOP );
/*N*/ 	}
/*N*/ 
/*N*/ 	//		set visible area for online spelling
/*N*/ 
/*N*/ 	if ( aViewData.IsActive() )
/*N*/ 	{
/*N*/ 		ScSplitPos eActive = aViewData.GetActivePart();
/*N*/ 		ScHSplitPos eHWhich = WhichH( eActive );
/*N*/ 		ScVSplitPos eVWhich = WhichV( eActive );
/*N*/ 		USHORT nPosX = aViewData.GetPosX(eHWhich);
/*N*/ 		USHORT nPosY = aViewData.GetPosY(eVWhich);
/*N*/ 		USHORT nEndX = nPosX + ( ( eHWhich == SC_SPLIT_LEFT ) ? nVisXL : nVisXR );
/*N*/ 		USHORT nEndY = nPosY + ( ( eVWhich == SC_SPLIT_TOP ) ? nVisYT : nVisYB );
/*N*/ 		if ( nEndX > MAXCOL ) nEndX = MAXCOL;
/*N*/ 		if ( nEndY > MAXROW ) nEndY = MAXROW;
/*N*/ 		ScRange aVisible( nPosX, nPosY, nTab, nEndX, nEndY, nTab );
/*N*/ 		if ( pDoc->SetVisibleSpellRange( aVisible ) )
/*N*/ 			SC_MOD()->AnythingChanged();				// if visible area has changed
/*N*/ 	}
/*N*/ }

#ifndef HDR_SLIDERSIZE
#define HDR_SLIDERSIZE		2
#endif



//==================================================================

/*N*/ void ScTabView::InterpretVisible()
/*N*/ {
/*N*/ 	//	make sure all visible cells are interpreted,
/*N*/ 	//	so the next paint will not execute a macro function
/*N*/ 
/*N*/ 	ScDocument* pDoc = aViewData.GetDocument();
/*N*/ 	if ( !pDoc->GetAutoCalc() )
/*N*/ 		return;
/*N*/ 
/*N*/ 	USHORT nTab = aViewData.GetTabNo();
/*N*/ 	for (USHORT i=0; i<4; i++)
/*N*/ 	{
/*N*/ 		//	rely on gridwin pointers to find used panes
/*N*/ 		//	no IsVisible test in case the whole view is not yet shown
/*N*/ 
/*N*/ 		if (pGridWin[i])
/*N*/ 		{
/*N*/ 			ScHSplitPos eHWhich = WhichH( ScSplitPos(i) );
/*N*/ 			ScVSplitPos eVWhich = WhichV( ScSplitPos(i) );
/*N*/ 
/*N*/ 			USHORT	nX1 = aViewData.GetPosX( eHWhich );
/*N*/ 			USHORT	nY1 = aViewData.GetPosY( eVWhich );
/*N*/ 			USHORT	nX2 = nX1 + aViewData.VisibleCellsX( eHWhich );
/*N*/ 			USHORT	nY2 = nY1 + aViewData.VisibleCellsY( eVWhich );
/*N*/ 
/*N*/ 			if (nX2 > MAXCOL) nX2 = MAXCOL;
/*N*/ 			if (nY2 > MAXROW) nY2 = MAXROW;
/*N*/ 
/*N*/ 			ScCellIterator aIter( pDoc, nX1, nY1, nTab, nX2, nY2, nTab );
/*N*/ 			ScBaseCell* pCell = aIter.GetFirst();
/*N*/ 			while ( pCell )
/*N*/ 			{
/*N*/ 				if ( pCell->GetCellType() == CELLTYPE_FORMULA && ((ScFormulaCell*)pCell)->GetDirty() )
/*N*/ 					((ScFormulaCell*)pCell)->Interpret();
/*N*/ 
/*N*/ 				pCell = aIter.GetNext();
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ }





}
