/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_tabview5.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 17:15:58 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

#define ITEMID_FIELD EE_FEATURE_FIELD

#include <bf_svx/fmshell.hxx>

#include "tabvwsh.hxx"
#include "document.hxx"
#include "gridwin.hxx"
#include "olinewin.hxx"
#include "tabsplit.hxx"
#include "colrowba.hxx"
#include "tabcont.hxx"
#include "hintwin.hxx"
#include "bf_sc.hrc"
#include "pagedata.hxx"
#include "hiranges.hxx"
#include "drawview.hxx"
#include "drwlayer.hxx"
#include "fusel.hxx"                // Start-Function
#include "seltrans.hxx"
#include "scmod.hxx"
namespace binfilter {


// STATIC DATA -----------------------------------------------------------


/*M*/ void __EXPORT ScTabView::Init()
/*M*/ {
/*M*/ 	USHORT i;
/*M*/ 
/*M*/ 	aScrollTimer.SetTimeout(10);
/*M*/ 	aScrollTimer.SetTimeoutHdl( LINK( this, ScTabView, TimerHdl ) );
/*M*/ 
/*M*/ 	for (i=0; i<4; i++)
/*M*/ 		pGridWin[i] = NULL;
/*M*/ 	pGridWin[SC_SPLIT_BOTTOMLEFT] = new ScGridWindow( pFrameWin, &aViewData, SC_SPLIT_BOTTOMLEFT );
/*M*/ 
/*M*/ 	pSelEngine = new ScViewSelectionEngine( pGridWin[SC_SPLIT_BOTTOMLEFT], this,
/*M*/ 												SC_SPLIT_BOTTOMLEFT );
/*M*/ 	aFunctionSet.SetSelectionEngine( pSelEngine );
/*M*/ 
/*M*/ 	pHdrSelEng = new ScHeaderSelectionEngine( pFrameWin, &aHdrFunc );
/*M*/ 
/*M*/ 	pColBar[SC_SPLIT_LEFT] = new ScColBar( pFrameWin, &aViewData, SC_SPLIT_LEFT,
/*M*/ 												&aHdrFunc, pHdrSelEng );
/*M*/ 	pColBar[SC_SPLIT_RIGHT] = NULL;
/*M*/ 	pRowBar[SC_SPLIT_BOTTOM] = new ScRowBar( pFrameWin, &aViewData, SC_SPLIT_BOTTOM,
/*M*/ 												&aHdrFunc, pHdrSelEng );
/*M*/ 	pRowBar[SC_SPLIT_TOP] = NULL;
/*M*/ 	for (i=0; i<2; i++)
/*M*/ 		pColOutline[i] = pRowOutline[i] = NULL;
/*M*/ 
/*M*/ 	pHSplitter = new ScTabSplitter( pFrameWin, WinBits( WB_HSCROLL ), &aViewData );
/*M*/ 	pVSplitter = new ScTabSplitter( pFrameWin, WinBits( WB_VSCROLL ), &aViewData );
/*M*/ 
/*M*/     // SSA: override default keyboard step size to allow snap to row/column
/*M*/     pHSplitter->SetKeyboardStepSize( 1 );
/*M*/     pVSplitter->SetKeyboardStepSize( 1 );
/*M*/ 
/*M*/ 	pTabControl = new ScTabControl( pFrameWin, &aViewData );
/*M*/ 	//MI: nie! das war mal eine MUSS-Aenderung von MBA
/*M*/ 	//if (!aViewData.IsBasicView())
/*M*/ 	//	pTabControl->ToTop();		// ueber dem Splitter
/*M*/ 
/*M*/ 	InitScrollBar( aHScrollLeft,	MAXCOL+1 );
/*M*/ 	InitScrollBar( aHScrollRight,	MAXCOL+1 );
/*M*/ 	InitScrollBar( aVScrollTop, 	MAXROW+1 );
/*M*/ 	InitScrollBar( aVScrollBottom,	MAXROW+1 );
/*M*/ 
/*M*/     // SSA: --- RTL --- no mirroring for horizontal scrollbars, otherwise
/*M*/     // scroll direction will be wrong
/*M*/     aHScrollLeft.EnableRTL ( FALSE );
/*M*/     aHScrollRight.EnableRTL ( FALSE );
/*M*/ 
/*M*/ 	//	Hier noch nichts anzeigen (Show), weil noch falsch angeordnet ist
/*M*/ 	//	Show kommt dann aus UpdateShow beim ersten Resize
/*M*/ 	//		pTabControl, pGridWin, aHScrollLeft, aVScrollBottom,
/*M*/ 	//		aCornerButton, aScrollBarBox, pHSplitter, pVSplitter
/*M*/ 
/*M*/ 	//		Splitter
/*M*/ 
/*M*/ 	pHSplitter->SetSplitHdl( LINK( this, ScTabView, SplitHdl ) );
/*M*/ 	pVSplitter->SetSplitHdl( LINK( this, ScTabView, SplitHdl ) );
/*M*/ 
/*M*/ 	//	UpdateShow kommt beim Resize, oder bei Kopie einer bestehenden View aus dem ctor
/*M*/ 
/*M*/ 	pDrawActual = NULL;
/*M*/ 	pDrawOld	= NULL;
/*M*/ 
/*M*/ 			//	DrawView darf nicht im TabView - ctor angelegt werden,
/*M*/ 			//	wenn die ViewShell noch nicht konstruiert ist...
/*M*/ 			//	Das gilt auch fuer ViewOptionsHasChanged()
/*M*/ 
/*M*/ 	TestHintWindow();
/*M*/ }

/*N*/ __EXPORT ScTabView::~ScTabView()
/*N*/ {
/*N*/ 	USHORT i;
/*N*/ 
/*N*/ 	//	remove selection object
/*N*/ 	ScModule* pScMod = SC_MOD();
/*N*/ 	ScSelectionTransferObj* pOld = pScMod->GetSelectionTransfer();
/*N*/ 	if ( pOld && pOld->GetView() == this )
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pOld->ForgetView();
/*N*/ 	}
/*N*/ 
/*N*/ 	DELETEZ(pPageBreakData);
/*N*/ 	DELETEZ(pHighlightRanges);
/*N*/ 
/*N*/ 	DELETEZ(pDrawOld);
/*N*/ 	DELETEZ(pDrawActual);
/*N*/ 
/*N*/ 	aViewData.KillEditView();			// solange GridWin's noch existieren
/*N*/ 
/*N*/ 	DELETEZ(pInputHintWindow);
/*N*/ 
/*N*/ 	if (pDrawView)
/*N*/ 	{
/*N*/ 		for (i=0; i<4; i++)
/*N*/ 			if (pGridWin[i])
/*N*/ 			{
/*N*/ 				pDrawView->VCRemoveWin(pGridWin[i]);
/*N*/ 				pDrawView->DelWin(pGridWin[i]);
/*N*/ 			}
/*N*/ 
/*N*/ 		pDrawView->HidePagePvNum(0);
/*N*/ 		delete pDrawView;
/*N*/ 	}
/*N*/ 
/*N*/ 	delete pSelEngine;
/*N*/ 
/*N*/ 	for (i=0; i<4; i++)
/*N*/ 		delete pGridWin[i];
/*N*/ 
/*N*/ 	delete pHdrSelEng;
/*N*/ 
/*N*/ 	for (i=0; i<2; i++)
/*N*/ 	{
/*N*/ 		delete pColBar[i];
/*N*/ 		delete pRowBar[i];
/*N*/ 		delete pColOutline[i];
/*N*/ 		delete pRowOutline[i];
/*N*/ 	}
/*N*/ 
/*N*/ 	delete pHSplitter;
/*N*/ 	delete pVSplitter;
/*N*/ 
/*N*/ 	delete pTabControl;
/*N*/ }

/*N*/ void ScTabView::MakeDrawView( BYTE nForceDesignMode )
/*N*/ {
/*N*/ 	if (!pDrawView)
/*N*/ 	{
/*N*/ 		ScDrawLayer* pLayer = aViewData.GetDocument()->GetDrawLayer();
/*N*/ 		DBG_ASSERT(pLayer, "wo ist der DrawLayer ??");
/*N*/ 
/*N*/ 		USHORT i;
/*N*/ 		pDrawView = new ScDrawView( pGridWin[SC_SPLIT_BOTTOMLEFT], &aViewData );
/*N*/ 		for (i=0; i<4; i++)
/*N*/ 			if (pGridWin[i])
/*N*/ 			{
/*N*/ 				if ( SC_SPLIT_BOTTOMLEFT != (ScSplitPos)i )
/*?*/ 					pDrawView->AddWin(pGridWin[i]);
/*N*/ 				pDrawView->VCAddWin(pGridWin[i]);
/*N*/ 			}
/*N*/ 		pDrawView->RecalcScale();
/*N*/ 		for (i=0; i<4; i++)
/*N*/ 			if (pGridWin[i])
/*N*/ 			{
/*N*/ 				pGridWin[i]->SetMapMode(pGridWin[i]->GetDrawMapMode());
/*N*/ 
/*N*/ 				pGridWin[i]->Update();		// wegen Invalidate im DrawView ctor (ShowPage),
/*N*/ 											// damit gleich gezeichnet werden kann
/*N*/ 			}
/*N*/ 		SfxRequest aSfxRequest(SID_OBJECT_SELECT, 0,aViewData.GetViewShell()->GetPool());
/*N*/ 		SetDrawFuncPtr(new FuSelection( aViewData.GetViewShell(), GetActiveWin(), pDrawView,
/*N*/ 										pLayer,aSfxRequest));
/*N*/ 
/*N*/ 		//	#106334# used when switching back from page preview: restore saved design mode state
/*N*/ 		//	(otherwise, keep the default from the draw view ctor)
/*N*/ 		if ( nForceDesignMode != SC_FORCEMODE_NONE )
/*?*/ 			pDrawView->SetDesignMode( (BOOL)nForceDesignMode );
/*N*/ 
/*N*/ 		//	an der FormShell anmelden
/*N*/ 		FmFormShell* pFormSh = aViewData.GetViewShell()->GetFormShell();
/*N*/ 		if (pFormSh)
/*N*/ 			pFormSh->SetView(pDrawView);
/*N*/ 
/*N*/ 	    if (aViewData.GetViewShell()->HasAccessibilityObjects())
				{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 		    aViewData.GetViewShell()->BroadcastAccessibility(SfxSimpleHint(SC_HINT_ACC_MAKEDRAWLAYER));
/*N*/         
/*N*/ 	}
/*N*/ }


//==================================================================


/*N*/ void ScTabView::UpdateLayerLocks()
/*N*/ {
/*N*/ 	if (pDrawView)
/*N*/ 	{
/*N*/ 		USHORT nTab = aViewData.GetTabNo();
/*N*/ 		BOOL bEx = aViewData.GetViewShell()->IsDrawSelMode();
/*N*/ 		BOOL bProt = aViewData.GetDocument()->IsTabProtected( nTab ) ||
/*N*/ 					 aViewData.GetSfxDocShell()->IsReadOnly();
/*N*/ 
/*N*/ 		SdrLayer* pLayer;
/*N*/ 		SdrLayerAdmin& rAdmin = pDrawView->GetModel()->GetLayerAdmin();
/*N*/ 		pLayer = rAdmin.GetLayerPerID(SC_LAYER_BACK);
/*N*/ 		if (pLayer)
/*N*/ 			pDrawView->SetLayerLocked( pLayer->GetName(), bProt || !bEx );
/*N*/ 		pLayer = rAdmin.GetLayerPerID(SC_LAYER_INTERN);
/*N*/ 		if (pLayer)
/*N*/ 			pDrawView->SetLayerLocked( pLayer->GetName(), TRUE );
/*N*/ 		pLayer = rAdmin.GetLayerPerID(SC_LAYER_FRONT);
/*N*/ 		if (pLayer)
/*N*/ 			pDrawView->SetLayerLocked( pLayer->GetName(), bProt );
/*N*/ 		pLayer = rAdmin.GetLayerPerID(SC_LAYER_CONTROLS);
/*N*/ 		if (pLayer)
/*N*/ 			pDrawView->SetLayerLocked( pLayer->GetName(), bProt );
/*N*/ 	}
/*N*/ }




/*N*/ void ScTabView::SetZoom( const Fraction& rNewX, const Fraction& rNewY )
/*N*/ {
/*N*/ 	aViewData.SetZoom(rNewX,rNewY);
/*N*/ 	if (pDrawView)
/*N*/ 		pDrawView->RecalcScale();
/*N*/ 	ZoomChanged();				// einzeln wegen CLOOKs
/*N*/ }



/*N*/ void ScTabView::ViewOptionsHasChanged( BOOL bHScrollChanged, BOOL bGraphicsChanged )
/*N*/ {
/*N*/ 	//	DrawView erzeugen, wenn Gitter angezeigt werden soll
/*N*/ 	if ( !pDrawView && aViewData.GetOptions().GetGridOptions().GetGridVisible() )
			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 		MakeDrawLayer();
/*N*/ 
/*N*/ 	if (pDrawView)
/*N*/ 		pDrawView->UpdateUserViewOptions();
/*N*/ 
/*N*/ 	if (bGraphicsChanged)
/*?*/ 		DrawEnableAnim(TRUE);	// DrawEnableAnim checks the options state
/*N*/ 
/*N*/ 	// if TabBar is set to visible, make sure its size is not 0
/*N*/ 	BOOL bGrow = ( aViewData.IsTabMode() && pTabControl->GetSizePixel().Width() <= 0 );
/*N*/ 
/*N*/ 	// if ScrollBar is set to visible, TabBar must make room
/*N*/ 	BOOL bShrink = ( bHScrollChanged && aViewData.IsTabMode() && aViewData.IsHScrollMode() &&
/*N*/ 						pTabControl->GetSizePixel().Width() > SC_TABBAR_DEFWIDTH );
/*N*/ 
/*N*/ 	if ( bGrow || bShrink )
/*N*/ 	{
/*?*/ 		Size aSize = pTabControl->GetSizePixel();
/*?*/ 		aSize.Width() = SC_TABBAR_DEFWIDTH;				// initial size
/*?*/ 		pTabControl->SetSizePixel(aSize);				// DoResize is called later...
/*N*/ 	}
/*N*/ }

// Helper-Funktion gegen das Include des Drawing Layers

/*N*/ SdrView* ScTabView::GetSdrView()
/*N*/ {
/*N*/ 	return pDrawView;
/*N*/ }





/*N*/ void ScTabView::DrawEnableAnim(BOOL bSet)
/*N*/ {
/*N*/ 	USHORT i;
/*N*/ 	if ( pDrawView )
/*N*/ 	{
/*N*/ 		//	#71040# dont start animations if display of graphics is disabled
/*N*/ 		//	graphics are controlled by VOBJ_TYPE_OLE
/*N*/ 		if ( bSet && aViewData.GetOptions().GetObjMode(VOBJ_TYPE_OLE) == VOBJ_MODE_SHOW )
/*N*/ 		{
/*N*/ 			if ( !pDrawView->IsAnimationEnabled() )
/*N*/ 			{
/*?*/ 				pDrawView->SetAnimationEnabled(TRUE);
/*?*/ 
/*?*/ 				//	Animierte GIFs muessen wieder gestartet werden:
/*?*/ 				ScDocument* pDoc = aViewData.GetDocument();
/*?*/ 				for (i=0; i<4; i++)
/*?*/ 					if ( pGridWin[i] && pGridWin[i]->IsVisible() )
/*?*/ 						{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pDoc->StartAnimations( aViewData.GetTabNo(), pGridWin[i] );
/*?*/ 			}
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*?*/ 			pDrawView->SetAnimationEnabled(FALSE);
/*?*/ 			//	StopAnimations am Dokument ist nicht mehr noetig
/*N*/ 		}
/*N*/ 	}
/*N*/ }




//---------------------------------------------------------------

/*N*/ void ScTabView::ScrollToObject( SdrObject* pDrawObj )
/*N*/ {
/*N*/ 	if ( pDrawObj )
			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*N*/ 		MakeVisible( pDrawObj->GetLogicRect() );
/*N*/ }




}
