/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_tabvwsh2.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 17:16:23 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#include "ui_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

#ifdef WNT
#pragma optimize ("", off)
#endif

#include <bf_sfx2/bindings.hxx>
#include <bf_sfx2/ipfrm.hxx>
#include <svtools/aeitem.hxx>
#include <svtools/whiter.hxx>
#include <svtools/moduleoptions.hxx>
#ifndef _SVTOOLS_LANGUAGEOPTIONS_HXX
#include <svtools/languageoptions.hxx>
#endif
#include <bf_sfx2/dispatch.hxx>

#include "tabvwsh.hxx"
#include "drawattr.hxx"
#include "drawsh.hxx"
#include "drawview.hxx"
#include "fupoor.hxx"
#include "fusel.hxx"
#include "global.hxx"
#include "bf_sc.hrc"
#include "scmod.hxx"
#include "appoptio.hxx"

// #98185# Create default drawing objects via keyboard
#ifndef _SVDPAGV_HXX
#include <bf_svx/svdpagv.hxx>
#endif

#ifndef _SVDPAGE_HXX
#include <bf_svx/svdpage.hxx>
#endif
namespace binfilter {

// -----------------------------------------------------------------------




/*N*/ void ScTabViewShell::GetDrawState(SfxItemSet &rSet)
/*N*/ {
/*N*/ 	SfxWhichIter	aIter(rSet);
/*N*/ 	USHORT			nWhich = aIter.FirstWhich();
/*N*/ 
/*N*/ 	while ( nWhich )
/*N*/ 	{
/*N*/ 		switch ( nWhich )
/*N*/ 		{
/*N*/ 			case SID_INSERT_DRAW:
/*N*/ 				{
/*N*/ 					//	SID_OBJECT_SELECT nur, wenn "harter" Selektionsmodus
/*N*/ 					USHORT nPutId = nDrawSfxId;
/*N*/ 					if ( nPutId == SID_OBJECT_SELECT && !IsDrawSelMode() )
/*N*/ 						nPutId = USHRT_MAX;
/*N*/ 					// nur die Images, die auch auf dem Controller liegen
/*N*/ 					if ( nPutId != SID_OBJECT_SELECT &&
/*N*/ 						 nPutId != SID_DRAW_LINE &&
/*N*/ 						 nPutId != SID_DRAW_RECT &&
/*N*/ 						 nPutId != SID_DRAW_ELLIPSE &&
/*N*/ 						 nPutId != SID_DRAW_POLYGON_NOFILL &&
/*N*/ 						 nPutId != SID_DRAW_BEZIER_NOFILL &&
/*N*/ 						 nPutId != SID_DRAW_FREELINE_NOFILL &&
/*N*/ 						 nPutId != SID_DRAW_ARC &&
/*N*/ 						 nPutId != SID_DRAW_PIE &&
/*N*/ 						 nPutId != SID_DRAW_CIRCLECUT &&
/*N*/ 						 nPutId != SID_DRAW_TEXT &&
/*N*/ 						 nPutId != SID_DRAW_TEXT_VERTICAL &&
/*N*/ 						 nPutId != SID_DRAW_TEXT_MARQUEE &&
/*N*/ 						 nPutId != SID_DRAW_CAPTION &&
/*N*/ 						 nPutId != SID_DRAW_CAPTION_VERTICAL )
/*N*/ 						nPutId = USHRT_MAX;
/*N*/ 					SfxAllEnumItem aItem( nWhich, nPutId );
/*N*/ 					if ( !SvtLanguageOptions().IsVerticalTextEnabled() )
/*N*/ 					{
/*N*/ 						aItem.DisableValue( SID_DRAW_TEXT_VERTICAL );
/*N*/ 						aItem.DisableValue( SID_DRAW_CAPTION_VERTICAL );
/*N*/ 					}
/*N*/ 					rSet.Put( aItem );
/*N*/ 				}
/*N*/ 				break;
/*N*/ 
/*?*/ 			case SID_DRAW_CHART:
/*?*/ 				{
/*?*/ 					BOOL bOle = GetViewFrame()->ISA(SfxInPlaceFrame);
/*?*/ 					if ( bOle || !SvtModuleOptions().IsChart() )
/*?*/ 						rSet.DisableItem( nWhich );
/*?*/ 				}
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SID_OBJECT_SELECT:		// wichtig fuer den ollen Control-Controller
/*?*/ 				rSet.Put( SfxBoolItem( nWhich, nDrawSfxId == SID_OBJECT_SELECT && IsDrawSelMode() ) );
/*?*/ 				break;
/*N*/ 		}
/*N*/ 		nWhich = aIter.NextWhich();
/*N*/ 	}
/*N*/ }




}
