/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_tabvwsh4.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 17:16:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// INCLUDE ---------------------------------------------------------------

#include "scitems.hxx"
#define ITEMID_FIELD EE_FEATURE_FIELD

#include <bf_svx/fmshell.hxx>
#include <bf_svx/boxitem.hxx>
#include <bf_sfx2/dispatch.hxx>
#include <svtools/moduleoptions.hxx>
#include <rtl/logfile.hxx>

#include <bf_sfx2/basedlgs.hxx>

#include "tabvwsh.hxx"
#include "bf_sc.hrc"
#include "globstr.hrc"
#include "docsh.hxx"
#include "scmod.hxx"
#include "appoptio.hxx"
#include "rangeutl.hxx"
#include "drformsh.hxx"
#include "editsh.hxx"
#include "pivotsh.hxx"
#include "auditsh.hxx"
#include "drtxtob.hxx"
#include "inputhdl.hxx"
#include "dbcolect.hxx"		// fuer ReImport
#include "reffact.hxx"
#include "viewuno.hxx"
#include "dispuno.hxx"
#include "cellsh.hxx"
#include "oleobjsh.hxx"
#include "chartsh.hxx"
#include "graphsh.hxx"
#include "pgbrksh.hxx"
#include "dpobject.hxx"
#include "prevwsh.hxx"

#ifndef SC_NAVSETT_HXX
#include "navsett.hxx"
#endif
namespace binfilter {

void ActivateOlk( ScViewData* pViewData );
void DeActivateOlk( ScViewData* pViewData );

extern SfxViewShell* pScActiveViewShell;			// global.cxx

using namespace ::com::sun::star;

// STATIC DATA -----------------------------------------------------------

USHORT ScTabViewShell::nInsertCtrlState = SID_INSERT_GRAPHIC;
USHORT ScTabViewShell::nInsCellsCtrlState = 0;
USHORT ScTabViewShell::nInsObjCtrlState = SID_DRAW_CHART;


/*N*/ USHORT __EXPORT ScTabViewShell::PrepareClose(BOOL bUI, BOOL bForBrowsing)
/*N*/ {
/*N*/     // #110797#
/*N*/     if ( GetDrawView() )
/*?*/         GetDrawView()->EndTextEdit();

/*N*/ 	if ( pFormShell )
/*N*/ 	{
/*N*/ 		USHORT nRet = pFormShell->PrepareClose(bUI, bForBrowsing);
/*N*/ 		if (nRet!=TRUE)
/*N*/ 			return nRet;
/*N*/ 	}
/*N*/ 	return SfxViewShell::PrepareClose(bUI,bForBrowsing);
/*N*/ }


/*N*/ void __EXPORT ScTabViewShell::OuterResizePixel( const Point &rOfs, const Size &rSize )
/*N*/ {
/*N*/ 	SvBorder aBorder;
/*N*/ 	GetBorderSize( aBorder, rSize );
/*N*/ 	SetBorderPixel( aBorder );
/*N*/ 
/*N*/ 	DoResize( rOfs, rSize );					// Position und Groesse von tabview wie uebergeben
/*N*/ 
/*N*/ 	// ForceMove als Ersatz fuer den Sfx-Move-Mechanismus
/*N*/ 	// (aWinPos muss aktuell gehalten werden, damit ForceMove beim Ole-Deaktivieren klappt)
/*N*/ 
/*N*/ 	ForceMove();
/*N*/ }



//------------------------------------------------------------------

/*N*/ void __EXPORT ScTabViewShell::Move()
/*N*/ {
/*N*/ 	Point aNewPos = GetViewFrame()->GetWindow().OutputToScreenPixel(Point());
/*N*/ 
/*N*/ 	if (aNewPos != aWinPos)
/*N*/ 	{
/*N*/ 		StopMarking();
/*N*/ 		aWinPos = aNewPos;
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------

/*N*/ void __EXPORT ScTabViewShell::ShowCursor(FASTBOOL bOn)
/*N*/ {
/*!!!	ShowCursor wird nicht paarweise wie im gridwin gerufen.
		Der CursorLockCount am Gridwin muss hier direkt auf 0 gesetzt werden

	if (bOn)
		ShowAllCursors();
	else
		HideAllCursors();
*/
/*N*/ }

//------------------------------------------------------------------

/*N*/ void __EXPORT ScTabViewShell::WriteUserData(String& rData, BOOL bBrowse)
/*N*/ {
/*N*/ 	GetViewData()->WriteUserData(rData);
/*N*/ }

/*N*/ void ScTabViewShell::WriteUserDataSequence (uno::Sequence < beans::PropertyValue >& rSettings, sal_Bool bBrowse )
/*N*/ {
/*N*/ 	GetViewData()->WriteUserDataSequence (rSettings);
/*N*/ }


/*N*/ void ScTabViewShell::SetDrawShell( BOOL bActive )
/*N*/ {
/*N*/ 	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if(bActive)
/*N*/ }

/*N*/ void ScTabViewShell::SetCurSubShell(ObjectSelectionType	eOST, BOOL bForce)
/*N*/ {
/*N*/ 	ScViewData* pViewData	= GetViewData();
/*N*/ 	ScDocShell* pDocSh		= pViewData->GetDocShell();
/*N*/ 	SfxShell*	pCurSubSh	= NULL;
/*N*/ 
/*N*/ 	if(bDontSwitch) return;
/*N*/ 
/*N*/ 	if(!pCellShell) //Wird eh immer gebraucht.
/*N*/ 	{
/*N*/ 		pCellShell = new ScCellShell( GetViewData() );
/*N*/ 		pCellShell->SetRepeatTarget( &aTarget );
/*N*/ 	}
/*N*/ 
/*N*/ 	BOOL bPgBrk=pViewData->IsPagebreakMode();
/*N*/ 
/*N*/ 	if(bPgBrk && !pPageBreakShell)
/*N*/ 	{
/*?*/ 		pPageBreakShell = new ScPageBreakShell( this );
/*?*/ 		pPageBreakShell->SetRepeatTarget( &aTarget );
/*N*/ 	}
/*N*/ 
/*N*/ 
/*N*/ 	if ( eOST!=eCurOST || bForce )
/*N*/ 	{
/*N*/ 		if(eCurOST!=OST_NONE) RemoveSubShell();
/*N*/ 
/*N*/ 		if(pFormShell) AddSubShell(*pFormShell);
/*N*/ 
/*N*/ 
/*N*/ 		switch(eOST)
/*N*/ 		{
/*N*/ 			case	OST_Cell:
/*N*/ 					{
/*N*/ 						AddSubShell(*pCellShell);
/*N*/ 						if(bPgBrk) AddSubShell(*pPageBreakShell);
/*N*/ 					}
/*N*/ 					break;
/*?*/ 			case	OST_Editing:
/*?*/ 					{
/*?*/ 						AddSubShell(*pCellShell);
/*?*/ 						if(bPgBrk) AddSubShell(*pPageBreakShell);
/*?*/ 
/*?*/ 						if(pEditShell)
/*?*/ 						{
/*?*/ 							AddSubShell(*pEditShell);
/*?*/ 						}
/*?*/ 					}
/*?*/ 					break;
/*?*/ 			case	OST_DrawText:
/*?*/ 					{
/*?*/ 						if ( !pDrawTextShell )
/*?*/ 						{
/*?*/ 							pDocSh->MakeDrawLayer();
/*?*/ 							pDrawTextShell = new ScDrawTextObjectBar( GetViewData() );
/*?*/ 						}
/*?*/ 						AddSubShell(*pDrawTextShell);
/*?*/ 					}
/*?*/ 					break;
/*?*/ 			case	OST_Drawing:
/*?*/ 					{
/*?*/ 						if ( !pDrawShell )
/*?*/ 						{
/*?*/ 							pDocSh->MakeDrawLayer();
/*?*/ 							pDrawShell = new ScDrawShell( GetViewData() );
/*?*/ 							pDrawShell->SetRepeatTarget( &aTarget );
/*?*/ 						}
/*?*/ 						AddSubShell(*pDrawShell);
/*?*/ 					}
/*?*/ 					break;
/*?*/ 
/*?*/ 			case	OST_DrawForm:
/*?*/ 					{
/*?*/ 						if ( !pDrawFormShell )
/*?*/ 						{
/*?*/ 							pDocSh->MakeDrawLayer();
/*?*/ 							pDrawFormShell = new ScDrawFormShell( GetViewData() );
/*?*/ 							pDrawFormShell->SetRepeatTarget( &aTarget );
/*?*/ 						}
/*?*/ 						AddSubShell(*pDrawFormShell);
/*?*/ 					}
/*?*/ 					break;
/*?*/ 
/*?*/ 			case	OST_Chart:
/*?*/ 					{
/*?*/ 						if ( !pChartShell )
/*?*/ 						{
/*?*/ 							pDocSh->MakeDrawLayer();
/*?*/ 							pChartShell = new ScChartShell( GetViewData() );
/*?*/ 							pChartShell->SetRepeatTarget( &aTarget );
/*?*/ 						}
/*?*/ 						AddSubShell(*pChartShell);
/*?*/ 					}
/*?*/ 					break;
/*?*/ 
/*?*/ 			case	OST_OleObject:
/*?*/ 					{
/*?*/ 						if ( !pOleObjectShell )
/*?*/ 						{
/*?*/ 							pDocSh->MakeDrawLayer();
/*?*/ 							pOleObjectShell = new ScOleObjectShell( GetViewData() );
/*?*/ 							pOleObjectShell->SetRepeatTarget( &aTarget );
/*?*/ 						}
/*?*/ 						AddSubShell(*pOleObjectShell);
/*?*/ 					}
/*?*/ 					break;
/*?*/ 
/*?*/ 			case	OST_Graphic:
/*?*/ 					{
/*?*/ 						if ( !pGraphicShell)
/*?*/ 						{
/*?*/ 							pDocSh->MakeDrawLayer();
/*?*/ 							pGraphicShell = new ScGraphicShell( GetViewData() );
/*?*/ 							pGraphicShell->SetRepeatTarget( &aTarget );
/*?*/ 						}
/*?*/ 						AddSubShell(*pGraphicShell);
/*?*/ 					}
/*?*/ 					break;
/*?*/ 
/*?*/ 			case	OST_Pivot:
/*?*/ 					{
/*?*/ 						AddSubShell(*pCellShell);
/*?*/ 						if(bPgBrk) AddSubShell(*pPageBreakShell);
/*?*/ 
/*?*/ 						if ( !pPivotShell )
/*?*/ 						{
/*?*/ 							pPivotShell = new ScPivotShell( this );
/*?*/ 							pPivotShell->SetRepeatTarget( &aTarget );
/*?*/ 						}
/*?*/ 						AddSubShell(*pPivotShell);
/*?*/ 					}
/*?*/ 					break;
/*?*/ 			case	OST_Auditing:
/*?*/ 					{
/*?*/ 						AddSubShell(*pCellShell);
/*?*/ 						if(bPgBrk) AddSubShell(*pPageBreakShell);
/*?*/ 
/*?*/ 						if ( !pAuditingShell )
/*?*/ 						{
/*?*/ 							pDocSh->MakeDrawLayer();	// die Wartezeit lieber jetzt als beim Klick
/*?*/ 
/*?*/ 							pAuditingShell = new ScAuditingShell( GetViewData() );
/*?*/ 							pAuditingShell->SetRepeatTarget( &aTarget );
/*?*/ 						}
/*?*/ 						AddSubShell(*pAuditingShell);
/*?*/ 					}
/*?*/ 					break;
/*N*/ 			default:
/*N*/ 					DBG_ERROR("Falsche Shell angefordert");
/*N*/ 					break;
/*N*/ 		}
/*N*/ 		eCurOST=eOST;
/*N*/ 	}
/*N*/ }


//	GetMySubShell / SetMySubShell: altes Verhalten simulieren,
//	dass es nur eine SubShell gibt (nur innerhalb der 5 eignenen SubShells)


//------------------------------------------------------------------

/*N*/ ScTabViewShell* ScTabViewShell::GetActiveViewShell()
/*N*/ {
/*N*/ 	return PTR_CAST(ScTabViewShell,Current());
/*N*/ }

//------------------------------------------------------------------

/*N*/ SfxPrinter* __EXPORT ScTabViewShell::GetPrinter( BOOL bCreate )
/*N*/ {
/*N*/ 	//	Drucker ist immer da (wird fuer die FontListe schon beim Starten angelegt)
/*N*/ 	return GetViewData()->GetDocShell()->GetPrinter();
/*N*/ }


/*N*/ void ScTabViewShell::StopEditShell()
/*N*/ {
/*N*/ 	if ( pEditShell != NULL && !bDontSwitch )
			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 		SetEditShell(NULL, FALSE );
/*N*/ }


/*N*/ void ScTabViewShell::StartSimpleRefDialog(
/*N*/ 			const String& rTitle, const String& rInitVal, BOOL bCloseOnButtonUp )
/*N*/ {
		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*N*/ 	SfxViewFrame* pViewFrm = GetViewFrame();
/*N*/ }

/*N*/ void ScTabViewShell::StopSimpleRefDialog()
/*N*/ {
/*N*/ 	SfxViewFrame* pViewFrm = GetViewFrame();
/*N*/ 	USHORT nId = ScSimpleRefDlgWrapper::GetChildWindowId();
/*N*/ 
/*N*/ 	ScSimpleRefDlgWrapper* pWnd = (ScSimpleRefDlgWrapper*)pViewFrm->GetChildWindow( nId );
/*N*/ 	if (pWnd)
/*N*/ 	{
/*N*/ 		Window* pWin = pWnd->GetWindow();
/*N*/ 		if (pWin && pWin->IsSystemWindow())
/*N*/ 			((SystemWindow*)pWin)->Close();		// calls abort handler
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------

//	SfxViewShell( pViewFrame, SFX_VIEW_MAXIMIZE_FIRST | SFX_VIEW_DISABLE_ACCELS ),

#define __INIT_ScTabViewShell \
	SfxViewShell( pViewFrame, SFX_VIEW_MAXIMIZE_FIRST | SFX_VIEW_CAN_PRINT | SFX_VIEW_HAS_PRINTOPTIONS ), \
	nDrawSfxId(0),				\
	nCtrlSfxId(USHRT_MAX),		\
	eCurOST(OST_NONE),			\
	nFormSfxId(USHRT_MAX),		\
	pCellShell(NULL),			\
	pPageBreakShell(NULL),		\
	pDrawShell(NULL),			\
	pDrawFormShell(NULL),		\
	pOleObjectShell(NULL),		\
	pChartShell(NULL),			\
	pGraphicShell(NULL),		\
	pDrawTextShell(NULL),		\
	pEditShell(NULL),			\
	pPivotShell(NULL),			\
	pAuditingShell(NULL),		\
	pFormShell(NULL),			\
	pInputHandler(NULL),		\
	pCurFrameLine(NULL),		\
	bActiveChartSh(FALSE),		\
	bActiveDrawSh(FALSE),		\
	bActiveDrawTextSh(FALSE),	\
	bActiveGraphicSh(FALSE),	\
	bActivePivotSh(FALSE),		\
	bActiveAuditingSh(FALSE),	\
	bActiveDrawFormSh(FALSE),	\
	bActiveOleObjectSh(FALSE),	\
	bDontSwitch(FALSE),			\
	bInFormatDialog(FALSE),		\
	bPrintSelected(FALSE),		\
	bReadOnly(FALSE),			\
	pScSbxObject(NULL),			\
	bChartAreaValid(FALSE),		\
	bChartDlgIsEdit(FALSE),		\
	pDialogDPObject(NULL),		\
    nCurRefDlgId(0),            \
    pNavSettings(NULL),         \
	aTarget( this ),			\
	pAccessibilityBroadcaster(NULL)


//------------------------------------------------------------------

/*N*/ void ScTabViewShell::Construct( BYTE nForceDesignMode )
/*N*/ {
/*N*/ 	SfxApplication* pSfxApp  = SFX_APP();
/*N*/ 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
/*N*/ 	ScDocument* pDoc = pDocSh->GetDocument();
/*N*/ 
/*N*/ 	bReadOnly = pDocSh->IsReadOnly();
/*N*/ 
/*N*/ 	SetName( String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("View")) );	// fuer SBX
/*N*/ 	Color aColBlack( COL_BLACK );
/*N*/ //	SetPool( &pSfxApp->GetPool() );
/*N*/ 	SetPool( &SC_MOD()->GetPool() );
/*N*/ 	SetWindow( GetActiveWin() );
/*N*/ 
/*N*/ 	pCurFrameLine	= new SvxBorderLine( &aColBlack, 20, 0, 0 );
/*N*/ 	pPivotSource	= new ScArea;
/*N*/ 	StartListening(*GetViewData()->GetDocShell());
/*N*/ 	StartListening(*GetViewFrame());
/*N*/ 	StartListening(*pSfxApp,TRUE);		// SfxViewShell hoert da schon zu?
/*N*/ 
/*N*/ 	SfxViewFrame* pFirst = SfxViewFrame::GetFirst(pDocSh);
/*N*/ 	BOOL bFirstView = !pFirst
/*N*/ 		  || (pFirst == GetViewFrame() && !SfxViewFrame::GetNext(*pFirst,pDocSh));
/*N*/ 
/*N*/ 	if ( pDocSh->GetCreateMode() == SFX_CREATE_MODE_EMBEDDED )
/*N*/ 	{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ 	}
/*N*/ 
/*N*/ 	// ViewInputHandler
/*N*/ 	//	#48721# jeder Task hat neuerdings sein eigenes InputWindow,
/*N*/ 	//	darum muesste eigentlich entweder jeder Task seinen InputHandler bekommen,
/*N*/ 	//	oder das InputWindow muesste sich beim App-InputHandler anmelden, wenn der
/*N*/ 	//	Task aktiv wird, oder das InputWindow muesste sich den InputHandler selbst
/*N*/ 	//	anlegen (dann immer ueber das InputWindow suchen, und nur wenn das nicht da
/*N*/ 	//	ist, den InputHandler von der App nehmen).
/*N*/ 	//	Als Sofortloesung bekommt erstmal jede View ihren Inputhandler, das gibt
/*N*/ 	//	nur noch Probleme, wenn zwei Views in einem Task-Fenster sind.
/*N*/ 
/*N*/ 	pInputHandler = new ScInputHandler;
/*N*/ 
/*N*/ 	// Alte Version:
/*N*/ 	//	if ( !GetViewFrame()->ISA(SfxTopViewFrame) )		// OLE oder Plug-In
/*N*/ 	//		pInputHandler = new ScInputHandler;
/*N*/ 
/*N*/ 			//	FormShell vor MakeDrawView anlegen, damit die DrawView auf jeden Fall
/*N*/ 			//	an der FormShell angemeldet werden kann
/*N*/ 			//	Gepusht wird die FormShell im ersten Activate
/*N*/ 	pFormShell = new FmFormShell(this);
/*N*/ 
/*N*/ 			//	DrawView darf nicht im TabView - ctor angelegt werden,
/*N*/ 			//	wenn die ViewShell noch nicht kostruiert ist...
/*N*/ 	if (pDoc->GetDrawLayer())
/*N*/ 		MakeDrawView( nForceDesignMode );
/*N*/ 	ViewOptionsHasChanged(FALSE);	// legt auch evtl. DrawView an
/*N*/ 
/*N*/ 	SetUndoManager( pDocSh->GetUndoManager() );
/*N*/ 	pFormShell->SetUndoManager( pDocSh->GetUndoManager() );
/*N*/ 	SetRepeatTarget( &aTarget );
/*N*/ 	pFormShell->SetRepeatTarget( &aTarget );
/*N*/ 	SetHelpId( HID_SCSHELL_TABVWSH );
/*N*/ 
/*N*/ 	if ( bFirstView )
/*N*/ 	{	// erste View?
/*N*/ 
/*N*/ 		//	Tabellen anhaengen? (nicht bei OLE)
/*N*/ 		if ( pDocSh->IsEmpty() &&
/*N*/ 				pDocSh->GetCreateMode() != SFX_CREATE_MODE_EMBEDDED )
/*N*/ 		{
/*N*/ 			USHORT nInitTabCount = 3;							//!	konfigurierbar !!!
/*N*/ 			for (USHORT i=1; i<nInitTabCount; i++)
/*N*/ 				pDoc->MakeTable(i);
/*N*/ 
/*N*/ 			pDocSh->ResetEmpty();			// #i6232# make sure this is done only once
/*N*/ 		}
/*N*/ 
/*N*/ 
/*N*/ 		//	Link-Update nicht verschachteln
/*N*/ 		if ( pDocSh->GetCreateMode() != SFX_CREATE_MODE_INTERNAL &&
/*N*/              pDocSh->IsUpdateEnabled() )  // #105575#; update only in the first creation of the ViewShell
/*N*/ 		{
/*N*/ 			BOOL bLink = FALSE;									// Links updaten
/*N*/ 			USHORT nTabCount = pDoc->GetTableCount();
/*N*/ 			for (USHORT i=0; i<nTabCount && !bLink; i++)
/*N*/ 				if (pDoc->IsLinked(i))
/*N*/ 					bLink = TRUE;
/*N*/ 			if (!bLink)
/*N*/ 				if (pDoc->HasDdeLinks() || pDoc->HasAreaLinks())
/*N*/ 					bLink = TRUE;
/*N*/ 			if (bLink)
/*N*/ 			{
/*N*/ 				if ( !pFirst )
/*N*/ 					pFirst = GetViewFrame();
/*N*/ 
/*N*/ 				if(SC_MOD()->GetCurRefDlgId()==0)
/*N*/ 				{
/*N*/ 						pFirst->GetDispatcher()->Execute( SID_UPDATETABLINKS,
/*N*/ 											SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD );
/*N*/ 				}
/*N*/ 			}
/*N*/ 
/*N*/ 			BOOL bReImport = FALSE;								// importierte Daten aktualisieren
/*N*/ 			ScDBCollection* pDBColl = pDoc->GetDBCollection();
/*N*/ 			if ( pDBColl )
/*N*/ 			{
/*N*/ 				USHORT nCount = pDBColl->GetCount();
/*N*/ 				for (USHORT i=0; i<nCount && !bReImport; i++)
/*N*/ 				{
/*N*/ 					ScDBData* pData = (*pDBColl)[i];
/*N*/ 					if ( pData->IsStripData() &&
/*N*/ 							pData->HasImportParam() && !pData->HasImportSelection() )
/*N*/ 						bReImport = TRUE;
/*N*/ 				}
/*N*/ 			}
/*N*/ 			if (bReImport)
/*N*/ 			{
/*?*/ 				if ( !pFirst )
/*?*/ 					pFirst = GetViewFrame();
/*?*/ 				if(SC_MOD()->GetCurRefDlgId()==0)
/*?*/ 				{
/*?*/ 					pFirst->GetDispatcher()->Execute( SID_REIMPORT_AFTER_LOAD,
/*?*/ 											SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD );
/*?*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	UpdateAutoFillMark();
/*N*/ 
/*N*/ 	// ScDispatchProviderInterceptor registers itself in ctor
/*N*/ 	xDisProvInterceptor = new ScDispatchProviderInterceptor( this );
/*N*/ 
/*N*/ 	bFirstActivate = TRUE; // NavigatorUpdate aufschieben bis Activate()
/*N*/ 
/*N*/     // #105575#; update only in the first creation of the ViewShell
/*N*/     pDocSh->SetUpdateEnabled(FALSE);
/*N*/ }

//------------------------------------------------------------------

/*N*/ ScTabViewShell::ScTabViewShell( SfxViewFrame* pViewFrame,
/*N*/ 								SfxViewShell* pOldSh ) :
/*N*/ 	__INIT_ScTabViewShell,
/*N*/ 	ScDBFunc( &pViewFrame->GetWindow(), (ScDocShell&)*pViewFrame->GetObjectShell(), this )
/*N*/ {
/*N*/ 	RTL_LOGFILE_CONTEXT_AUTHOR ( aLog, "sc", "nn93723", "ScTabViewShell::ScTabViewShell" );
/*N*/ 
/*N*/ 	const ScAppOptions&	rAppOpt = SC_MOD()->GetAppOptions();
/*N*/ 
/*N*/ 	//	if switching back from print preview,
/*N*/ 	//	restore the view settings that were active when creating the preview
/*N*/ 	//	#89897# ReadUserData must not happen from ctor, because the view's edit window
/*N*/ 	//	has to be shown by the sfx. ReadUserData is deferred until the first Activate call.
/*N*/ 	//	#106334# old DesignMode state from form layer must be restored, too
/*N*/ 
/*N*/ 	BYTE nForceDesignMode = SC_FORCEMODE_NONE;
/*N*/ 	if ( pOldSh && pOldSh->ISA( ScPreviewShell ) )
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 ScPreviewShell* pPreviewShell = ((ScPreviewShell*)pOldSh);
/*N*/ 	}
/*N*/ 
/*N*/ 	Construct( nForceDesignMode );
/*N*/ 
/*N*/ 	if ( GetViewData()->GetDocShell()->IsPreview() )
/*N*/ 	{
/*?*/ 		//	preview for template dialog: always show whole page
/*?*/ 		SetZoomType( SVX_ZOOM_WHOLEPAGE );		// zoom value is recalculated at next Resize
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		Fraction aFract( rAppOpt.GetZoom(), 100 );
/*N*/ 		SetZoom( aFract, aFract );
/*N*/ 		SetZoomType( rAppOpt.GetZoomType() );
/*N*/ 	}
/*N*/ 
/*N*/ 	uno::Reference<frame::XFrame> xFrame = pViewFrame->GetFrame()->GetFrameInterface();
/*N*/ 	if (xFrame.is())
/*N*/ 		xFrame->setComponent( uno::Reference<awt::XWindow>(), new ScTabViewObj( this ) );
/*N*/ 
/*N*/ 	SetCurSubShell(OST_Cell);
/*N*/ }

#undef __INIT_ScTabViewShell

//------------------------------------------------------------------

/*N*/ __EXPORT ScTabViewShell::~ScTabViewShell()
/*N*/ {
/*N*/ 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
/*N*/ 	EndListening(*pDocSh);
/*N*/ 	EndListening(*GetViewFrame());
/*N*/ 
/*N*/ 	SC_MOD()->ViewShellGone(this);
/*N*/ 
/*N*/ 	RemoveSubShell();			// alle
/*N*/ 	SetWindow(0);
/*N*/ 
/*N*/ 	//	#54104# alles auf NULL, falls aus dem TabView-dtor noch darauf zugegriffen wird
/*N*/ 	//!	(soll eigentlich nicht !??!?!)
/*N*/ 
/*N*/ 	DELETEZ(pCellShell);
/*N*/ 	DELETEZ(pPageBreakShell);
/*N*/ 	DELETEZ(pDrawShell);
/*N*/ 	DELETEZ(pDrawFormShell);
/*N*/ 	DELETEZ(pOleObjectShell);
/*N*/ 	DELETEZ(pChartShell);
/*N*/ 	DELETEZ(pGraphicShell);
/*N*/ 	DELETEZ(pDrawTextShell);
/*N*/ 	DELETEZ(pEditShell);
/*N*/ 	DELETEZ(pPivotShell);
/*N*/ 	DELETEZ(pAuditingShell);
/*N*/ 	DELETEZ(pCurFrameLine);
/*N*/ 	DELETEZ(pInputHandler);
/*N*/ 	DELETEZ(pPivotSource);
/*N*/ 	DELETEZ(pDialogDPObject);
/*N*/     DELETEZ(pNavSettings);
/*N*/ 
/*N*/ 	DELETEZ(pFormShell);
/*N*/ 	DELETEZ(pAccessibilityBroadcaster);
/*N*/ }


/*N*/ void ScTabViewShell::GetTbxState( SfxItemSet& rSet )
/*N*/ {
/*N*/ 	rSet.Put( SfxUInt16Item( SID_TBXCTL_INSERT,   nInsertCtrlState ) );
/*N*/ 	rSet.Put( SfxUInt16Item( SID_TBXCTL_INSCELLS, nInsCellsCtrlState ) );
/*N*/ 
/*N*/ 	//	ohne installiertes Chart darf Chart nicht Default sein...
/*N*/ 	if ( nInsObjCtrlState == SID_DRAW_CHART && !SvtModuleOptions().IsChart() )
/*N*/ 		nInsObjCtrlState = SID_INSERT_OBJECT;
/*N*/ 
/*N*/ 	rSet.Put( SfxUInt16Item( SID_TBXCTL_INSOBJ,   nInsObjCtrlState ) );
/*N*/ }

}
