/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sch_fudraw.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 17:47:36 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#define _SDR_NOITEMS
#define _SDR_NOTOUCH
#define _SDR_NOTRANSFORM
#define _SI_NOSBXCONTROLS
#define _SI_NOOTHERFORMS
#define _SI_NOCONTROL
#define _SI_NOSBXCONTROLS

#pragma hdrstop

#include "app.hrc"
#include "strings.hrc"
#include "fudraw.hxx"
#include "schview.hxx"
#include "chwindow.hxx"
#include <bf_svx/svxids.hrc>
namespace binfilter {



/*************************************************************************
|*
|* Basisklasse fuer alle Drawmodul-spezifischen Funktionen
|*
\************************************************************************/

/*N*/ SchFuDraw::SchFuDraw(SchViewShell* pViewSh, SchWindow* pWin, SchView* pView,
/*N*/ 			   ChartModel* pDoc, SfxRequest& rReq) :
/*N*/ 	SchFuPoor(pViewSh, pWin, pView, pDoc, rReq),
/*N*/ 	aNewPointer(POINTER_ARROW),
/*N*/ 	aOldPointer(POINTER_ARROW),
/*N*/ 	bMBDown(FALSE)
/*N*/ {
/*N*/ }

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

/*N*/ SchFuDraw::~SchFuDraw()
/*N*/ {
/*N*/ 	pView->BrkAction();
/*N*/ }

/*************************************************************************
|*
|* Tastaturereignisse bearbeiten
|*
|* Wird ein KeyEvent bearbeitet, so ist der Return-Wert TRUE, andernfalls
|* FALSE.
|*
\************************************************************************/


/*************************************************************************
|*
|* MouseButtonDown-event
|*
\************************************************************************/


/*************************************************************************
|*
|* MouseMove-event
|*
\************************************************************************/


/*************************************************************************
|*
|* MouseButtonUp-event
|*
\************************************************************************/


/*************************************************************************
|*
|* Function aktivieren
|*
\************************************************************************/

/*N*/ void SchFuDraw::Activate()
/*N*/ {
/*N*/ 	SchFuPoor::Activate();
/*N*/ 
/*N*/ 	ForcePointer();
/*N*/ }

/*************************************************************************
|*
|* Maus-Pointer umschalten
|* FG: Bisher (8.3.97) gab es nur einen einzigen Mousepointer und den
|*     brauchte man daher auch nie umschalten. Ab jetzt gibt es auch
|*     Mousepointer die ein Resize andeuten.
|*
\************************************************************************/

/*N*/ void SchFuDraw::ForcePointer(const MouseEvent* pMEvt)
/*N*/ {
/*N*/ 	if (pMEvt != NULL)
/*N*/ 	{
/*?*/ 		USHORT nModifier = 0;
/*?*/ 		BOOL bLeftDown = FALSE;
/*?*/ 		BOOL bAllowChange=TRUE;
/*?*/ 		USHORT nHitLog = (USHORT)pWindow->PixelToLogic(Size(HITPIX,0)).Width();
/*?*/ 
/*?*/ 		Point aPnt(pWindow->PixelToLogic(pMEvt->GetPosPixel()));
/*?*/ 		nModifier = pMEvt->GetModifier();
/*?*/ 		bLeftDown = pMEvt->IsLeft();
/*?*/ 
/*?*/ 		Pointer aPointer = pView->GetPreferedPointer(aPnt, pWindow,
/*?*/ 														  nModifier, bLeftDown);
/*?*/ 		if( aPointer.GetStyle() == POINTER_TEXT )
/*?*/ 		{
/*?*/ 			SdrObject*   pObj = NULL;
/*?*/ 			SdrPageView* pPV  = pView->GetPageViewPvNum (0);
/*?*/ 
/*?*/ 			pView->PickObj(aMDPos,nHitLog,pObj,pPV);
/*?*/ 
/*?*/ 			if(pObj)
/*?*/ 			{
/*?*/ 
/*?*/ 				SchObjectId* pId = GetObjectId(*pObj);
/*?*/ 				if (pId)switch(pId->GetObjId())
/*?*/ 				{
/*?*/ 
/*?*/ 					case CHOBJID_TITLE_MAIN:
/*?*/ 					case CHOBJID_TITLE_SUB :
/*?*/ 					case CHOBJID_DIAGRAM_TITLE_X_AXIS :
/*?*/ 					case CHOBJID_DIAGRAM_TITLE_Y_AXIS :
/*?*/ 					case CHOBJID_DIAGRAM_TITLE_Z_AXIS :
/*?*/ 						break;
/*?*/ 					default:
/*?*/ 						bAllowChange=FALSE;
/*?*/ 					break;
/*?*/ 				}
/*?*/ 			}
/*?*/ 		}
/*?*/ 		if( aPointer.GetStyle() == POINTER_MOVE )
/*?*/ 		{
/*?*/ 			SdrObject*   pObj = NULL;
/*?*/ 			SdrPageView* pPV  = pView->GetPageViewPvNum (0);
/*?*/ 
/*?*/ 			pView->PickObj(aMDPos,nHitLog,pObj,pPV);
/*?*/ 
/*?*/ 			if(pObj)
/*?*/ 			{
/*?*/ 				SchObjectId* pId = GetObjectId(*pObj);
/*?*/ 				if (pId)switch(pId->GetObjId())
/*?*/ 				{
/*?*/ 
/*?*/ 					case CHOBJID_LEGEND_SYMBOL_ROW:
/*?*/ 					case CHOBJID_LEGEND_SYMBOL_COL:
/*?*/ 						aPointer=Pointer(POINTER_ARROW);
/*?*/ 						break;
/*?*/ 					default:
/*?*/ 					break;
/*?*/ 				}
/*?*/ 			}
/*?*/ 		}
/*?*/ 
/*?*/         // there is no point-editing in a chart
/*?*/         if( aPointer.GetStyle() == POINTER_MOVEPOINT )
/*?*/         {
/*?*/             aPointer = Pointer( POINTER_ARROW );
/*?*/         }
/*?*/ 
/*?*/ 
/*?*/ 		switch(aPointer.GetStyle())
/*?*/ 		{
/*?*/ 		case POINTER_DRAW_BEZIER:
/*?*/ 		case POINTER_HAND:
/*?*/ 		case POINTER_MOVEBEZIERWEIGHT:
/*?*/ 			 bAllowChange=FALSE;
/*?*/ 		default: break;
/*?*/ 		}
/*?*/ 
/*?*/ 		if(bAllowChange)
/*?*/ 			pWindow->SetPointer(aPointer);
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Reaktion auf Doppelklick
|*
\************************************************************************/


// ========================================
// Methods for selecting and moving objects
// with the keyboard
// ========================================









}
