/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sch_fusel.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 17:47:58 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop



// header for SdrCircObj

#include "app.hrc"
#include "fusel.hxx"
#include "schview.hxx"

// header for SchCalculationHelper
// header for SchDragConstrainedToVector
#include "strings.hrc"
namespace binfilter {



/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

/*N*/ SchFuSelection::SchFuSelection(SchViewShell* pViewSh, SchWindow* pWin,
/*N*/ 							   SchView* pView, ChartModel* pDoc,
/*N*/ 							   SfxRequest& rReq) :
/*N*/ 		SchFuDraw(pViewSh, pWin, pView, pDoc, rReq),
/*N*/ 		bVCAction(FALSE),
/*N*/ 		pDragMethod(NULL)
/*N*/ {
/*N*/ }

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

/*N*/ SchFuSelection::~SchFuSelection()
/*N*/ {
/*N*/ 	if( pView->GetDragMode() != SDRDRAG_MOVE )
/*?*/ 	{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 	pView->SetDragMode(SDRDRAG_MOVE);
/*N*/ }

/*************************************************************************
|*
|* Wege durch die MouseUp/Down Events:
|*
|* Weg A:  markierte Gesamtflaeche -> markierte Diagramflaeche (DIAGRAM_AREA -> DIAGRAM)
|*         (durch Klick in freie Flaeche, z.B. neben einem Datenpunkt)
|* Weg B:  markierte Gesamtflaeche -> markierte Datenreihe
\*************************************************************************/

/*************************************************************************
|*
|* MouseButtonDown-event
|*
\************************************************************************/


/*************************************************************************
|*
|* MouseMove-event
|*
\************************************************************************/



/*************************************************************************
|*
|* MouseButtonUp-event
|*
\************************************************************************/


/*************************************************************************
|*
|* Command-event
|*
\************************************************************************/


/*************************************************************************
|*
|* Function aktivieren
|*
\************************************************************************/

/*N*/ void SchFuSelection::Activate()
/*N*/ {
/*N*/ 	pView->SetEditMode(TRUE);
/*N*/ 
/*N*/ 	SchFuDraw::Activate();
/*N*/ }

/*************************************************************************
|*
|* Function deaktivieren
|*
\************************************************************************/

/*N*/ void SchFuSelection::Deactivate()
/*N*/ {
/*N*/ 	if(pView->GetDragMode() != SDRDRAG_MOVE)
/*?*/ 	{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 	pView->SetDragMode(SDRDRAG_MOVE);
/*N*/ 
/*N*/ 	pView->SetEditMode(FALSE);
/*N*/ 
/*N*/ 	SchFuDraw::Deactivate();
/*N*/ }




}
