/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sch_viewshe1.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 18:00:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#ifndef	_SFX_WHITER_HXX
# include	<svtools/whiter.hxx>
#endif


#define _SI_NOSBXCONTROLS
#define _SI_NOOTHERFORMS
#define _SI_NOCONTROL
#define _SI_NOSBXCONTROLS
#define _SDR_NOITEMS
#define _SDR_NOTOUCH
#define _SDR_NOVIEWMARKER
#define _SDR_NODRAGMETHODS
#define _SDR_NOUNDO
#define _SDR_NOXOUTDEV


#pragma hdrstop

#define ITEMID_LRSPACE			EE_PARA_LRSPACE
#define ITEMID_ULSPACE			EE_PARA_ULSPACE

#define ITEMID_SIZE 0



#ifndef _SFX_HRC
#include <bf_sfx2/sfx.hrc>
#endif
#include <svtools/style.hrc>
#include <bf_svx/dialogs.hrc>



#include "schattr.hxx"
#define ITEMID_CHARTLEGENDPOS	SCHATTR_LEGEND_POS

#include "app.hrc"
#include "strings.hrc"
#include "res_bmp.hrc"
#include "glob.hrc"


#define ITEMID_COLOR 0

#include "viewshel.hxx"
#include "schview.hxx"
#include "fusel.hxx"

#ifndef _SCH_DATAROW_HXX
# include	"datarow.hxx"
#endif
#ifndef _SCH_DATAPOIN_HXX
# include	"datapoin.hxx"
#endif

namespace binfilter {
/*************************************************************************
|*
|* SfxRequests fuer Support-Funktionen
|*
\************************************************************************/


/*************************************************************************
|*
|* SfxRequests fuer permanente Funktionen
|*
\************************************************************************/

/*N*/ void SchViewShell::FuPermanent(SfxRequest &rReq)
/*N*/ {
/*N*/ 	ChartModel* pChDoc = &pChView->GetDoc();
/*N*/ 	USHORT nSlotID = rReq.GetSlot();
/*N*/ 
/*N*/ 	if (pFuActual)
/*N*/ 	{
/*?*/ 		if (pFuOld == pFuActual)
/*?*/ 			pFuOld = NULL;
/*?*/ 
/*?*/ 		if (nSlotID != SID_TEXTEDIT && pChView->IsTextEdit())
/*?*/ 			pChView->EndTextEdit();
/*?*/ 
/*?*/ 		pFuActual->Deactivate();
/*?*/ 		delete pFuActual;
/*?*/ 		pFuActual = NULL;
/*N*/ 	}

/*N*/ 	switch (nSlotID)
/*N*/ 	{
/*N*/ 		case SID_TOOL_SELECT:
/*N*/ 			pFuActual = new SchFuSelection(this, GetWindow(), pChView,
/*N*/ 										   pChDoc, rReq);
/*N*/ 			rReq.Done();
/*N*/ 			break;
/*N*/ 
/*?*/ 		case SID_TEXTEDIT:
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 	pFuActual = new SchFuText(this, GetWindow(), pChView,
/*?*/ 			break;
/*N*/ 	}
/*N*/ 
/*N*/ 	if (pFuOld)
/*N*/ 	{
/*?*/ 		pFuOld->Deactivate();
/*?*/ 		delete pFuOld;
/*?*/ 		pFuOld = NULL;
/*N*/ 	}
/*N*/ 
/*N*/ 	if (pFuActual)
/*N*/ 	{
/*N*/ 		pFuActual->Activate();
/*N*/ 		pFuOld = pFuActual;
/*N*/ 	}
/*N*/ 
/*N*/ 	// Shell wird invalidiert, schneller als einzeln (laut MI)
/*N*/ 
/*N*/ 	Invalidate();
/*N*/ }


/*************************************************************************
|*
|* Status (Enabled/Disabled) von Menue-SfxSlots setzen
|*
\************************************************************************/

/*?*/ void SchViewShell::GetMenuState(SfxItemSet &rSet)
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

/*************************************************************************
|*
|* SfxRequests fuer StatusBar bearbeiten
|*
\************************************************************************/


/*************************************************************************
|*
|* Statuswerte der Statusbar zurueckgeben
|*
\************************************************************************/

/*N*/ void SchViewShell::GetStatusBarState(SfxItemSet& rSet)
/*N*/ {
/*N*/ }

/*************************************************************************
|*
|* Status der Attribut-Items
|*
\************************************************************************/




/**
	@short	Set the given item set at the given object.
*/

/*?*/ IMPL_LINK( SchViewShell, ClipboardChanged, TransferableDataHelper*, pDataHelper )
/*?*/ {
/*?*/ 	{DBG_BF_ASSERT(0, "STRIP");} return 0;//STRIP001 	if ( pDataHelper )
/*?*/ }
}
