/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sch_viewshe4.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 18:00:56 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/






#define _SI_NOSBXCONTROLS
#define _SI_NOOTHERFORMS
#define _SI_NOCONTROL
#define _SI_NOSBXCONTROLS
#define _SDR_NOITEMS
#define _SDR_NOTOUCH
#define _SDR_NOVIEWMARKER
#define _SDR_NODRAGMETHODS
#define _SDR_NOUNDO
#define _SDR_NOXOUTDEV


#pragma hdrstop

#define ITEMID_LRSPACE			EE_PARA_LRSPACE
#define ITEMID_ULSPACE			EE_PARA_ULSPACE

#define ITEMID_SIZE 0



#ifndef _CLIPLISTENER_HXX
#include <svtools/cliplistener.hxx>
#endif


#define _SI_NOSBXCONTROLS
#define _SI_NOOTHERFORMS
#define _SI_NOCONTROL
#define _SI_NOSBXCONTROLS
#define _SDR_NOITEMS
#define _SDR_NOTOUCH
#define _SDR_NOTRANSFORM
#define _SDR_NOVIEWMARKER
#define _SDR_NODRAGMETHODS
#define _SDR_NOUNDO
#define _SDR_NOXOUTDEV


#pragma hdrstop

#define ITEMID_LRSPACE			EE_PARA_LRSPACE
#define ITEMID_ULSPACE			EE_PARA_ULSPACE

#define ITEMID_SIZE 0

//sfxcore.hxx

#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif


#ifndef _SFX_HRC
#include <bf_sfx2/sfx.hrc>
#endif
//------------------------------------------------------------------
//
// dieses Define dient nur zum Testen und darf auf keinen Fall aktiv bleiben
// Bei Umstellungen alle Files nach SIG_CHARTMODELDEFSCHDOC durchsuchen
// #define ChartModel SchChartDocument
//------------------------------------------------------------------
#include <svtools/style.hrc>
#include <bf_svx/dialogs.hrc>

#ifndef _SVX_F3DCHILD_HXX //autogen
#include <bf_svx/f3dchild.hxx>
#endif

#include "chwindow.hxx"
#include "schattr.hxx"
#define ITEMID_CHARTLEGENDPOS	SCHATTR_LEGEND_POS

#include "app.hrc"
#include "strings.hrc"
#include "res_bmp.hrc"
#include "glob.hrc"
#include "schview.hxx"
#include "schresid.hxx"

#define _SBX_HXX 0
#include "viewshel.hxx"
#include "fusel.hxx"
#include "schhids.h"


#include "ChXChartView.hxx"


/*************************************************************************
|*
|* SFX-Slotmap und Standardinterface deklarieren
|*
\************************************************************************/

#define SchViewShell
namespace binfilter {
#include "schslots.hxx"

/*N*/ SFX_IMPL_INTERFACE( SchViewShell, SfxViewShell, SchResId( STR_CHARTVIEWSHELL ))
/*N*/ // from macro: void SchViewShell::InitInterface_Impl()
/*N*/ {
/*N*/ 	SFX_OBJECTBAR_REGISTRATION( SFX_OBJECTBAR_TOOLS | SFX_VISIBILITY_STANDARD |
/*N*/ 								SFX_VISIBILITY_FULLSCREEN | SFX_VISIBILITY_SERVER,
/*N*/ 								SchResId( RID_DRAW_TOOLBOX ));
/*N*/ 	SFX_FEATURED_CHILDWINDOW_REGISTRATION( Svx3DChildWindow::GetChildWindowId(), SCH_UI_FEATURE_THREE_D );
/*N*/ }

/*N*/ SFX_IMPL_VIEWFACTORY(SchViewShell, SchResId(STR_DEFAULTVIEW))
/*N*/ {
/*N*/ 	SFX_VIEW_REGISTRATION(SchChartDocShell);
/*N*/ }

/*N*/ TYPEINIT1(SchViewShell, SfxViewShell);

/*************************************************************************
|*
|* gemeinsamer Initialiserungsanteil der beiden Konstruktoren
|*
\************************************************************************/

/*N*/ void SchViewShell::Construct(SchChartDocShell& rDocSh)
/*N*/ {
/*N*/ 	bUserKnowsTranslation=FALSE;
/*N*/ 	// Hilfe-ID setzen
/*N*/ 	SetHelpId( HID_SCH_VIEWSHELL_DOCUMENT );
/*N*/ 
/*N*/ 	bRepaintPossible = TRUE;
/*N*/ 	bFirstStart      = TRUE;
/*N*/ 
/*N*/     OutputDevice * pOutDev = GetWindow();
/*N*/ 	pChView          = new SchView(&rDocSh, pOutDev, this);
/*N*/ 
/*N*/ 	// Muss Namen haben, damit Basic ueber OLE funktioniert
/*N*/ 	SetName( String( RTL_CONSTASCII_USTRINGPARAM( "View" )));
/*N*/ 
/*N*/ 	SetPool(&rDocSh.GetDoc().GetPool());
/*N*/ 	SetUndoManager(rDocSh.GetUndoManager());
/*N*/ 	SetRepeatTarget(pChView);
/*N*/ 
/*N*/ 	// Initialisierungen der Zeichen-(Bildschirm-)Attribute
/*N*/ 	pChView->SetGridCoarse(Size(1000, 1000));
/*N*/ 	pChView->SetSnapGrid(Size(1000, 1000));
/*N*/ 	pChView->SetGridVisible(FALSE);
/*N*/ 	pChView->SetGridSnap(FALSE);
/*N*/ 	pChView->SetDragStripes(FALSE);
/*N*/ 	pChView->SetFrameDragSingles(TRUE);
/*N*/ 	pChView->SetNoDragXorPolys(TRUE);
/*N*/ 
/*N*/ 	SetZoom(100);
/*N*/ 	pChView->ShowPagePgNum(0, Point(0, 0));
/*N*/ 
/*N*/ 	// Darstellung von Gruppierungen disablen, dies ist
/*N*/ 	// im Chart nicht erwuenscht...
/*N*/ 	pChView->SetVisualizeEnteredGroup(FALSE);
/*N*/ 
/*N*/ 	// Selektionsfunktion starten
/*N*/ //	SfxRequest aReq(SID_TOOL_SELECT, pChView->GetDoc().GetItemPool());
/*N*/ 	SfxRequest aReq(SID_TOOL_SELECT, 0, pChView->GetDoc().GetItemPool());
/*N*/ 	FuPermanent(aReq);
/*N*/ 
/*N*/     // #109912# Transfer Arabic/Hindi Cipher setting from RefDevice to Window
/*N*/     if( pOutDev )
/*N*/     {
/*?*/         OutputDevice * pRefDev = rDocSh.GetRefDevice();
/*?*/         if( pRefDev )
/*?*/         {
/*?*/             pOutDev->SetDigitLanguage( pRefDev->GetDigitLanguage() );
/*?*/         }
/*?*/         else
/*?*/         {
/*?*/             DBG_ERROR( "No RefDevice" );
/*?*/         }
/*N*/     }
/*N*/     else
/*N*/     {
/*N*/         DBG_ERROR( "Invalid Window" );
/*N*/     }
/*N*/ 
/*N*/     // remember the UNO Controller
/*N*/     mpUNOController = new ChXChartView( this );
/*N*/ 
/*N*/ 	::com::sun::star::uno::Reference< ::com::sun::star::awt::XWindow > aTmpRef;
/*N*/ 	GetViewFrame()->GetFrame()->GetFrameInterface()->setComponent( aTmpRef, mpUNOController );
/*N*/ 
/*N*/     pChView->SetSolidMarkHdl( TRUE );
/*N*/     StartListening( rDocSh );
/*N*/ }

/*************************************************************************
|*
|* Standard-Konstruktor
|*
\************************************************************************/


/*************************************************************************
|*
|* Standard-Konstruktor (2)
|*
\************************************************************************/

/*N*/ SchViewShell::SchViewShell(SfxViewFrame* pFrame,
/*N*/ 						   SfxViewShell* pOldShell) :
/*N*/ 	SfxViewShell(pFrame, SFX_VIEW_MAXIMIZE_FIRST |
/*N*/ 						 SFX_VIEW_OPTIMIZE_EACH |
/*N*/ 						 SFX_VIEW_OBJECTSIZE_EMBEDDED |
/*N*/ 						 SFX_VIEW_DISABLE_ACCELS |
/*N*/ 						 SFX_VIEW_CAN_PRINT),
/*N*/ 	pFuActual(NULL),
/*N*/ 	pFuOld(NULL),
/*N*/ 	nCurrentObjectBar(0),
/*N*/ 	bObjectBarSwitchEnabled(TRUE),
/*N*/ 	pTempFuActual(NULL),
/*N*/ 	pDocSh( (SchChartDocShell*) GetViewFrame()->GetObjectShell() ),
/*N*/ 	mpClipEvtLstnr(NULL),
/*N*/     mp3DFlyerReference(NULL),
/*N*/ 	mbPastePossible(FALSE),
/*N*/     mbTextPastePossible(FALSE),
/*N*/     mpUNOController( NULL ),
/*N*/     mbBroadcastSelectionChanges( sal_True ),
/*N*/     mbPendingSelectionChange( sal_False )
/*N*/ {
/*N*/ 	SchWindow* pWin = new SchWindow(&pFrame->GetWindow());
/*N*/ 	SetWindow(pWin);
/*N*/ 	pWin->SetViewShell(this);
/*N*/ 
/*N*/ 	Construct(*(SchChartDocShell*)pFrame->GetObjectShell());
/*N*/ }

/*************************************************************************
|*
|* Copy-Konstruktor
|*
\************************************************************************/


/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

/*N*/ SchViewShell::~SchViewShell()
/*N*/ {
/*N*/     if( NULL != pDocSh )
/*N*/         EndListening( *pDocSh );
/*N*/ 
/*N*/     // #96642# Remove references to items within Svx3DWin
/*N*/     // (maybe do a listening sometime in Svx3DWin)
/*N*/     USHORT nId = Svx3DChildWindow::GetChildWindowId();
/*N*/     SfxChildWindow* pWindow = GetViewFrame() ? GetViewFrame()->GetChildWindow(nId) : NULL;
/*N*/     if( pWindow )
/*N*/     {
/*?*/         DBG_BF_ASSERT(0, "STRIP"); //STRIP001 Svx3DWin* p3DWin = static_cast< Svx3DWin* >( pWindow->GetWindow() );
/*N*/     }
/*N*/ 
/*N*/ 	SwitchObjectBar(0);
/*N*/ 
/*N*/ 	// Umschaltung der ObjectBarShells unterdruecken, sonst versucht die
/*N*/ 	// sterbende Funktion eventuell die ObjectBars zu wechseln. Die
/*N*/ 	// entsprechende Shell ist aber schon vom SFX vom Dispatcher-Stack
/*N*/ 	// genommen worden.
/*N*/ 	bObjectBarSwitchEnabled = FALSE;
/*N*/ 
/*N*/ 	if (pFuActual)
/*N*/ 	{
/*N*/ 		if (pFuOld == pFuActual)
/*N*/ 			pFuOld = NULL;
/*N*/ 
/*N*/ 		pFuActual->Deactivate();
/*N*/ 		delete pFuActual;
/*N*/ 		pFuActual = NULL;
/*N*/ 	}
/*N*/ 
/*N*/ 	if (pFuOld)
/*N*/ 	{
/*?*/ 		delete pFuOld;
/*?*/ 		pFuOld = NULL;
/*N*/ 	}
/*N*/ 
/*N*/     // remove listener for system clipboard
/*N*/ 	if ( mpClipEvtLstnr )
/*N*/ 	{
/*N*/ 		mpClipEvtLstnr->AddRemoveListener( GetWindow(), FALSE );
/*N*/ 		mpClipEvtLstnr->release();
/*N*/ 	}
/*N*/ 
/*N*/ 	delete pChView;
/*N*/ 
/*N*/ 	delete GetWindow();
/*N*/ 	SetWindow( NULL );	// #76782#
/*N*/ 
/*N*/ 	// Shells fuer Object Bars loeschen
/*N*/ 	// vorm Zerstoeren der ObjectBarShells den Dispatcher flushen
/*N*/ 	GetViewFrame()->GetDispatcher()->Flush();
/*N*/ 
/*N*/ 	SfxShell* pObjBarShell = (SfxShell*)aShellTable.First();
/*N*/ 	while (pObjBarShell)
/*N*/ 	{
/*?*/ 		delete pObjBarShell;
/*?*/ 		pObjBarShell = (SfxShell*)aShellTable.Next();
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Paint-Methode: das Ereignis wird vom Fenster an die Viewshell und
|* die aktuelle Funktion weitergeleitet
|*
\************************************************************************/


/*************************************************************************
|*
|* View ermitteln
|*
\************************************************************************/

/*N*/ SchView* SchViewShell::GetView() const
/*N*/ {
/*N*/ 	return pChView;
/*N*/ }

/*************************************************************************
|*
|* Vorbereitung fuers Drucken; virtuell, wird vom SFX aufgerufen
|*
\************************************************************************/


/*************************************************************************
|*
|* Drucken; virtuell, wird vom SFX aufgerufen
|*
\************************************************************************/


/*************************************************************************
|*
|* Command event
|*
\************************************************************************/


/*************************************************************************
|*
|* Wird gerufen, wenn sich der Selektionszustand der View aendert
|*
\************************************************************************/

/*N*/ void SchViewShell::SelectionHasChanged()
/*N*/ {
/*N*/ 	Invalidate();
/*N*/ 
/*N*/ 	// 3d flyer window
/*N*/ 	USHORT nId = Svx3DChildWindow::GetChildWindowId();
/*N*/ 	SfxChildWindow* pWindow = GetViewFrame()->GetChildWindow( nId );
/*N*/ 	if( pWindow )
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 Svx3DWin* p3DWin = (Svx3DWin*)( pWindow->GetWindow() );
/*N*/ 	}
/*N*/ 
/*N*/     if( mbBroadcastSelectionChanges )
/*N*/     {
/*N*/         pChView->UpdateSelectionClipboard( FALSE );
/*N*/ 
/*N*/         if( mpUNOController != NULL )
/*?*/             mpUNOController->fireSelectionChangeListener();
/*N*/ 
/*N*/         mbPendingSelectionChange = sal_False;
/*N*/     }
/*N*/     else
/*?*/         mbPendingSelectionChange = sal_True;
/*N*/ }

/*************************************************************************
|*
|* aktuellen Drucker des Dokuments zurueckgeben
|*
\************************************************************************/

/*N*/ SfxPrinter* SchViewShell::GetPrinter(BOOL bCreate)
/*N*/ {
/*N*/ 	return (*(SchChartDocShell*)GetViewFrame()->
/*N*/ 								GetObjectShell()).GetPrinter();
/*N*/ }

/*************************************************************************
|*
|* neuen Drucker fuer die Applikation setzen
|*
\************************************************************************/


/*************************************************************************
|*
|* PrepareClose, ggfs. Texteingabe beenden, damit andere Viewshells ein
|* aktualisiertes Textobjekt vorfinden
|*
\************************************************************************/



/** Returns TRUE if the corresponding feature is available,
    eg it returns only true if the chart is three dimensional
    and the 3d effect flyer is to be displayed
*/
/*N*/ BOOL SchViewShell::HasUIFeature( ULONG nFeature )
/*N*/ {
/*N*/     switch( nFeature )
/*N*/     {
/*N*/         case SCH_UI_FEATURE_THREE_D:
/*N*/             if( pDocSh )
/*N*/                 return pDocSh->GetDoc().IsReal3D();
/*?*/             return FALSE;
/*N*/ 
/*N*/         case SCH_UI_FEATURE_OWN_DATA:
/*N*/             // ToDo: If chart is inside Calc/Writer using external data, FALSE
/*N*/             // should be returned. It currently works in a different way (hack)
/*N*/             return TRUE;
/*N*/ 
/*?*/         default:
/*?*/             DBG_ERRORFILE( "Unknown UI Feature requested!" );
/*?*/             return FALSE;
/*N*/     }
/*N*/ }


// SfxListener

/*N*/ void SchViewShell::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
/*N*/ {
/*N*/     if( rHint.ISA( SchVisAreaChangedHint ) &&
/*N*/         NULL != mpUNOController )
/*N*/     {
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/         Rectangle aRect = static_cast< const SchVisAreaChangedHint & >( rHint ).getNewRect();
/*N*/     }
/*N*/     else
/*N*/         SfxViewShell::Notify( rBC, rHint );
/*N*/ }


// ________________________________________
//
//  SuspendSelectionChangeBroadcasting
// ________________________________________

/*?*/ SuspendSelectionChangeBroadcasting::SuspendSelectionChangeBroadcasting( SchViewShell *  pViewShell ) :
/*?*/         mpViewShell( pViewShell )
/*?*/ {
/*?*/ 	DBG_BF_ASSERT(0, "STRIP"); //STRIP001     if( mpViewShell )
/*?*/ }


// __________ SchVisAreaChangedHint __________

/*N*/ TYPEINIT0( SchVisAreaChangedHint );

/*N*/ SchVisAreaChangedHint::SchVisAreaChangedHint( const Rectangle & rNewRect )
/*N*/ {
/*N*/     maNewRect = rNewRect;
/*N*/ }


/*N*/ SchVisAreaChangedHint::~SchVisAreaChangedHint()
/*N*/ {}

}
