/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_drviews6.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 18:42:13 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SFXREQUEST_HXX //autogen
#include <bf_sfx2/request.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX //autogen
#include <bf_sfx2/viewfrm.hxx>
#endif
#ifndef _SVDOGRAF_HXX //autogen
#include <bf_svx/svdograf.hxx>
#endif
#ifndef _SVXIDS_HXX
#include <bf_svx/svxids.hrc>
#endif
#ifndef _FONTWORK_HXX
#include <bf_svx/fontwork.hxx>
#endif
#ifndef _BMPMASK_HXX
#include <bf_svx/bmpmask.hxx>
#endif
#ifndef _SVX_GALBRWS_HXX
#include <bf_svx/galbrws.hxx>
#endif
#ifndef _IMAPDLG_HXX
#include <bf_svx/imapdlg.hxx>
#endif
#ifndef _SVX_COLRCTRL_HXX //autogen
#include <bf_svx/colrctrl.hxx>
#endif

#ifndef _SVX_F3DCHILD_HXX //autogen
#include <bf_svx/f3dchild.hxx>
#endif


#include "app.hrc"
#include "strings.hrc"

#include "animobjs.hxx"
#include "prevchld.hxx"
#include "efctchld.hxx"
#include "slidchld.hxx"
//#include "3dchld.hxx"
#include "drviewsh.hxx"

#include "frmview.hxx"

namespace binfilter {

/*************************************************************************
|*
|* SfxRequests fuer FontWork bearbeiten
|*
\************************************************************************/


/*************************************************************************
|*
|* Statuswerte fuer FontWork zurueckgeben
|*
\************************************************************************/


/*************************************************************************
|*
|* SfxRequests fuer Objektpalette bearbeiten
|*
\************************************************************************/


/*************************************************************************
|*
|* Statuswerte fuer Objektpalette zurueckgeben
|*
\************************************************************************/


/*************************************************************************
|*
|* SfxRequests fuer Animator bearbeiten
|*
\************************************************************************/


/*************************************************************************
|*
|* Statuswerte fuer Animator zurueckgeben
|*
|* nValue == 0 -> Kein Button
|* nValue == 1 -> Button 'uebernehmen'
|* nValue == 2 -> Button 'einzeln uebernehmen'
|* nValue == 3 -> Buttons 'uebernehmen' und 'einzeln uebernehmen'
|*
\************************************************************************/


/*************************************************************************
|*
|* Statuswerte fuer SfxChildWindows setzen
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::SetChildWindowState( SfxItemSet& rSet )
/*N*/ {
/*N*/ 	// Stati der SfxChild-Windows (Animator, Fontwork etc.)
/*N*/ 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_FONTWORK ) )
/*N*/ 	{
/*?*/ 		USHORT nId = SvxFontWorkChildWindow::GetChildWindowId();
/*?*/ 		rSet.Put(SfxBoolItem(SID_FONTWORK, GetViewFrame()->HasChildWindow(nId)));
/*?*/ 	}
/*N*/ 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_COLOR_CONTROL ) )
/*N*/ 	{
/*?*/ 		USHORT nId = SvxColorChildWindow::GetChildWindowId();
/*?*/ 		rSet.Put(SfxBoolItem(SID_COLOR_CONTROL, GetViewFrame()->HasChildWindow(nId)));
/*?*/ 	}
/*N*/ 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_ANIMATION_OBJECTS ) )
/*N*/ 	{
/*?*/ 		USHORT nId = SdAnimationChildWindow::GetChildWindowId();
/*?*/ 		rSet.Put( SfxBoolItem( SID_ANIMATION_OBJECTS, GetViewFrame()->HasChildWindow( nId ) ) );
/*?*/ 	}
/*N*/ 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_NAVIGATOR ) )
/*N*/ 	{
/*?*/ 		USHORT nId = SID_NAVIGATOR;
/*?*/ 		rSet.Put( SfxBoolItem( SID_NAVIGATOR, GetViewFrame()->HasChildWindow( nId ) ) );
/*?*/ 	}
/*N*/ 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_BMPMASK ) )
/*N*/ 	{
/*?*/ 		USHORT nId = SvxBmpMaskChildWindow::GetChildWindowId();
/*?*/ 		rSet.Put( SfxBoolItem( SID_BMPMASK, GetViewFrame()->HasChildWindow( nId ) ) );
/*?*/ 	}
/*N*/ 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_GALLERY ) )
/*N*/ 	{
/*?*/ 		USHORT nId = GalleryChildWindow::GetChildWindowId();
/*?*/ 		rSet.Put( SfxBoolItem( SID_GALLERY, GetViewFrame()->HasChildWindow( nId ) ) );
/*?*/ 	}
/*N*/ 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_IMAP ) )
/*N*/ 	{
/*N*/ 		USHORT nId = SvxIMapDlgChildWindow::GetChildWindowId();
/*N*/ 		rSet.Put( SfxBoolItem( SID_IMAP, GetViewFrame()->HasChildWindow( nId ) ) );
/*N*/ 	}
/*N*/ 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_PREVIEW_WIN ) )
/*N*/ 	{
/*N*/ 		USHORT nId = SdPreviewChildWindow::GetChildWindowId();
/*N*/ 		rSet.Put( SfxBoolItem( SID_PREVIEW_WIN, GetViewFrame()->HasChildWindow( nId ) ) );
/*N*/ 	}
/*N*/ 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_EFFECT_WIN ) )
/*N*/ 	{
/*?*/ 		USHORT nId = SdEffectChildWindow::GetChildWindowId();
/*?*/ 		rSet.Put( SfxBoolItem( SID_EFFECT_WIN, GetViewFrame()->HasChildWindow( nId ) ) );
/*?*/ 	}
/*N*/ 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_SLIDE_CHANGE_WIN ) )
/*N*/ 	{
/*?*/ 		USHORT nId = SdSlideChangeChildWindow::GetChildWindowId();
/*?*/ 		rSet.Put( SfxBoolItem( SID_SLIDE_CHANGE_WIN, GetViewFrame()->HasChildWindow( nId ) ) );
/*?*/ 	}
/*N*/ 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_3D_WIN ) )
/*N*/ 	{
/*?*/ 		USHORT nId = Svx3DChildWindow::GetChildWindowId();
/*?*/ 		rSet.Put( SfxBoolItem( SID_3D_WIN, GetViewFrame()->HasChildWindow( nId ) ) );
/*?*/ 	}
/*N*/ }


/*************************************************************************
|*
|* SfxRequests fuer Pipette bearbeiten
|*
\************************************************************************/


/*************************************************************************
|*
|*
|*
\************************************************************************/


/*************************************************************************
|*
|* SfxRequests fuer temporaere Funktionen
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::FuTemp04(SfxRequest& rReq)
/*N*/ {
/*N*/ 
/*N*/ 	USHORT nSId = rReq.GetSlot();
/*N*/ 	switch( nSId )
/*N*/ 	{
/*?*/ 		case SID_FONTWORK:
/*?*/ 		{
/*?*/ 			if ( rReq.GetArgs() )
/*?*/ 			{
/*?*/ 				GetViewFrame()->SetChildWindow(SvxFontWorkChildWindow::GetChildWindowId(),
/*?*/ 										((const SfxBoolItem&) (rReq.GetArgs()->
/*?*/ 										Get(SID_FONTWORK))).GetValue());
/*?*/ 			}
/*?*/ 			else
/*?*/ 			{
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 GetViewFrame()->ToggleChildWindow( SvxFontWorkChildWindow::GetChildWindowId() );
/*?*/ 			}
/*?*/ 
/*?*/ 			GetViewFrame()->GetBindings().Invalidate(SID_FONTWORK);
/*?*/ 			Cancel();
/*?*/ 			rReq.Ignore ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_COLOR_CONTROL:
/*?*/ 		{
/*?*/ 			if ( rReq.GetArgs() )
/*?*/ 				GetViewFrame()->SetChildWindow(SvxColorChildWindow::GetChildWindowId(),
/*?*/ 										((const SfxBoolItem&) (rReq.GetArgs()->
/*?*/ 										Get(SID_COLOR_CONTROL))).GetValue());
/*?*/ 			else
/*?*/ 				{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 GetViewFrame()->ToggleChildWindow(SvxColorChildWindow::GetChildWindowId() );
/*?*/ 
/*?*/ 			GetViewFrame()->GetBindings().Invalidate(SID_COLOR_CONTROL);
/*?*/ 			Cancel();
/*?*/ 			rReq.Ignore ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_BMPMASK:
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_GALLERY:
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_NAVIGATOR:
/*?*/ 		{
/*?*/ 			if ( rReq.GetArgs() )
/*?*/ 				GetViewFrame()->SetChildWindow(SID_NAVIGATOR,
/*?*/ 										((const SfxBoolItem&) (rReq.GetArgs()->
/*?*/ 										Get(SID_NAVIGATOR))).GetValue());
/*?*/ 			else
/*?*/ 				{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 GetViewFrame()->ToggleChildWindow( SID_NAVIGATOR );
/*?*/ 
/*?*/ 			GetViewFrame()->GetBindings().Invalidate(SID_NAVIGATOR);
/*?*/ 			Cancel();
/*?*/ 			rReq.Ignore ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_ANIMATION_OBJECTS:
/*?*/ 		{
/*?*/ 			if ( rReq.GetArgs() )
/*?*/ 				GetViewFrame()->SetChildWindow(SdAnimationChildWindow::GetChildWindowId(),
/*?*/ 										((const SfxBoolItem&) (rReq.GetArgs()->
/*?*/ 										Get(SID_ANIMATION_OBJECTS))).GetValue());
/*?*/ 			else
/*?*/ 				{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 GetViewFrame()->ToggleChildWindow(SdAnimationChildWindow::GetChildWindowId() );
/*?*/ 
/*?*/ 			GetViewFrame()->GetBindings().Invalidate(SID_ANIMATION_OBJECTS);
/*?*/ 			Cancel();
/*?*/ 			rReq.Ignore ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 
/*N*/ 		case SID_PREVIEW_WIN:
/*N*/ 		{
/*N*/ 			bool bPreview = FALSE;
/*N*/ 
/*N*/ 			if ( rReq.GetArgs() )
/*N*/ 			{
/*N*/ 			 	bPreview = ((const SfxBoolItem&) (rReq.GetArgs()->Get(SID_PREVIEW_WIN))).GetValue();
/*N*/ 			}
/*N*/ 			else
/*N*/ 			{
/*?*/ 				USHORT nId = SdPreviewChildWindow::GetChildWindowId();
/*?*/ 				bPreview = !SfxBoolItem(SID_PREVIEW_WIN, GetViewFrame()->HasChildWindow(nId)).GetValue();
/*?*/ 			}
/*N*/ 
/*N*/ 			SetPreview( bPreview );
/*N*/ 
/*N*/ 			if (eEditMode == EM_PAGE)
/*N*/ 				pFrameView->SetShowPreviewInPageMode(bPreview);
/*N*/ 			else
/*?*/ 				pFrameView->SetShowPreviewInMasterPageMode(bPreview);
/*?*/ 
/*N*/ 			Cancel();
/*N*/ 			rReq.Ignore ();
/*N*/ 		}
/*N*/ 		break;
/*?*/ 
/*?*/ 		case SID_EFFECT_WIN:
/*?*/ 		{
/*?*/ 			if ( rReq.GetArgs() )
/*?*/ 				GetViewFrame()->SetChildWindow(SdEffectChildWindow::GetChildWindowId(),
/*?*/ 										((const SfxBoolItem&) (rReq.GetArgs()->
/*?*/ 										Get(SID_EFFECT_WIN))).GetValue());
/*?*/ 			else
/*?*/ 				{DBG_BF_ASSERT(0, "STRIP"); }//STRIP001 GetViewFrame()->ToggleChildWindow(SdEffectChildWindow::GetChildWindowId() );
/*?*/ 
/*?*/ 			GetViewFrame()->GetBindings().Invalidate(SID_EFFECT_WIN);
/*?*/ 			Cancel();
/*?*/ 			rReq.Ignore ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_SLIDE_CHANGE_WIN:
/*?*/ 		{
/*?*/ 			if ( rReq.GetArgs() )
/*?*/ 				GetViewFrame()->SetChildWindow(SdSlideChangeChildWindow::GetChildWindowId(),
/*?*/ 										((const SfxBoolItem&) (rReq.GetArgs()->
/*?*/ 										Get(SID_SLIDE_CHANGE_WIN))).GetValue());
/*?*/ 			else
/*?*/ 				{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 GetViewFrame()->ToggleChildWindow(SdSlideChangeChildWindow::GetChildWindowId() );
/*?*/ 
/*?*/ 			GetViewFrame()->GetBindings().Invalidate(SID_SLIDE_CHANGE_WIN);
/*?*/ 			Cancel();
/*?*/ 			rReq.Ignore ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_3D_WIN:
/*?*/ 		{
/*?*/ 			if ( rReq.GetArgs() )
/*?*/ 				GetViewFrame()->SetChildWindow( Svx3DChildWindow::GetChildWindowId(),
/*?*/ 										((const SfxBoolItem&) (rReq.GetArgs()->
/*?*/ 										Get( SID_3D_WIN ))).GetValue());
/*?*/ 			else
/*?*/ 				{DBG_BF_ASSERT(0, "STRIP"); }//STRIP001 GetViewFrame()->ToggleChildWindow( Svx3DChildWindow::GetChildWindowId() );
/*?*/ 
/*?*/ 			GetViewFrame()->GetBindings().Invalidate( SID_3D_WIN );
/*?*/ 			Cancel();
/*?*/ 			rReq.Ignore ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_CONVERT_TO_3D_LATHE_FAST:
/*?*/ 		{
/*?*/ 			// Der Aufruf ist ausreichend. Die Initialisierung per Start3DCreation und CreateMirrorPolygons
/*?*/ 			// ist nicht mehr noetig, falls der Parameter TRUE uebergeben wird. Dann wird sofort und
/*?*/ 			// ohne Benutzereingriff ein gekippter Rotationskoerper mit einer Achse links neben dem
/*?*/ 			// Umschliessenden Rechteck der slektierten Objekte gezeichnet.
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->EndTextEdit();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_PRESENTATION_DLG:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuSlideShowDlg( this, pWindow, pDrView, pDoc, rReq );
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_CUSTOMSHOW_DLG:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuCustomShowDlg( this, pWindow, pDrView, pDoc, rReq );
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_EXPAND_PAGE:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuExpandPage( this, pWindow, pDrView, pDoc, rReq );
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_SUMMARY_PAGE:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->EndTextEdit();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		default:
/*?*/ 		{
/*?*/ 			DBG_ASSERT( 0, "Slot ohne Funktion" );
/*?*/ 			Cancel();
/*?*/ 			rReq.Ignore ();
/*?*/ 		}
/*?*/ 		break;
/*N*/ 	};
/*N*/ };

}
