/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_drviewsj.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 18:43:55 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SVXIDS_HRC //autogen
#include <bf_svx/svxids.hrc>
#endif
#ifndef _EEITEM_HXX //autogen
#include <bf_svx/eeitem.hxx>
#endif


#ifndef _SFXPOOLITEM_HXX
#include <svtools/poolitem.hxx>
#endif

#ifndef _SVX_ITEMDATA_HXX
#include <bf_svx/itemdata.hxx>
#endif

#ifndef _DATE_HXX
#include <tools/date.hxx>
#endif

#ifndef _TOOLS_TIME_HXX
#include <tools/time.hxx>
#endif

#define ITEMID_FIELD    EE_FEATURE_FIELD
#ifndef _SVDOOLE2_HXX //autogen
#include <bf_svx/svdoole2.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
#ifndef _SFXREQUEST_HXX //autogen
#include <bf_sfx2/request.hxx>
#endif
#ifndef _SFXEVENT_HXX //autogen
#include <bf_sfx2/event.hxx>
#endif


#pragma hdrstop

#include "app.hrc"

#include "fusel.hxx"
#include "drviewsh.hxx"
#include "drawdoc.hxx"
#include "docshell.hxx"
#include "drawview.hxx"
namespace binfilter {



/*************************************************************************
|*
|* Status (Enabled/Disabled) von Menue-SfxSlots setzen
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::GetMenuStateSel( SfxItemSet &rSet )
/*N*/ {
/*N*/ 	// Status der Menueintraege, bzw. Buttons
/*N*/ 	// Einfachselektion
/*N*/ 
/*N*/ 	const SdrMarkList& rMarkList = pDrView->GetMarkList();
/*N*/ 	ULONG nMarkCount = rMarkList.GetMarkCount();
/*N*/ 
/*N*/ 	if ( nMarkCount == 1 )
/*N*/ 	{
/*?*/ 		if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_BEZIER_EDIT ) ||
/*?*/ 			SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_UNGROUP ) ||
/*?*/ 			SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_ENTER_GROUP ) ||
/*?*/ 			SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_NAME_GROUP ) ||
/*?*/ 			SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_ATTR_FILL_STYLE ) ||
/*?*/ 			SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_CHANGEBEZIER ) ||
/*?*/ 			SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_CHANGEPOLYGON ) ||
/*?*/ 			SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_LINEEND_POLYGON ) ||
/*?*/ 			SFX_ITEM_AVAILABLE == rSet.GetItemState( OBJ_TITLETEXT ) ||
/*?*/ 			SFX_ITEM_AVAILABLE == rSet.GetItemState( OBJ_OUTLINETEXT ) ||
/*?*/ 			SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_MEASURE_DLG ) ||
/*?*/ 			SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_CONNECTION_DLG ) ||
/*?*/ 			SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_CONNECTION_NEW_ROUTING ) ||
/*?*/ //			SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_CONVERT_TO_3D_LATHE ) ||
/*?*/ //			SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_CONVERT_TO_3D_LATHE_FAST ) ||
/*?*/ 			SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_OBJECT_SHEAR ) ||
/*?*/ 			SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_CONVERT_TO_1BIT_THRESHOLD ) ||
/*?*/ 			SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_CONVERT_TO_1BIT_MATRIX ) ||
/*?*/ 			SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_CONVERT_TO_4BIT_GRAYS ) ||
/*?*/ 			SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_CONVERT_TO_4BIT_COLORS ) ||
/*?*/ 			SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_CONVERT_TO_8BIT_GRAYS ) ||
/*?*/ 			SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_CONVERT_TO_8BIT_COLORS ) ||
/*?*/ 			SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_CONVERT_TO_24BIT ) ||
/*?*/ 			SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_OBJECT_ALIGN_LEFT ) ||
/*?*/ 			SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_OBJECT_ALIGN_CENTER ) ||
/*?*/ 			SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_OBJECT_ALIGN_RIGHT ) ||
/*?*/ 			SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_OBJECT_ALIGN_UP ) ||
/*?*/ 			SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_OBJECT_ALIGN_MIDDLE ) ||
/*?*/ 			SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_OBJECT_ALIGN_DOWN ) ||
/*?*/ 			SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_FRAME_TO_TOP ) ||
/*?*/ 			SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_MOREFRONT ) ||
/*?*/ 			SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_MOREBACK ) ||
/*?*/ 			SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_FRAME_TO_BOTTOM ) ||
/*?*/ 			SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_BEFORE_OBJ ) ||
/*?*/ 			SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_BEHIND_OBJ ) ||
/*?*/ 			SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_REVERSE_ORDER ) ||
/*?*/ 			SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_ORIGINAL_SIZE ) )
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 const SdrObject* pObj = rMarkList.GetMark(0)->GetObj();
/*?*/ 		}
/*?*/ 
/*?*/ 		if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_DISMANTLE ) ||
/*?*/ 			SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_BREAK ) )
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( !pDrView->IsDismantlePossible(FALSE) )
/*?*/ 		}
/*?*/ 		if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_MODIFY_FIELD ) )
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 OutlinerView* pOLV = pDrView->GetTextEditOutlinerView();
/*?*/ 		}
/*?*/ 
/*?*/ 		rSet.DisableItem( SID_GROUP );
/*?*/ 		rSet.DisableItem( SID_COMBINE );
/*?*/         rSet.DisableItem(SID_DISTRIBUTE_DLG);
/*?*/         rSet.DisableItem(SID_POLY_MERGE);
/*?*/         rSet.DisableItem(SID_POLY_SUBSTRACT);
/*?*/         rSet.DisableItem(SID_POLY_INTERSECT);
/*?*/ 		rSet.DisableItem( SID_CONNECT );
/*?*/ 	}
	// Mehrfachselektion
/*N*/ 	else if( nMarkCount > 1 )
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 // distribure dialog for 3+n objects
/*N*/ 	}
	// kein Objekt selektiert
/*N*/ 	else
/*N*/ 	{
//        rSet.ClearItem( SID_BEZIER_EDIT );

/*N*/ 		rSet.DisableItem( SID_ENTER_GROUP );
/*N*/ 		rSet.DisableItem( SID_CUT );
/*N*/ 		rSet.DisableItem( SID_COPY );
/*N*/ 		rSet.DisableItem( SID_DELETE );
/*N*/ 		rSet.DisableItem( SID_ATTR_TRANSFORM );

/*N*/ 		rSet.DisableItem( SID_OBJECT_ALIGN_LEFT );
/*N*/ 		rSet.DisableItem( SID_OBJECT_ALIGN_CENTER );
/*N*/ 		rSet.DisableItem( SID_OBJECT_ALIGN_RIGHT );
/*N*/ 		rSet.DisableItem( SID_OBJECT_ALIGN_UP );
/*N*/ 		rSet.DisableItem( SID_OBJECT_ALIGN_MIDDLE );
/*N*/ 		rSet.DisableItem( SID_OBJECT_ALIGN_DOWN );

/*N*/ 		rSet.DisableItem( SID_FRAME_TO_TOP );
/*N*/ 		rSet.DisableItem( SID_MOREFRONT );
/*N*/ 		rSet.DisableItem( SID_MOREBACK );
/*N*/ 		rSet.DisableItem( SID_FRAME_TO_BOTTOM );
/*N*/ 		rSet.DisableItem( SID_BEFORE_OBJ );
/*N*/ 		rSet.DisableItem( SID_BEHIND_OBJ );
/*N*/ 		rSet.DisableItem( SID_CONVERT );

//		rSet.DisableItem( SID_BEZIER_EDIT );
/*N*/ 		rSet.DisableItem( SID_SIZE_OPTIMAL );
/*N*/ 		rSet.DisableItem( SID_LINEEND_POLYGON );
/*N*/ 		rSet.DisableItem( SID_COPYOBJECTS );
/*N*/ 		rSet.DisableItem( SID_HORIZONTAL );
/*N*/ 		rSet.DisableItem( SID_VERTICAL );
/*N*/ 		rSet.DisableItem( SID_GROUP );
/*N*/ 		rSet.DisableItem( SID_UNGROUP );
/*N*/ 		rSet.DisableItem( SID_NAME_GROUP );
/*N*/ 		rSet.DisableItem( SID_DISMANTLE );
/*N*/ 		rSet.DisableItem( SID_BREAK );
/*N*/ 		rSet.DisableItem( SID_COMBINE );
/*N*/         rSet.DisableItem(SID_DISTRIBUTE_DLG);
/*N*/         rSet.DisableItem(SID_POLY_MERGE);
/*N*/         rSet.DisableItem(SID_POLY_SUBSTRACT);
/*N*/         rSet.DisableItem(SID_POLY_INTERSECT);
/*N*/ 		rSet.DisableItem( SID_CONNECT );
/*N*/ 		rSet.DisableItem( SID_ANIMATION_EFFECTS );
/*N*/ 		rSet.DisableItem( SID_MODIFY_FIELD );
/*N*/ 		rSet.DisableItem (SID_OBJECT_SHEAR);
/*N*/ 	}

/*N*/ }

/*************************************************************************
|*
|* Notify
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::SFX_NOTIFY(SfxBroadcaster& rBC, const TypeId& rBCType,
/*N*/ 								 const SfxHint& rHint, const TypeId& rHintType)
/*N*/ {
/*N*/ 	BOOL bOK = FALSE;
/*N*/ 
/*N*/ 	// Zuerst die Basisklasse
/*N*/ 	SdViewShell::SFX_NOTIFY(rBC, rBCType, rHint, rHintType);
/*N*/ 
/*N*/ 	SfxSimpleHint* pSimple = PTR_CAST(SfxSimpleHint, &rHint);
/*N*/ 	ULONG nId = pSimple == NULL ? 0 : pSimple->GetId();
/*N*/ 
/*N*/ 	if (nId == SFX_HINT_MODECHANGED)
/*N*/ 	{
/*N*/ 		if (pDocSh->IsReadOnly() && pFuActual && !pFuActual->ISA(FuSelection))
/*N*/ 		{
			// Aktuelle Funktion beenden und Selektion aktivieren
/*?*/ 			SfxRequest aReq(SID_OBJECT_SELECT, 0, pDoc->GetItemPool());
/*?*/ 			FuPermanent(aReq);
/*?*/ 			bOK = TRUE;
/*?*/ 		}

/*N*/ 		if (pDocSh->IsReadOnly() != bReadOnly )
/*?*/ 		{
/*?*/ 			bReadOnly = pDocSh->IsReadOnly();

/*?*/ 			SfxBoolItem aItem( SID_FM_DESIGN_MODE, !bReadOnly );
/*?*/ 			GetViewFrame()->GetDispatcher()->Execute( SID_FM_DESIGN_MODE,
/*?*/ 					  SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD, &aItem, 0L );
/*?*/ 		}
/*?*/ 	}

/*?*/ 	if( rHint.IsA(TYPE(SfxEventHint)) )
/*?*/ 	{
/*?*/ 		if( ((SfxEventHint&)rHint).GetEventId() == SFX_EVENT_OPENDOC )
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if( pDoc && pDoc->IsStartWithPresentation() )
/*?*/ 		}
/*?*/ 	}
/*N*/ }


}
