/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_accelcfg.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 18:49:42 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

#include <tools/urlobj.hxx>
#include <unotools/ucbstreamhelper.hxx>
#include <svtools/pathoptions.hxx>

#include "xmlaccelcfg.hxx"

namespace binfilter {


using namespace utl;
using namespace rtl;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::io;
using namespace ::com::sun::star::xml::sax;

/*?*/ class SfxAcceleratorConfig_Impl
/*?*/ {
/*?*/ public:
/*?*/ 
/*?*/     SfxAcceleratorItemList aList;
/*?*/ 	bool			bModified;
/*?*/ 
/*?*/                     SfxAcceleratorConfig_Impl()
/*?*/                         : bModified( FALSE )
/*?*/                     {}
/*?*/ };

// -----------------------------------------------------------------------

/*?*/ SfxAcceleratorConfiguration::SfxAcceleratorConfiguration()
/*?*/ {
/*?*/     pImp = new SfxAcceleratorConfig_Impl;
/*?*/ }

// -----------------------------------------------------------------------

/*?*/ SfxAcceleratorConfiguration::~SfxAcceleratorConfiguration()
/*?*/ {
/*?*/     if ( pImp->bModified )
/*?*/     {
/*?*/         String aUserConfig = SvtPathOptions().GetUserConfigPath();
/*?*/         INetURLObject aObj( aUserConfig );
/*?*/         aObj.insertName( String::CreateFromAscii("GlobalKeyBindings.xml") );
/*?*/         SvStream* pStream = ::utl::UcbStreamHelper::CreateStream( aObj.GetMainURL( INetURLObject::NO_DECODE ), STREAM_STD_READWRITE|STREAM_TRUNC );
/*?*/         Commit( *pStream );
/*?*/         delete pStream;
/*?*/     }
/*?*/ 
/*?*/     delete pImp;
/*?*/ }

/*?*/ bool SfxAcceleratorConfiguration::Load( SvStream& rStream )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE; //STRIP001 
/*?*/ }

/*?*/ const SfxAcceleratorItemList& SfxAcceleratorConfiguration::GetItems()
/*?*/ {
/*?*/ 	return pImp->aList;
/*?*/ }

/*?*/ void SfxAcceleratorConfiguration::SetCommand( const SfxAcceleratorConfigItem& rItem )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ 
/*?*/ }

/*?*/ void SfxAcceleratorConfiguration::SetItems( const SfxAcceleratorItemList& rItems, bool bClear )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

/*?*/ bool SfxAcceleratorConfiguration::Commit( SvStream& rStream )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
/*?*/ }

}
