/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_accmgr.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 18:50:04 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/




#include <tools/rcid.h>
//#include <unotools/ucbstreamhelper.hxx>
//#include <tools/urlobj.hxx>

//#include "mnumgr.hxx"
//#include "app.hxx"
//#include "sfxtypes.hxx"
//#include "sfxresid.hxx"
#include "macrconf.hxx"
//#include "msgpool.hxx"
#include "dispatch.hxx"
#include "accel.hrc"
#include "accelcfg.hxx"
namespace binfilter {

static const USHORT nVersion = 1;

//--------------------------------------------------------------------

/*N*/ SfxAcceleratorManager::SfxAcceleratorManager( SfxConfigManager* pMgr)
/*N*/     : SfxConfigItem( SFX_ITEMTYPE_ACCEL, pMgr ),
/*N*/ 	nIteratorPos(0),
/*N*/ 	pAccel(0),
/*N*/     pAccelCfg(0),
/*N*/ 	pResMgr(0)
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/     Initialize();
/*N*/ }

/*N*/ SfxAcceleratorManager::SfxAcceleratorManager( const ResId& rResId, SfxConfigManager* pMgr )
/*N*/     : SfxConfigItem(rResId.GetId() == RID_DEFAULTACCEL ? SFX_ITEMTYPE_ACCEL : rResId.GetId(), pMgr )
/*N*/     , nIteratorPos(0)
/*N*/     , pAccel(0)
/*N*/     , pAccelCfg(0)
/*N*/     , pResMgr(rResId.GetResMgr())
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/     Initialize();
/*N*/ }

/*?*/ SfxAcceleratorManager::SfxAcceleratorManager( const SfxAcceleratorManager& rOther, SfxConfigManager* pMgr )
/*?*/     : SfxConfigItem( rOther.GetType(), pMgr )
/*?*/     , nIteratorPos(0)
/*?*/     , pAccel(0)
/*?*/     , pAccelCfg(0)
/*?*/     , pResMgr( rOther.pResMgr )
/*?*/ {
/*?*/ 	DBG_MEMTEST();
/*?*/     Initialize();
/*?*/ }

//--------------------------------------------------------------------

/*N*/ SfxAcceleratorManager::~SfxAcceleratorManager()
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	Clear();
/*N*/ }

/*N*/ void SfxAcceleratorManager::Clear()
/*N*/ {
/*N*/ 	if ( pAccel )
/*N*/ 	{
/*N*/ 		USHORT nCount = pAccel->GetItemCount();
/*N*/ 		for ( USHORT nPos = 0; nPos < nCount; ++nPos )
/*N*/ 		{
/*N*/ 			USHORT nId = pAccel->GetItemId( nPos );
/*N*/ 			if ( SfxMacroConfig::IsMacroSlot( nId ) )
/*?*/ 				SFX_APP()->GetMacroConfig()->ReleaseSlotId(nId);
/*N*/ 		}
/*N*/ 
/*N*/ 		DELETEZ( pAccel );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*?*/         std::vector< SfxAcceleratorConfigItem>::const_iterator p;
/*?*/         const SfxAcceleratorItemList& rItems = GetItems();
/*?*/         for ( p = rItems.begin(); p != rItems.end(); p++ )
/*?*/ 			if ( SfxMacroConfig::IsMacroSlot( p->nId ) )
/*?*/ 				SFX_APP()->GetMacroConfig()->ReleaseSlotId(p->nId);
/*?*/ 		DELETEZ( pAccelCfg );
/*N*/ 	}
/*N*/ }

//====================================================================

/*?*/ SvStream& operator>>( SvStream &rStream, KeyCode& rVal )
/*?*/ {
/*?*/ 	USHORT nCode, nMod;
/*?*/ 	rStream >> nCode;
/*?*/ 	rStream >> nMod;
/*?*/ 
/*?*/ 	if( nCode == USHRT_MAX )
/*?*/ 		// virtuelle Taste
/*?*/ 		rVal = KeyCode( (KeyFuncType) nMod );
/*?*/ 	else
/*?*/ 		// normale Taste
/*?*/ 		rVal = KeyCode ( nCode, nMod );
/*?*/ 
/*?*/ 	return rStream;
/*?*/ }


//--------------------------------------------------------------------

// stream out a KeyCode

/*?*/ SvStream& operator<<( SvStream &rStream, const KeyCode& rVal )
/*?*/ {
/*?*/ 	DBG_MEMTEST();
/*?*/ 
/*?*/ 	if( rVal.IsFunction() )
/*?*/     {
/*?*/ 		// write virtual key code, marked as USHRT_MAX
/*?*/ 		rStream << USHORT(USHRT_MAX) << USHORT( rVal.GetFunction() );
/*?*/         DBG_ERROR("Error: Function Key detected!");
/*?*/     }
/*?*/ 	else
/*?*/ 		// write normal key code
/*?*/ 		rStream << USHORT( rVal.GetCode() ) << USHORT( rVal.GetModifier() );
/*?*/ 	return rStream;
/*?*/ }


//====================================================================

// stores the configured accelerators to a stream

/*N*/ BOOL SfxAcceleratorManager::Store( SvStream& rStream )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
/*?*/ }


//--------------------------------------------------------------------
/*N*/ void SfxAcceleratorManager::UseDefault()
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 
/*N*/     BOOL bReconfigure = ( pAccel || pAccelCfg );
/*N*/ 	if ( bReconfigure )
/*N*/ 		Clear();
/*N*/ 
/*N*/     ResId aId( GetType() == SFX_ITEMTYPE_ACCEL ? RID_DEFAULTACCEL : GetType(), pResMgr );
/*N*/     aId.SetRT(RSC_ACCEL);
/*N*/ 
/*N*/     if ( Resource::GetResManager()->IsAvailable( aId ) )
/*N*/         pAccel =  new Accelerator( aId );
/*N*/     else
/*N*/         pAccelCfg = new SfxAcceleratorConfiguration;
/*N*/ 
/*N*/     SetDefault( TRUE );
/*N*/ }


/*?*/ const SfxAcceleratorItemList& SfxAcceleratorManager::GetItems()
/*?*/ {
/*?*/     if ( pAccel )
/*?*/         Convert();
/*?*/ 
/*?*/     return pAccelCfg->GetItems();
/*?*/ }

//--------------------------------------------------------------------

/*?*/ USHORT SfxAcceleratorManager::GetId( const KeyCode &rKeyCode )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*
        if( rKeyCode.IsFunction() )
        {
            nCode = 0;
            nModifier = rKeyCode.GetFunction();
        }
        else
*/
        return 0;
/*?*/ }

//--------------------------------------------------------------------

// key code for a func-id

/*N*/ KeyCode SfxAcceleratorManager::GetKeyCode( USHORT nId )
/*N*/ {
/*N*/     if ( pAccel )
/*N*/         return pAccel->GetKeyCode( nId );
/*N*/     else
/*N*/     {
/*?*/         const SfxAcceleratorItemList& rItems = GetItems();
/*?*/ 
/*?*/         KeyCode aCode;
/*?*/         std::vector< SfxAcceleratorConfigItem>::const_iterator p;
/*?*/         for ( p = rItems.begin(); p != rItems.end(); p++ )
/*?*/ 		{
/*?*/             if ( p->nId == nId )
/*?*/             {
/*?*/                 if ( p->nCode == 0 )
/*?*/                     return KeyCode( p->nModifier );
/*?*/                 else
/*?*/                     return KeyCode( p->nCode, p->nModifier );
/*?*/             }
/*?*/ 		}
/*?*/ 
/*?*/         return KeyCode();
/*N*/     }
/*N*/ }

//--------------------------------------------------------------------
// call this before reconfiguring
/*?*/ void SfxAcceleratorManager::Reset( USHORT nCount )
/*?*/ {
/*?*/ 	Clear();
/*?*/ 	pAccelCfg = new SfxAcceleratorConfiguration;
/*?*/ }

//--------------------------------------------------------------------

// call this after reconfiguring
/*?*/ void SfxAcceleratorManager::Reconfigure()
/*?*/ {
/*?*/ 	SetDefault(FALSE);
/*?*/ }

//--------------------------------------------------------------------

// append a new binding
/*?*/ void SfxAcceleratorManager::AppendItem( USHORT nId, const KeyCode& rKeyCode )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

// ------------------------------------------------------------------------

/*?*/ String SfxAcceleratorManager::GetStreamName() const
/*?*/ {
/*?*/     return SfxConfigItem::GetStreamName( GetType() );
/*?*/ }

/*?*/ BOOL SfxAcceleratorManager::Call(const KeyEvent& rEvnt, SfxBindings& rBind, BOOL bGlobal )
/*?*/ {DBG_BF_ASSERT(0, "STRIP");return FALSE; //STRIP001 
/*?*/ }

/*?*/ int SfxAcceleratorManager::Load( SotStorage& rStorage )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
/*?*/ }

/*?*/ BOOL SfxAcceleratorManager::Store( SotStorage& rStorage )
/*?*/ {DBG_BF_ASSERT(0, "STRIP");return FALSE; //STRIP001 
/*?*/ }

/*?*/ void SfxAcceleratorManager::Convert()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

//--------------------------------------------------------------------
/*?*/ int SfxAcceleratorManager::Load(SvStream& rStream)
/*?*/ {DBG_BF_ASSERT(0, "STRIP");return 0; //STRIP001 
/*?*/ }

}
