/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_idpool.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 19:04:23 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _TOOLS_DEBUG_HXX //autogen
#include <tools/debug.hxx>
#endif
#pragma hdrstop

#include "idpool.hxx"
namespace binfilter {

//====================================================================
// locks all ids in the set; returns TRUE if none was locked

/*N*/ BOOL IdPool::Lock( const BitSet& rLockSet )
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	// shift the set by offset
/*N*/ 	BitSet aLockSet = rLockSet << nOffset;
/*N*/ 
/*N*/ 	// is none of the numbers in the set already locked?
/*N*/ 	if ( !(aLockSet & *this) )
/*N*/ 	{
/*N*/ 		// lock all the numbers in the range
/*N*/ 		*this |= aLockSet;
/*N*/ 
/*N*/ 		return TRUE;
/*N*/ 	}
/*N*/ 	return FALSE;
/*N*/ }

//--------------------------------------------------------------------

// creates a pool of unique numbers between nMin and nMax

/*N*/ IdPool::IdPool( USHORT nMin, USHORT nMax ):
/*N*/ 	nOffset(nMin),
/*N*/ 	nRange(nMax-nMin+1),
/*N*/ 	nNextFree(0)
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 
/*N*/ }

//--------------------------------------------------------------------

// gets and locks a unique id


//--------------------------------------------------------------------

// frees a unique id for recycling


//--------------------------------------------------------------------

// marks a range of ids as used, return FALSE if already used


//--------------------------------------------------------------------

// marks a single id as used, return FALSE if already used



}
