/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_basedlgs.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 19:15:19 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#include <stdlib.h>

#pragma hdrstop

#include "basedlgs.hxx"
#include "dispatch.hxx"
#include "workwin.hxx"
namespace binfilter {

static String aEmptyString;

using namespace ::com::sun::star::uno;
using namespace ::rtl;

#define USERITEM_NAME OUString::createFromAscii( "UserItem" )

class SfxModelessDialog_Impl
{
public:
    ByteString      aWinState;
    SfxChildWindow* pMgr;
	BOOL				bConstructed;
};

class SfxFloatingWindow_Impl
{
public:
    ByteString      aWinState;
    SfxChildWindow* pMgr;
	BOOL				bConstructed;
};

// class SfxModalDefParentHelper -----------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------

/*?*/ SfxModalDialog::SfxModalDialog(Window* pParent, const ResId &rResId)
/*?*/ 
/*      [Beschreibung]

	Konstruktor der allgemeinen Basisklasse f"ur modale Dialoge;
	ResId wird als ID im ini-file verwendet.
	Die dort gespeicherte Position wird gesetzt.
*/
/*?*/ 
/*?*/ :       ModalDialog(pParent, rResId),
/*?*/ 	nUniqId(rResId.GetId())
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

// -----------------------------------------------------------------------

/*?*/ SfxModalDialog::SfxModalDialog(Window* pParent,
/*?*/ 							   sal_uInt16 nUniqueId,
/*?*/ 							   WinBits nWinStyle) :

/*?*/ 	ModalDialog(pParent, nWinStyle),
/*?*/ 	nUniqId(nUniqueId)
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

// -----------------------------------------------------------------------

/*?*/ SfxModalDialog::SfxModalDialog
/*?*/ (
/*?*/ 	SfxViewFrame*   pViewFrame,
/*?*/ 	Window*                 pParent,
/*?*/ 	const ResId&    rResId
/*?*/ )
/*?*/ :       ModalDialog(pParent, rResId),
/*?*/ 	nUniqId(rResId.GetId())
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

// -----------------------------------------------------------------------

/*?*/ SfxModalDialog::SfxModalDialog
/*?*/ (
/*?*/ 	SfxViewFrame*   pViewFrame,
/*?*/ 	Window*                 pParent,
/*?*/ 	sal_uInt16                  nUniqueId,
/*?*/ 	WinBits                 nWinStyle
/*?*/ )
/*?*/ 
/*?*/ :       ModalDialog(pParent, nWinStyle),
/*?*/ 	nUniqId(nUniqueId)
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


//-------------------------------------------------------------------------



/*  [Beschreibung]

	Diese virtuelle Methode der Klasse FloatingWindow merkt sich ggf. eine
	ver"anderte Gr"o\se.
	Wird diese Methode von einer abgeleiteten Klasse "uberschrieben, mu\s
	auch SfxFloatingWindow::Resize() gerufen werden.
*/



// -----------------------------------------------------------------------

/*N*/ SfxModelessDialog::SfxModelessDialog( SfxBindings *pBindinx,
/*N*/ 						SfxChildWindow *pCW,
/*N*/ 						Window* pParent, WinBits nWinBits ) :
/*N*/ 	ModelessDialog (pParent, nWinBits),
/*N*/ 	pBindings(pBindinx),
/*N*/     pImp( new SfxModelessDialog_Impl )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ SfxModelessDialog::SfxModelessDialog( SfxBindings *pBindinx,
/*N*/ 						SfxChildWindow *pCW, Window *pParent,
/*N*/ 						const ResId& rResId ) :
/*N*/ 	ModelessDialog(pParent, rResId),
/*N*/ 	pBindings(pBindinx),
/*N*/     pImp( new SfxModelessDialog_Impl )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }

// -----------------------------------------------------------------------


// -----------------------------------------------------------------------

/*N*/ SfxModelessDialog::~SfxModelessDialog()
/*N*/ 
/*      [Beschreibung]

	Dtor
*/

/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }

//-------------------------------------------------------------------------


//-------------------------------------------------------------------------

/*N*/ void SfxModelessDialog::FillInfo(SfxChildWinInfo& rInfo) const
/*N*/ 
/*  [Beschreibung]

	F"ullt ein SfxChildWinInfo mit f"ur SfxModelessDialof spezifischen Daten,
	damit sie in die INI-Datei geschrieben werden koennen.
	Es wird angenommen, da\s rInfo alle anderen evt. relevanten Daten in
	der ChildWindow-Klasse erh"alt.
	ModelessDialogs haben keine spezifischen Informationen, so da?die
	Basisimplementierung nichts tut und daher nicht gerufen werden mu\s.
*/

/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ long SfxFloatingWindow::Notify( NotifyEvent& rEvt )

/*      [Beschreibung]

	Wenn ein ModelessDialog aktiviert wird, wird sein ViewFrame aktiviert.
	Notwendig ist das bei PlugInFrames.
*/

/*N*/ {
/*
    if ( rEvt.GetType() == EVENT_GETFOCUS || rEvt.GetType() == EVENT_MOUSEBUTTONDOWN )
	{
		SfxViewFrame *pFrame = pBindings->GetDispatcher_Impl()->GetFrame();
		if ( pFrame )
			pFrame->MakeActive_Impl();

		if ( rEvt.GetType() == EVENT_MOUSEBUTTONDOWN )
			FloatingWindow::ParentNotify( rEvt );
		return sal_True;
	}
*/

/*N*/ 	if ( rEvt.GetType() == EVENT_GETFOCUS )
/*N*/ 	{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ 	}
/*N*/ 	else if ( rEvt.GetType() == EVENT_LOSEFOCUS )
/*N*/ 	{
/*?*/ 		if ( !HasChildPathFocus() )
/*?*/             pImp->pMgr->Deactivate_Impl();
/*N*/ 	}
/*N*/ 	else if( rEvt.GetType() == EVENT_KEYINPUT )
/*N*/ 	{
/*N*/ 		// KeyInput zuerst f"ur Dialogfunktionen zulassen
/*?*/ 		if ( !FloatingWindow::Notify( rEvt ) )
/*?*/ 			// dann auch global g"ultige Acceleratoren verwenden
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 return SfxViewShell::Current()->GlobalKeyInput_Impl( *rEvt.GetKeyEvent() );
/*?*/ 		return sal_True;
/*N*/ 	}
/*N*/ 
/*N*/ 	return FloatingWindow::Notify( rEvt );
/*N*/ }

// -----------------------------------------------------------------------


// -----------------------------------------------------------------------

/*N*/ SfxFloatingWindow::SfxFloatingWindow( SfxBindings *pBindinx,
/*N*/ 						SfxChildWindow *pCW,
/*N*/ 						Window* pParent,
/*N*/ 						const ResId& rResId) :
/*N*/ 	FloatingWindow(pParent, rResId),
/*N*/ 	pBindings(pBindinx),
/*N*/     pImp( new SfxFloatingWindow_Impl )
/*N*/ {
/*N*/     pImp->pMgr = pCW;
/*N*/     pImp->bConstructed = FALSE;
/*N*/ 	sal_uInt32 nId = GetHelpId();
/*N*/ 	SetHelpId(0);
/*N*/ 	SetUniqueId( nId );
/*N*/ }

//-------------------------------------------------------------------------

/*?*/ sal_Bool SfxFloatingWindow::Close()

/*      [Beschreibung]

	Das Fenster wird geschlossen, indem das ChildWindow durch Ausf"uhren des
	ChildWindow-Slots zerst"ort wird.
	Wird diese Methode von einer abgeleiteten Klasse "uberschrieben, mu\s
	danach SfxFloatingWindow::Close() gerufen werden, wenn nicht das Close()
	mit "return sal_False" abgebrochen wird.

*/

/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
/*?*/ }

// -----------------------------------------------------------------------

/*N*/ SfxFloatingWindow::~SfxFloatingWindow()

/*      [Beschreibung]

	Dtor
*/

/*N*/ {
/*N*/     if ( pImp->pMgr->GetFrame() == pBindings->GetActiveFrame() )
/*?*/         pBindings->SetActiveFrame( NULL );
/*N*/     delete pImp;
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxFloatingWindow::Resize()

/*  [Beschreibung]

	Diese virtuelle Methode der Klasse FloatingWindow merkt sich ggf. eine
	ver"anderte Gr"o\se.
	Wird diese Methode von einer abgeleiteten Klasse "uberschrieben, mu\s
	auch SfxFloatingWindow::Resize() gerufen werden.
*/

/*N*/ {
/*N*/ 	FloatingWindow::Resize();
/*N*/     if ( pImp->bConstructed && pImp->pMgr )
/*N*/     {
/*?*/         if ( !IsRollUp() )
/*?*/             aSize = GetSizePixel();
/*?*/         ULONG nMask = WINDOWSTATE_MASK_POS | WINDOWSTATE_MASK_STATE;
/*?*/         if ( GetStyle() & WB_SIZEABLE )
/*?*/             nMask |= ( WINDOWSTATE_MASK_WIDTH | WINDOWSTATE_MASK_HEIGHT );
/*?*/         pImp->aWinState = GetWindowState( nMask );
/*?*/         GetBindings().GetWorkWindow_Impl()->ConfigChild_Impl( SFX_CHILDWIN_DOCKINGWINDOW, SFX_ALIGNDOCKINGWINDOW, pImp->pMgr->GetType() );
/*N*/     }
/*N*/ }

/*N*/ void SfxFloatingWindow::Move()
/*N*/ {
/*N*/     FloatingWindow::Move();
/*N*/     if ( pImp->bConstructed && pImp->pMgr )
/*N*/     {
/*?*/         ULONG nMask = WINDOWSTATE_MASK_POS | WINDOWSTATE_MASK_STATE;
/*?*/         if ( GetStyle() & WB_SIZEABLE )
/*?*/             nMask |= ( WINDOWSTATE_MASK_WIDTH | WINDOWSTATE_MASK_HEIGHT );
/*?*/         pImp->aWinState = GetWindowState( nMask );
/*?*/         GetBindings().GetWorkWindow_Impl()->ConfigChild_Impl( SFX_CHILDWIN_DOCKINGWINDOW, SFX_ALIGNDOCKINGWINDOW, pImp->pMgr->GetType() );
/*N*/     }
/*N*/ }

//-------------------------------------------------------------------------
/*N*/ void SfxFloatingWindow::StateChanged( StateChangedType nStateChange )
/*N*/ {
/*N*/ 	if ( nStateChange == STATE_CHANGE_INITSHOW )
/*N*/     {
/*N*/         // FloatingWindows are not centered by default
/*N*/         if ( pImp->aWinState.Len() )
/*?*/             SetWindowState( pImp->aWinState );
/*N*/         pImp->bConstructed = TRUE;
/*N*/     }
/*N*/ 
/*N*/     FloatingWindow::StateChanged( nStateChange );
/*N*/ }



//-------------------------------------------------------------------------

/*N*/ void SfxFloatingWindow::FillInfo(SfxChildWinInfo& rInfo) const

/*  [Beschreibung]

	F"ullt ein SfxChildWinInfo mit f"ur SfxFloatingWindow spezifischen Daten,
	damit sie in die INI-Datei geschrieben werden koennen.
	Es wird angenommen, da\s rInfo alle anderen evt. relevanten Daten in
	der ChildWindow-Klasse erh"alt.
	Eingetragen werden hier gemerkte Gr"o\se und das ZoomIn-Flag.
	Wird diese Methode "uberschrieben, mu\s zuerst die Basisimplementierung
	gerufen werden.
*/

/*N*/ {
/*N*/ 	rInfo.aSize  = aSize;
/*N*/ 	if ( IsRollUp() )
/*?*/ 		rInfo.nFlags |= SFX_CHILDWIN_ZOOMIN;
/*N*/ }

// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


//--------------------------------------------------------------------
// Vergleichsfunktion fuer qsort


// -----------------------------------------------------------------------

/*
	Bildet das Set "uber die Ranges der Page. Die Page muss die statische
	Methode f"ur das Erfragen ihrer	Ranges bei SetTabPage angegeben haben,
	liefert also ihr Set onDemand.
 */

}
