/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: intfrm.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 19:36:49 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SFX_INTFRM_HXX
#define _SFX_INTFRM_HXX

#include "viewfrm.hxx"
#include "objface.hxx"
#include "objsh.hxx"
#include "viewsh.hxx"
namespace binfilter {

class SfxViewShell;
class SfxInternalWin_Impl;

//=========================================================================

struct SfxInternalFrameData_Impl

{
	Size				aMargin;
	Point				aWinPos;
	SfxScrollingMode	eScrollingMode;
	BOOL				bHasUI;
	USHORT				nViewId;
	BOOL				bHasToolSpace;

						SfxInternalFrameData_Impl( SfxScrollingMode eScroll )
						 : bHasUI( TRUE )
						 , eScrollingMode ( eScroll )
						 , nViewId( 0 )
						 , bHasToolSpace( FALSE )
						{}
};

// -----------------------------------------------------------------------

class SfxInternalFrame: public SfxViewFrame
{
	SfxInternalWin_Impl*	pWin;
	SfxViewShell*			pViewShell;

protected:

	virtual void            Notify( SfxBroadcaster& rBC, const SfxHint& rHint ){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 virtual void            Notify( SfxBroadcaster& rBC, const SfxHint& rHint );
	virtual void            Activate( BOOL bUI ){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 virtual void            Activate( BOOL bUI );
	virtual void            Deactivate( BOOL bUI ){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 virtual void            Deactivate( BOOL bUI );
	virtual BOOL            Close(){DBG_BF_ASSERT(0, "STRIP"); return FALSE;} //STRIP001 virtual BOOL            Close();
	virtual                 ~SfxInternalFrame();

public:
							SFX_DECL_INTERFACE(SFX_INTERFACE_SFXINTERNALFRM);

							SfxInternalFrame( Window*, SfxFrame*,
								SfxInternalFrameData_Impl*, SfxObjectShell *pDoc=NULL );

	virtual void            SetZoomFactor( const Fraction &rZoomX,
										   const Fraction &rZoomY );
 	virtual String			UpdateTitle(){DBG_BF_ASSERT(0, "STRIP"); String a; return a;} //STRIP001 virtual String			UpdateTitle();

	void                    Exec_Impl(SfxRequest &);
	void                    GetState_Impl(SfxItemSet &);

	virtual BOOL			SetBorderPixelImpl( const SfxViewShell *pSh, const SvBorder &rBorder ){DBG_BF_ASSERT(0, "STRIP"); return FALSE;} //STRIP001 virtual BOOL			SetBorderPixelImpl( const SfxViewShell *pSh, const SvBorder &rBorder );
	virtual void			InvalidateBorderImpl( const SfxViewShell *pSh );

#ifndef _SFXDOC_HXX
#endif
};

}//end of namespace binfilter
#endif


