/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: tbxconf.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: kz $ $Date: 2006/01/05 17:51:10 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SFXTOOLBOXCONF_HXX
#define _SFXTOOLBOXCONF_HXX

#ifndef _SV_TOOLBOX_HXX
#include <vcl/toolbox.hxx>
#endif

#include "sfx.hrc"
#include "cfgitem.hxx"
#include "minarray.hxx"
#include "imgmgr.hxx"
#include "chalign.hxx"
namespace binfilter {

class SfxToolBoxManager;

class SfxToolBoxConfig : public SfxConfigItem
{
	static SfxToolBoxConfig*	pTbxConfig;

	SfxSymbolsSize	eSymbolsSize;
	USHORT			nOutStyle;
	BOOL			bQuiet;
	BOOL			bStatusBarVisible;

public:
					SfxToolBoxConfig( SfxConfigManager* pCfgMgr );
                    SfxToolBoxConfig( const SfxToolBoxConfig& rOther, SfxConfigManager* pCfgMgr );
					~SfxToolBoxConfig();

                    // for Import/Export
	static BOOL 	Import( SvStream&, SvStream& );
	static BOOL		Export( SotStorage&, SvStream& );
    static BOOL     Load( SvStream&, SvStream& );
    static BOOL     Export( SvStream*, SvStream& );

	virtual int 	Load( SotStorage& );
	virtual BOOL	Store( SotStorage& );
    virtual String  GetStreamName() const;
	virtual	void	UseDefault();
    virtual BOOL    ReInitialize();

	void			SetToolBoxPositionVisible(USHORT nPos, BOOL bVis);
	BOOL			IsToolBoxPositionVisible(USHORT nPos) const;
//	void			SetToolBoxPositionName(USHORT nPos, const String* pName);
	static String	GetToolBoxPositionName(USHORT nPos);
	void			SetToolBoxPositionUserName(USHORT nPos, const String& aUserName );
	String			GetToolBoxPositionUserName(USHORT nPos );
	void			SetButtonType( USHORT nPos, ButtonType );
	void			SetQuiet(BOOL bSet)
					{ bQuiet = bSet; }
	BOOL			IsQuiet() const
					{ return bQuiet; }
	ButtonType		GetButtonType( USHORT nPos ) const;
	void 			Configure_Impl( SfxToolBoxManager* );
	WinBits			GetWinBits( USHORT nPos );
	SfxChildAlignment GetAlignment( USHORT nPos ) const;

	void 			SetStatusBarVisible( BOOL bVis )
					{ bStatusBarVisible=bVis; SetDefault( FALSE ); }
	BOOL			IsStatusBarVisible() const
					{ return bStatusBarVisible; }

	static BOOL		GetObjectbarVisibilityDefault( USHORT nPos );
};
}//end of namespace binfilter
#endif
