/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_inettbc.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 19:42:11 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "inettbc.hxx"

#pragma hdrstop

#ifndef _COM_SUN_STAR_UNO_ANY_H_
#include <com/sun/star/uno/Any.h>
#endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_HISTORYOPTIONS_HXX
#include <svtools/historyoptions.hxx>
#endif
#include <vcl/toolbox.hxx>

#include <svtools/inettbc.hxx>

#include <unotools/localfilehelper.hxx>

#include "sfx.hrc"
#include "dispatch.hxx"
#include "so3/staticbaseurl.hxx"
namespace binfilter {

//***************************************************************************
// SfxURLToolBoxControl_Impl
//***************************************************************************

/*N*/ SFX_IMPL_TOOLBOX_CONTROL(SfxURLToolBoxControl_Impl,SfxStringItem)

/*N*/ SfxURLToolBoxControl_Impl::SfxURLToolBoxControl_Impl( USHORT nId ,
/*N*/ 												ToolBox& rBox ,
/*N*/ 												SfxBindings& rBindings )
/*N*/ 		: SfxToolBoxControl( nId , rBox , rBindings )
/*N*/ 		, aURLForwarder( SID_CURRENT_URL, *this )
/*N*/ {
/*N*/ }

/*N*/ SvtURLBox* SfxURLToolBoxControl_Impl::GetURLBox() const
/*N*/ {
/*N*/ 	return (SvtURLBox*) GetToolBox().GetItemWindow(GetId());
/*N*/ }

//***************************************************************************


/*N*/ Window* SfxURLToolBoxControl_Impl::CreateItemWindow( Window* pParent )
/*N*/ {
/*N*/ 	SvtURLBox* pURLBox = new SvtURLBox( pParent );
/*N*/     pURLBox->SetOpenHdl( LINK( this, SfxURLToolBoxControl_Impl, OpenHdl ) );
/*N*/     pURLBox->SetSelectHdl( LINK( this, SfxURLToolBoxControl_Impl, SelectHdl ) );
/*N*/ 	return pURLBox;
/*N*/ }

/*N*/ IMPL_LINK( SfxURLToolBoxControl_Impl, SelectHdl, void*, pVoid )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/     return 1L;
/*N*/ }

/*N*/ IMPL_LINK( SfxURLToolBoxControl_Impl, OpenHdl, void*, pVoid )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/     return 1L;
/*N*/ }

//***************************************************************************

/*N*/ void SfxURLToolBoxControl_Impl::StateChanged
/*N*/ (
/*N*/ 	USHORT              nSID,
/*N*/ 	SfxItemState        eState,
/*N*/ 	const SfxPoolItem*  pState
/*N*/ )
/*N*/ {
/*N*/ 	if( nSID == SID_FOCUSURLBOX )
/*N*/ 	{
/*?*/ 		if ( GetURLBox()->IsVisible() )
/*?*/ 			GetURLBox()->GrabFocus();
/*N*/ 	}
/*N*/ 	else if ( !GetURLBox()->IsModified() && SFX_ITEM_AVAILABLE == eState )
/*N*/ 	{
/*N*/ 		SvtURLBox* pURLBox = GetURLBox();
/*N*/ 		pURLBox->Clear();
/*N*/ 
/*N*/         ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue > > lList = SvtHistoryOptions().GetList(eHISTORY);
/*N*/         for (sal_Int32 i=0; i<lList.getLength(); ++i)
/*N*/         {
/*N*/             ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue > lProps = lList[i];
/*N*/             for (sal_Int32 p=0; p<lProps.getLength(); ++p)
/*N*/             {
/*N*/                 if (lProps[p].Name != HISTORY_PROPERTYNAME_URL)
/*N*/                     continue;
/*N*/ 
/*N*/                 ::rtl::OUString sURL;
/*N*/                 if (!(lProps[p].Value>>=sURL) || !sURL.getLength())
/*N*/                     continue;
/*N*/ 
/*N*/                 INetURLObject aURL    ( sURL );
/*N*/                 String        sMainURL( aURL.GetMainURL( INetURLObject::DECODE_WITH_CHARSET ) );
/*N*/                 String        sFile;
/*N*/ 
/*N*/                 if (::utl::LocalFileHelper::ConvertURLToSystemPath(sMainURL,sFile))
/*?*/                     pURLBox->InsertEntry(sFile);
/*N*/                 else
/*N*/                     pURLBox->InsertEntry(sMainURL);
/*N*/             }
/*N*/         }
/*N*/ 
/*N*/ 		const SfxStringItem *pURL = PTR_CAST(SfxStringItem,pState);
/*N*/ 		String aRep( pURL->GetValue() );
/*N*/ 		INetURLObject aURL( aRep );
/*N*/ 		INetProtocol eProt = aURL.GetProtocol();
/*N*/         if ( eProt == INET_PROT_FILE )
/*N*/         {
/*?*/             pURLBox->SetText( aURL.PathToFileName() );
/*N*/         }
/*N*/         else
/*N*/             pURLBox->SetText( aURL.GetURLNoPass() );
/*N*/ 	}
/*N*/ }

//***************************************************************************
// SfxCancelToolBoxControl_Impl
//***************************************************************************

/*N*/ SFX_IMPL_TOOLBOX_CONTROL(SfxCancelToolBoxControl_Impl,SfxBoolItem)

//***************************************************************************

/*N*/ SfxCancelToolBoxControl_Impl::SfxCancelToolBoxControl_Impl
/*N*/ (
/*N*/ 	USHORT nId,
/*N*/ 	ToolBox& rBox,
/*N*/ 	SfxBindings& rBindings
/*N*/ )
/*N*/ :   SfxToolBoxControl( nId, rBox, rBindings )
/*N*/ {
/*N*/ }

//***************************************************************************


//***************************************************************************


//***************************************************************************

/*N*/ void SfxCancelToolBoxControl_Impl::StateChanged
/*N*/ (
/*N*/ 	USHORT              nSID,
/*N*/ 	SfxItemState        eState,
/*N*/ 	const SfxPoolItem*  pState
/*N*/ )
/*N*/ {
/*N*/ 	SfxVoidItem aVoidItem( nSID );
/*N*/ 	//SfxToolBoxControl::StateChanged( nSID, eState, pState ? &aVoidItem : 0 );
/*N*/ 	SfxToolBoxControl::StateChanged( nSID, eState, pState );
/*N*/ }
}
