/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_imgmgr.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 19:45:35 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <stdio.h>


#include <svtools/miscopt.hxx>

#pragma hdrstop

#include "sfx.hrc"

#ifndef _SVTOOLS_IMGDEF_HXX
#include <svtools/imgdef.hxx>
#endif

#include "tbxmgr.hxx"

#ifndef _COM_SUN_STAR_LANG_XTYPEPROVIDER_HPP_
#include <com/sun/star/lang/XTypeProvider.hpp>
#endif

#include "statcach.hxx"
#include "sfxtypes.hxx"
#include "viewfrm.hxx"
#include "objsh.hxx"
#include "cfgmgr.hxx"
namespace binfilter {

static const USHORT nVersion = 5;
/*?*/ DECLARE_LIST( LinkList, Link * )//STRIP008 ;

/*?*/ class SfxToolBoxArr_Impl;
/*?*/ struct SfxImageManagerData_Impl
/*?*/ {
/*?*/     sal_Int16       nOutStyle;
/*?*/     sal_Int16       nSet;
/*?*/     SfxToolBoxArr_Impl* pToolBoxList;
/*?*/     SfxObjectShell* pDoc;
/*?*/ };

/*?*/ class SfxBitmapList_Impl;
/*?*/ class SfxImageManager_Impl : public SfxConfigItem
/*?*/ {
/*?*/ public:
/*?*/     LinkList			m_aList;
/*?*/     SvtMiscOptions		m_aOpt;
/*?*/ 	SfxBitmapList_Impl* m_pUserDefList;
/*?*/ 	ImageList*			m_pUserImageList;
/*?*/ 	ImageList*			m_pHCUserImageList;
/*?*/ 	int					m_nUserRef;
/*?*/ 
/*?*/ 	void            MakeDefaultImageList( BOOL bHiContrast = FALSE );
/*?*/ 	void 			MakeUserList();
/*?*/ 	void			RebuildUserList();
/*?*/ 	Image           GetImage( USHORT nId, SfxModule*, BOOL bBig, BOOL bHiContrast ) const;
/*?*/ 	Image           SeekImage(USHORT nId, SfxModule* pModule, BOOL bHiContrast ) const;
/*?*/ 	Image           GetDefaultImage( USHORT nId, SfxModule*, BOOL bBig, BOOL bHiContrast ) const;
/*?*/ 
/*?*/     virtual BOOL    ReInitialize();
/*?*/ 	int 			Load( SvStream& );
/*?*/ 	BOOL			Store( SvStream& );
/*?*/ 	virtual	void	UseDefault();
/*?*/     virtual String  GetStreamName() const;
/*?*/ 	virtual int 	Load(SotStorage&);
/*?*/ 	virtual BOOL	Store(SotStorage&);
/*?*/     void            AddLink( const Link& );
/*?*/     void            RemoveLink( const Link& );
/*?*/     void            LoadBitmap( Bitmap&, SotStorage&, const String& );
/*?*/ 
/*?*/                     SfxImageManager_Impl( SfxConfigManager* pCfg );
/*?*/ 					~SfxImageManager_Impl();
/*?*/ };

// elements common to all ImageManager instances
static ImageList* pImageListSmall=0;
static ImageList* pImageListBig=0;
static ImageList* pImageListHiSmall=0;
static ImageList* pImageListHiBig=0;
//static ImageList* pOffImageList;
//static ImageList* pOffHiImageList;
static ImageList* pImageList;
static ImageList* pHiImageList;
static SfxImageManager_Impl* pGlobalConfig=NULL;
static int nRef=0;
static int nGlobalRef=0;

// we need a static list of all pImp instances, so all operations that should change all instances can be performed
// which operations ?!

/*N*/ ImageList* GetImageList( BOOL bBig, BOOL bHiContrast = FALSE )
/*N*/ {
/*N*/ 	// Has to be changed if we know how the IDs are named!!!
/*N*/ 	ImageList*& rpList = bBig ? ( bHiContrast ? pImageListHiBig : pImageListBig ) :
/*N*/ 								( bHiContrast ? pImageListHiSmall : pImageListSmall );
/*N*/     if ( !rpList )
/*N*/     {
/*N*/         ResMgr *pResMgr = Resource::GetResManager();
/*N*/         ResId aResId( bBig ? ( bHiContrast ? RID_DEFAULTIMAGELIST_LCH : RID_DEFAULTIMAGELIST_LC ) :
/*N*/ 							 ( bHiContrast ? RID_DEFAULTIMAGELIST_SCH : RID_DEFAULTIMAGELIST_SC ));
/*N*/ 
/*N*/ 		aResId.SetRT( RSC_IMAGELIST );
/*N*/ 
// #i30187# ImageList is not needed for binfilter/*N*/         DBG_ASSERT( pResMgr->IsAvailable(aResId), "No default ImageList!" );
/*N*/ 
/*N*/         if ( pResMgr->IsAvailable(aResId) )
/*N*/             rpList = new ImageList( aResId );
/*N*/         else
/*?*/             rpList = new ImageList();
/*N*/ 	}
/*N*/ 
/*N*/     return rpList;
/*N*/ }

//=========================================================================

/*N*/ sal_Int16 SfxImageManager::GetCurrentSymbolsSize()
/*N*/ {
/*N*/     return SvtMiscOptions().GetCurrentSymbolsSize();
/*N*/ }

//=========================================================================

// Enth"alt eine Kombination aus Bitmap und zugeordneter SlotId
/*?*/ struct ToolboxBitmap_Impl
/*?*/ {
/*?*/ 	USHORT	nId;
/*?*/ 	Bitmap*	pBitmap;
/*?*/ 
/*?*/ 	ToolboxBitmap_Impl( USHORT n, const Bitmap& rBmp ) : nId( n )
/*?*/ 	{
/*?*/ 		pBitmap = new Bitmap( rBmp );
/*?*/ 	}
/*?*/ 
/*?*/ 	~ToolboxBitmap_Impl() { delete pBitmap; }
/*?*/ };

// Enth"alt einen Ptr auf eine registrierte Toolbox und Flags f"ur die
// Ereignisse, bei denen die Toolbox upgedatet werden soll
/*?*/ struct ToolBoxInf_Impl
/*?*/ {
/*?*/ 	SfxToolBoxManager*	pMgr;
/*?*/ 	SfxModule*	pModule;
/*?*/ 	ToolBox *pToolBox;
/*?*/ 	USHORT	nFlags;
/*?*/ };

//-------------------------------------------------------------------------

/*?*/ DECL_PTRARRAY( SfxBitmapArr_Impl, ToolboxBitmap_Impl*, 4, 4 )//STRIP008 ;
/*?*/ DECL_PTRARRAY( SfxToolBoxArr_Impl, ToolBoxInf_Impl*, 4, 4 )//STRIP008 ;

//-------------------------------------------------------------------------

// Liste der geladenen Userdef-Bitmaps
/*?*/ class SfxBitmapList_Impl
/*?*/ {
/*?*/ 	SfxBitmapArr_Impl*	pList;
/*?*/ 
/*?*/ public:
/*?*/ friend SvStream& operator >> (SvStream& rStream, SfxBitmapList_Impl& rList);
/*?*/ friend SvStream& operator << (SvStream& rStream, const SfxBitmapList_Impl& rList);
/*?*/ 
/*?*/ 	SfxBitmapList_Impl()
/*?*/ 			{ pList = new SfxBitmapArr_Impl; }
/*?*/ 
/*?*/ 	~SfxBitmapList_Impl()
/*?*/ 			{
/*?*/ 				for (USHORT n=0; n<pList->Count(); n++)
/*?*/ 					delete (*pList)[n];
/*?*/ 				delete pList;
/*?*/ 			}
/*?*/ 
/*?*/ 	USHORT	GetBitmapCount() const
/*?*/ 			{ return pList->Count(); }
/*?*/ 
/*?*/ 	USHORT	GetBitmapId(USHORT n) const
/*?*/ 			{ return (*pList)[n]->nId; }
/*?*/ 
/*?*/ 	USHORT  GetBitmapPos(USHORT nId) const;
/*?*/ 	Bitmap* GetBitmap(USHORT nId) const;
/*?*/ 	void	AddBitmap (USHORT nId, const Bitmap& rpBmp);
/*?*/ 	void	ReplaceBitmap (USHORT nId, const Bitmap& rpBmp);
/*?*/ 	void	RemoveBitmap (USHORT nId);
/*?*/ };

//=========================================================================

/*  [Beschreibung]

	Liefert die Position einer Bitmap in der internen Bitmapliste
*/

/*?*/ USHORT SfxBitmapList_Impl::GetBitmapPos( USHORT nId ) const
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
/*?*/ }

//-------------------------------------------------------------------------

/*  [Beschreibung]

	Liefert die Bitmap an der "uebergebenen Position der internen Bitmapliste
*/

/*?*/ Bitmap* SfxBitmapList_Impl::GetBitmap(USHORT nId) const
/*?*/ {DBG_BF_ASSERT(0, "STRIP");return 0; //STRIP001 
/*?*/ }

//-------------------------------------------------------------------------

/*  [Beschreibung]

	F"ugt der internen Bitmapliste eine Bitmap hinzu, die f"ur die "ubergebene
	SlotId registriert wird. Die Bitmap geht in den Besitz des ImageManagers
	"uber.
*/

/*?*/ void SfxBitmapList_Impl::AddBitmap( USHORT nId, const Bitmap& rBmp )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

//-------------------------------------------------------------------------

/*  [Beschreibung]

	Ersetzt die Bitmap in der internen Bitmapliste, die f"ur die "ubergebene
	SlotId registriert ist, durch die "ubergebene Bitmap.
	Die Bitmap geht in den Besitz des ImageManagers	"uber.
*/

/*?*/ void SfxBitmapList_Impl::ReplaceBitmap( USHORT nId, const Bitmap& rBmp )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

//-------------------------------------------------------------------------

/*  [Beschreibung]

	Entfernt die Bitmap in der internen Bitmapliste, die f"ur die "ubergebene
	SlotId registriert ist.
	Da die Bitmap dem ImageManagers	geh"ort, wird sie zerst"ort.
*/

/*?*/ void SfxBitmapList_Impl::RemoveBitmap( USHORT nId )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

//-------------------------------------------------------------------------

/*  [Beschreibung]

	Liest die interne Bitmapliste aus einem Stream.
*/

/*?*/ SvStream& operator >> (SvStream& rStream, SfxBitmapList_Impl& rList)
/*?*/ {
/*?*/ 	USHORT nCount, nId;
/*?*/ 	rStream >> nCount;
/*?*/ 	for (USHORT n=0; n<nCount; n++)
/*?*/ 	{
/*?*/ 		Bitmap aBmp;
/*?*/ 		rStream >> nId >> aBmp;
/*?*/ 		rList.AddBitmap(nId, aBmp);
/*?*/ 	}
/*?*/ 
/*?*/ 	return rStream;
/*?*/ }

//-------------------------------------------------------------------------

/*  [Beschreibung]

	Speichert die interne Bitmapliste in einem Stream,
*/

/*?*/ SvStream& operator << (SvStream& rStream, const SfxBitmapList_Impl& rList)
/*?*/ {
/*?*/ 	rStream << rList.GetBitmapCount();
/*?*/ 	for (USHORT n=0; n<rList.GetBitmapCount(); n++)
/*?*/ 		rStream << (*rList.pList)[n]->nId << *((*rList.pList)[n]->pBitmap);
/*?*/ 
/*?*/ 	return rStream;
/*?*/ }

/*N*/ SfxImageManager_Impl::SfxImageManager_Impl( SfxConfigManager* pCfgMgr )
/*N*/ 	: SfxConfigItem( SFX_ITEMTYPE_IMAGELIST, pCfgMgr )
/*N*/ 	, m_pUserDefList( 0 )
/*N*/ 	, m_pUserImageList( 0 )
/*N*/ 	, m_pHCUserImageList( 0 )
/*N*/ {
/*N*/ //    SetInternal( TRUE );
/*N*/     Initialize();
/*N*/ }

/*N*/ SfxImageManager_Impl::~SfxImageManager_Impl()
/*N*/ {
/*N*/ 	delete m_pUserDefList;
/*N*/ 	delete m_pUserImageList;
/*N*/ 	delete m_pHCUserImageList;
/*N*/ 
/*N*/ 	if ( this == pGlobalConfig )
/*N*/ 		pGlobalConfig = NULL;
/*N*/ }

/*N*/ void SfxImageManager_Impl::AddLink( const Link& rLink )
/*N*/ {
/*N*/     m_aList.Insert( new Link( rLink ) );
/*N*/ }

/*N*/ void SfxImageManager_Impl::RemoveLink( const Link& rLink )
/*N*/ {
/*N*/     for ( USHORT n=0; n<m_aList.Count(); n++ )
/*N*/     {
/*N*/         if ( (*m_aList.GetObject(n) ) == rLink )
/*N*/         {
/*N*/             delete m_aList.Remove(n);
/*N*/             break;
/*N*/         }
/*N*/     }
/*N*/ }

//-------------------------------------------------------------------------

/*?*/ void SfxImageManager_Impl::LoadBitmap( Bitmap& rBmp, SotStorage& rStorage, const String& rURL )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

/*?*/ int SfxImageManager_Impl::Load( SotStorage& rStorage )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 

/*?*/ }

/*?*/ BOOL SfxImageManager_Impl::Store( SotStorage& rStorage )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
/*?*/ }


/*?*/ int SfxImageManager_Impl::Load(SvStream& rStream)
/*?*/ {DBG_BF_ASSERT(0, "STRIP");return 0; //STRIP001 
/*?*/ }

/*?*/ BOOL SfxImageManager_Impl::ReInitialize()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
/*?*/ }

//-------------------------------------------------------------------------


/*?*/ BOOL SfxImageManager_Impl::Store(SvStream& rStream)
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
/*?*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxImageManager_Impl::UseDefault()
/*N*/ {
/*N*/ 	MakeDefaultImageList();
/*N*/ 	MakeUserList();
/*N*/     SetDefault( TRUE );
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ String SfxImageManager_Impl::GetStreamName() const
/*N*/ {
/*N*/     return SfxConfigItem::GetStreamName( GetType() );
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxImageManager_Impl::MakeUserList()
/*N*/ {
/*N*/ 	if ( m_pUserImageList )
/*N*/ 	{
/*?*/ 		DELETEZ( m_pUserImageList );
/*?*/ 		DELETEZ( m_pHCUserImageList );
/*?*/ 		DELETEZ( m_pUserDefList );
/*N*/ 	}
/*N*/ 
/*N*/     m_pUserDefList = new SfxBitmapList_Impl;
/*N*/     m_pUserImageList = new ImageList;
/*N*/ 	m_pHCUserImageList = new ImageList;
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxImageManager_Impl::MakeDefaultImageList( BOOL bHiContrast )
/*N*/ {
/*N*/ 	USHORT nType=0;
/*N*/ 	{
/*N*/ 		switch ( SfxImageManager::GetCurrentSymbolsSize() )
/*N*/ 		{
/*N*/ 			case SFX_SYMBOLS_SIZE_SMALL:
/*N*/ 				if ( bHiContrast )
/*?*/ 					pHiImageList = GetImageList( FALSE, TRUE );
/*N*/ 				else
/*N*/ 					pImageList = GetImageList( FALSE, FALSE );
/*N*/ 				break;
/*N*/ 			case SFX_SYMBOLS_SIZE_LARGE:
/*?*/ 				if ( bHiContrast )
/*?*/ 					pHiImageList = GetImageList( TRUE, TRUE );
/*?*/ 				else
/*?*/ 					pImageList = GetImageList( TRUE, FALSE );
/*N*/ 				break;
/*N*/ 			default:
/*?*/ 				DBG_ERROR("Unknown Symboltype!");
/*N*/ 				break;
/*N*/ 		}
/*N*/ 	}
/*N*/ }

//-------------------------------------------------------------------------

/*?*/ void SfxImageManager::ExchangeItemImage_Impl( USHORT nId, const Image& rImage )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

/*?*/ void SfxImageManager_Impl::RebuildUserList()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

/*N*/ Image SfxImageManager_Impl::GetImage( USHORT nId, SfxModule *pModule, BOOL bBig, BOOL bHiContrast ) const
/*N*/ {
/*N*/ 	if ( !pModule )
/*N*/ 		pModule = SFX_APP()->GetActiveModule();
/*N*/ 	ImageList *pList=0;
/*N*/ 	if ( pModule )
/*N*/         pList = pModule->GetImageList_Impl( bBig, bHiContrast );
/*N*/ 
/*N*/ 	if ( bHiContrast )
/*N*/ 	{
/*?*/ 		if ( m_pHCUserImageList->GetImagePos( nId ) != IMAGELIST_IMAGE_NOTFOUND )
/*?*/ 			return m_pHCUserImageList->GetImage( nId );
/*?*/ 		else if ( pList && pList->GetImagePos( nId ) != IMAGELIST_IMAGE_NOTFOUND )
/*?*/ 			return pList->GetImage( nId );
/*?*/ 		else
/*?*/ 			return GetImageList( bBig, bHiContrast )->GetImage( nId );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		if ( m_pUserImageList->GetImagePos( nId ) != IMAGELIST_IMAGE_NOTFOUND )
/*?*/ 			return m_pUserImageList->GetImage( nId );
/*N*/ 		else if ( pList && pList->GetImagePos( nId ) != IMAGELIST_IMAGE_NOTFOUND )
/*N*/ 			return pList->GetImage( nId );
/*N*/ 		else
/*N*/ 			return GetImageList( bBig, bHiContrast )->GetImage( nId );
/*N*/ 	}
/*N*/ }

/*?*/ Image SfxImageManager_Impl::GetDefaultImage(USHORT nId, SfxModule* pMod, BOOL bBig, BOOL bHiContrast ) const
/*?*/ {
/*?*/ 	if ( !pMod )
/*?*/ 		pMod = SFX_APP()->GetActiveModule();
/*?*/ 	ImageList *pList=0;
/*?*/ 	if ( pMod )
/*?*/         pList = pMod->GetImageList_Impl( bBig, bHiContrast );
/*?*/ 
/*?*/ 	if ( pList && pList->GetImagePos( nId ) != IMAGELIST_IMAGE_NOTFOUND )
/*?*/ 		return pList->GetImage( nId );
/*?*/ 	else
/*?*/ 		return GetImageList( bBig, bHiContrast )->GetImage( nId );
/*?*/ }

/*N*/ Image SfxImageManager_Impl::SeekImage( USHORT nId, SfxModule *pModule, BOOL bHiContrast ) const
/*N*/ {
/*N*/ 	BOOL bBig = ( SfxImageManager::GetCurrentSymbolsSize() == SFX_SYMBOLS_SIZE_LARGE );
/*N*/ 
/*N*/ 	if ( !pModule )
/*?*/ 		pModule = SFX_APP()->GetActiveModule();
/*N*/ 	ImageList *pList=0;
/*N*/ 	if ( pModule )
/*N*/         pList = pModule->GetImageList_Impl( bBig, bHiContrast );
/*N*/ 
/*N*/ 	if ( bHiContrast )
/*N*/ 	{
/*?*/ 		if ( m_pHCUserImageList->GetImagePos( nId ) != IMAGELIST_IMAGE_NOTFOUND )
/*?*/ 			return m_pHCUserImageList->GetImage( nId );
/*?*/ 		else if ( pList && pList->GetImagePos( nId ) != IMAGELIST_IMAGE_NOTFOUND )
/*?*/ 			return pList->GetImage( nId );
/*?*/ 		else
/*?*/ 			return GetImageList( bBig, bHiContrast )->GetImage( nId );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		if ( m_pUserImageList->GetImagePos( nId ) != IMAGELIST_IMAGE_NOTFOUND )
/*?*/ 			return m_pUserImageList->GetImage( nId );
/*N*/ 		else if ( pList && pList->GetImagePos( nId ) != IMAGELIST_IMAGE_NOTFOUND )
/*N*/ 			return pList->GetImage( nId );
/*N*/ 		else
/*?*/ 			return GetImageList( bBig, bHiContrast )->GetImage( nId );
/*N*/ 	}
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ SfxImageManager::SfxImageManager( SfxObjectShell* pDoc )
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 
/*N*/     // every ImageManager has its own list of toolboxes, so even if it gets a new configuration, the list
/*N*/     // remains the same!
/*N*/     pData = new SfxImageManagerData_Impl;
/*N*/     pData->pToolBoxList = new SfxToolBoxArr_Impl;
/*N*/     pData->pDoc = pDoc;
/*N*/ 
/*N*/ 	if ( pDoc && pDoc->GetConfigManager() && pDoc->GetConfigManager()->HasConfigItem(SFX_ITEMTYPE_IMAGELIST) )
/*N*/ 	{
/*?*/ 		pImp = new SfxImageManager_Impl( pDoc->GetConfigManager() );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		if ( !pGlobalConfig )
/*N*/             pGlobalConfig = new SfxImageManager_Impl( SFX_APP()->GetConfigManager_Impl() );
/*N*/ 		pImp = pGlobalConfig;
/*N*/         nGlobalRef++;
/*N*/ 	}
/*N*/ 
/*N*/     // internal cached data for comparision in callback
/*N*/     pData->nSet = SfxImageManager::GetCurrentSymbolsSize();
/*N*/     pData->nOutStyle = pImp->m_aOpt.GetToolboxStyle();
/*N*/ 
/*N*/     // register callback for changes of SymbolsSize or ToolboxStyle
/*N*/     pImp->m_aOpt.AddListener( LINK( this, SfxImageManager, OptionsChanged_Impl ) );
/*N*/     Application::AddEventListener( LINK( this, SfxImageManager, SettingsChanged_Impl ) );
/*N*/ 
/*N*/ //    SetInternal( TRUE );
/*N*/     nRef++;
/*N*/     pImp->AddLink( LINK( this, SfxImageManager, OptionsChanged_Impl ) );
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ SfxImageManager::~SfxImageManager()
/*N*/ {
/*N*/     pImp->RemoveLink( LINK( this, SfxImageManager, OptionsChanged_Impl ) );
/*N*/ 
/*N*/     if ( !--nRef )
/*N*/     {
/*N*/         DELETEZ( pImageListSmall );
/*N*/         DELETEZ( pImageListBig );
/*N*/ 		DELETEZ( pImageListHiSmall );
/*N*/ 		DELETEZ( pImageListHiBig );
/*N*/     }
/*N*/ 
/*N*/     DELETEZ( pData->pToolBoxList );
/*N*/     pImp->m_aOpt.RemoveListener( LINK( this, SfxImageManager, OptionsChanged_Impl ) );
/*N*/     Application::RemoveEventListener( LINK( this, SfxImageManager, SettingsChanged_Impl ) );
/*N*/     if ( pImp != pGlobalConfig || !--nGlobalRef )
/*N*/ 		delete pImp;
/*N*/     delete pData;
/*N*/ }



/*?*/ BOOL SfxImageManager::Import( SvStream& rInStream, SotStorage& rOutStorage )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
/*?*/ }

/*?*/ BOOL SfxImageManager::Export( SotStorage& rInStorage, SvStream& rOutStream )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
/*?*/ }

//-------------------------------------------------------------------------

/*  [Beschreibung]

	Nimmt eine Referenz auf ein Image auf und erweitert die aktuelle ImageList
	ggf. um ein weiteres Image. Der Zweck dieser Methode ist, da\s verhindert
	werden mu\s, da\s die Toolbox "uber das Image eine Referenz auf die
	Quell-Liste diese am Leben erh"alt.
*/

/*?*/ void SfxImageManager::LockImage( USHORT nId, ToolBox *pBox )
/*?*/ {
DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	LockImage( nId, pBox, FALSE );
/*?*/ }

/*?*/ void SfxImageManager::LockImage( USHORT nId, ToolBox *pBox, BOOL bHiContrast )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

//-------------------------------------------------------------------------

/*?*/ Image SfxImageManager::MakeUserImage( USHORT nId, Image& aImage, BOOL bHiContrast )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ 	return Image();
/*?*/ }

//-------------------------------------------------------------------------

/*?*/ void SfxImageManager::SetSymbolsSize_Impl( sal_Int16 nNewSet )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

//-------------------------------------------------------------------------
/* Retrieves the default image for an ID. The search order is
   Module-Imagelist (if existing), Defaultlist
*/

/*?*/ Image SfxImageManager::GetDefaultImage(USHORT nId, SfxModule* pMod, BOOL bBig, BOOL bHiContrast ) const
/*?*/ {
/*?*/ 	return pImp->GetDefaultImage( nId, pMod, bBig, bHiContrast );
/*?*/ }

//-------------------------------------------------------------------------
/*  [Beschreibung]

	Sucht das Image der uebergebenen Id. Suchreihenfolge:

	UserDefListe, Modul-Imageliste( sofern vorhanden ), Default-Liste,
	Officeliste( sofern vorhanden ).
*/

/*?*/ Image SfxImageManager::SeekImage( USHORT nId, SfxModule *pModule ) const
/*?*/ {
/*?*/ 	return SeekImage( nId, FALSE, pModule );
/*?*/ }

/*N*/ Image SfxImageManager::SeekImage( USHORT nId, BOOL bHiContrast, SfxModule *pModule ) const
/*N*/ {
/*N*/ 	return pImp->SeekImage( nId, pModule, bHiContrast );
/*N*/ }

//-------------------------------------------------------------------------

/*  [Beschreibung]

	Sucht das Image der uebergebenen Id genauso wie SeekImage, allerdings
	wird die Office-liste nicht durchsucht, d.h. es werden nur die aktuell
	konfigurierten Images ber"ucksichtigt.
*/
/*?*/ Image SfxImageManager::GetImage( USHORT nId, SfxModule *pModule ) const
/*?*/ {
/*?*/ 	return GetImage( nId, FALSE, pModule );
/*?*/ }

/*N*/ Image SfxImageManager::GetImage( USHORT nId, BOOL bHiContrast, SfxModule *pModule ) const
/*N*/ {
/*N*/     return pImp->GetImage( nId, pModule, ( SfxImageManager::GetCurrentSymbolsSize() == SFX_SYMBOLS_SIZE_LARGE ), bHiContrast );
/*N*/ }

/*?*/ Image SfxImageManager::GetImage(USHORT nId, SfxModule* pMod, BOOL bBig ) const
/*?*/ {
/*?*/ 	return GetImage( nId, pMod, bBig, FALSE );
/*?*/ }

/*?*/ Image SfxImageManager::GetImage( USHORT nId, SfxModule *pModule, BOOL bBig, BOOL bHiContrast ) const
/*?*/ {
/*?*/     return pImp->GetImage( nId, pModule, bBig, bHiContrast );
/*?*/ }

/*?*/ Image SfxImageManager::GetImageFromModule_Impl( USHORT nId, SfxModule *pModule )
/*?*/ {
/*?*/ 	return GetImageFromModule_Impl( nId, pModule, FALSE );
/*?*/ }

/*?*/ Image SfxImageManager::GetImageFromModule_Impl( USHORT nId, SfxModule *pModule, BOOL bHiContrast )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ 	return Image();
/*?*/ }

/*?*/ Image SfxImageManager::GetAndLockImage_Impl( USHORT nId, SfxModule *pModule )
/*?*/ {
/*?*/ 	return GetAndLockImage_Impl( nId, FALSE, pModule );
/*?*/ }

/*?*/ Image SfxImageManager::GetAndLockImage_Impl( USHORT nId, BOOL bHiContrast, SfxModule *pModule )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return Image();//STRIP001 
/*?*/ }

//-------------------------------------------------------------------------

/*  [Beschreibung]

	Erzeugt die Office-Liste, die f"ur das Konfigurieren ben"otigt wird.
*/

/*N*/ void SfxImageManager::StartCustomize()
/*N*/ {
/*N*/ 	// no more office list
/*N*/ }

//-------------------------------------------------------------------------

/*  [Beschreibung]

	Entfernt die nachgeladenen ImageLists wieder aus dem Speicher.
*/

/*N*/ void SfxImageManager::EndCustomize()
/*N*/ {
/*N*/ 	// no more office list
/*N*/ }

//-------------------------------------------------------------------------

/*  [Beschreibung]

	Ersetzt das Image f"ur die "ubergebene Id durch die "ubergebene Bitmap
	bzw. entfernt die Bindung an eine Bitmap.
*/

/*N*/ void SfxImageManager::ReplaceImage( USHORT nId, Bitmap* pBmp )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

/*  [Beschreibung]

	Meldet eine Toolbox an, damit sie (je nach Flags) bei "Anderungen von
	Symbolset oder OutStyle benachrichtigt werden kann.
*/

/*N*/ void SfxImageManager::RegisterToolBox( ToolBox *pBox, USHORT nFlags )
/*N*/ {
/*N*/ 	ToolBoxInf_Impl *pInf = new ToolBoxInf_Impl;
/*N*/ 	pInf->pToolBox = pBox;
/*N*/ 	pInf->pMgr = NULL;
/*N*/ 	pInf->nFlags = nFlags;
/*N*/ 	pInf->pModule = NULL;
/*N*/     pData->pToolBoxList->Append( pInf );
/*N*/     pBox->SetOutStyle( pImp->m_aOpt.GetToolboxStyle() );
/*N*/ }

/*N*/ void SfxImageManager::RegisterToolBox( ToolBox *pBox, SfxModule* pModule, USHORT nFlags )
/*N*/ {
/*N*/ 	ToolBoxInf_Impl *pInf = new ToolBoxInf_Impl;
/*N*/ 	pInf->pToolBox = pBox;
/*N*/ 	pInf->pMgr = NULL;
/*N*/ 	pInf->nFlags = nFlags;
/*N*/ 	pInf->pModule = pModule;
/*N*/     pData->pToolBoxList->Append( pInf );
/*N*/     pBox->SetOutStyle( pImp->m_aOpt.GetToolboxStyle() );
/*N*/ }

//-------------------------------------------------------------------------

/*  [Beschreibung]

	Meldet eine Toolbox wieder ab.
*/

/*N*/ void SfxImageManager::ReleaseToolBox( ToolBox *pBox )
/*N*/ {
/*N*/     for ( USHORT n=0; n<pData->pToolBoxList->Count(); n++ )
/*N*/ 	{
/*N*/         if ( (*pData->pToolBoxList)[n]->pToolBox == pBox )
/*N*/ 		{
/*N*/             delete (*pData->pToolBoxList)[n];
/*N*/             pData->pToolBoxList->Remove( n );
/*N*/ 			return;
/*N*/ 		}
/*N*/ 	}
/*N*/ }

/*N*/ void SfxImageManager::RegisterToolBoxManager( SfxToolBoxManager *pMgr, USHORT nFlags )
/*N*/ {
/*N*/ 	ToolBoxInf_Impl *pInf = new ToolBoxInf_Impl;
/*N*/ 	pInf->pToolBox = &pMgr->GetToolBox();
/*N*/ 	pInf->pMgr = pMgr;
/*N*/ 	pInf->nFlags = nFlags;
/*N*/     pData->pToolBoxList->Append( pInf );
/*N*/     pInf->pToolBox->SetOutStyle( pImp->m_aOpt.GetToolboxStyle() );
/*N*/ }

//-------------------------------------------------------------------------

/*  [Beschreibung]

	Meldet eine Toolbox wieder ab.
*/

/*?*/ void SfxImageManager::ReleaseToolBoxManager( SfxToolBoxManager *pMgr )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

//-------------------------------------------------------------------------

/*  [Beschreibung]

	Gibt die Color zu"ruck, die als Maskenfarbe verwendet wird.
*/

/*?*/ Color SfxImageManager::GetMaskColor() const
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ 		return Color( COL_LIGHTMAGENTA );
/*?*/ }

//-------------------------------------------------------------------------

/*  [Beschreibung]

	Versorgt die "ubergebene Toolbox mit allen Images, die f"ur die enthaltenen
	Ids konfiguriert sind.
	Es wird ( genauso wie bei GetImage ) nicht in der Office-Liste gesucht.
*/

/*N*/ void SfxImageManager::SetImages( ToolBox& rToolBox, SfxModule *pModule )
/*N*/ {
/*N*/ 	SetImages( rToolBox, pModule, FALSE );
/*N*/ }

/*N*/ void SfxImageManager::SetImages( ToolBox& rToolBox, SfxModule *pModule, BOOL bHiContrast )
/*N*/ {
/*N*/ 	BOOL bBig = ( pData->nSet == SFX_SYMBOLS_SIZE_LARGE );
/*N*/ 
/*N*/ 	if ( !pModule )
/*N*/ 		pModule = SFX_APP()->GetActiveModule();
/*N*/ 	ImageList *pList=0;
/*N*/ 	if ( pModule )
/*N*/         pList = pModule->GetImageList_Impl( bBig, bHiContrast );
/*N*/ 
/*N*/ 	ImageList *pUserImageList	= bHiContrast ? pImp->m_pHCUserImageList : pImp->m_pUserImageList;
/*N*/ 	ImageList *pWorkImageList	= GetImageList( bBig, bHiContrast );
/*N*/ 	USHORT nCount = rToolBox.GetItemCount();
/*N*/ 	for (USHORT n=0; n<nCount; n++)
/*N*/ 	{
/*N*/ 		USHORT nId = rToolBox.GetItemId(n);
/*N*/ 		switch ( rToolBox.GetItemType(n) )
/*N*/ 		{
/*N*/ 			case TOOLBOXITEM_BUTTON:
/*N*/ 			{
/*N*/ 				if ( pUserImageList->GetImagePos( nId ) != IMAGELIST_IMAGE_NOTFOUND )
/*N*/ 					rToolBox.SetItemImage(nId, pUserImageList->GetImage(nId));
/*N*/ 				else if ( pList && pList->GetImagePos( nId ) != IMAGELIST_IMAGE_NOTFOUND )
/*N*/ 					rToolBox.SetItemImage(nId, pList->GetImage(nId));
/*N*/ 				else if ( pWorkImageList->GetImagePos( nId ) != IMAGELIST_IMAGE_NOTFOUND )
/*N*/ 					rToolBox.SetItemImage(nId, pWorkImageList->GetImage(nId));
/*N*/ 			}
/*N*/ 
/*N*/ 			case TOOLBOXITEM_SEPARATOR:
/*N*/ 			case TOOLBOXITEM_SPACE:
/*N*/ 			case TOOLBOXITEM_BREAK:
/*N*/ 				break;
/*N*/ 
/*N*/ 			default:
/*N*/ 				DBG_ERROR( "invalid item-type in toolbox config" );
/*N*/ 		}
/*N*/ 	}
/*N*/ }

//-------------------------------------------------------------------------

/*  [Beschreibung]

	Gibt zur"uck, ob f"ur die angegebene Id eine Bitmap konfiguriert wurde.
*/

/*N*/ BOOL SfxImageManager::IsUserDef_Impl(USHORT nId) const
/*N*/ {
/*N*/ 	return ( pImp->m_pUserDefList->GetBitmapPos(nId) != USHRT_MAX );
/*N*/ }

//-------------------------------------------------------------------------

/*  [Beschreibung]

	Gibt die konfigurierte Bitmap f"ur die angegebene Id zur"uck. Wichtig:
	vorher mu\s mit IsUserDef_Impl "uberpr"uft werden, ob es auch eine gibt.
*/

/*?*/ const Bitmap& SfxImageManager::GetUserDefBitmap_Impl( USHORT nId ) const
/*?*/ {
/*?*/ 	SfxBitmapList_Impl* pUserDefList = pImp->m_pUserDefList;
/*?*/ 	USHORT nPos = pUserDefList->GetBitmapPos( nId );
/*?*/ 	DBG_ASSERT( nPos != USHRT_MAX, "Bitmap nicht vorhanden!" );
/*?*/ 	return ( *pUserDefList->GetBitmap(nId) );
/*?*/ }

/*?*/ void SfxImageManager::SetOutStyle_Impl( sal_Int16 nNewStyle )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

/*?*/ Size SfxImageManager::GetImageSize() const
/*?*/ {
/*?*/ 	return pImageList->GetImageSize();
/*?*/ }

/*?*/ IMPL_LINK( SfxImageManager, OptionsChanged_Impl, void*, pVoid )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/     return 0L;
/*?*/ }

/*?*/ Image SfxImageManager::GetGlobalImage( USHORT nId, BOOL bBig )
/*?*/ {DBG_BF_ASSERT(0, "STRIP");return Image(); //STRIP001 
/*?*/ }

/*?*/ Image SfxImageManager::GetGlobalImage( USHORT nId, BOOL bBig, BOOL bHiContrast )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return Image();//STRIP001 
/*?*/ }


/*N*/ IMPL_LINK( SfxImageManager, SettingsChanged_Impl, void*, pVoid )
/*N*/ {
/*N*/     // Check if toolbar button size have changed and we have to use system settings
/*N*/     sal_Int16 nSymbolsSize = SfxImageManager::GetCurrentSymbolsSize();
/*N*/     if ( pData->nSet != nSymbolsSize )
/*?*/         SetSymbolsSize_Impl( nSymbolsSize );
/*N*/     
/*N*/     return 0L;
/*N*/ }

/*?*/ IMPL_LINK( SfxImageManager, ConfigChanged_Impl, void*, pVoid )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
/*?*/ }

/*?*/ BOOL SfxImageManager::CopyConfiguration_Impl( SfxConfigManager& rSource, SfxConfigManager& rDest )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
/*?*/ }
}
