/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_tbxitem.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 19:46:41 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef SOLARIS
// HACK: prevent conflict between STLPORT and Workshop headers on Solaris 8
#include <ctime>
#endif

#include <string>			// prevent conflict with STL includes

#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif

#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif

#include <svtools/imagemgr.hxx>
#include <framework/menuconfiguration.hxx>

#ifndef INCLUDED_SVTOOLS_MENUOPTIONS_HXX
#include <svtools/menuoptions.hxx>
#endif

#pragma hdrstop

#include "tbxctrl.hxx"
#include "dispatch.hxx"
#include "msgpool.hxx"

#ifndef _COM_SUN_STAR_LANG_XTYPEPROVIDER_HPP_
#include <com/sun/star/lang/XTypeProvider.hpp>
#endif

#include "viewfrm.hxx"
#include "arrdecl.hxx"
#include "sfxtypes.hxx"
#include "macrconf.hxx"
#include "toolbox.hrc"
#include "sfx.hrc"
#include "docfac.hxx"
#include "unoctitm.hxx"
#include "helpid.hrc"
#include "imgmgr.hxx"
#ifndef _LEGACYBINFILTERMGR_HXX
#include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
#endif

#ifndef _SVTOOLS_IMGDEF_HXX
#include <svtools/imgdef.hxx>
#endif

#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif

namespace binfilter {

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::frame;

//--------------------------------------------------------------------

static USHORT nLastId_Impl = SID_NEWDOCDIRECT;

//====================================================================

/*N*/ SFX_IMPL_TOOLBOX_CONTROL_ARG(SfxToolBoxControl, SfxStringItem, TRUE);
/*N*/ SFX_IMPL_TOOLBOX_CONTROL(SfxAppToolBoxControl_Impl, SfxStringItem);

//--------------------------------------------------------------------

/*N*/ SfxToolBoxControl::SfxToolBoxControl
/*N*/ (
/*N*/ 	USHORT          nId,
/*N*/ 	ToolBox&        rBox,
/*N*/ 	SfxBindings&    rBindings,
/*N*/ 	BOOL            bShowStringItems
/*N*/ )
/*N*/ :   SfxControllerItem(nId, rBindings),
/*N*/ 	pBox(&rBox),
/*N*/ 	bShowString(bShowStringItems),
/*N*/ 	pFact(0)
/*N*/ {
/*N*/ 	nSelectModifier = 0;
/*N*/ 	DBG( CheckConfigure_Impl(SFX_SLOT_TOOLBOXCONFIG) );
/*N*/ }

//--------------------------------------------------------------------

/*N*/ SfxToolBoxControl::~SfxToolBoxControl()
/*N*/ {
/*N*/ 	if ( SfxMacroConfig::IsMacroSlot( GetId() ) )
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 SFX_APP()->GetMacroConfig()->ReleaseSlotId(GetId());
/*N*/ }

//--------------------------------------------------------------------

/*N*/ SfxToolBoxControl* SfxToolBoxControl::CreateControl( USHORT nId,
/*N*/ 		ToolBox *pBox, SfxBindings &rBindings, SfxModule *pMod )
/*N*/ {
/*N*/ 	SfxToolBoxControl *pCtrl;
/*N*/ 	SfxApplication *pApp = SFX_APP();
/*N*/ 	if ( !pMod )
/*N*/ 	{
/*N*/ 		SfxDispatcher *pDisp = rBindings.GetDispatcher_Impl();
/*N*/ 		pMod = pDisp ? pApp->GetActiveModule( pDisp->GetFrame() ) :0;
/*N*/ 	}
/*N*/ 
/*N*/ 	SfxSlotPool *pSlotPool;
/*N*/ 	if ( pMod )
/*N*/ 		pSlotPool = pMod->GetSlotPool();
/*N*/ 	else
/*N*/ 		pSlotPool = &pApp->GetSlotPool();
/*N*/ 	TypeId aSlotType = pSlotPool->GetSlotType(nId);
/*N*/ 	if ( aSlotType )
/*N*/ 	{
/*N*/ 		if ( pMod )
/*N*/ 		{
/*N*/ 			SfxTbxCtrlFactArr_Impl *pFactories = pMod->GetTbxCtrlFactories_Impl();
/*N*/ 			if ( pFactories )
/*N*/ 			{
/*N*/ 				SfxTbxCtrlFactArr_Impl &rFactories = *pFactories;
/*N*/ 				for ( USHORT nFactory = 0; nFactory < rFactories.Count(); ++nFactory )
/*N*/ 					if ( rFactories[nFactory]->nTypeId == aSlotType &&
/*N*/ 						 ( ( rFactories[nFactory]->nSlotId == 0 ) ||
/*N*/ 						   ( rFactories[nFactory]->nSlotId == nId) ) )
/*N*/ 					{
/*N*/ 						pCtrl = rFactories[nFactory]->pCtor( nId, *pBox, rBindings );
/*N*/ 						pCtrl->pFact = rFactories[nFactory];
/*N*/ 						return pCtrl;
/*N*/ 					}
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		SfxTbxCtrlFactArr_Impl &rFactories = pApp->GetTbxCtrlFactories_Impl();
/*N*/ 
/*N*/ 		for ( USHORT nFactory = 0; nFactory < rFactories.Count(); ++nFactory )
/*N*/ 			if ( rFactories[nFactory]->nTypeId == aSlotType &&
/*N*/ 				 ( ( rFactories[nFactory]->nSlotId == 0 ) ||
/*N*/ 				   ( rFactories[nFactory]->nSlotId == nId) ) )
/*N*/ 			{
/*N*/ 				pCtrl = rFactories[nFactory]->pCtor( nId, *pBox, rBindings );
/*N*/ 				pCtrl->pFact = rFactories[nFactory];
/*N*/ 				return pCtrl;
/*N*/ 			}
/*N*/ 	}
/*N*/ 
/*N*/ 	return new SfxToolBoxControl( nId, *pBox, rBindings );
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxToolBoxControl::StateChanged
/*N*/ (
/*N*/ 	USHORT              nId,
/*N*/ 	SfxItemState        eState,
/*N*/ 	const SfxPoolItem*  pState
/*N*/ )
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	DBG_ASSERT( GetId() == nId, "strange SID" );
/*N*/ 	DBG_ASSERT( pBox != 0, "setting state to dangling ToolBox" );
/*N*/ 
/*N*/ 	if ( GetId() >= SID_OBJECTMENU0 && GetId() <= SID_OBJECTMENU_LAST )
/*N*/ 		return;
/*N*/ 
/*N*/ 	// enabled/disabled-Flag pauschal korrigieren
/*N*/ 	pBox->EnableItem( GetId(), eState != SFX_ITEM_DISABLED );
/*N*/ 
/*N*/ 	USHORT nItemBits = pBox->GetItemBits( GetId() );
/*N*/ 	nItemBits &= ~TIB_CHECKABLE;
/*N*/ 	TriState eTri = STATE_NOCHECK;
/*N*/ 	switch ( eState )
/*N*/ 	{
/*N*/ 		case SFX_ITEM_AVAILABLE:
/*N*/ 		{
/*N*/ 			if ( pState->ISA(SfxBoolItem) )
/*N*/ 			{
/*N*/ 				// BoolItem fuer checken
/*N*/ 				if ( ((const SfxBoolItem*)pState)->GetValue() )
/*N*/ 					eTri = STATE_CHECK;
/*N*/ 				nItemBits |= TIB_CHECKABLE;
/*N*/ 			}
/*N*/ 			else if ( pState->ISA(SfxEnumItemInterface) &&
/*N*/ 				((SfxEnumItemInterface *)pState)->HasBoolValue())
/*N*/ 			{
/*N*/ 				// EnumItem wie Bool behandeln
/*N*/ 				if ( ((const SfxEnumItemInterface *)pState)->GetBoolValue() )
/*N*/ 					eTri = STATE_CHECK;
/*N*/ 				nItemBits |= TIB_CHECKABLE;
/*N*/ 			}
/*N*/ 			else if ( bShowString && pState->ISA(SfxStringItem) )
/*N*/ 				pBox->SetItemText(nId, ((const SfxStringItem*)pState)->GetValue() );
/*N*/ 			break;
/*N*/ 		}
/*N*/ 
/*N*/ 		case SFX_ITEM_DONTCARE:
/*N*/         {
/*N*/ 			eTri = STATE_DONTKNOW;
/*N*/             nItemBits |= TIB_CHECKABLE;
/*N*/         }
/*N*/ 	}
/*N*/ 
/*N*/ 	pBox->SetItemState( GetId(), eTri );
/*N*/ 	pBox->SetItemBits( GetId(), nItemBits );
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxToolBoxControl::Select( USHORT nModifier )
/*N*/ {
/*N*/ 	nSelectModifier = nModifier;
/*N*/ 	Select( BOOL((nModifier & KEY_MOD1)!=0) );
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxToolBoxControl::Select( BOOL bMod1 )
/*N*/ {
/*N*/ 	GetBindings().Execute( GetId(), 0, nSelectModifier );
/*N*/ }

//--------------------------------------------------------------------

/*?*/ void SfxToolBoxControl::DoubleClick()
/*?*/ {
/*?*/ }

//--------------------------------------------------------------------

/*N*/ void SfxToolBoxControl::Click()
/*N*/ {
/*N*/ }

//--------------------------------------------------------------------

/*N*/ SfxPopupWindowType SfxToolBoxControl::GetPopupWindowType() const
/*N*/ {
/*N*/ 	return SFX_POPUPWINDOW_NONE;
/*N*/ }

//--------------------------------------------------------------------



//--------------------------------------------------------------------

/*N*/ Window* SfxToolBoxControl::CreateItemWindow( Window * )
/*N*/ {
/*N*/ 	return 0;
/*N*/ }

/*?*/ SfxToolBoxControl* SfxToolBoxControl::ReInit_Impl()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return NULL;//STRIP001 
/*?*/ }

//--------------------------------------------------------------------


//--------------------------------------------------------------------


//--------------------------------------------------------------------


//--------------------------------------------------------------------

/*N*/ SfxPopupWindow::SfxPopupWindow( USHORT nId, WinBits nBits, SfxBindings &rBindings ):
/*N*/ 	SfxControllerItem(nId, rBindings.GetSubBindings_Impl() ? *rBindings.GetSubBindings_Impl(TRUE) : rBindings ),
/*N*/ 	FloatingWindow( SFX_APP()->GetTopWindow(), nBits ),
/*N*/ 	bFloating(FALSE)
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }

//--------------------------------------------------------------------

/*N*/ SfxPopupWindow::SfxPopupWindow( USHORT nId, const ResId &rId, SfxBindings &rBindings ):
/*N*/ 	SfxControllerItem(nId, rBindings.GetSubBindings_Impl() ? *rBindings.GetSubBindings_Impl(TRUE) : rBindings ),
/*N*/ 	FloatingWindow( SFX_APP()->GetTopWindow(), rId ),
/*N*/ 	bFloating(FALSE)
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }

/*N*/ SfxPopupWindow::~SfxPopupWindow()
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }




//--------------------------------------------------------------------


//--------------------------------------------------------------------


//--------------------------------------------------------------------


//--------------------------------------------------------------------

/*N*/ SfxAppToolBoxControl_Impl::SfxAppToolBoxControl_Impl
/*N*/ (
/*N*/ 	USHORT nId, ToolBox& rBox, SfxBindings &rBindings
/*N*/ )
/*N*/ 	: SfxToolBoxControl( nId, rBox, rBindings )
/*N*/ 	, bBigImages( FALSE )
/*N*/     , pMenu( 0 )
/*N*/ {
/*N*/ 	aTimer.SetTimeout( 250 );
/*N*/ 	aTimer.SetTimeoutHdl( LINK( this, SfxAppToolBoxControl_Impl, Timeout ) );
/*N*/     rBox.SetHelpId( nId, HID_TBXCONTROL_FILENEW );
/*N*/     rBox.SetItemBits( nId,  rBox.GetItemBits( nId ) | TIB_DROPDOWN);
/*N*/ 
/*N*/ 	// Determine the current background color of the menus
/*N*/ 	const StyleSettings& rSettings = Application::GetSettings().GetStyleSettings();
/*N*/ 	m_bWasHiContrastMode	= rSettings.GetMenuColor().IsDark();
/*N*/ 	m_bShowMenuImages		= SvtMenuOptions().IsMenuIconsEnabled();
/*N*/ 
/*N*/     SetImage( String() );
/*N*/ }

/*N*/ SfxAppToolBoxControl_Impl::~SfxAppToolBoxControl_Impl()
/*N*/ {
/*N*/     delete pMenu;
/*N*/ }

//_____________________________________________________
/*
    it return the existing state of the given URL in the popupmenu of this toolbox control.

    If the given URL can be located as an action command of one menu item of the
    popup menu of this control, we return TRUE. Otherwhise we return FALSE.
    Further we return a fallback URL, in case we have to return FALSE. Because
    the outside code must select a valid item of the popup menu everytime ...
    and we define it here. By the way this m ethod was written to handle
    error situations gracefully. E.g. it can be called during creation time
    but then we have no valid menu. For this case we know another fallback URL.
    Then we return the private:factory/ URL of the default factory.

    @param  *pMenu
                pounts to the popup menu, on which item we try to locate the given URL
                Can be NULL! Search will be supressed then.

    @param  sURL
                the URL for searching

    @param  pFallback
                contains the fallback URL in case we return FALSE
                Must point to valid memory!

    @return TRUE - if URL could be located as an item of the popup menu.
            FALSE - otherwhise.
*/
/*N*/ BOOL Impl_ExistURLInMenu( const PopupMenu *pMenu     ,
/*N*/                           const String    &sURL      ,
/*N*/                                 String    *pFallback )
/*N*/ {
/*N*/     BOOL bValidFallback = FALSE;
/*N*/     if (pMenu && sURL.Len())
/*N*/     {
/*N*/         USHORT c = pMenu->GetItemCount();
/*N*/         for (USHORT p=0; p<c; ++p)
/*N*/         {
/*N*/             USHORT nId = pMenu->GetItemId(p);
/*N*/             String aCmd( pMenu->GetItemCommand(nId) );
/*N*/ 
/*N*/             if (!bValidFallback && aCmd.Len())
/*N*/             {
/*N*/                 *pFallback = aCmd;
/*N*/                 bValidFallback = TRUE;
/*N*/             }
/*N*/ 
/*N*/             if (sURL.Equals(aCmd))
/*N*/                 return TRUE;
/*N*/         }
/*N*/     }
/*N*/ 
/*N*/     if (!bValidFallback)
/*N*/     {
/*N*/ 		*pFallback  = DEFINE_CONST_UNICODE("private:factory/");
/*N*/         *pFallback += String::CreateFromAscii(SfxObjectFactory::GetDefaultFactory().GetShortName());
/*N*/     }
/*N*/ 
/*N*/     return FALSE;
/*N*/ }

/*N*/ void SfxAppToolBoxControl_Impl::SetImage( const String &rURL )
/*N*/ {
    /* We accept URL's here only, which exist as items of our internal popup menu.
       All other ones will be ignored and a fallback is used ... */
/*N*/     String aURL = rURL;
/*N*/     String sFallback;
/*N*/     BOOL bValid = Impl_ExistURLInMenu(pMenu,aURL,&sFallback);
/*N*/     if (!bValid)
/*N*/         aURL = sFallback;
/*N*/ 
/*N*/ 	BOOL bBig = ( SfxImageManager::GetCurrentSymbolsSize() == SFX_SYMBOLS_SIZE_LARGE );
/*N*/     GetToolBox().SetItemImage( GetId(),
/*N*/ 							   SvFileInformationManager::GetImage( INetURLObject( aURL ),
/*N*/ 							   bBig,
/*N*/ 								GetToolBox().GetBackground().GetColor().IsDark() ) );
/*N*/ 	aLastURL = aURL;
/*N*/ }

/*N*/ void SfxAppToolBoxControl_Impl::StateChanged
/*N*/ (
/*N*/ 	USHORT              nId,
/*N*/ 	SfxItemState        eState,
/*N*/ 	const SfxPoolItem*  pState
/*N*/ )
/*N*/ {
/*N*/     if ( pState && pState->ISA(SfxStringItem) )
/*N*/     {
/*N*/         // Important step for following SetImage() call!
/*N*/         // It needs the valid pMenu item to fullfill it's specification
/*N*/         // to check for supported URLs ...
/*N*/         if ( !pMenu )
/*N*/         {
/*N*/             Reference < ::com::sun::star::lang::XMultiServiceFactory> aXMultiServiceFactory(::legacy_binfilters::getLegacyProcessServiceFactory());
/*N*/             ::framework::MenuConfiguration aConf( aXMultiServiceFactory );
/*N*/             Reference< ::com::sun::star::frame::XFrame> aXFrame( GetBindings().GetDispatcher_Impl()->GetFrame()->GetFrame()->GetFrameInterface() );
/*N*/             pMenu = aConf.CreateBookmarkMenu( aXFrame, BOOKMARK_NEWMENU );
/*N*/         }
/*N*/         GetToolBox().EnableItem( GetId(), eState != SFX_ITEM_DISABLED );
/*N*/         SetImage(((const SfxStringItem*)pState)->GetValue());
/*N*/     }
/*N*/     else
/*N*/         SfxToolBoxControl::StateChanged( nId, eState, pState );
/*N*/ }

//--------------------------------------------------------------------

/*?*/ void SfxAppToolBoxControl_Impl::Select( BOOL bMod1 )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

//--------------------------------------------------------------------
/*?*/ long Select_Impl( void* pHdl, void* pVoid );


/*?*/ IMPL_LINK( SfxAppToolBoxControl_Impl, Activate, Menu *, pMenu )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ 	return FALSE;
/*?*/ }

//--------------------------------------------------------------------

/*?*/ IMPL_LINK( SfxAppToolBoxControl_Impl, Timeout, Timer *, pTimer )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ 	return 0;
/*?*/ }

//--------------------------------------------------------------------

/*?*/ void SfxAppToolBoxControl_Impl::Click( )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

//--------------------------------------------------------------------





//--------------------------------------------------------------------


//--------------------------------------------------------------------


//--------------------------------------------------------------------








}
