/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_fmvwimp.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 20:58:47 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#pragma hdrstop

#ifndef _COM_SUN_STAR_AWT_XFOCUSLISTENER_HPP_
#include <com/sun/star/awt/XFocusListener.hpp>
#endif

#ifndef _COM_SUN_STAR_SDBC_XROWSETLISTENER_HPP_
#include <com/sun/star/sdbc/XRowSetListener.hpp>
#endif

#ifndef _COM_SUN_STAR_SDB_XSQLQUERYCOMPOSERFACTORY_HPP_
#include <com/sun/star/sdb/XSQLQueryComposerFactory.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif

#ifndef _COM_SUN_STAR_CONTAINER_XCONTAINER_HPP_
#include <com/sun/star/container/XContainer.hpp>
#endif

#ifndef _SVX_FMCTRLER_HXX
#include <fmctrler.hxx>
#endif

#ifndef _SVX_FMVWIMP_HXX
#include "fmvwimp.hxx"
#endif
#ifndef _SVX_FMRESIDS_HRC
#include "fmresids.hrc"
#endif
#ifndef _SVDITER_HXX
#include "svditer.hxx"
#endif


#ifndef _COM_SUN_STAR_SDBCX_XTABLESSUPPLIER_HPP_ 
#include <com/sun/star/sdbcx/XTablesSupplier.hpp>
#endif
#ifndef _SVX_FMMODEL_HXX
#include <fmmodel.hxx>
#endif


#ifndef _SVX_FMPAGE_HXX
#include "fmpage.hxx"
#endif
#ifndef _SVX_FMUNOPGE_HXX
#include "fmpgeimp.hxx"
#endif
#ifndef _SVX_FMSHELL_HXX
#include "fmshell.hxx"
#endif
#ifndef _SVX_FMSHIMP_HXX
#include "fmshimp.hxx"
#endif
#ifndef _SVX_FMPROP_HRC
#include "fmprop.hrc"
#endif
#ifndef _SVDPAGV_HXX
#include "svdpagv.hxx"
#endif
#ifndef _COMPHELPER_ENUMHELPER_HXX_
#include <comphelper/enumhelper.hxx>
#endif

#include <algorithm>
namespace binfilter {

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::sdbcx;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::sdb;
using namespace ::com::sun::star::container;
using namespace ::com::sun::star::form;
using namespace ::com::sun::star::awt;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::util;
using namespace ::comphelper;
using namespace ::binfilter::svxform;//STRIP008 using namespace ::svxform;
using namespace ::binfilter ::svx;

namespace svxform
{
	//========================================================================

	//------------------------------------------------------------------------

	//------------------------------------------------------------------------
}

//------------------------------------------------------------------------------
class FmXFormView::ObjectRemoveListener : public SfxListener
{
	FmXFormView* m_pParent;
public:
	ObjectRemoveListener( FmXFormView* pParent );
	virtual void Notify( SfxBroadcaster& rBC, const SfxHint& rHint );
};

//========================================================================
/*N*/ DBG_NAME(FmXPageViewWinRec)
//------------------------------------------------------------------------
/*N*/ FmXPageViewWinRec::FmXPageViewWinRec(const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >&	_xORB,
/*N*/ 									 const SdrPageViewWinRec* pWinRec,
/*N*/ 								   FmXFormView* _pViewImpl)
/*N*/ 				 :m_pViewImpl(_pViewImpl)
/*N*/ 				 ,m_pWindow( (Window*)pWinRec->GetOutputDevice() )
/*N*/ 				 ,m_xORB(_xORB)
/*N*/ {
/*N*/ 	DBG_CTOR(FmXPageViewWinRec,NULL);
/*N*/ 
/*N*/ 	// legt fuer jede ::com::sun::star::form ein FormController an
/*N*/ 	FmFormPage* pP = NULL;
/*N*/ 	if (m_pViewImpl)
/*N*/ 		pP = PTR_CAST(FmFormPage,m_pViewImpl->getView()->GetPageViewPvNum(0)->GetPage());
/*N*/ 
/*N*/ 	DBG_ASSERT(pP,"kein Page gefunden");
/*N*/ 
/*N*/ 	if (pP)
/*N*/ 	{
/*N*/ 		Reference< XIndexAccess >  xForms(pP->GetForms(), UNO_QUERY);
/*N*/ 		sal_uInt32 nLength = xForms->getCount();
/*N*/ 		Any aElement;
/*N*/ 		Reference< XForm >  xForm;
/*N*/ 		for (sal_uInt32 i = 0; i < nLength; i++)
/*N*/ 		{
/*N*/ 			xForms->getByIndex(i) >>= xForm;
/*N*/ 			setController(xForm, pWinRec->GetControlContainerRef() );
/*N*/ 		}
/*N*/ 	}
/*N*/ }
// -----------------------------------------------------------------------------
/*N*/ FmXPageViewWinRec::~FmXPageViewWinRec()
/*N*/ {
/*N*/ 	DBG_DTOR(FmXPageViewWinRec,NULL);
/*N*/ }

//------------------------------------------------------------------
/*N*/ void FmXPageViewWinRec::dispose()
/*N*/ {
/*N*/ 	for (vector< ::com::sun::star::uno::Reference< ::com::sun::star::form::XFormController > >::const_iterator i = m_aControllerList.begin();
/*N*/ 			i != m_aControllerList.end(); i++)
/*N*/ 	{
/*N*/ 		// detaching the events
/*N*/ 		::com::sun::star::uno::Reference< ::com::sun::star::container::XChild >  xChild((*i)->getModel(), ::com::sun::star::uno::UNO_QUERY);
/*N*/ 		if (xChild.is())
/*N*/ 		{
/*N*/ 			::com::sun::star::uno::Reference< ::com::sun::star::script::XEventAttacherManager >  xEventManager(xChild->getParent(), ::com::sun::star::uno::UNO_QUERY);
/*N*/ 			::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >  xIfc(*i, ::com::sun::star::uno::UNO_QUERY);
/*N*/ 			xEventManager->detach( i - m_aControllerList.begin(), xIfc );
/*N*/ 		}
/*N*/ 
/*N*/ 		// dispose the formcontroller
/*N*/ 		::com::sun::star::uno::Reference< ::com::sun::star::lang::XComponent >  xComp(*i, ::com::sun::star::uno::UNO_QUERY);
/*N*/ 		xComp->dispose();
/*N*/ 	}
/*N*/ 	m_aControllerList.clear(); // this call deletes the formcontrollers
/*N*/ 	m_xORB = NULL;
/*N*/ }


//------------------------------------------------------------------------------
/*N*/ sal_Bool SAL_CALL FmXPageViewWinRec::hasElements(void) throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/ 	return getCount() != 0;
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ ::com::sun::star::uno::Type SAL_CALL  FmXPageViewWinRec::getElementType(void) throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/ 	return ::getCppuType((const ::com::sun::star::uno::Reference< ::com::sun::star::form::XFormController>*)0);
/*N*/ }

// ::com::sun::star::container::XEnumerationAccess			
//------------------------------------------------------------------------------
/*N*/ ::com::sun::star::uno::Reference< ::com::sun::star::container::XEnumeration >  SAL_CALL FmXPageViewWinRec::createEnumeration(void) throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/ 	return new ::comphelper::OEnumerationByIndex(this);
/*N*/ }

// ::com::sun::star::container::XIndexAccess
//------------------------------------------------------------------------------
/*N*/ sal_Int32 SAL_CALL FmXPageViewWinRec::getCount(void) throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/ 	return m_aControllerList.size();
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ ::com::sun::star::uno::Any SAL_CALL FmXPageViewWinRec::getByIndex(sal_Int32 nIndex) throw( ::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::lang::WrappedTargetException, ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/ 	if (nIndex < 0 ||
/*N*/ 		nIndex >= getCount())
/*N*/ 		throw ::com::sun::star::lang::IndexOutOfBoundsException();
/*N*/ 
/*N*/ 	::com::sun::star::uno::Any aElement;
/*N*/ 	aElement <<= m_aControllerList[nIndex];
/*N*/ 	return aElement;
/*N*/ }

//------------------------------------------------------------------------

// Search the according controller
//------------------------------------------------------------------------

//------------------------------------------------------------------------
/*N*/ void FmXPageViewWinRec::setController(const ::com::sun::star::uno::Reference< ::com::sun::star::form::XForm > & xForm,
/*N*/ 									 const ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlContainer > & xCC,
/*N*/ 									 FmXFormController* pParent)
/*N*/ {
/*N*/ 	DBG_ASSERT(xForm.is(), "Kein Formular angegeben");
/*N*/ 	::com::sun::star::uno::Reference< ::com::sun::star::container::XIndexAccess >  xFormCps(xForm, ::com::sun::star::uno::UNO_QUERY);
/*N*/ 	if (!xFormCps.is())
/*N*/ 		return;
/*N*/ 
/*N*/ 	::com::sun::star::uno::Reference< ::com::sun::star::awt::XTabControllerModel >  xTabOrder(xForm, ::com::sun::star::uno::UNO_QUERY);
/*N*/ 
/*N*/ 	FmFormPage* pCurrentPage = PTR_CAST(FmFormPage, m_pViewImpl->getView()->GetPageViewPvNum(0)->GetPage());
/*N*/ 	DBG_ASSERT(pCurrentPage, "FmXPageViewWinRec::setController: could not retrieve my page !");
/*N*/ 	String sPageId = pCurrentPage ? pCurrentPage->GetImpl()->GetPageId() : String::CreateFromAscii("no page");
/*N*/ 		// this "no page" should result in a empty ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatch >  provided by the controller's external dispatcher
/*N*/ 
/*N*/ 	// Anlegen des Tabcontrollers
/*N*/ 	FmXFormController* pController = new FmXFormController(m_xORB,m_pViewImpl->getView(), m_pWindow, sPageId);
/*N*/ 	::com::sun::star::uno::Reference< ::com::sun::star::form::XFormController >  xController(pController);
/*N*/ 
/*N*/ 	pController->setModel(xTabOrder);
/*N*/ 	pController->setContainer(xCC);
/*N*/ 	pController->activateTabOrder();
/*N*/ 	pController->addActivateListener(m_pViewImpl);
/*N*/ 
/*N*/ 	if (pParent)
/*?*/		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 		pParent->addChild(pController);
/*N*/ 	else
/*N*/ 	{
/*N*/ 		//	::com::sun::star::uno::Reference< ::com::sun::star::form::XFormController >  xController(pController);
/*N*/ 		m_aControllerList.push_back(xController);
/*N*/ 
/*N*/ 		pController->setParent(*this);
/*N*/ 
/*N*/ 		// attaching the events
/*N*/ 		::com::sun::star::uno::Reference< ::com::sun::star::script::XEventAttacherManager >  xEventManager(xForm->getParent(), ::com::sun::star::uno::UNO_QUERY);
/*N*/ 		::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >  xIfc(xController, ::com::sun::star::uno::UNO_QUERY);
/*N*/ 		xEventManager->attach(m_aControllerList.size() - 1, xIfc, ::com::sun::star::uno::makeAny(xController) );
/*N*/ 	}
/*N*/ 
/*N*/ 
/*N*/ 
/*N*/ 	// jetzt die Subforms durchgehen
/*N*/ 	sal_uInt32 nLength = xFormCps->getCount();
/*N*/ 	::com::sun::star::uno::Reference< ::com::sun::star::form::XForm >  xSubForm;
/*N*/ 	for (sal_uInt32 i = 0; i < nLength; i++)
/*N*/ 	{
/*N*/ 		xFormCps->getByIndex(i) >>= xSubForm;
/*N*/ 		if (xSubForm.is())
/*?*/ 			setController(xSubForm, xCC, pController);
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------

//------------------------------------------------------------------------
/*N*/ ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlContainer >  FmXPageViewWinRec::getControlContainer() const
/*N*/ {
/*N*/ 	::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlContainer >  xCC;
/*N*/ 	if (m_aControllerList.size())
/*N*/ 		xCC = m_aControllerList[0]->getContainer();
/*N*/ 	return xCC;
/*N*/ }

//------------------------------------------------------------------------
/*N*/ FmXFormView::FmXFormView(const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >&	_xORB,
/*N*/ 			FmFormView* _pView)
/*N*/ 	:m_pView(_pView)
/*N*/ 	,m_xORB( _xORB )
/*N*/ 	,m_nActivationEvent(0)
/*N*/ 	,m_nErrorMessageEvent( 0 )
/*N*/ 	,m_nAutoFocusEvent( 0 )
/*N*/ 	,m_pWatchStoredList( NULL )
/*N*/ 	,m_bFirstActivation( sal_True )
/*N*/ 	,m_pMarkedGrid(NULL)
/*N*/ {
/*N*/ }

//------------------------------------------------------------------------
/*N*/ void FmXFormView::cancelEvents()
/*N*/ {
/*N*/ 	if ( m_nActivationEvent )
/*N*/ 	{
/*?*/ 		Application::RemoveUserEvent( m_nActivationEvent );
/*?*/ 		m_nActivationEvent = 0;
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( m_nErrorMessageEvent )
/*N*/ 	{
/*?*/ 		Application::RemoveUserEvent( m_nErrorMessageEvent );
/*?*/ 		m_nErrorMessageEvent = 0;
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( m_nAutoFocusEvent )
/*N*/ 	{
/*?*/         Application::RemoveUserEvent( m_nAutoFocusEvent );
/*?*/ 		m_nAutoFocusEvent = 0;
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------
/*N*/ void FmXFormView::notifyViewDying( )
/*N*/ {
/*N*/ 	DBG_ASSERT( m_pView, "FmXFormView::notifyViewDying: my view already died!" );
/*N*/ 	m_pView = NULL;
/*N*/ 	cancelEvents();
/*N*/ }

//------------------------------------------------------------------------
/*N*/ FmXFormView::~FmXFormView()
/*N*/ {
/*N*/ 	DBG_ASSERT(m_aWinList.size() == 0, "Liste nicht leer");
/*N*/ 
/*N*/ 	cancelEvents();
/*N*/ 
/*N*/ 	delete m_pWatchStoredList;
/*N*/ 	m_pWatchStoredList = NULL;
/*N*/ }

//      EventListener
//------------------------------------------------------------------------------
/*N*/ void SAL_CALL FmXFormView::disposing(const ::com::sun::star::lang::EventObject& Source) throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/ 	if ( m_xWindow.is() && Source.Source == m_xWindow )
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");}//STRIP001 removeGridWindowListening();
/*N*/ }

// ::com::sun::star::form::XFormControllerListener
//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormView::formActivated(const ::com::sun::star::lang::EventObject& rEvent) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	::com::sun::star::uno::Reference< ::com::sun::star::form::XFormController >  xController(rEvent.Source, ::com::sun::star::uno::UNO_QUERY);
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormView::formDeactivated(const ::com::sun::star::lang::EventObject& rEvent) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ 	// deaktivierung wird nicht registriert
/*?*/ }

// ::com::sun::star::container::XContainerListener
//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormView::elementInserted(const ::com::sun::star::container::ContainerEvent& evt) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlContainer >  xCC(evt.Source, ::com::sun::star::uno::UNO_QUERY);
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormView::elementReplaced(const ::com::sun::star::container::ContainerEvent& evt) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	elementInserted(evt);
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormView::elementRemoved(const ::com::sun::star::container::ContainerEvent& evt) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ }

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
/*N*/ FmWinRecList::iterator FmXFormView::findWindow( const ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlContainer > & rCC )
/*N*/ {
/*N*/ 	for (FmWinRecList::iterator i = m_aWinList.begin();
/*N*/ 			i != m_aWinList.end(); i++)
/*N*/ 	{
/*N*/ 		if (rCC == (*i)->getControlContainer())
/*N*/ 			return i;
/*N*/ 	}
/*N*/ 	return m_aWinList.end();
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormView::addWindow(const SdrPageViewWinRec* pRec)
/*N*/ {
/*N*/ 	// Wird gerufen, wenn
/*N*/ 	// - in den aktiven Modus geschaltet wird
/*N*/ 	// - ein Window hinzugefuegt wird, waehrend man im Design-Modus ist
/*N*/ 	// - der Control-Container fuer ein Window angelegt wird, waehrend
/*N*/ 	//   der aktive Modus eingeschaltet ist.
/*N*/ 
/*N*/ 	// Wenn es noch keinen Control-Container gibt oder am Control-Container
/*N*/ 	// noch keine Peer Erzeugt wurde, dann ist es noch zu frueh, um die
/*N*/ 	// Tab-Order einzustellen ...
/*N*/ 	if( pRec->GetOutputDevice()->GetOutDevType() == OUTDEV_WINDOW  )
/*N*/ 	{
/*N*/ 		const ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlContainer > & rCC = pRec->GetControlContainerRef();
/*N*/ 		if ( rCC.is() && findWindow( rCC ) == m_aWinList.end())
/*N*/ 		{
/*N*/ 			FmXPageViewWinRec *pFmRec = new FmXPageViewWinRec(m_xORB,pRec, this);
/*N*/ 			pFmRec->acquire();
/*N*/ 
/*N*/ 			m_aWinList.push_back(pFmRec);
/*N*/ 
/*N*/ 			// Am ControlContainer horchen um Aenderungen mitzbekommen
/*N*/ 			::com::sun::star::uno::Reference< ::com::sun::star::container::XContainer >  xContainer(rCC, ::com::sun::star::uno::UNO_QUERY);
/*N*/ 			if (xContainer.is())
/*N*/ 				xContainer->addContainerListener(this);
/*N*/ 		}
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormView::removeWindow( const ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlContainer > & rCC )
/*N*/ {
/*N*/ 	// Wird gerufen, wenn
/*N*/ 	// - in den Design-Modus geschaltet wird
/*N*/ 	// - ein Window geloescht wird, waehrend man im Design-Modus ist
/*N*/ 	// - der Control-Container fuer ein Window entfernt wird, waehrend
/*N*/ 	//   der aktive Modus eingeschaltet ist.
/*N*/ 	FmWinRecList::iterator i = findWindow( rCC );
/*N*/ 	if (i != m_aWinList.end())
/*N*/ 	{
/*N*/ 		// Am ControlContainer horchen um Aenderungen mitzbekommen
/*N*/ 		::com::sun::star::uno::Reference< ::com::sun::star::container::XContainer >  xContainer(rCC, ::com::sun::star::uno::UNO_QUERY);
/*N*/ 		if (xContainer.is())
/*N*/ 			xContainer->removeContainerListener(this);
/*N*/ 
/*N*/ 		(*i)->dispose();
/*N*/ 		(*i)->release();
/*N*/ 		m_aWinList.erase(i);
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
/*N*/ void FmXFormView::onFirstViewActivation( const FmFormModel* _pDocModel )
/*N*/ {
/*N*/ 	if ( _pDocModel && _pDocModel->GetAutoControlFocus() )
/*N*/ 		Application::PostUserEvent( LINK( this, FmXFormView, OnAutoFocus ) );
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ IMPL_LINK(FmXFormView, OnActivate, void*, EMPTYTAG)
/*N*/ {
/*N*/ 	m_nActivationEvent = 0;
/*N*/ 
/*N*/ 	if ( !m_pView )
/*N*/ 	{
/*N*/ 		DBG_ERROR( "FmXFormView::OnActivate: well .... seems we have a timing problem (the view already died)!" );
/*N*/ 		return 0;
/*N*/ 	}
/*N*/ 
/*N*/ 	// setting the controller to activate
/*N*/ 	if (m_pView->GetFormShell() && m_pView->GetActualOutDev() && m_pView->GetActualOutDev()->GetOutDevType() == OUTDEV_WINDOW)
/*N*/ 	{
/*N*/ 		Window* pWindow = const_cast<Window*>(static_cast<const Window*>(m_pView->GetActualOutDev()));
/*N*/ 		FmXPageViewWinRec* pFmRec = m_aWinList.size() ? m_aWinList[0] : NULL;
/*N*/ 		for (FmWinRecList::const_iterator i = m_aWinList.begin();
/*N*/ 			i != m_aWinList.end(); i++)
/*N*/ 		{
/*?*/ 			if (pWindow == (*i)->getWindow())
/*?*/ 				pFmRec =*i;
/*N*/ 		}
/*N*/ 
/*N*/ 		if (pFmRec)
/*N*/ 		{
/*?*/ 			for (vector< Reference< XFormController > >::const_iterator i = pFmRec->GetList().begin();
/*?*/ 				i != pFmRec->GetList().end(); i++)
/*?*/ 			{
/*?*/ 				const Reference< XFormController > & xController = *i;
/*?*/ 				if (xController.is())
/*?*/ 				{
/*?*/					DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 					// Nur bei Datenbankformularen erfolgt eine aktivierung
/*?*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 	return 0;
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormView::Activate(sal_Bool bSync)
/*N*/ {
/*N*/ 	if (m_nActivationEvent)
/*N*/ 	{
/*?*/ 		Application::RemoveUserEvent(m_nActivationEvent);
/*?*/ 		m_nActivationEvent = 0;
/*N*/ 	}
/*N*/ 
/*N*/ 	if (bSync)
/*N*/ 	{
/*?*/ 		LINK(this,FmXFormView,OnActivate).Call(NULL);
/*N*/ 	}
/*N*/ 	else
/*N*/ 		m_nActivationEvent = Application::PostUserEvent(LINK(this,FmXFormView,OnActivate));
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormView::Deactivate(BOOL bDeactivateController)
/*N*/ {
/*N*/ 	if (m_nActivationEvent)
/*N*/ 	{
/*N*/ 		Application::RemoveUserEvent(m_nActivationEvent);
/*N*/ 		m_nActivationEvent = 0;
/*N*/ 	}
/*N*/ 
/*N*/ 	FmXFormShell* pShImpl =  m_pView->GetFormShell() ? m_pView->GetFormShell()->GetImpl() : NULL;
/*N*/ 	if (pShImpl && bDeactivateController)
/*N*/ 		pShImpl->setActiveController( NULL );
/*N*/ }

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
/*N*/ FmFormShell* FmXFormView::GetFormShell() const
/*N*/ {
/*N*/ 	return m_pView ? m_pView->GetFormShell() : NULL;
/*N*/ }
// -----------------------------------------------------------------------------
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
/*N*/ IMPL_LINK(FmXFormView, OnAutoFocus, void*, EMPTYTAG)
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ 	return 0L;
/*N*/ }

// -----------------------------------------------------------------------------

//------------------------------------------------------------------------

//------------------------------------------------------------------------------
/*N*/ FmXFormView::ObjectRemoveListener::ObjectRemoveListener( FmXFormView* pParent )
/*N*/ 	:m_pParent( pParent )
/*N*/ {
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormView::ObjectRemoveListener::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
/*N*/ {
/*N*/ 	if (rHint.ISA(SdrHint) && (((SdrHint&)rHint).GetKind() == HINT_OBJREMOVED))
/*N*/ 		m_pParent->ObjectRemovedInAliveMode(((SdrHint&)rHint).GetObject());
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormView::ObjectRemovedInAliveMode( const SdrObject* pObject )
/*N*/ {
/*N*/ 	// wenn das entfernte Objekt in meiner MarkList, die ich mir beim Umschalten in den Alive-Mode gemerkt habe, steht,
/*N*/ 	// muss ich es jetzt da rausnehmen, da ich sonst beim Zurueckschalten versuche, die Markierung wieder zu setzen
/*N*/ 	// (interesanterweise geht das nur bei gruppierten Objekten schief (beim Zugriff auf deren ObjList GPF), nicht bei einzelnen)
/*N*/ 
/*N*/ 	sal_uInt32 nCount = m_aMark.GetMarkCount();
/*N*/ 	for (sal_uInt32 i = 0; i < nCount; ++i)
/*N*/ 	{
/*?*/ 		SdrMark* pMark = m_aMark.GetMark(i);
/*?*/ 		SdrObject* pCurrent = pMark->GetObj();
/*?*/ 		if (pObject == pCurrent)
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ 			return;
/*?*/ 		}
/*?*/ 		// ich brauche nicht in GroupObjects absteigen : wenn dort unten ein Objekt geloescht wird, dann bleibt der
/*N*/ 		// Zeiger auf das GroupObject, den ich habe, trotzdem weiter gueltig bleibt ...
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormView::stopMarkListWatching()
/*N*/ {
/*N*/ 	if ( m_pWatchStoredList )
/*N*/ 	{
/*N*/ 		m_pWatchStoredList->EndListeningAll();
/*N*/ 		delete m_pWatchStoredList;
/*N*/ 		m_pWatchStoredList = NULL;
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormView::startMarkListWatching()
/*N*/ {
/*N*/ 	if ( !m_pWatchStoredList )
/*N*/ 	{
/*N*/ 		m_pWatchStoredList = new ObjectRemoveListener( this );
/*N*/ 		FmFormModel* pModel = GetFormShell() ? GetFormShell()->GetFormModel() : NULL;
/*N*/ 		DBG_ASSERT( pModel != NULL, "FmXFormView::startMarkListWatching: shell has no model!" );
/*N*/ 		m_pWatchStoredList->StartListening( *static_cast< SfxBroadcaster* >( pModel ) );
/*N*/ 	}
/*N*/ 	else
/*N*/ 		DBG_ERROR( "FmXFormView::startMarkListWatching: already listening!" );
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormView::saveMarkList( sal_Bool _bSmartUnmark )
/*N*/ {
/*N*/ 	if ( m_pView )
/*N*/ 	{
/*N*/ 		m_aMark = m_pView->GetMarkList();
/*N*/ 		if ( _bSmartUnmark )
/*N*/ 		{
/*N*/ 			sal_uInt32 nCount = m_aMark.GetMarkCount( );
/*N*/ 			for ( sal_uInt32 i = 0; i < nCount; ++i )
/*N*/ 			{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*?*/ 		DBG_ERROR( "FmXFormView::saveMarkList: invalid view!" );
/*?*/ 		m_aMark = SdrMarkList();
/*N*/ 	}
/*N*/ }

//--------------------------------------------------------------------------

//------------------------------------------------------------------------------
/*N*/ void FmXFormView::restoreMarkList( SdrMarkList& _rRestoredMarkList )
/*N*/ {
/*N*/ 	if ( !m_pView )
/*N*/ 		return;
/*N*/ 
/*N*/ 	_rRestoredMarkList.Clear();
/*N*/ 
/*N*/ 	const SdrMarkList& rCurrentList = m_pView->GetMarkList();
/*N*/ 	FmFormPage* pPage = GetFormShell() ? GetFormShell()->GetCurPage() : NULL;
/*N*/ 	if (pPage)
/*N*/ 	{
/*N*/ 		if (rCurrentList.GetMarkCount())
/*N*/ 		{	// there is a current mark ... hmm. Is it a subset of the mark we remembered in saveMarkList?
/*?*/ 			sal_Bool bMisMatch = sal_False;
/*?*/ 
/*?*/ 			// loop through all current marks
/*?*/ 			sal_uInt32 nCurrentCount = rCurrentList.GetMarkCount();
/*?*/ 			for ( sal_uInt32 i=0; i<nCurrentCount&& !bMisMatch; ++i )
/*?*/ 			{
/*?*/ 				const SdrObject* pCurrentMarked = rCurrentList.GetMark( i )->GetObj();
/*?*/ 
/*?*/ 				// loop through all saved marks, check for equality
/*?*/ 				sal_Bool bFound = sal_False;
/*?*/ 				sal_uInt32 nSavedCount = m_aMark.GetMarkCount();
/*?*/ 				for ( sal_uInt32 j=0; j<nSavedCount && !bFound; ++j )
/*?*/ 				{
/*?*/ 					if ( m_aMark.GetMark( j )->GetObj() == pCurrentMarked )
/*?*/ 						bFound = sal_True;
/*?*/ 				}
/*?*/ 
/*?*/ 				// did not find a current mark in the saved marks
/*?*/ 				if ( !bFound )
/*?*/ 					bMisMatch = sal_True;
/*?*/ 			}
/*?*/ 
/*?*/ 			if ( bMisMatch )
/*?*/ 			{
/*?*/ 				m_aMark.Clear();
/*?*/ 				_rRestoredMarkList = rCurrentList;
/*?*/ 				return;
/*N*/ 			}
/*N*/ 		}
/*N*/ 		// wichtig ist das auf die Objecte der markliste nicht zugegriffen wird
/*N*/ 		// da diese bereits zerstoert sein koennen
/*N*/ 		SdrPageView* pCurPageView = m_pView->GetPageViewPvNum(0);
/*N*/ 		SdrObjListIter aPageIter( *pPage );
/*N*/ 		sal_Bool bFound = sal_True;
/*N*/ 
/*N*/ 		// gibt es noch alle Objecte
/*N*/ 		sal_uInt32 nCount = m_aMark.GetMarkCount();
/*N*/ 		for (sal_uInt32 i = 0; i < nCount && bFound; i++)
/*N*/ 		{
/*?*/			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 			SdrMark*   pMark = m_aMark.GetMark(i);
/*N*/ 		}
/*N*/ 
/*N*/ 		if (bFound)
/*N*/ 		{
/*N*/ 			// Das LastObject auswerten
/*N*/ 			if (nCount) // Objecte jetzt Markieren
/*N*/ 			{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ 			}
/*N*/ 			// This one is from the times where the code was part of the FmXFormShell instead of the FmXFormView.
/*N*/ 			// I do not see the deeper sense - it's not fully clear what it does, and everything works as
/*N*/ 			// expected without it. Fine, so I omit it :).
/*N*/ 			// 02.05.2002 - fs@openoffice.org
/*N*/ //			else
/*N*/ //			{
/*N*/ //				Reference< XIndexAccess> xCont(pPage->GetForms(), UNO_QUERY);
/*N*/ //
/*N*/ //				// Ist das aktuelle Object ein Element eines SelectionSuppliers?
/*N*/ //				Reference< XChild> xChild(m_xCurControl,UNO_QUERY);
/*N*/ //				Reference< ::com::sun::star::view::XSelectionSupplier> xSelectionSupplier;
/*N*/ //				if (xChild.is())
/*N*/ //					xSelectionSupplier = Reference< ::com::sun::star::view::XSelectionSupplier>(xChild->getParent(), UNO_QUERY);
/*N*/ //				if (xSelectionSupplier.is())
/*N*/ //				{
/*N*/ //					// suchen der Zugehoreigen Form
/*N*/ //					Reference< XForm> xForm(GetForm(m_xCurControl));
/*N*/ //					Reference< XInterface> xIface(xForm, UNO_QUERY);
/*N*/ //					if (xForm.is() && searchElement(xCont, xIface))
/*N*/ //					{
/*N*/ //						setCurForm(xForm);
/*N*/ //						setCurControl(m_xCurControl);
/*N*/ //
/*N*/ //						// jetzt noch die Selection vornehmen
/*N*/ //						xSelectionSupplier->select(makeAny(m_xCurControl));
/*N*/ //					}
/*N*/ //				}
/*N*/ //				else
/*N*/ //				{
/*N*/ //					// Auswerten des letzen Objects
/*N*/ //					Reference< XForm> xForm(m_xCurForm, UNO_QUERY);
/*N*/ //					Reference< XInterface> xIface(xForm, UNO_QUERY);
/*N*/ //					if (xForm.is() && searchElement(xCont, xIface))
/*N*/ //					{
/*N*/ //						setCurForm(xForm);
/*N*/ //					}
/*N*/ //					else
/*N*/ //					{
/*N*/ //						if (pPage->GetImpl()->getCurForm().is())
/*N*/ //							xForm = pPage->GetImpl()->getCurForm();
/*N*/ //						else if (xCont.is() && xCont->getCount())
/*N*/ //							xForm = pPage->GetImpl()->getDefaultForm();
/*N*/ //
/*N*/ //						if (xForm.is())
/*N*/ //							setCurForm(xForm);
/*N*/ //					}
/*N*/ //				}
/*N*/ //
/*N*/ //				Reference< XInterface> xPreviousObject(getSelObject());
/*N*/ //
/*N*/ //				// wurde vorher Form angezeigt, dann wieder die Form anzeigen
/*N*/ //				Reference< XForm> xOldForm(xPreviousObject, UNO_QUERY);
/*N*/ //				if (xOldForm.is())
/*N*/ //					setSelObject(m_xCurForm);
/*N*/ //				else
/*N*/ //					setSelObject(m_xCurControl);
/*N*/ //
/*N*/ //				if (IsPropBrwOpen() && m_xSelObject != xPreviousObject)
/*N*/ //					ShowProperties(m_xSelObject, sal_True);
/*N*/ //			}
/*N*/ 		}
/*N*/ 		m_aMark.Clear();
/*N*/ 	}
/*N*/ }
// -----------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormView::focusGained( const ::com::sun::star::awt::FocusEvent& e ) throw (::com::sun::star::uno::RuntimeException)
/*?*/ {DBG_BF_ASSERT(0, "STRIP");//STRIP001 
/*?*/ }
// -----------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormView::focusLost( const ::com::sun::star::awt::FocusEvent& e ) throw (::com::sun::star::uno::RuntimeException)
/*?*/ {DBG_BF_ASSERT(0, "STRIP");//STRIP001 
/*?*/ }											    
// -----------------------------------------------------------------------------
// -----------------------------------------------------------------------------


}
